/*
 * Decompiled with CFR 0.152.
 */
package devParameterize.modules.fieldGenerator;

import dev.numeric.PnTaucsSolver;
import dev.numeric.PnTaucsSparseCholeskyFactorization;
import dev6.numeric.PnCSparseCholesky;
import devCovering.PgCovering;
import devCovering.PgFrameField;
import devCovering.PnFrameField;
import devParameterize.geom.PgParamGeom;
import devParameterize.modules.PnModule;
import jv.geom.PgElementSet;
import jv.geom.PgVectorField;
import jv.number.PuDouble;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuMath;
import jvx.geom.PgVertexStar;
import jvx.numeric.PnSparseMatrix;
import jvx.util.PuQueue;
import jvx.vector.PwVectorField;

public class PmVectorAngleSmoother
extends PnModule {
    public static final double DEFAULT_SMOOTHING_FACTOR = 0.3;
    private boolean m_useTAUCS;
    private PdVector[] m_startAngles;
    private PnSparseMatrix m_A;
    private PdVector m_b;
    private PnTaucsSparseCholeskyFactorization m_factorization1;
    private PnCSparseCholesky.PnCSparseCholeskyFactor m_factorization2;
    private int m_numSystemsSolved;
    private double[] m_elemArea;
    protected PuDouble m_smooth;
    private PdVector m_angles;
    private double[][] m_edgeWeight;
    private double[] m_elemWeight;
    private PdVector m_rotationAngles;
    private PiVector m_indices;
    private PgVertexStar[] m_stars;

    public PmVectorAngleSmoother() {
        boolean bl = this.m_useTAUCS = PsConfig.isApplication() && PnTaucsSolver.isAvailable();
        if (this.m_useTAUCS) {
            this.m_factorization1 = new PnTaucsSparseCholeskyFactorization();
        }
        this.m_smooth = new PuDouble("Smoothing", (PsUpdateIf)this);
        if (((Object)((Object)this)).getClass() == PmVectorAngleSmoother.class) {
            this.init();
        }
    }

    @Override
    public void init() {
        this.m_smooth.setDefBounds(0.0, 1.0, 0.1, 0.1);
        this.m_smooth.setDefValue(0.3);
        this.m_smooth.init();
    }

    public PsPanel getInfoPanel() {
        return this.m_smooth.getInfoPanel();
    }

    @Override
    public boolean setGeometry(PgParamGeom geom) {
        if (!super.setGeometry(geom)) {
            return false;
        }
        this.reset();
        return true;
    }

    public void reset() {
        this.m_angles = null;
        this.m_A = null;
        this.m_b = null;
        this.freeFactorization();
    }

    @Override
    public boolean start() {
        if (!super.start()) {
            return false;
        }
        this.solveUseFactorization();
        this.m_angles.sub(this.m_rotationAngles);
        PnFrameField.rotateFrames((PgFrameField)this.m_geom.getFrameField(), (double[])this.m_angles.m_data);
        this.m_rotationAngles.add(this.m_angles);
        return true;
    }

    private void initializeDatastructures() {
        int numElements = this.m_geom.getNumElements();
        this.m_numSystemsSolved = 0;
        this.m_rotationAngles = new PdVector(numElements);
        this.m_angles = new PdVector(numElements);
        this.freeFactorization();
        this.m_A = null;
        this.m_b = null;
        this.m_startAngles = PdVector.realloc((PdVector[])this.m_startAngles, (int)numElements, (int)3);
        int e = 0;
        while (e < numElements) {
            int size = this.m_geom.getDimOfElement(e);
            int j = 0;
            while (j < size) {
                int ne = this.m_geom.getNeighbour((int)e).m_data[j];
                if (ne >= 0) {
                    double angle = PwVectorField.calcAngle((PgVectorField)this.m_geom.getFrameField().getField(0), (int)e, (int)ne);
                    while (angle > Math.PI) {
                        angle -= Math.PI * 2;
                    }
                    while (angle < -Math.PI) {
                        angle += Math.PI * 2;
                    }
                    this.m_startAngles[e].m_data[j] = angle;
                }
                ++j;
            }
            ++e;
        }
        this.m_indices = PnFrameField.calcIndices((PgFrameField)this.m_geom.getFrameField(), (int)this.m_geom.getCovering().getSymmetryOrder(), null);
        this.m_stars = PmVectorAngleSmoother.makeVertexStars((PgElementSet)this.m_geom, PgVertexStar.getElementPerVertex((PgElementSet)this.m_geom));
        this.updateWeights();
    }

    private void updateWeights() {
        int numElements = this.m_geom.getNumElements();
        this.m_elemArea = new double[numElements];
        double totalArea = 0.0;
        int e = 0;
        while (e < numElements) {
            this.m_elemArea[e] = this.m_geom.getAreaOfElement(e);
            totalArea += this.m_elemArea[e];
            ++e;
        }
        this.m_edgeWeight = new double[numElements][3];
        e = 0;
        while (e < numElements) {
            int size = this.m_geom.getDimOfElement(e);
            int j = 0;
            while (j < size) {
                int ne = this.m_geom.getNeighbour((int)e).m_data[j];
                if (ne >= 0) {
                    this.m_edgeWeight[e][j] = this.edgeWeight(e, ne);
                }
                ++j;
            }
            ++e;
        }
        e = 0;
        while (e < numElements) {
            int n = e++;
            this.m_elemArea[n] = this.m_elemArea[n] * ((double)numElements / totalArea);
        }
        this.m_elemWeight = new double[numElements];
        e = 0;
        while (e < numElements) {
            this.m_elemWeight[e] = this.elementWeight(e);
            ++e;
        }
    }

    private PdVector computeRightHandSide() {
        int numElements = this.m_geom.getNumElements();
        int symmOrder = this.m_geom.getCovering().getSymmetryOrder();
        if (this.m_b == null) {
            this.m_b = new PdVector(numElements);
        }
        int e = 0;
        while (e < numElements) {
            int j = 0;
            while (j < 3) {
                int ne = this.m_geom.getNeighbour((int)e).m_data[j];
                if (ne >= 0) {
                    double w_ij = this.m_edgeWeight[e][j];
                    double angle = this.m_startAngles[e].m_data[j];
                    int m = this.m_geom.getCovering().getMatching(e, j);
                    angle += Math.PI * 2 / (double)symmOrder * (double)PuMath.modulo((int)m, (int)symmOrder);
                    while (angle > Math.PI) {
                        angle -= Math.PI * 2;
                    }
                    while (angle < -Math.PI) {
                        angle += Math.PI * 2;
                    }
                    int n = e;
                    this.m_b.m_data[n] = this.m_b.m_data[n] + w_ij * angle;
                }
                ++j;
            }
            ++e;
        }
        return this.m_b;
    }

    public double solveAndEval() {
        this.solveUseFactorization();
        int numElements = this.m_geom.getNumElements();
        int symmOrder = this.m_geom.getCovering().getSymmetryOrder();
        PiVector[] matching = this.m_geom.getCovering().getMatching();
        double energy = 0.0;
        int e = 0;
        while (e < numElements) {
            energy += this.m_elemWeight[e] * this.m_angles.m_data[e] * this.m_angles.m_data[e];
            int j = 0;
            while (j < 3) {
                int ne = this.m_geom.getNeighbour((int)e).m_data[j];
                if (ne >= e) {
                    double angle = this.m_startAngles[e].m_data[j] + this.m_angles.m_data[ne] - this.m_angles.m_data[e];
                    int m = matching[e].m_data[j];
                    angle += Math.PI * 2 / (double)symmOrder * (double)PuMath.modulo((int)m, (int)symmOrder);
                    while (angle > Math.PI) {
                        angle -= Math.PI * 2;
                    }
                    while (angle < -Math.PI) {
                        angle += Math.PI * 2;
                    }
                    energy += 2.0 * this.m_edgeWeight[e][j] * angle * angle;
                }
                ++j;
            }
            ++e;
        }
        return energy;
    }

    public void changeMatching(int e, int ne, int change, boolean editCovering) {
        if (this.m_b == null) {
            this.computeRightHandSide();
        }
        int locE = this.m_geom.getNeighbour(e).getIndexOf(ne);
        int locNE = this.m_geom.getNeighbour(ne).getIndexOf(e);
        double edgeWeight = this.m_edgeWeight[e][locE];
        int symmOrder = this.m_geom.getCovering().getSymmetryOrder();
        PiVector[] matching = this.m_geom.getCovering().getMatching();
        int n = e;
        this.m_b.m_data[n] = this.m_b.m_data[n] + (double)change * edgeWeight * (Math.PI * 2 / (double)symmOrder);
        int n2 = ne;
        this.m_b.m_data[n2] = this.m_b.m_data[n2] - (double)change * edgeWeight * (Math.PI * 2 / (double)symmOrder);
        if (!editCovering) {
            return;
        }
        if (locE >= 0) {
            matching[e].m_data[locE] = matching[e].m_data[locE] + change;
        }
        if (locNE >= 0) {
            matching[ne].m_data[locNE] = matching[ne].m_data[locNE] - change;
        }
    }

    private PnSparseMatrix computeMatrix() {
        int numElements = this.m_geom.getNumElements();
        if (this.m_A == null) {
            this.m_A = new PnSparseMatrix(numElements, numElements, 4);
        } else {
            this.m_A.clear();
        }
        int e = 0;
        while (e < numElements) {
            double sm_ii = this.m_elemWeight[e];
            int j = 0;
            while (j < 3) {
                int ne = this.m_geom.getNeighbour((int)e).m_data[j];
                if (ne >= 0) {
                    double w_ij = this.m_edgeWeight[e][j];
                    this.m_A.setEntry(e, ne, -w_ij);
                    sm_ii += w_ij;
                }
                ++j;
            }
            this.m_A.setEntry(e, e, sm_ii);
            ++e;
        }
        this.m_A.validate();
        return this.m_A;
    }

    public void freeFactorization() {
        if (this.m_useTAUCS) {
            this.m_factorization1.freeFactorization();
        } else {
            this.m_factorization2 = null;
        }
    }

    public PdVector solveUseFactorization() {
        if (this.m_angles == null) {
            this.initializeDatastructures();
        }
        if (this.m_A == null) {
            this.m_A = this.computeMatrix();
        }
        if (this.m_b == null) {
            this.computeRightHandSide();
        }
        if (this.m_useTAUCS) {
            if (!this.m_factorization1.hasFactorization()) {
                this.m_factorization1.computeFactorization(this.m_A, true, true);
            }
            this.m_factorization1.solveUseFactorization(this.m_angles.m_data, this.m_b.m_data);
        } else {
            if (this.m_factorization2 == null) {
                this.m_factorization2 = PnCSparseCholesky.solve(this.m_A, null, null);
            }
            PnCSparseCholesky.solveUseFactorization(this.m_factorization2, this.m_angles, this.m_b);
        }
        ++this.m_numSystemsSolved;
        return this.m_angles;
    }

    private double elementWeight(int e) {
        return (1.0 - this.getSmoothingFactor()) * this.m_elemArea[e] * this.m_geom.getTrustWeights().m_data[e];
    }

    private double edgeWeight(int e, int ne) {
        double hingeArea = 0.3333333333333333 * (this.m_elemArea[e] + this.m_elemArea[ne]);
        int locE = this.m_geom.getNeighbour(e).getIndexOf(ne);
        PdVector v1 = this.m_geom.getVertex(this.m_geom.getElement(e).getEntry((locE + 1) % 3));
        PdVector v2 = this.m_geom.getVertex(this.m_geom.getElement(e).getEntry((locE + 2) % 3));
        double length = PdVector.dist((PdVector)v1, (PdVector)v2);
        double height = Math.sqrt(3.0) * 2.0 * hingeArea / length;
        double heightRatio = length / height;
        return heightRatio * this.getSmoothingFactor();
    }

    public void setSmoothingFactor(double smooth) {
        double EPS = 0.001;
        if (smooth <= 0.0) {
            double min = 0.001;
            if (this.m_parameterizer != null && this.m_parameterizer.isEnabledConsoleLog()) {
                PsDebug.message((String)("Smoothing factor of " + smooth + " leads to singular optimization problem. " + "Setting smoothing factor to " + min + "."));
            }
            smooth = min;
        }
        if (smooth >= 1.0) {
            double max = 0.999;
            if (this.m_parameterizer != null && this.m_parameterizer.isEnabledConsoleLog()) {
                PsDebug.message((String)("Smoothing factor of " + smooth + " leads to singular optimization problem. " + "Setting smoothing factor to " + max + "."));
            }
            smooth = max;
        }
        this.m_smooth.setValue(smooth);
        this.reset();
        this.updateWeights();
    }

    public double getSmoothingFactor() {
        double value = this.m_smooth.getValue();
        double EPS = 0.001;
        if (value < 0.001) {
            return 0.001;
        }
        if (value > 0.999) {
            return 0.999;
        }
        return value;
    }

    public int getNumSystemsSolved() {
        return this.m_numSystemsSolved;
    }

    public PdVector getAngles() {
        return PdVector.addNew((PdVector)this.m_angles, (PdVector)this.m_rotationAngles);
    }

    @Override
    public String getStatusMessage() {
        return null;
    }

    public PgCovering getCovering() {
        return this.m_geom.getCovering();
    }

    public boolean update(Object event) {
        if (event == this.m_smooth) {
            if (this.m_angles != null) {
                this.updateWeights();
            }
            this.reset();
            return true;
        }
        return super.update(event);
    }

    public PdVector[] getStartAngles() {
        return this.m_startAngles;
    }

    public void applyChange(PiVector path, int change) {
        if (path == null) {
            PsDebug.warning((String)"missing argument.");
            return;
        }
        PgParamGeom geom = this.getGeometry();
        int from = path.getFirstEntry();
        int to = path.getLastEntry();
        int n = from;
        this.m_indices.m_data[n] = this.m_indices.m_data[n] + change;
        int n2 = to;
        this.m_indices.m_data[n2] = this.m_indices.m_data[n2] - change;
        int i = 0;
        while (i < path.getSize() - 1) {
            int v = path.getEntry(i);
            int w = path.getEntry(i + 1);
            PgVertexStar star = this.m_stars[v];
            int j = star.getLink().getIndexOf(w);
            if (star.isClosed() || j != 0 && j != star.getSize()) {
                int elLocInd = (j - 1 + star.getSize()) % star.getSize();
                int elInd = star.getElement().getEntry(elLocInd);
                PiVector elem = geom.getElement(elInd);
                int locInd = (elem.getIndexOf(w) - 1 + elem.getSize()) % elem.getSize();
                int ne = geom.getNeighbour(elInd).getEntry(locInd);
                this.changeMatching(elInd, ne, change, true);
            }
            ++i;
        }
        this.m_geom.getCovering().updateBranchpoint(from, this.m_stars[from].getElement().getFirstEntry());
        this.m_geom.getCovering().updateBranchpoint(to, this.m_stars[to].getElement().getFirstEntry());
    }

    private static PgVertexStar[] makeVertexStars(PgElementSet geom, PiVector elementToVertex) {
        PgVertexStar[] stars = new PgVertexStar[geom.getNumVertices()];
        int v = 0;
        while (v < geom.getNumVertices()) {
            if (elementToVertex.m_data[v] != -1) {
                PgVertexStar star = new PgVertexStar();
                star.makeVertexStar(geom, v, elementToVertex.m_data[v]);
                stars[v] = star;
            }
            ++v;
        }
        return stars;
    }

    public PiVector[] findPaths(PgCovering covering, int startVertex, int numPaths) {
        PiVector branchPoints = covering.getBranchPoints();
        PuQueue queue = new PuQueue();
        queue.enqueue(startVertex);
        PiVector parent = new PiVector(covering.getGeometry().getNumVertices());
        parent.setConstant(-1);
        parent.setEntry(startVertex, -2);
        PiVector[] paths = new PiVector[numPaths];
        int current = 0;
        while (!queue.isEmpty() && current < numPaths) {
            int v = queue.extractFirst();
            PiVector neigh = this.m_stars[v].getLink();
            int start = this.m_stars[v].isClosed() ? 0 : 1;
            int end = this.m_stars[v].isClosed() ? neigh.getSize() : neigh.getSize() - 1;
            int i = start;
            while (i < end) {
                int n = neigh.m_data[i];
                if (parent.getEntry(n) == -1) {
                    parent.setEntry(n, v);
                    queue.enqueue(n);
                    if (branchPoints.getIndexOf(n) != -1) {
                        PiVector path = new PiVector(0);
                        while (parent.getEntry(n) != -2) {
                            path.addEntry(n);
                            n = parent.getEntry(n);
                        }
                        path.addEntry(startVertex);
                        path.invert();
                        paths[current] = path;
                        if (++current == numPaths) {
                            return paths;
                        }
                    }
                }
                ++i;
            }
        }
        return paths;
    }

    public int getIndex(int vertex) {
        return this.m_indices.m_data[vertex];
    }

    public void changeIndex(int vertex, int change) {
        int n = vertex;
        this.m_indices.m_data[n] = this.m_indices.m_data[n] + change;
    }

    public PiVector getLink(int v) {
        return this.m_stars[v].getLink();
    }

    public PgVertexStar getStar(int v) {
        return this.m_stars[v];
    }
}

