/*
 * Decompiled with CFR 0.152.
 */
package devParameterize.modules.fieldGenerator;

import devParameterize.modules.PnModule;
import devParameterize.modules.fieldGenerator.PmSparseFieldGenerator;
import java.awt.BorderLayout;
import java.awt.Choice;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import jv.object.PsDebug;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;
import jvx.gui.PsToolTip;

public class PmSparseFieldGenerator_IP
extends PsPanel
implements ItemListener {
    protected static final String HELP_CURV_RADIUS = "Set a disk radius for averaging the principal curvature tensor. If the radius is 0, principal curvatures will be averaged over all edges incident to a triangle and its vertices. The rightmost slider position accords with the object's diameter. Moving the slider 4 minor ticks to the right yields a good value to start with.";
    protected static final String HELP_TRUST_REGION = "Elements whose principal curvatures are most reliable are considered as trusted. This slider determines how many percent of the triangles will be marked as trusted. The frame field will align only with trusted elements. The frames in non-trusted elements will be rotated in the smoothing phase so that they align best with the trusted ones.";
    protected static final String HELP_ABSOLUTE_THRESHOLD = "This box indicates, whether the Trust Region shall be choosen by the absolute curvature (ticked) or by taking the most curved triangles, whereby the slider above determines the value.";
    protected PmSparseFieldGenerator m_pmSparseFieldGenerator;
    private Choice m_rosySymmetryBox;

    public PmSparseFieldGenerator_IP() {
        if (this.getClass() == PmSparseFieldGenerator_IP.class) {
            this.init();
        }
    }

    public void init() {
        super.init();
    }

    public void setParent(PsUpdateIf parent) {
        if (parent == null) {
            return;
        }
        if (!(parent instanceof PmSparseFieldGenerator)) {
            PsDebug.warning((String)"Parent has to be of type PmSparseFieldGenerator");
            return;
        }
        super.setParent(parent);
        this.m_pmSparseFieldGenerator = (PmSparseFieldGenerator)parent;
        this.makeLayout();
    }

    public void makeLayout() {
        this.removeAll();
        this.setInsetSize(0);
        PsPanel curveRadius_IP = this.m_pmSparseFieldGenerator.m_curvRadius.getInfoPanel();
        this.add((Component)curveRadius_IP);
        if (PnModule.SHOW_TOOLTIPS) {
            new PsToolTip((Component)curveRadius_IP, HELP_CURV_RADIUS);
        }
        PsPanel trustFunction_IP = this.m_pmSparseFieldGenerator.m_trustFunctionThreshold.getInfoPanel();
        this.add((Component)trustFunction_IP);
        if (PnModule.SHOW_TOOLTIPS) {
            new PsToolTip((Component)trustFunction_IP, HELP_TRUST_REGION);
        }
        this.add((Component)this.m_pmSparseFieldGenerator.m_absoluteThreshold.getInfoPanel());
        if (PnModule.SHOW_TOOLTIPS) {
            new PsToolTip((Component)this.m_pmSparseFieldGenerator.m_absoluteThreshold.getInfoPanel(), HELP_ABSOLUTE_THRESHOLD);
        }
        Panel p = new Panel(new GridLayout(1, 2));
        p.add((Component)this.m_pmSparseFieldGenerator.m_alignToBoundary.getInfoPanel());
        p.add((Component)this.m_pmSparseFieldGenerator.m_alignToSharpEdges.getInfoPanel());
        this.add(p);
        this.add((Component)this.m_pmSparseFieldGenerator.m_showSharpEdges.getInfoPanel());
        this.add((Component)this.m_pmSparseFieldGenerator.m_sharpEdgeTheshold.getInfoPanel());
        p = new Panel(new BorderLayout());
        this.m_rosySymmetryBox = new Choice();
        p.add((Component)this.m_rosySymmetryBox, "East");
        this.m_rosySymmetryBox.add("2-rosy");
        this.m_rosySymmetryBox.add("4-rosy");
        this.m_rosySymmetryBox.add("6-rosy");
        this.m_rosySymmetryBox.add("12-rosy");
        this.m_rosySymmetryBox.select(1);
        this.m_rosySymmetryBox.addItemListener(this);
        this.add(p);
    }

    public boolean update(Object event) {
        if (this.m_pmSparseFieldGenerator == null) {
            PsDebug.notify((String)"missing parent");
            return true;
        }
        if (event == this.m_pmSparseFieldGenerator) {
            switch (this.m_pmSparseFieldGenerator.getSymmetryOrder()) {
                case 2: {
                    this.m_rosySymmetryBox.select(0);
                    break;
                }
                case 4: {
                    this.m_rosySymmetryBox.select(1);
                    break;
                }
                case 6: {
                    this.m_rosySymmetryBox.select(2);
                    break;
                }
                case 12: {
                    this.m_rosySymmetryBox.select(3);
                }
            }
        }
        return super.update(event);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        if (source == this.m_rosySymmetryBox) {
            switch (this.m_rosySymmetryBox.getSelectedIndex()) {
                case 0: {
                    this.m_pmSparseFieldGenerator.setSymmetryOrder(2);
                    break;
                }
                case 1: {
                    this.m_pmSparseFieldGenerator.setSymmetryOrder(4);
                    break;
                }
                case 2: {
                    this.m_pmSparseFieldGenerator.setSymmetryOrder(6);
                    break;
                }
                case 3: {
                    this.m_pmSparseFieldGenerator.setSymmetryOrder(12);
                }
            }
        }
    }
}

