/*
 * Decompiled with CFR 0.152.
 */
package devParameterize.modules.fieldGenerator;

import devCovering.PgCovering;
import devParameterize.geom.PgParamGeom;
import devParameterize.modules.PnModule;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgPolygonSet;
import jv.geom.PgVectorField;
import jv.number.PuBoolean;
import jv.number.PuDouble;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.project.PgGeometryIf;
import jv.project.PvDisplayIf;
import jv.vecmath.PbVector;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuVectorGeom;
import jvx.geom.PgUtil;
import jvx.geom.PwShapeOperator;

public class PmSparseFieldGenerator
extends PnModule {
    private static final double BOUNDARY_ALIGNMENT = 10.0;
    private static final double DEFAULT_CURVATURE_RADIUS = 0.0;
    private static final boolean USE_ABSOLUTE_CURVATURE_VALUES = false;
    protected PuBoolean m_alignToBoundary;
    protected PuBoolean m_alignToSharpEdges;
    protected PuDouble m_trustFunctionThreshold;
    protected PuBoolean m_absoluteThreshold;
    protected PuDouble m_meanCurvatureThreshold;
    protected PuDouble m_curvRadius;
    private boolean m_useAbsoluteThreshold;
    protected PuBoolean m_link;
    private PgVectorField m_curvatureVectors;
    private double m_currRadius;
    private PdVector m_trustWeights;
    protected PuBoolean m_showSharpEdges;
    protected PuDouble m_sharpEdgeTheshold;
    private PgPolygonSet m_sharpEdgesGeom;
    private int m_symmetryOrder;

    public PmSparseFieldGenerator() {
        this.setName("Sparse Field Generator");
        this.setStatusMessage("Generate sparse field");
        this.m_trustFunctionThreshold = new PuDouble("Trust function threshold", (PsUpdateIf)this);
        this.m_meanCurvatureThreshold = new PuDouble("Mean curvature threshold", (PsUpdateIf)this);
        this.m_absoluteThreshold = new PuBoolean("Absolute Threshold", (PsUpdateIf)this);
        this.m_alignToBoundary = new PuBoolean("Align to Boundary", (PsUpdateIf)this, false);
        this.m_alignToSharpEdges = new PuBoolean("Align to sharp edges", (PsUpdateIf)this, false);
        this.m_curvRadius = new PuDouble("Support radius");
        this.m_link = new PuBoolean("Link Slider to data");
        this.m_showSharpEdges = new PuBoolean("Show sharp edges", (PsUpdateIf)this);
        this.m_sharpEdgeTheshold = new PuDouble("Dihedral angle for sharp edges", (PsUpdateIf)this);
        this.m_symmetryOrder = 4;
        if (((Object)((Object)this)).getClass() == PmSparseFieldGenerator.class) {
            this.init();
        }
    }

    @Override
    public void init() {
        super.init();
        this.m_trustFunctionThreshold.setDefBounds(0.0, 1.0, 0.01, 0.1);
        this.m_trustFunctionThreshold.setDefValue(0.3);
        this.m_trustFunctionThreshold.init();
        this.m_absoluteThreshold.setDefState(false);
        this.m_absoluteThreshold.init();
        this.m_useAbsoluteThreshold = this.m_absoluteThreshold.getState();
        this.m_alignToBoundary.init();
        this.m_alignToSharpEdges.init();
        this.m_meanCurvatureThreshold.setDefBounds(0.0, 1.0, 1.0, 1.0);
        this.m_meanCurvatureThreshold.setDefValue(0.0);
        this.m_meanCurvatureThreshold.init();
        this.m_curvRadius.setDefBounds(0.0, 1.0, 0.01, 0.1);
        this.m_curvRadius.setDefValue(0.0);
        this.m_curvRadius.init();
        this.m_link.setDefState(true);
        this.m_link.init();
        this.m_showSharpEdges.setDefState(false);
        this.m_showSharpEdges.init();
        this.m_sharpEdgeTheshold.setDefBounds(0.0, 180.0, 5.0, 5.0);
        this.m_sharpEdgeTheshold.setDefValue(180.0);
        this.m_sharpEdgeTheshold.init();
    }

    @Override
    public boolean setGeometry(PgParamGeom geom) {
        if (geom != null && (geom.getCovering() == null || geom.getCovering().getSymmetryOrder() != this.m_symmetryOrder)) {
            PgCovering covering = new PgCovering((PgElementSet)geom, this.m_symmetryOrder);
            geom.setCovering(covering);
        }
        if (!super.setGeometry(geom)) {
            return false;
        }
        double diameter = geom.getDiameter();
        double max = 0.1 / diameter;
        this.m_meanCurvatureThreshold.setBounds(0.0, max, max / 64.0, max / 16.0);
        this.m_meanCurvatureThreshold.setValue(max / 64.0);
        this.m_curvRadius.setBounds(0.0, 0.5 * diameter, diameter / 100.0, diameter / 10.0);
        this.m_curvatureVectors = null;
        this.m_trustWeights = null;
        this.m_currRadius = -1.0;
        this.m_link.setState(true);
        this.updateSharpEdges();
        return true;
    }

    public boolean update(Object event) {
        if (event == null) {
            return super.update(event);
        }
        if (event == this.m_trustFunctionThreshold) {
            if (this.m_link.getState()) {
                this.updateSparseFieldAndTrustweights(false);
                this.m_geom.update((Object)this.m_geom);
            }
            return true;
        }
        if (event == this.m_absoluteThreshold) {
            if (this.m_absoluteThreshold.getState()) {
                this.switchToAbsoluteThreshold();
            } else {
                this.switchToRelativeThreshold();
            }
            return true;
        }
        if (event == this.m_meanCurvatureThreshold) {
            if (this.m_link.getState()) {
                this.updateSparseFieldAndTrustweights(false);
                this.m_geom.update((Object)this.m_geom);
            }
            return true;
        }
        if (event == this.m_alignToBoundary || event == this.m_alignToSharpEdges) {
            return true;
        }
        if (event == this.m_showSharpEdges || event == this.m_sharpEdgeTheshold) {
            this.updateSharpEdges();
            return true;
        }
        return super.update(event);
    }

    public void setTrustThreshold(double thresh, boolean absolute) {
        if (absolute) {
            this.switchToAbsoluteThreshold();
        } else {
            this.switchToRelativeThreshold();
        }
        this.m_trustFunctionThreshold.setValue(thresh);
    }

    private void updateSharpEdges() {
        if (this.m_geom == null) {
            return;
        }
        if (this.m_sharpEdgesGeom != null && this.m_display != null) {
            this.m_display.removeGeometry((PgGeometryIf)this.m_sharpEdgesGeom);
        }
        this.m_sharpEdgesGeom = null;
        if (this.m_showSharpEdges.getState()) {
            this.m_sharpEdgesGeom = new PgPolygonSet(3);
            this.m_sharpEdgesGeom.setName("Sharp Edges Preview");
            this.m_sharpEdgesGeom.setEnabledInstanceSharing(true);
            this.m_sharpEdgesGeom.setNumVertices(this.m_geom.getNumVertices());
            this.m_sharpEdgesGeom.setMaxNumVertices(this.m_geom.getMaxNumVertices());
            this.m_sharpEdgesGeom.setVertices(this.m_geom.getVertices());
            this.m_sharpEdgesGeom.setEnabledInstanceSharing(false);
            this.m_sharpEdgesGeom.showVertices(false);
            PbVector[] se = this.makeSharpEdges();
            int numE = this.m_geom.getNumElements();
            int e = 0;
            while (e < numE) {
                PiVector neighb = this.m_geom.getNeighbour(e);
                int i = 0;
                while (i < 3) {
                    if (neighb.m_data[i] > e && se[e].m_data[i]) {
                        this.m_sharpEdgesGeom.addPolygon(new PiVector(this.m_geom.getElement((int)e).m_data[(i + 1) % 3], this.m_geom.getElement((int)e).m_data[(i + 2) % 3]));
                    }
                    ++i;
                }
                ++e;
            }
            if (this.m_display != null && this.m_sharpEdgesGeom != null) {
                this.m_display.addGeometry((PgGeometryIf)this.m_sharpEdgesGeom);
            }
        }
        this.m_geom.update((Object)this.m_geom);
    }

    @Override
    public void setDisplay(PvDisplayIf display) {
        if (this.m_display != null && this.m_sharpEdgesGeom != null) {
            this.m_display.removeGeometry((PgGeometryIf)this.m_sharpEdgesGeom);
        }
        super.setDisplay(display);
        if (this.m_display != null && this.m_sharpEdgesGeom != null) {
            this.m_display.addGeometry((PgGeometryIf)this.m_sharpEdgesGeom);
        }
    }

    private PbVector[] makeSharpEdges() {
        double angleThreshold = this.m_sharpEdgeTheshold.getValue();
        int numE = this.m_geom.getNumElements();
        PbVector[] se = PbVector.realloc(null, (int)numE, (int)3);
        PdVector[] elemNormal = this.m_geom.getElementNormals();
        int e = 0;
        while (e < numE) {
            PiVector neighb = this.m_geom.getNeighbour(e);
            int i = 0;
            while (i < 3) {
                double angle;
                int ne = neighb.m_data[i];
                if (ne >= 0 && Math.abs(angle = PdVector.angle((PdVector)elemNormal[e], (PdVector)elemNormal[ne])) >= angleThreshold && Math.abs(angle) < 180.0 - angleThreshold) {
                    se[e].m_data[i] = true;
                }
                ++i;
            }
            ++e;
        }
        return se;
    }

    private void switchToRelativeThreshold() {
        if (!this.m_useAbsoluteThreshold) {
            return;
        }
        this.m_useAbsoluteThreshold = false;
        if (this.m_trustWeights == null) {
            return;
        }
        int numE = this.m_geom.getNumElements();
        double thresh = this.m_trustFunctionThreshold.getValue();
        int count = 0;
        int e = 0;
        while (e < numE) {
            if (this.m_trustWeights.m_data[e] >= thresh) {
                ++count;
            }
            ++e;
        }
        this.m_trustFunctionThreshold.setBounds(0.0, 1.0, 0.1, 0.1);
        this.m_trustFunctionThreshold.setValue(1.0 * (double)count / (double)numE);
    }

    private void switchToAbsoluteThreshold() {
        if (this.m_useAbsoluteThreshold) {
            return;
        }
        this.m_useAbsoluteThreshold = true;
        if (this.m_trustWeights == null) {
            return;
        }
        PdVector temp = PdVector.copyNew((PdVector)this.m_trustWeights);
        temp.sort();
        double thresh = temp.getEntry((int)((double)temp.getSize() * (1.0 - this.m_trustFunctionThreshold.getValue())));
        double max = temp.getLastEntry();
        this.m_trustFunctionThreshold.setBounds(0.0, max, max / 16.0, max / 16.0);
        this.m_trustFunctionThreshold.setValue(thresh);
    }

    public double getCurvRadius() {
        return this.m_curvRadius.getValue();
    }

    public void setCurvRadius(double radius) {
        this.m_curvRadius.setValue(radius);
    }

    public double getCurvRadiusTic() {
        return this.m_curvRadius.getLineIncr();
    }

    @Override
    public boolean start() {
        if (!super.start()) {
            return false;
        }
        this.m_link.setState(false);
        this.updateSparseFieldAndTrustweights(true);
        this.m_showSharpEdges.setState(false);
        this.updateSharpEdges();
        if (this.m_alignToSharpEdges.getState()) {
            this.m_geom.setSharpEdges(this.makeSharpEdges());
            this.addSharpEdgesAlignment(this.m_geom.getTrustWeights(), this.m_geom.getSparseField());
            this.m_geom.setUpdateTrustWeights(true);
            this.m_geom.setUpdateSparseField(true);
        }
        return true;
    }

    protected void updateSparseFieldAndTrustweights(boolean computeCurvatures) {
        PdVector tw;
        if (this.m_geom == null) {
            return;
        }
        int numE = this.m_geom.getNumElements();
        PgVectorField sf = this.m_geom.getSparseField();
        if (sf == null || sf.getGeometry() != this.m_geom) {
            sf = new PgVectorField(3, 1);
            sf.setGeometry((PgPointSet)this.m_geom);
            sf.setName("SparseConstraints");
        }
        if ((tw = this.m_geom.getTrustWeights()) == null) {
            tw = new PdVector(numE);
        }
        if (this.m_curvatureVectors == null || this.m_geom.getCurvatureVectorField() == null || this.m_curvRadius.getValue() != this.m_currRadius) {
            if (computeCurvatures) {
                this.computePrincipalCurvatures();
            } else {
                tw.setConstant(0.0);
                return;
            }
        }
        double trustMin = this.m_trustFunctionThreshold.getValue();
        boolean[] trusted = PmSparseFieldGenerator.findLargestEntries((PdVector)this.m_trustWeights, (double)trustMin, (boolean)this.m_useAbsoluteThreshold).m_data;
        double hMin = this.m_meanCurvatureThreshold.getValue();
        int e = 0;
        while (e < numE) {
            double kMin = this.m_geom.getCurvatureValues()[e].m_data[1];
            double kMax = this.m_geom.getCurvatureValues()[e].m_data[0];
            double h = kMin + kMax;
            if (Math.abs(h) < hMin) {
                trusted[e] = false;
            }
            ++e;
        }
        boolean somethingTrusted = false;
        int e2 = 0;
        while (e2 < numE) {
            if (trusted[e2]) {
                somethingTrusted = true;
                tw.m_data[e2] = this.m_trustWeights.m_data[e2];
                sf.getVector(e2).copy(this.m_curvatureVectors.getVector(e2));
                sf.getVector(e2).normalize();
            } else {
                tw.m_data[e2] = 0.0;
                sf.getVector(e2).setConstant(0.0);
            }
            ++e2;
        }
        if (!somethingTrusted && !this.m_alignToBoundary.getState()) {
            tw.setFirstEntry(1.0);
            sf.getVector(0).copy(this.m_curvatureVectors.getVector(0));
            sf.getVector(0).normalize();
        }
        tw.multScalar(PgUtil.getEdgeLengths((PgElementSet)this.m_geom, null, (boolean)true).average());
        if (this.m_alignToBoundary.getState()) {
            this.addBoundaryAlignment(tw, sf);
        }
        this.m_geom.setTrustWeights(tw);
        this.m_geom.setSparseField(sf);
    }

    private void addBoundaryAlignment(PdVector tw, PgVectorField sf) {
        int noe = this.m_geom.getNumElements();
        PdVector edge = new PdVector(this.m_geom.getDimOfVertices());
        int e = 0;
        while (e < noe) {
            PiVector neigh = this.m_geom.getNeighbour(e);
            PiVector elem = this.m_geom.getElement(e);
            int numBoundaries = neigh.changeValue(-1, -1);
            if (numBoundaries == 1) {
                int locInd = neigh.getIndexOf(-1);
                PdVector v1 = this.m_geom.getVertex(elem.getEntry((locInd + 1) % 3));
                PdVector v2 = this.m_geom.getVertex(elem.getEntry((locInd + 2) % 3));
                edge.sub(v1, v2);
                edge.normalize();
                edge.cross(this.m_geom.getElementNormal(e), edge);
                sf.setVector(e, edge);
                tw.setEntry(e, 2);
            }
            ++e;
        }
    }

    private void addSharpEdgesAlignment(PdVector tw, PgVectorField sf) {
        double avg = tw.max() / this.m_trustFunctionThreshold.getValue();
        int numE = this.m_geom.getNumElements();
        int e = 0;
        while (e < numE) {
            PiVector elem = this.m_geom.getElement(e);
            int i = 0;
            while (i < 3) {
                if (this.m_geom.getSharpEdges()[e].m_data[i]) {
                    PdVector v1 = this.m_geom.getVertex(elem.getEntry((i + 1) % 3));
                    PdVector v2 = this.m_geom.getVertex(elem.getEntry((i + 2) % 3));
                    PdVector edge = PdVector.subNew((PdVector)v1, (PdVector)v2);
                    edge.normalize();
                    edge.cross(this.m_geom.getElementNormal(e), edge);
                    sf.setVector(e, edge);
                    tw.setEntry(e, avg * 10.0);
                }
                ++i;
            }
            ++e;
        }
    }

    private static void smoothFunction(PdVector values, PgElementSet geom) {
        PdVector bValues = PdVector.copyNew((PdVector)values);
        int numE = geom.getNumElements();
        int e = 0;
        while (e < numE) {
            int dim = geom.getDimOfElement(e);
            int n = e;
            values.m_data[n] = values.m_data[n] * (double)dim;
            PiVector neigh = geom.getNeighbour(e);
            int j = 0;
            while (j < dim) {
                int ne = neigh.getEntry(j);
                if (ne < 0) {
                    int n2 = e;
                    values.m_data[n2] = values.m_data[n2] + bValues.m_data[e];
                } else {
                    int n3 = e;
                    values.m_data[n3] = values.m_data[n3] + bValues.m_data[ne];
                }
                ++j;
            }
            int n4 = e++;
            values.m_data[n4] = values.m_data[n4] * (0.5 / (double)dim);
        }
    }

    private void computePrincipalCurvatures() {
        PdVector[] curvatures = PdVector.realloc(null, (int)this.m_geom.getNumElements(), (int)2);
        double curvRadius = this.m_curvRadius.getValue();
        PgVectorField[] cf = new PgVectorField[2];
        cf[0] = new PgVectorField(3, 1);
        cf[0].setGeometry((PgPointSet)this.m_geom);
        cf[1] = new PgVectorField(3, 1);
        cf[1].setGeometry((PgPointSet)this.m_geom);
        boolean tmp = PwShapeOperator.isEnabledAbsoluteValue();
        PwShapeOperator.enableAbsoluteValue((boolean)false);
        if (curvRadius == 0.0) {
            cf = PwShapeOperator.makeElementBasedPrincipalCurvatures((PgElementSet)this.m_geom, (PdVector[])curvatures, (boolean)false);
        } else {
            cf = PwShapeOperator.makeElementBasedPrincipalCurvatures((PgElementSet)this.m_geom, (PdVector[])curvatures, (double)curvRadius);
            if (PdVector.flatten((PdVector[])curvatures).maxAbs() == 0.0) {
                cf = PwShapeOperator.makeElementBasedPrincipalCurvatures((PgElementSet)this.m_geom, (PdVector[])curvatures, (boolean)false);
            }
        }
        PwShapeOperator.enableAbsoluteValue((boolean)tmp);
        int e = 0;
        while (e < curvatures.length) {
            if (Math.abs(curvatures[e].m_data[1] - curvatures[e].m_data[0]) < 1.0E-10) {
                PdVector normal = this.m_geom.getElementNormal(e);
                PdVector u = cf[0].getVector(e);
                PuVectorGeom.rotatePointAroundVector((PdVector)u, (PdVector)u, (PdVector)normal, (double)0.7853981633974483);
                PdVector w = cf[1].getVector(e);
                PuVectorGeom.rotatePointAroundVector((PdVector)w, (PdVector)w, (PdVector)normal, (double)0.7853981633974483);
            }
            ++e;
        }
        this.m_currRadius = curvRadius;
        this.m_geom.setCurvatureValues(curvatures);
        this.m_curvatureVectors = new PgVectorField(3, 1);
        this.m_curvatureVectors.setGeometry((PgPointSet)this.m_geom);
        this.m_curvatureVectors.copy((PsObject)cf[0]);
        this.m_geom.setCurvatureField(cf);
        this.m_geom.setCurvatureVectorField(this.m_curvatureVectors);
        this.m_trustWeights = PwShapeOperator.makeTrustFunction((PgVectorField)this.m_curvatureVectors, (PdVector[])curvatures, (boolean)true);
        PmSparseFieldGenerator.smoothFunction(this.m_trustWeights, (PgElementSet)this.m_geom);
    }

    public PgVectorField getCurvatureVectors() {
        return this.m_curvatureVectors;
    }

    public void setCurvatureVectors(PgVectorField curvatureVectors) {
        this.m_curvatureVectors = curvatureVectors;
    }

    public void setAlignToSharpEdges(boolean b) {
        this.m_alignToSharpEdges.setState(b);
    }

    public void setAlignToBoundary(boolean b) {
        this.m_alignToBoundary.setState(b);
    }

    public void showSharpEdges(boolean b) {
        this.m_showSharpEdges.setState(b);
        this.updateSharpEdges();
    }

    public int getSymmetryOrder() {
        return this.m_symmetryOrder;
    }

    public void setSymmetryOrder(int symmetryOrder) {
        this.m_symmetryOrder = symmetryOrder;
    }

    public static PbVector findLargestEntries(PdVector vector, double threshold, boolean absoluteThreshold) {
        if (!absoluteThreshold) {
            PdVector temp = PdVector.copyNew((PdVector)vector);
            temp.sort();
            int ind = (int)((double)temp.getSize() * (1.0 - threshold));
            if (ind >= temp.getSize()) {
                ind = temp.getSize() - 1;
            }
            double thresh = temp.getEntry(ind);
            return PmSparseFieldGenerator.findLargestEntries(vector, thresh, true);
        }
        PbVector largest = new PbVector(vector.getSize());
        int size = vector.getSize();
        int e = 0;
        while (e < size) {
            if (vector.m_data[e] >= threshold) {
                largest.m_data[e] = true;
            }
            ++e;
        }
        return largest;
    }
}

