/*
 * Decompiled with CFR 0.152.
 */
package devParameterize.modules.fieldGenerator;

import devParameterize.geom.PgParamGeom;
import devParameterize.modules.PnModule;
import java.awt.Color;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgVectorField;
import jv.number.PuBoolean;
import jv.number.PuDouble;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.project.PgGeometryIf;
import jv.project.PvPickEvent;
import jv.project.PvPickListenerIf;
import jv.vecmath.PdBary;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuVectorGeom;
import jvx.geom.PgPolygonOnElementSet;
import jvx.geom.PwGeodesic;
import jvx.geom.PwShapeOperator;

public class PmSparseFieldEditor
extends PnModule
implements PvPickListenerIf {
    protected static final int MODE_ADD_FRAME = 0;
    protected static final int MODE_REMOVE_FRAME = 1;
    protected static final int MODE_SET_TRUST = 2;
    protected static final int MODE_ADD_LINE_CONSTRAINTS = 3;
    protected PuBoolean m_lineConstraints;
    protected PgPolygonOnElementSet m_line;
    private int m_startV = -1;
    private int m_startElt;
    private PdBary m_startBary;
    protected final Object m_continueWaiter;
    protected int m_editingMode;
    protected PuDouble m_setTrustValue;
    protected PuDouble m_setAngle;
    protected double[] m_frameAngles;
    protected PgVectorField m_curvatureVectors;

    public PmSparseFieldEditor() {
        this.setName("Sparse Field Editor");
        this.setStatusMessage("Editing the sparse frame field, (N) select faces, (I) add Path and  press continue to go on!");
        this.m_setTrustValue = new PuDouble("Trust value", (PsUpdateIf)this);
        this.m_setAngle = new PuDouble("Frame angle", (PsUpdateIf)this);
        this.m_startElt = -1;
        this.m_continueWaiter = new Object();
        this.m_editingMode = 0;
        if (((Object)((Object)this)).getClass() == PmSparseFieldEditor.class) {
            this.init();
        }
    }

    @Override
    public void init() {
        super.init();
        this.setEnabled(false);
        this.m_setTrustValue.setDefBounds(0.0, 2.0, 0.05, 0.5);
        this.m_setTrustValue.setDefValue(1.0);
        this.m_setTrustValue.init();
        this.m_setAngle.setDefBounds(-Math.PI, Math.PI, 0.1, 0.5);
        this.m_setAngle.setDefValue(0.0);
        this.m_setAngle.init();
        this.m_lineConstraints = new PuBoolean("Line Constraints", (PsUpdateIf)this);
        this.m_lineConstraints.setDefState(true);
        this.m_lineConstraints.init();
        this.m_line = new PgPolygonOnElementSet(3);
        this.setEditModus(3);
    }

    @Override
    public boolean setGeometry(PgParamGeom geom) {
        if (!super.setGeometry(geom)) {
            return false;
        }
        this.m_frameAngles = new double[this.m_geom.getNumElements()];
        int i = 0;
        while (i < this.m_frameAngles.length) {
            this.m_frameAngles[i] = 0.0;
            ++i;
        }
        this.m_line.setGeometry((PgElementSet)this.m_geom);
        return true;
    }

    public boolean update(Object event) {
        if (event == this.m_setTrustValue) {
            PdVector newTrustWeights = (PdVector)this.m_geom.getTrustWeights().clone();
            int i = 0;
            while (i < this.m_geom.getNumElements()) {
                if (this.m_geom.getElement(i).hasTag(1)) {
                    newTrustWeights.setEntry(i, this.m_setTrustValue.getValue());
                    if (this.m_setTrustValue.getValue() > 0.0 && this.m_geom.getSparseField().getVector(i).maxAbs() == 0.0) {
                        this.m_geom.getSparseField().setVector(i, (PdVector)this.m_curvatureVectors.getVector(i).clone());
                    } else if (this.m_setTrustValue.getValue() == 0.0) {
                        this.m_geom.getSparseField().getVector(i).setConstant(0.0);
                    }
                }
                ++i;
            }
            this.m_geom.setTrustWeights(newTrustWeights);
            this.m_geom.getSparseField().update((Object)this.m_geom.getSparseField());
            return true;
        }
        if (event == this.m_setAngle) {
            PdVector newTrustWeights = (PdVector)this.m_geom.getTrustWeights().clone();
            int numEl = this.m_geom.getNumElements();
            int i = 0;
            while (i < numEl) {
                if (this.m_geom.getElement(i).hasTag(1)) {
                    this.m_frameAngles[i] = this.m_setAngle.getValue();
                    PdVector newFrame = (PdVector)this.m_curvatureVectors.getVector(i).clone();
                    PuVectorGeom.rotatePointAroundVector((PdVector)newFrame, (PdVector)newFrame, (PdVector)this.m_geom.getElementNormal(i), (double)this.m_frameAngles[i]);
                    this.m_geom.getSparseField().setVector(i, newFrame);
                    newTrustWeights.setEntry(i, this.m_setTrustValue.getValue());
                }
                ++i;
            }
            this.m_geom.setTrustWeights(newTrustWeights);
            this.m_geom.getSparseField().update((Object)this.m_geom.getSparseField());
            return true;
        }
        if (event == this.m_lineConstraints) {
            if (this.m_lineConstraints.getState()) {
                this.setEditModus(3);
            } else {
                this.setEditModus(0);
            }
            return true;
        }
        return super.update(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean start() {
        Object sf;
        if (!super.start()) {
            return false;
        }
        if (this.m_editingMode == 3) {
            this.m_line.init();
            if (!this.m_display.containsGeometry((PgGeometryIf)this.m_line)) {
                this.m_display.addGeometry((PgGeometryIf)this.m_line);
            }
            if (!this.m_display.hasPickListener((PvPickListenerIf)this)) {
                this.m_display.addPickListener((PvPickListenerIf)this);
            }
        }
        if (this.m_geom.getCurvatureVectorField() == null) {
            PdVector[] m_curvatureValues = new PdVector[this.m_geom.getNumElements()];
            this.m_curvatureVectors = PwShapeOperator.makeElementBasedPrincipalCurvatures((PgElementSet)this.m_geom, (PdVector[])m_curvatureValues, (boolean)false)[0];
            int i = 0;
            while (i < this.m_curvatureVectors.getNumVectors()) {
                this.m_curvatureVectors.getVector(i).normalize();
                ++i;
            }
            this.m_geom.setCurvatureVectorField(this.m_curvatureVectors);
            this.m_geom.setCurvatureValues(m_curvatureValues);
            sf = this.m_geom.getSparseField();
            if (sf == null || sf.getGeometry() != this.m_geom) {
                sf = new PgVectorField(3, 1);
                sf.setGeometry((PgPointSet)this.m_geom);
                sf.setName("SparseConstraints");
            }
            this.m_geom.setSparseField((PgVectorField)sf);
        } else {
            this.m_curvatureVectors = this.m_geom.getCurvatureVectorField();
        }
        if (this.m_curvatureVectors == null) {
            PsDebug.warning((String)"Couldn't compute curvature vectors for this geometry.");
            return false;
        }
        if (this.m_geom.getTrustWeights() != null) {
            this.m_geom.getTrustWeights().multScalar(1.0 / this.m_geom.getTrustWeights().max());
        } else {
            PdVector trustWeights = new PdVector(this.m_geom.getNumElements());
            trustWeights.setConstant(0.0);
            this.m_geom.setTrustWeights(trustWeights);
        }
        int previousColorMethod = this.m_geom.getShowingColor();
        this.m_geom.showColors(1);
        this.m_geom.showField(true);
        this.m_geom.showSparseField(true);
        this.m_geom.updateVisualizations();
        this.m_geom.update((Object)this.m_geom);
        try {
            sf = this.m_continueWaiter;
            synchronized (sf) {
                this.m_continueWaiter.wait();
            }
        }
        catch (Exception e) {
            System.err.println("Exception in start() in PmSparseFieldEditor");
        }
        int i = 0;
        while (i < this.m_geom.getNumElements()) {
            this.m_geom.getElement(i).clearTag(1);
            ++i;
        }
        this.m_geom.showColors(previousColorMethod);
        this.m_geom.showField(false);
        this.m_geom.showSparseField(false);
        this.m_geom.update((Object)this.m_geom);
        return true;
    }

    public void setEditModus(int mode) {
        this.m_editingMode = mode;
    }

    public void selectGeometry(PgGeometryIf geom) {
    }

    public void pickDisplay(PvPickEvent pos) {
    }

    public void dragDisplay(PvPickEvent pos) {
    }

    public void pickInitial(PvPickEvent pos) {
        if (this.m_editingMode == 3) {
            this.pickInitialAddConstraints(pos);
            return;
        }
    }

    private void pickInitialAddConstraints(PvPickEvent pos) {
        if (pos.getGeometry() != this.m_geom) {
            return;
        }
        int i = 0;
        while (i < this.m_geom.getNumElements()) {
            this.m_geom.getElement(i).clearTag(1);
            ++i;
        }
        PdBary b = pos.getBary();
        int e = b.getElementInd();
        if (e < 0) {
            return;
        }
        if (this.m_startV < 0) {
            this.m_line.init();
            this.m_line.setNumVertices(1);
            this.m_line.setVertexBary(0, e, b);
            this.m_line.setVertexSize(0, 2.0);
            this.m_line.setVertexColor(0, Color.ORANGE);
            this.m_line.showVertexColors(true);
            this.m_line.showVertexSizes(true);
            this.m_line.update((Object)this.m_line);
            this.m_startV = 1;
            this.m_startElt = e;
            this.m_startBary = b;
        } else {
            this.makeGeodesicConstraint(this.m_startElt, this.m_startBary, e, b);
            this.m_startV = -1;
        }
        this.update((Object)this);
    }

    private void makeGeodesicConstraint(int startElt, PdBary startBary, int endElt, PdBary endBary) {
        this.m_line.copy((PsObject)PwGeodesic.getShortest((PgElementSet)this.m_geom, (PdBary)startBary, (int)startElt, (PdBary)endBary, (int)endElt));
        this.makeElementSparseDirection(this.m_line, this.m_geom);
        if (!this.m_display.containsGeometry((PgGeometryIf)this.m_line)) {
            this.m_display.addGeometry((PgGeometryIf)this.m_line);
        }
        this.m_line.showVertices(false);
        this.m_line.setGlobalEdgeColor(Color.red);
        this.m_line.setGlobalEdgeSize(2.0);
        this.m_line.update((Object)this.m_line);
    }

    private void makeElementSparseDirection(PgPolygonOnElementSet line, PgParamGeom geom) {
        PiVector indElt = line.getVertexElemInd();
        PdVector newTrustWeights = (PdVector)this.m_geom.getTrustWeights().clone();
        int i = 0;
        while (i < line.getNumVertices() - 1) {
            PdVector s = line.getVertex(i);
            PdVector e = line.getVertex(i + 1);
            PdVector dir = PdVector.subNew((PdVector)e, (PdVector)s);
            dir.normalize();
            this.m_geom.getSparseField().setVector(indElt.m_data[i], dir);
            this.m_geom.getSparseField().update((Object)this.m_geom.getSparseField());
            this.m_geom.getElement(indElt.m_data[i]).setTag(1);
            newTrustWeights.setEntry(indElt.m_data[i], this.m_setTrustValue.getValue());
            ++i;
        }
        this.m_geom.setTrustWeights(newTrustWeights);
        this.m_geom.update((Object)this.m_geom);
    }

    public void dragInitial(PvPickEvent pos) {
    }

    public void pickVertex(PgGeometryIf geom, int index, PdVector vertex) {
    }

    public void dragVertex(PgGeometryIf geom, int index, PdVector vertex) {
    }

    public void markVertices(PvPickEvent pos) {
    }

    public void unmarkVertices(PvPickEvent pos) {
    }

    public void removePickListener() {
        if (this.m_display.hasPickListener((PvPickListenerIf)this)) {
            this.m_display.removePickListener((PvPickListenerIf)this);
        }
    }

    public void removeLineConstraints() {
        if (this.m_display.containsGeometry((PgGeometryIf)this.m_line)) {
            this.m_display.removeGeometry((PgGeometryIf)this.m_line);
        }
        this.m_display.update((Object)this.m_display);
    }
}

