/*
 * Decompiled with CFR 0.152.
 */
package devParameterize.modules.fieldGenerator;

import devGraph.PnGraphOnElementSet;
import devParameterize.geom.PgParamGeom;
import devParameterize.modules.PnModule;
import devParameterize.modules.fieldGenerator.PmRelaxEnergyCurl;
import devParameterize.modules.fieldGenerator.PmVectorAngleSmoother;
import jv.geom.PgElementSet;
import jv.geom.PgVectorField;
import jv.object.PsDebug;
import jv.object.PsUpdateIf;
import jv.project.PgGeometryIf;
import jv.project.PvDisplayIf;
import jv.project.PvPickEvent;
import jv.project.PvPickListenerIf;
import jv.vecmath.PdBary;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public class PmSingularityMover
extends PnModule
implements PvPickListenerIf {
    private static final long serialVersionUID = -573247245347272514L;
    private int m_bpInd;
    protected final Object m_continueWaiter;
    protected PmRelaxEnergyCurl m_energy;

    public PmSingularityMover() {
        this.setName("Singularity Mover");
        this.setStatusMessage("Move Singularities");
        this.m_continueWaiter = new Object();
        this.m_energy = new PmRelaxEnergyCurl();
        if (((Object)((Object)this)).getClass() == PmSingularityMover.class) {
            this.init();
        }
    }

    @Override
    public void init() {
        super.init();
        this.setEnabled(false);
    }

    @Override
    public boolean setGeometry(PgParamGeom geom) {
        if (!super.setGeometry(geom)) {
            return false;
        }
        if (this.m_geom != null) {
            this.m_geom.removeUpdateListener((PsUpdateIf)this);
        }
        super.setGeometry(geom);
        if (this.m_geom != null) {
            this.m_geom.addUpdateListener((PsUpdateIf)this);
        }
        this.m_bpInd = -1;
        return true;
    }

    @Override
    public PvDisplayIf getDisplay() {
        return this.m_display;
    }

    @Override
    public void setDisplay(PvDisplayIf display) {
        if (this.m_display != null) {
            this.m_display.removePickListener((PvPickListenerIf)this);
        }
        super.setDisplay(display);
        this.m_bpInd = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean start() {
        if (!super.start() || this.m_geom.getCovering().getBranchPoints().getSize() == 0) {
            return false;
        }
        if (this.m_geom.getFixMatching()) {
            this.m_geom.setFixMatching(false);
        }
        if (!this.m_display.hasPickListener((PvPickListenerIf)this)) {
            this.m_display.addPickListener((PvPickListenerIf)this);
        }
        this.m_geom.showGradientField(true);
        this.m_geom.showField(true);
        PgVectorField[] field = new PgVectorField[]{this.m_geom.getFrameField().getField(0), this.m_geom.getFrameField().getField(1)};
        this.m_geom.setGradientField(field);
        this.m_geom.update((Object)this.m_geom);
        this.m_energy.setParameterizer(this.getParameterizer());
        PdVector[][] texture = new PdVector[this.m_geom.getNumElements()][];
        int noe = this.m_geom.getNumElements();
        int e2 = 0;
        while (e2 < noe) {
            texture[e2] = PdVector.realloc(null, (int)this.m_geom.getDimOfElement(e2), (int)2);
            ++e2;
        }
        this.m_geom.setTmpTexture(texture);
        this.m_geom.assureElementTextures();
        this.m_energy.show(this.m_energy.eval());
        try {
            Object e2 = this.m_continueWaiter;
            synchronized (e2) {
                this.m_continueWaiter.wait();
            }
        }
        catch (Exception e3) {
            System.err.println("Exception in start() in PmSparseFieldEditor");
        }
        this.removePickListener();
        this.m_geom.showGradientField(false);
        this.m_geom.showField(false);
        this.m_geom.update((Object)this.m_geom);
        this.update((Object)this);
        this.m_geom.setTmpTexture(null);
        return true;
    }

    private void moveSingularity(int bpInd, int destV) {
        this.m_geom.assureElementTextures();
        int v = this.m_geom.getCovering().getBranchPoints().m_data[bpInd];
        PiVector path = PnGraphOnElementSet.makeShortestPath((PgElementSet)this.m_geom, (int)v, (int)destV, (int)0);
        PmVectorAngleSmoother smoother = this.getParameterizer().getSmoother();
        if (smoother != null && path != null) {
            this.m_geom.clearTagVertex(v, 1);
            this.m_geom.setTagVertex(destV, 1);
            smoother.applyChange(path, -((int)Math.signum(smoother.getIndex(v))));
            this.m_geom.setUpdateBranchpoints(true);
            smoother.start();
            this.m_geom.setUpdateField(true);
            PgVectorField[] field = new PgVectorField[]{this.m_geom.getFrameField().getField(0), this.m_geom.getFrameField().getField(1)};
            this.m_geom.setGradientField(field);
            this.m_energy.show(this.m_energy.eval());
            this.m_geom.update((Object)this.m_geom);
        }
    }

    public boolean update(Object event) {
        if (event == null) {
            super.update(null);
        }
        if (event == this.m_geom) {
            this.update((Object)this);
            return true;
        }
        return super.update(event);
    }

    public void selectGeometry(PgGeometryIf geom) {
    }

    public void pickDisplay(PvPickEvent pos) {
    }

    public void dragDisplay(PvPickEvent pos) {
    }

    public void pickInitial(PvPickEvent pos) {
        int bpInd;
        if (pos.getGeometry() != this.m_geom) {
            return;
        }
        if (this.m_geom == null || this.m_geom.getFrameField() == null) {
            PsDebug.warning((String)"Missing geometry or field set.");
            return;
        }
        PdBary b = pos.getBary();
        int e = b.getElementInd();
        if (e < 0) {
            return;
        }
        int locInd = b.m_data[0] >= b.m_data[1] && b.m_data[0] >= b.m_data[2] ? 0 : (b.m_data[1] >= b.m_data[2] ? 1 : 2);
        int v = this.m_geom.getElement((int)e).m_data[locInd];
        if (this.m_bpInd > -1) {
            this.m_geom.clearTagVertex(this.m_geom.getCovering().getBranchPoints().m_data[this.m_bpInd], 1);
        }
        if ((bpInd = this.m_geom.getCovering().getBranchPoints().getIndexOf(v)) < 0) {
            PsDebug.warning((String)"Pick a branch point.");
            return;
        }
        this.m_geom.setTagVertex(v, 1);
        this.m_geom.update((Object)this.m_geom);
        this.m_bpInd = bpInd;
        this.update((Object)this);
    }

    public void dragInitial(PvPickEvent pos) {
        if (pos.getGeometry() != this.m_geom) {
            return;
        }
        if (this.m_geom == null || this.m_geom.getFrameField() == null) {
            PsDebug.warning((String)"Missing geometry or field set.");
            return;
        }
        PdBary b = pos.getBary();
        int e = b.getElementInd();
        if (e < 0) {
            return;
        }
        int locInd = b.m_data[0] >= b.m_data[1] && b.m_data[0] >= b.m_data[2] ? 0 : (b.m_data[1] >= b.m_data[2] ? 1 : 2);
        int v = this.m_geom.getElement((int)e).m_data[locInd];
        if (this.m_bpInd < 0) {
            this.m_bpInd = this.m_geom.getCovering().getBranchPoints().getIndexOf(v);
        }
        if (this.m_bpInd < 0) {
            return;
        }
        this.moveSingularity(this.m_bpInd, v);
        this.m_bpInd = this.m_geom.getCovering().getBranchPoints().getIndexOf(v);
        this.m_geom.setUpdateBranchpoints(true);
        if (this.m_bpInd > -1) {
            this.m_geom.clearTagVertex(this.m_geom.getCovering().getBranchPoints().m_data[this.m_bpInd], 1);
        }
        this.m_geom.update((Object)this.m_geom);
        this.update((Object)this);
    }

    public void pickVertex(PgGeometryIf geom, int index, PdVector vertex) {
    }

    public void dragVertex(PgGeometryIf geom, int index, PdVector vertex) {
    }

    public void markVertices(PvPickEvent pos) {
    }

    public void unmarkVertices(PvPickEvent pos) {
    }

    public void removePickListener() {
        if (this.m_display.hasPickListener((PvPickListenerIf)this)) {
            this.m_display.removePickListener((PvPickListenerIf)this);
        }
    }
}

