/*
 * Decompiled with CFR 0.152.
 */
package devParameterize.modules.fieldGenerator;

import devCovering.PgFrameField;
import devParameterize.apps.PwParameterizerBase;
import devParameterize.covering.PgTextureMapOnCovering;
import devParameterize.geom.PgParamGeom;
import devParameterize.modules.PnModule;
import devParameterize.modules.fieldGenerator.PmRelaxEnergyIf;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Label;
import jv.number.PuDouble;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;
import jv.vecmath.PdVector;
import jv.vecmath.PuMath;

public class PmRelaxEnergyModuleCaller
extends PsObject
implements PmRelaxEnergyIf {
    protected PwParameterizerBase m_parameterizer;
    protected PgParamGeom m_geom;
    private PgFrameField m_curlField;
    private PgFrameField m_curlFreeField;
    protected PuDouble m_alignmentWeight = new PuDouble("Improve Alignment", (PsUpdateIf)this);
    protected PuDouble m_negativeTrianglesWeight;
    private Checkbox[] m_enabled;
    private PgFrameField m_fieldBackup;
    private PgFrameField m_fieldBeforeHodge;
    private PgFrameField m_gradient;

    public PmRelaxEnergyModuleCaller() {
        this.m_alignmentWeight.setDefBounds(0.0, 10.0, 0.1, 1.0);
        this.m_alignmentWeight.setDefValue(1.0);
        this.m_negativeTrianglesWeight = new PuDouble("Num Negative Triangles", (PsUpdateIf)this);
        this.m_negativeTrianglesWeight.setDefBounds(0.0, 100.0, 1.0, 10.0);
        this.m_negativeTrianglesWeight.setDefValue(0.0);
        if (this.getClass() == PmRelaxEnergyModuleCaller.class) {
            this.init();
        }
    }

    @Override
    public void setParameterizer(PwParameterizerBase parameterizer) {
        this.m_parameterizer = parameterizer;
        this.m_geom = this.m_parameterizer.getGeometry();
        this.m_curlField = new PgFrameField(this.m_geom.getCovering());
        this.m_curlField.assureFields();
        this.m_curlFreeField = new PgFrameField(this.m_geom.getCovering());
        this.m_curlFreeField.assureFields();
        this.m_gradient = new PgFrameField(this.m_geom.getCovering());
        this.m_gradient.assureFields();
    }

    @Override
    public void cleanup() {
        this.m_geom = null;
        this.m_curlField = null;
        this.m_curlFreeField = null;
        this.m_gradient = null;
    }

    public void init() {
        this.m_alignmentWeight.init();
        this.m_negativeTrianglesWeight.init();
    }

    public boolean update(Object event) {
        if (event == this.m_alignmentWeight || event == this.m_negativeTrianglesWeight) {
            return true;
        }
        return super.update(event);
    }

    @Override
    public PsPanel getInfoPanel() {
        PsPanel p = new PsPanel();
        p.add((Component)new Label("Used Modules:"));
        this.m_enabled = new Checkbox[this.m_parameterizer.getNumUsedModules()];
        int i = this.getStartModule();
        while (i < this.m_parameterizer.getNumUsedModules()) {
            PnModule module = this.m_parameterizer.getUsedModule(i);
            this.m_enabled[i] = new Checkbox(module.getName());
            this.m_enabled[i].setState(module.getEnabled());
            p.add((Component)this.m_enabled[i]);
            ++i;
        }
        p.add((Component)new Label("Quality Measurement:"));
        p.add((Component)this.m_alignmentWeight.getInfoPanel());
        p.add((Component)this.m_negativeTrianglesWeight.getInfoPanel());
        return p;
    }

    @Override
    public String toString() {
        return "Module Caller";
    }

    public static double computeAlignment(PgParamGeom geom, PgFrameField curlFreeField) {
        double alignment = 0.0;
        int e = 0;
        while (e < geom.getNumElements()) {
            if (geom.getTrustWeights().m_data[e] != 0.0) {
                PdVector direction = geom.getSparseField().getVector(e);
                PdVector vector0 = curlFreeField.getField(0).getVector(e);
                PdVector vector1 = curlFreeField.getField(1).getVector(e);
                double dist0 = Math.abs(PdVector.dot((PdVector)direction, (PdVector)vector0));
                double dist1 = Math.abs(PdVector.dot((PdVector)direction, (PdVector)vector1));
                double align = PuMath.sqr((double)Math.min(dist0, dist1)) / geom.getFrameScaleFactor();
                double area = geom.getAreaOfElement(e);
                alignment += geom.getTrustWeights().m_data[e] * area * align;
            }
            ++e;
        }
        return alignment;
    }

    private double computeEnergy() {
        PgTextureMapOnCovering tex = this.makeGradient();
        double energy = tex.distL2(this.m_fieldBeforeHodge);
        if (this.m_alignmentWeight.getValue() > 0.0) {
            energy += this.m_alignmentWeight.getValue() * PmRelaxEnergyModuleCaller.computeAlignment(this.m_geom, this.m_gradient);
        }
        if (this.m_negativeTrianglesWeight.getValue() > 0.0) {
            energy += this.m_negativeTrianglesWeight.getValue() * (double)this.countNegativeTriangles();
        }
        return energy;
    }

    private int countNegativeTriangles() {
        int counter = 0;
        int e = 0;
        while (e < this.m_geom.getNumElements()) {
            PdVector[] tex = this.m_geom.getParamTexture()[e];
            double area = (tex[1].m_data[0] - tex[0].m_data[0]) * (tex[2].m_data[1] - tex[0].m_data[1]) - (tex[1].m_data[1] - tex[0].m_data[1]) * (tex[2].m_data[0] - tex[0].m_data[0]);
            if (area < 0.0) {
                ++counter;
            }
            ++e;
        }
        return counter;
    }

    private PgTextureMapOnCovering makeGradient() {
        PgTextureMapOnCovering tex = new PgTextureMapOnCovering();
        tex.setGeometry(this.m_geom);
        tex.setSummand(this.m_geom.getParamTexture());
        tex.derivePotential(this.m_gradient);
        tex.multScalar(1.0 / this.m_geom.getFrameScaleFactor());
        return tex;
    }

    @Override
    public double eval() {
        this.m_parameterizer.getSmoother().start();
        this.m_fieldBackup = PgFrameField.copyNew((PgFrameField)this.m_geom.getFrameField());
        boolean cons = this.m_parameterizer.isEnabledConsoleLog();
        this.m_parameterizer.setEnabledConsoleLog(false);
        int[] usedModules = this.m_parameterizer.getUsedModulesID();
        int i = this.getStartModule();
        while (i < usedModules.length) {
            PnModule module = this.m_parameterizer.getUsedModule(i);
            if (this.m_enabled[i].getState()) {
                if (usedModules[i] == 12) {
                    this.m_fieldBeforeHodge = PgFrameField.copyNew((PgFrameField)this.m_geom.getFrameField());
                }
                module.start();
                this.m_parameterizer.startModule(module);
            }
            ++i;
        }
        this.m_parameterizer.setEnabledConsoleLog(cons);
        double energy = this.computeEnergy();
        this.m_geom.getFrameField().copy(this.m_fieldBackup);
        return energy;
    }

    private int getStartModule() {
        int[] usedModules = this.m_parameterizer.getUsedModulesID();
        int i = 1;
        while (i < usedModules.length) {
            if (usedModules[i - 1] == 8) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public void show(double energyVal) {
        int i;
        PgParamGeom geom;
        PdVector[][] tmpTexture;
        if (this.m_parameterizer.isEnabledConsoleLog()) {
            double alignment = this.m_alignmentWeight.getValue() * PmRelaxEnergyModuleCaller.computeAlignment(this.m_geom, this.m_gradient);
            PsDebug.message((String)("Curl: " + (float)energyVal + "\talignment: " + (float)alignment));
        }
        if ((tmpTexture = (geom = this.m_geom).getTmpTexture()) == null) {
            tmpTexture = new PdVector[geom.getNumElements()][];
            i = 0;
            while (i < geom.getNumElements()) {
                tmpTexture[i] = PdVector.realloc((PdVector[])tmpTexture[i], (int)geom.getDimOfElement(i), (int)2);
                ++i;
            }
        }
        i = 0;
        while (i < geom.getNumElements()) {
            i = 0;
            while (i < geom.getNumElements()) {
                PdVector.copy((PdVector[])tmpTexture[i], (int)0, (PdVector[])this.m_geom.getParamTexture()[i], (int)0, (int)geom.getDimOfElement(i));
                ++i;
            }
            ++i;
        }
        this.m_geom.setTmpTexture(this.m_geom.getParamTexture());
    }
}

