/*
 * Decompiled with CFR 0.152.
 */
package devParameterize.modules.fieldGenerator;

import dev6.numeric.PnCSparseCholesky;
import dev6.numeric.PnConjugateGradientMatrixMT;
import devCovering.PgCovering;
import devCovering.PgFrameField;
import devCovering.PnCovering;
import devCovering.PnFrameField;
import devCovering.PnStiffMatrixOnCovering;
import devGraph.PgGraphOnElementSet;
import devGraph.PnGraphOnElementSet;
import devParameterize.apps.PwParameterizerBase;
import devParameterize.geom.PgParamGeom;
import devParameterize.modules.fieldGenerator.PmRelaxEnergyIf;
import devParameterize.modules.fieldGenerator.PmVectorAngleSmoother;
import java.awt.Component;
import jv.geom.PgElementSet;
import jv.number.PuDouble;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuMath;
import jvx.numeric.PnSparseMatrix;

public class PmRelaxEnergyCurl
extends PsObject
implements PmRelaxEnergyIf {
    protected PwParameterizerBase m_parameterizer;
    protected PgParamGeom m_geom;
    private PdVector m_coord;
    private PgFrameField m_curlFreeField;
    private PdVector m_rv;
    private PuDouble m_alignmentWeight = new PuDouble("Improve Alignment", (PsUpdateIf)this);

    public PmRelaxEnergyCurl() {
        this.m_alignmentWeight.setDefBounds(0.0, 10.0, 0.1, 1.0);
        this.m_alignmentWeight.setDefValue(1.0);
        if (this.getClass() == PmRelaxEnergyCurl.class) {
            this.init();
        }
    }

    @Override
    public void setParameterizer(PwParameterizerBase parameterizer) {
        this.m_parameterizer = parameterizer;
        this.m_geom = this.m_parameterizer.getGeometry();
        this.m_coord = new PdVector(2 * this.m_geom.getNumEdges());
        this.m_curlFreeField = new PgFrameField(this.m_geom.getCovering());
        this.m_curlFreeField.assureFields();
    }

    @Override
    public void cleanup() {
        this.m_coord = null;
        this.m_curlFreeField = null;
        this.m_rv = null;
        this.m_coord = null;
    }

    public void init() {
        this.m_alignmentWeight.init();
    }

    public boolean update(Object event) {
        if (event == this.m_alignmentWeight) {
            return true;
        }
        return super.update(event);
    }

    @Override
    public PsPanel getInfoPanel() {
        PsPanel p = new PsPanel();
        p.add((Component)this.m_alignmentWeight.getInfoPanel());
        return p;
    }

    @Override
    public String toString() {
        return "Size of Curl";
    }

    public static double computeAlignment(PgParamGeom geom, PgFrameField curlFreeField) {
        double alignment = 0.0;
        int noe = geom.getNumElements();
        int e = 0;
        while (e < noe) {
            if (geom.getTrustWeights().m_data[e] != 0.0) {
                PdVector direction = geom.getSparseField().getVector(e);
                PdVector vector0 = curlFreeField.getField(0).getVector(e);
                PdVector vector1 = curlFreeField.getField(1).getVector(e);
                double dist0 = Math.abs(PdVector.dot((PdVector)direction, (PdVector)vector0));
                double dist1 = Math.abs(PdVector.dot((PdVector)direction, (PdVector)vector1));
                double align = PuMath.sqr((double)Math.min(dist0, dist1)) / geom.getFrameScaleFactor();
                double area = geom.getAreaOfElement(e);
                alignment += geom.getTrustWeights().m_data[e] * area * align;
            }
            ++e;
        }
        return alignment;
    }

    private double computeEnergy() {
        this.m_geom.setUpdateField(true);
        PgCovering covering = this.m_geom.getCovering();
        PiVector[] vertexRotation = PnCovering.makeVertexRotation((PgCovering)covering);
        PnSparseMatrix matrix = PnStiffMatrixOnCovering.computeStiffnessMatrix((PgElementSet)this.m_geom, (PgCovering)covering, (PiVector[])vertexRotation, (boolean)false, null);
        matrix.addDiagonal(1.0E-9);
        matrix.compress();
        this.m_rv = PnStiffMatrixOnCovering.computeRightVector((PgElementSet)this.m_geom, (PgFrameField)this.m_geom.getFrameField(), (PiVector[])vertexRotation, null, (boolean)false, (boolean)true, null);
        PnCSparseCholesky.PnCSparseCholeskyFactor factor = PnCSparseCholesky.solve(matrix, this.m_coord, this.m_rv);
        if (factor == null) {
            PsDebug.messageWithoutNewline((String)"Error");
            PnConjugateGradientMatrixMT cg = new PnConjugateGradientMatrixMT();
            if (this.m_parameterizer == null) {
                PsDebug.warning((String)"missing parameterizer workshop");
                return Double.MAX_VALUE;
            }
            cg.setThreadPool(this.m_parameterizer.getThreadPool());
            cg.solve(matrix, this.m_coord, this.m_rv);
        }
        double energy = Math.sqrt(this.m_coord.dot(this.m_rv));
        if (this.m_alignmentWeight.getValue() > 0.0) {
            this.updateCurlFreeField();
            energy += this.m_alignmentWeight.getValue() * PmRelaxEnergyCurl.computeAlignment(this.m_geom, this.m_curlFreeField);
        }
        return energy;
    }

    @Override
    public double eval() {
        PmVectorAngleSmoother smoother = this.m_parameterizer.getSmoother();
        smoother.start();
        return this.computeEnergy();
    }

    public void updateCurlFreeField() {
        int numElements = this.m_geom.getNumElements();
        PdVector[] curlVec = new PdVector[]{new PdVector(3), new PdVector(3)};
        int numCurlFreeFields = this.m_curlFreeField.getNumFields();
        int e = 0;
        while (e < numElements) {
            PnStiffMatrixOnCovering.calcGradNonConf((PgElementSet)this.m_geom, (PgCovering)this.m_geom.getCovering(), (int)e, (PdVector)this.m_coord, (PdVector)curlVec[0], (PdVector)curlVec[1], (boolean)true);
            int i = 0;
            while (i < numCurlFreeFields) {
                PdVector curlFreeVec = this.m_curlFreeField.getField(i).getVector(e);
                PdVector fieldVec = this.m_geom.getFrameField().getField(i).getVector(e);
                curlFreeVec.blend(this.m_geom.getFrameScaleFactor(), fieldVec, -this.m_geom.getFrameScaleFactor(), curlVec[i]);
                ++i;
            }
            ++e;
        }
    }

    @Override
    public void show(double energyVal) {
        this.updateCurlFreeField();
        if (this.m_geom.getElementTree() == null) {
            this.m_geom.setElementTree(new PgGraphOnElementSet((PgElementSet)this.m_geom, 1));
            PnGraphOnElementSet.makeShortestPathTree((PgGraphOnElementSet)this.m_geom.getElementTree());
        }
        PnFrameField.integrate((PgElementSet)this.m_geom, (PgFrameField)this.m_curlFreeField, (PdVector[][])this.m_geom.getTmpTexture(), (PgGraphOnElementSet)this.m_geom.getElementTree());
        this.m_geom.setTmpTexture(this.m_geom.getTmpTexture());
        this.m_geom.showBranchPoints(false);
        this.m_geom.showBranchPoints(true);
        this.m_geom.update((Object)this.m_geom);
    }

    public double getAlignmentWeight() {
        return this.m_alignmentWeight.getValue();
    }

    public void setAlignmentWeight(double alignmentWeight) {
        this.m_alignmentWeight.setValue(alignmentWeight);
    }
}

