/*
 * Decompiled with CFR 0.152.
 */
package devParameterize.modules.fieldGenerator;

import dev.numeric.PnTaucsSolver;
import devCovering.PgCovering;
import devCovering.PgFrameField;
import devCovering.PnFrameField;
import devCovering.PnStiffMatrix;
import devParameterize.apps.PwParameterizerBase;
import devParameterize.geom.PgParamGeom;
import devParameterize.modules.fieldGenerator.PmRelaxEnergyIf;
import jv.geom.PgElementSet;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsPanel;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.geom.PwCurvature;
import jvx.numeric.PnSparseMatrix;

public class PmRelaxEnergyConformal
extends PsObject
implements PmRelaxEnergyIf {
    protected PwParameterizerBase m_parameterizer;
    protected PgParamGeom m_geom;
    private static long m_taucsFact = 0L;

    public PmRelaxEnergyConformal() {
        if (this.getClass() == PmRelaxEnergyConformal.class) {
            this.init();
        }
    }

    @Override
    public void setParameterizer(PwParameterizerBase parameterizer) {
        this.m_parameterizer = parameterizer;
        this.m_geom = this.m_parameterizer.getGeometry();
        this.conformalInit((PgElementSet)this.m_geom);
    }

    @Override
    public void cleanup() {
        this.m_geom = null;
        if (m_taucsFact != 0L) {
            PnTaucsSolver.freeFactorization((long)m_taucsFact);
        }
    }

    public void init() {
    }

    public boolean update(Object event) {
        return super.update(event);
    }

    @Override
    public PsPanel getInfoPanel() {
        PsPanel p = new PsPanel();
        return p;
    }

    @Override
    public String toString() {
        return "Uniformity of conformal scaling factor";
    }

    public long conformalInit(PgElementSet geom) {
        if (geom.getElementEdges() == null) {
            geom.setEnabledEdges(true);
            geom.makeEdgeStars();
        }
        PnSparseMatrix stiff = PnStiffMatrix.computeMatrixEntries((PgElementSet)geom, (boolean)true, (boolean)false);
        int size = stiff.getNumRows();
        stiff.addDiagonal(1.0E-7);
        stiff.setSize(size - 1);
        stiff.validate();
        return PnTaucsSolver.getCholeksyFactorization((PnSparseMatrix)stiff);
    }

    @Override
    public double eval() {
        PgCovering covering = this.m_geom.getFrameField().getCovering();
        PgElementSet geom = covering.getGeometry();
        if (m_taucsFact == 0L) {
            m_taucsFact = this.conformalInit(geom);
        }
        int size = geom.getNumVertices();
        PiVector indices = PnFrameField.calcIndices((PgFrameField)this.m_geom.getFrameField(), (int)covering.getSymmetryOrder(), null);
        PdVector gauss = new PdVector(geom.getNumVertices());
        PwCurvature.getGaussCurvature((PgElementSet)geom, (PdVector)gauss);
        PdVector rightSide = new PdVector(size - 1);
        double angle = Math.PI * 2 / (double)covering.getSymmetryOrder();
        int i = 0;
        while (i < gauss.getSize() - 1) {
            rightSide.m_data[i] = angle * (double)indices.m_data[i] - gauss.m_data[i];
            ++i;
        }
        PdVector vertexScale = new PdVector(size - 1);
        PnTaucsSolver.solveUseFactorization((long)m_taucsFact, (double[])vertexScale.m_data, (double[])rightSide.m_data);
        vertexScale.add(-vertexScale.average());
        vertexScale.addEntry(0.0);
        return vertexScale.length();
    }

    @Override
    public void show(double energyVal) {
        if (this.m_parameterizer.isEnabledConsoleLog()) {
            PsDebug.message((String)("Curl: " + (float)energyVal));
        }
    }
}

