/*
 * Decompiled with CFR 0.152.
 */
package devParameterize.modules.fieldGenerator;

import devCovering.PgCovering;
import devCovering.PnStiffMatrix;
import devGraph.PgGraphOnElementSet;
import devGraph.PnGraphOnElementSet;
import devParameterize.geom.PgParamGeom;
import devParameterize.modules.PnModule;
import devParameterize.modules.fieldGenerator.PmAlignmentOptimizer;
import devParameterize.modules.fieldGenerator.PmRelaxEnergyCurl;
import devParameterize.modules.fieldGenerator.PmVectorAngleSmoother;
import java.util.Vector;
import jv.geom.PgElementSet;
import jv.object.PsDebug;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.geom.PgVertexStar;
import jvx.numeric.PnSparseMatrix;

public class PmRelaxAlongGradient
extends PnModule {
    private PmVectorAngleSmoother m_smoother;
    private static PdVector[] m_gradients;
    protected PmRelaxEnergyCurl m_energy;
    private boolean m_optAlignment;

    public PmRelaxAlongGradient() {
        this.setName("Quick Relaxer");
        this.setStatusMessage("Relaxing branch points");
        this.m_energy = new PmRelaxEnergyCurl();
        if (((Object)((Object)this)).getClass() == PmRelaxAlongGradient.class) {
            this.init();
        }
    }

    @Override
    public boolean setGeometry(PgParamGeom geom) {
        return super.setGeometry(geom);
    }

    @Override
    public boolean start() {
        if (!super.start()) {
            return false;
        }
        if (this.m_geom.getFixMatching() || this.m_geom.getCovering().getBranchPoints().getSize() == 0) {
            return false;
        }
        this.m_optAlignment = false;
        this.m_energy.setParameterizer(this.getParameterizer());
        PdVector[][] texture = new PdVector[this.m_geom.getNumElements()][];
        int noe = this.m_geom.getNumElements();
        int e = 0;
        while (e < noe) {
            texture[e] = PdVector.realloc(null, (int)this.m_geom.getDimOfElement(e), (int)2);
            ++e;
        }
        this.m_geom.setTmpTexture(texture);
        this.m_smoother = this.getParameterizer().getSmoother();
        this.m_smoother.start();
        this.relax();
        this.m_smoother.start();
        this.update((Object)this);
        this.m_geom.setTmpTexture(null);
        m_gradients = null;
        return true;
    }

    public void relax() {
        this.m_geom.setUpdateBranchpoints(true);
        this.m_geom.update((Object)this.m_geom);
        this.m_geom.assureElementTextures();
        PgGraphOnElementSet elementTree = new PgGraphOnElementSet((PgElementSet)this.m_geom, 1);
        PnGraphOnElementSet.makeShortestPathTree((PgGraphOnElementSet)elementTree);
        int[] elemAtVertex = PgVertexStar.getElementPerVertex((PgElementSet)this.m_geom).m_data;
        PnSparseMatrix stiff = PnStiffMatrix.computeMatrixEntries((PgElementSet)this.m_geom, (boolean)true, (boolean)false);
        int maxNumRounds = 500;
        int numRounds = 0;
        int failCounter = 0;
        int maxNumFails = 10;
        double minValue = Double.MAX_VALUE;
        Vector[] movements = new Vector[maxNumRounds];
        PdVector values = new PdVector(maxNumRounds);
        values.setConstant(Double.MAX_VALUE);
        int round = 0;
        while (round < maxNumRounds) {
            if (round > 0) {
                this.computeGradients(this.m_geom.getTmpTexture(), elemAtVertex, stiff);
                movements[round] = this.moveAlongGradients(this.m_smoother, elemAtVertex);
                this.m_geom.setCovering(this.m_geom.getCovering());
            }
            values.m_data[round] = this.m_energy.eval();
            this.m_energy.show(values.m_data[round]);
            if (values.m_data[round] < minValue) {
                minValue = values.m_data[round];
                failCounter = 0;
            } else {
                ++failCounter;
            }
            ++numRounds;
            if (this.isAborted()) {
                maxNumFails = 0;
            }
            if (failCounter >= maxNumFails) break;
            ++round;
        }
        int bestRound = values.indexOfMin();
        PiVector elements = new PiVector();
        int i = numRounds - 1;
        while (i > bestRound) {
            Vector moves = movements[i];
            int j = moves.size() - 1;
            while (j >= 0) {
                BranchPointMovement move = (BranchPointMovement)moves.elementAt(j);
                this.m_smoother.changeMatching(move.m_e, move.m_ne, -move.m_change, true);
                this.m_smoother.changeIndex(move.m_v, -move.m_change);
                this.m_smoother.changeIndex(move.m_w, move.m_change);
                this.m_geom.getCovering().updateBranchpoint(move.m_v, move.m_e);
                this.m_geom.getCovering().updateBranchpoint(move.m_w, move.m_e);
                elements.addEntry(move.m_ne);
                elements.addEntry(move.m_e);
                --j;
            }
            --i;
        }
        if (this.m_optAlignment) {
            PmAlignmentOptimizer.flipElements(this.m_smoother, this.m_geom, elements);
        }
        PsDebug.showStatus((String)("[Quick Relaxer] Undo last " + (numRounds - 1 - bestRound) + " of " + numRounds + " rounds."));
        double value = this.m_energy.eval();
        this.m_energy.show(value);
    }

    private void computeGradients(PdVector[][] tex, int[] elemAtVertex, PnSparseMatrix stiff) {
        if (m_gradients == null) {
            m_gradients = PdVector.realloc(null, (int)this.m_geom.getNumVertices(), (int)3);
        } else {
            int i = 0;
            while (i < this.m_geom.getNumVertices()) {
                m_gradients[i].setConstant(0.0);
                ++i;
            }
        }
        PiVector bp = this.m_geom.getCovering().getBranchPoints();
        PgVertexStar star = new PgVertexStar();
        PdVector edge = new PdVector(3);
        int numBP = bp.getSize();
        int b = 0;
        while (b < numBP) {
            int vInd = bp.getEntry(b);
            star.makeVertexStar((PgElementSet)this.m_geom, vInd, elemAtVertex[vInd]);
            if (star.isClosed()) {
                double diagEntry = stiff.getEntry(vInd, vInd);
                PdVector v = this.m_geom.getVertex(vInd);
                int starSize = star.getSize();
                int j = 0;
                while (j < starSize) {
                    int wInd = star.getLink().getEntry(j);
                    PdVector w = this.m_geom.getVertex(wInd);
                    int elem = star.getElement().getEntry(j);
                    int locInd = star.getVertexLocInd().getEntry(j);
                    PdVector vTex = tex[elem][locInd];
                    PdVector wTex = tex[elem][(locInd + 1) % 3];
                    edge.sub(w, v);
                    double edgeLen = edge.length();
                    double targetDist = edgeLen * this.m_geom.getFrameField().getField(0).getVector(elem).length();
                    double texDist = PdVector.dist((PdVector)vTex, (PdVector)wTex);
                    double cotan = stiff.getEntry(vInd, wInd) / diagEntry;
                    m_gradients[vInd].add((texDist - targetDist) / edgeLen * cotan, edge);
                    ++j;
                }
            }
            ++b;
        }
    }

    public Vector moveAlongGradients(PmVectorAngleSmoother smoother, int[] elemAtVertex) {
        PgParamGeom geom = smoother.getGeometry();
        PgVertexStar star = new PgVertexStar();
        PgCovering covering = smoother.getCovering();
        PiVector bp = covering.getBranchPoints();
        PdVector point = new PdVector(3);
        PdVector arrowLen = new PdVector(bp.getSize());
        int numBP = bp.getSize();
        int i = 0;
        while (i < numBP) {
            int b = bp.getEntry(i);
            arrowLen.m_data[i] = m_gradients[b].length();
            ++i;
        }
        arrowLen.sort();
        int threshInd = (int)((double)numBP * 0.8);
        double thresh = 0.0;
        if (numBP > 0) {
            thresh = arrowLen.getEntry(threshInd);
        }
        Vector<BranchPointMovement> movements = new Vector<BranchPointMovement>();
        PiVector elements = new PiVector();
        int b = 0;
        while (b < bp.getSize()) {
            int vInd = bp.getEntry(b);
            if (covering.getBranchPoints().contains(vInd) && !geom.hasTagVertex(vInd, 1) && !(m_gradients[vInd].length() < thresh)) {
                star.makeVertexStar((PgElementSet)geom, vInd, elemAtVertex[vInd]);
                if (star.isClosed()) {
                    PdVector v = geom.getVertex(vInd);
                    int starSize = star.getSize();
                    double minDist = Double.MAX_VALUE;
                    int minInd = -1;
                    point.blendBase(v, 1000.0, m_gradients[vInd]);
                    int j = 0;
                    while (j < starSize) {
                        int indexW;
                        int indexV;
                        int wInd = star.getLink().getEntry(j);
                        PdVector w = geom.getVertex(wInd);
                        double dist = PdVector.dist((PdVector)point, (PdVector)w);
                        if (dist < minDist) {
                            minInd = j;
                            minDist = dist;
                        }
                        if (covering.getBranchPoints().contains(wInd) && (indexV = smoother.getIndex(vInd)) != (indexW = smoother.getIndex(wInd))) {
                            minInd = j;
                            minDist = -1.0;
                        }
                        ++j;
                    }
                    if (minInd != -1) {
                        int change = -smoother.getIndex(vInd);
                        int e = star.getElement().getEntry((minInd - 1 + starSize) % starSize);
                        int ne = star.getElement().getEntry(minInd);
                        int wInd = star.getLink().getEntry(minInd);
                        elements.addEntry(ne);
                        elements.addEntry(e);
                        smoother.changeMatching(e, ne, change, true);
                        smoother.changeIndex(vInd, change);
                        smoother.changeIndex(wInd, -change);
                        covering.updateBranchpoint(vInd, e);
                        covering.updateBranchpoint(wInd, e);
                        BranchPointMovement movement = new BranchPointMovement(vInd, wInd, e, ne, change);
                        movements.addElement(movement);
                    }
                }
            }
            ++b;
        }
        if (this.m_optAlignment) {
            PmAlignmentOptimizer.flipElements(smoother, this.m_geom, elements);
        }
        return movements;
    }

    public PmRelaxEnergyCurl getEnergy() {
        return this.m_energy;
    }

    public static class BranchPointMovement {
        public int m_v;
        public int m_w;
        public int m_e;
        public int m_ne;
        public int m_change;

        public BranchPointMovement(int v, int w, int e, int ne, int change) {
            this.m_v = v;
            this.m_w = w;
            this.m_e = e;
            this.m_ne = ne;
            this.m_change = change;
        }
    }
}

