/*
 * Decompiled with CFR 0.152.
 */
package devParameterize.modules.fieldGenerator;

import devParameterize.modules.PnModule;
import devParameterize.modules.fieldGenerator.PmPrerelaxer;
import devParameterize.modules.fieldGenerator.PmRelaxEnergyIf;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import jv.object.PsDebug;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;
import jvx.gui.PsToolTip;

public class PmPrerelaxer_IP
extends PsPanel
implements ItemListener {
    private static final String HELP_MIN_DIST = "Specify the minimal allowed distance between branch points relative to the parameter line spacing. Branch points that are closer together will be merged by the branch point optimizer.";
    protected PmPrerelaxer m_pwBPRelaxer;
    protected JComboBox m_energyChoice;
    private Component m_energyPanel;

    public PmPrerelaxer_IP() {
        if (this.getClass() == PmPrerelaxer_IP.class) {
            this.init();
        }
    }

    public void setParent(PsUpdateIf parent) {
        if (parent == null) {
            return;
        }
        if (!(parent instanceof PmPrerelaxer)) {
            PsDebug.warning((String)"Parent has to be of type PmPrerelaxer");
            return;
        }
        super.setParent(parent);
        this.m_pwBPRelaxer = (PmPrerelaxer)parent;
        this.makeLayout();
    }

    public void makeLayout() {
        this.removeAll();
        this.setInsetSize(0);
        Panel p = new Panel(new GridLayout(1, 2));
        this.m_pwBPRelaxer.m_minDist.setEnabled(true);
        PsPanel minDist_IP = this.m_pwBPRelaxer.m_minDist.getInfoPanel();
        p = new Panel(new BorderLayout());
        p.add((Component)minDist_IP, "Center");
        if (PnModule.SHOW_TOOLTIPS) {
            new PsToolTip((Component)minDist_IP, HELP_MIN_DIST);
        }
        p.add((Component)this.m_pwBPRelaxer.m_tryMerging.getInfoPanel(), "West");
        this.add(p);
        boolean showSliderToSetNumberOfNeighboringVerticesConsideredForMerging = false;
        if (showSliderToSetNumberOfNeighboringVerticesConsideredForMerging) {
            this.add((Component)this.m_pwBPRelaxer.m_numMergeNeighbors.getInfoPanel());
        }
        this.m_energyChoice = new JComboBox<PmRelaxEnergyIf>(this.m_pwBPRelaxer.m_energyChoices);
        this.m_energyChoice.addItemListener(this);
        this.m_energyChoice.setSelectedItem(this.m_pwBPRelaxer.getEnergy());
        if (this.m_pwBPRelaxer.m_energyChoices != null && this.m_pwBPRelaxer.m_energyChoices.length > 1) {
            this.add(this.m_energyChoice);
        }
        this.m_energyPanel = this.m_pwBPRelaxer.m_energy.getInfoPanel();
        this.add(this.m_energyPanel);
    }

    public boolean update(Object event) {
        if (this.m_pwBPRelaxer == null) {
            PsDebug.notify((String)"missing parent");
            return true;
        }
        if (event == this.m_pwBPRelaxer.m_energyChoices) {
            this.updateLayout();
        }
        return super.update(event);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.m_energyChoice && this.m_energyChoice.getSelectedItem() != this.m_pwBPRelaxer.m_energy) {
            PmRelaxEnergyIf energy = (PmRelaxEnergyIf)this.m_energyChoice.getSelectedItem();
            this.m_pwBPRelaxer.setEnergy(energy);
            this.remove(this.m_energyPanel);
            this.m_energyPanel = energy.getInfoPanel();
            this.add(this.m_energyPanel);
            this.updateLayout();
        }
    }

    private void updateLayout() {
        Object c = this;
        while (((Component)c).getParent() != null) {
            c = ((Component)c).getParent();
        }
        ((Container)c).validate();
    }
}

