/*
 * Decompiled with CFR 0.152.
 */
package devParameterize.modules.fieldGenerator;

import devParameterize.geom.PgParamGeom;
import devParameterize.modules.PnModule;
import devParameterize.modules.fieldGenerator.PmAlignmentOptimizer;
import devParameterize.modules.fieldGenerator.PmRelaxEnergyConformal;
import devParameterize.modules.fieldGenerator.PmRelaxEnergyCurl;
import devParameterize.modules.fieldGenerator.PmRelaxEnergyIf;
import devParameterize.modules.fieldGenerator.PmRelaxEnergyModuleCaller;
import devParameterize.modules.fieldGenerator.PmRelaxEnergySmooth;
import devParameterize.modules.fieldGenerator.PmVectorAngleSmoother;
import jv.geom.PgElementSet;
import jv.number.PuBoolean;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.number.PuString;
import jv.object.PsDebug;
import jv.object.PsUpdateIf;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.geom.PgVertexStar;
import jvx.util.PuQueue;

public class PmPrerelaxer
extends PnModule {
    protected static final String TITLE = "Relaxer";
    protected static final PmRelaxEnergyIf[] DEFAULT_ENERGIES = new PmRelaxEnergyIf[]{new PmRelaxEnergySmooth(), new PmRelaxEnergyCurl(), new PmRelaxEnergyConformal(), new PmRelaxEnergyModuleCaller()};
    public PmRelaxEnergyIf[] m_energyChoices;
    private static final double DEFAULT_MIN_DIST = 0.0;
    private static final int DEFAULT_NUM_PATHS = 1;
    private static final double MIN_IMPROVEMENT = 0.97;
    private int m_initialBrachPoints;
    private double m_initialEnergy = -1.0;
    private long m_lastUpdateTime = 0L;
    private PmVectorAngleSmoother m_smoother;
    protected PmRelaxEnergyIf m_energy;
    protected PuDouble m_minDist;
    protected PuBoolean m_minDistAbs;
    protected PuBoolean m_tryMerging;
    protected PuInteger m_numMergeNeighbors;
    private double m_minVal;
    private boolean m_optAlignment;

    public PmPrerelaxer() {
        this(null);
    }

    public PmPrerelaxer(PmRelaxEnergyIf[] energies) {
        this.setStatusMessage("Relaxing branch points");
        if (energies == null || energies.length == 0) {
            this.m_energyChoices = DEFAULT_ENERGIES;
            this.setEnergy(this.m_energyChoices[1]);
        } else {
            this.m_energyChoices = energies;
            this.setEnergy(this.m_energyChoices[0]);
        }
        this.m_minDist = new PuDouble("Minimal dist.", (PsUpdateIf)this);
        this.m_minDist.setDefBounds(0.0, 1.0, 0.01, 0.1);
        this.m_minDist.setDefValue(0.0);
        this.m_tryMerging = new PuBoolean("Try Merging", (PsUpdateIf)this, true);
        this.m_minDistAbs = new PuBoolean("Absolute Value", (PsUpdateIf)this, false);
        this.m_numMergeNeighbors = new PuInteger("# Merge Neighbors", (PsUpdateIf)this);
        this.m_numMergeNeighbors.setDefBounds(0, 20, 1, 5);
        this.m_numMergeNeighbors.setDefValue(1);
        if (((Object)((Object)this)).getClass() == PmPrerelaxer.class) {
            this.init();
        }
    }

    @Override
    public void init() {
        super.init();
        this.m_minDist.init();
        this.m_numMergeNeighbors.init();
        this.setEnabled(this.m_energy instanceof PmRelaxEnergySmooth);
    }

    @Override
    public boolean setGeometry(PgParamGeom geom) {
        return super.setGeometry(geom);
    }

    @Override
    public boolean start() {
        if (!super.start()) {
            return false;
        }
        if (this.m_geom.getFixMatching() || this.m_geom.getCovering().getBranchPoints().getSize() == 0) {
            return false;
        }
        this.m_energy.setParameterizer(this.getParameterizer());
        this.m_optAlignment = false;
        PdVector[][] texture = new PdVector[this.m_geom.getNumElements()][];
        int e = 0;
        while (e < this.m_geom.getNumElements()) {
            texture[e] = PdVector.realloc(null, (int)this.m_geom.getDimOfElement(e), (int)2);
            ++e;
        }
        this.m_geom.setTmpTexture(texture);
        this.m_smoother = this.getParameterizer().getSmoother();
        this.m_initialBrachPoints = this.m_geom.getCovering().getNumBranchPoints();
        this.m_minVal = this.m_initialEnergy = this.solveAndEval();
        this.m_energy.show(this.m_initialEnergy);
        if (this.m_tryMerging.getState()) {
            this.branchPointMerging();
        }
        while (this.branchPointMovement()) {
        }
        this.m_smoother.start();
        this.m_geom.setUpdateField(true);
        this.m_lastUpdateTime = 0L;
        PsDebug.showStatus((String)"");
        this.update((Object)this);
        this.m_geom.setUpdateBranchpoints(true);
        this.m_geom.setTmpTexture(null);
        this.m_geom.update((Object)this.m_geom);
        return true;
    }

    public boolean update(Object event) {
        if (event == this.m_numMergeNeighbors || event == this.m_numMergeNeighbors || event == this.m_minDistAbs || event == this.m_minDist || event == this.m_tryMerging) {
            return true;
        }
        return super.update(event);
    }

    private boolean branchPointMerging() {
        int numPaths = this.m_numMergeNeighbors.getValue();
        PiVector branchPoints = this.m_geom.getCovering().getBranchPoints();
        PuQueue queue = new PuQueue(branchPoints.getSize());
        int i = 0;
        while (i < branchPoints.getSize()) {
            queue.enqueue(branchPoints.getEntry(i));
            ++i;
        }
        boolean bForcedMerge = false;
        double energyBefore = this.m_minVal;
        block1: while (!queue.isEmpty() && !this.isAborted()) {
            int v = queue.extractLast();
            if (!branchPoints.contains(v) || this.m_geom.hasTagVertex(v, 1)) continue;
            this.markVertex(v);
            PiVector[] paths = this.m_smoother.findPaths(this.m_geom.getCovering(), v, numPaths);
            int i2 = 0;
            while (i2 < paths.length) {
                PiVector path = paths[i2];
                if (path == null) continue block1;
                int start = path.getFirstEntry();
                int end = path.getLastEntry();
                if (end >= start) {
                    int change = -((int)Math.signum(this.m_smoother.getIndex(start)));
                    if (PmPrerelaxer.pathLength((PgElementSet)this.m_geom, path) < this.m_minDist.getValue() / this.m_geom.getFrameScaleFactor()) {
                        int numMergePaths = numPaths;
                        PiVector[] vPaths = this.m_smoother.findPaths(this.m_geom.getCovering(), start, numMergePaths);
                        PdVector vVal = new PdVector(numMergePaths);
                        int j = 0;
                        while (j < numMergePaths) {
                            PiVector p = vPaths[j];
                            if (p != null) {
                                this.m_smoother.applyChange(p, change);
                                vVal.m_data[j] = this.solveAndEval();
                                this.m_smoother.applyChange(p, -change);
                            }
                            ++j;
                        }
                        PiVector[] wPaths = this.m_smoother.findPaths(this.m_geom.getCovering(), end, numMergePaths);
                        PdVector wVal = new PdVector(numMergePaths);
                        int wChange = -this.m_smoother.getIndex(end);
                        int j2 = 0;
                        while (j2 < numMergePaths) {
                            PiVector p = wPaths[j2];
                            if (p != null) {
                                this.m_smoother.applyChange(p, wChange);
                                wVal.m_data[j2] = this.solveAndEval();
                                this.m_smoother.applyChange(p, -wChange);
                            }
                            ++j2;
                        }
                        if (wVal.min() < vVal.min()) {
                            path = wPaths[wVal.indexOfMin()];
                            change = wChange;
                            start = path.getFirstEntry();
                            end = path.getLastEntry();
                        } else {
                            path = vPaths[vVal.indexOfMin()];
                            start = path.getFirstEntry();
                            end = path.getLastEntry();
                        }
                        this.m_smoother.applyChange(path, change);
                        this.m_minVal = this.solveAndEval();
                        bForcedMerge = true;
                        this.update();
                        continue block1;
                    }
                    this.m_smoother.applyChange(path, change);
                    double eVal = this.solveAndEval();
                    if (eVal < this.m_minVal - 1.0E-10) {
                        PiVector changes;
                        this.m_minVal = eVal;
                        if (this.m_optAlignment && (changes = PmAlignmentOptimizer.flipElements(this.m_smoother, this.m_geom, this.getElements(path))).sqrLength() > 0) {
                            eVal = this.solveAndEval();
                            if (eVal < this.m_minVal) {
                                PsDebug.message((String)("FlipElements: " + (float)this.m_minVal + "\t--> " + (float)eVal));
                                this.m_minVal = eVal;
                            } else {
                                PmAlignmentOptimizer.unflipElements(this.m_smoother, changes);
                            }
                        }
                        this.update();
                        if (this.m_smoother.getIndex(start) != 0) {
                            queue.enqueue(start);
                        }
                        if (this.m_smoother.getIndex(end) == 0) continue block1;
                        queue.enqueue(end);
                        continue block1;
                    }
                    this.m_smoother.applyChange(path, -change);
                }
                ++i2;
            }
        }
        PsDebug.showStatus((String)"[Branch point merging] ");
        return bForcedMerge || this.m_minVal / energyBefore < 0.97;
    }

    private PiVector getElements(PiVector path) {
        if (path == null) {
            PsDebug.warning((String)"missing argument.");
            return null;
        }
        PiVector elements = new PiVector(2 * (path.getSize() - 1));
        PgParamGeom geom = this.getGeometry();
        int i = 0;
        while (i < path.getSize() - 1) {
            int v = path.getEntry(i);
            int w = path.getEntry(i + 1);
            PgVertexStar star = this.m_smoother.getStar(v);
            int j = star.getLink().getIndexOf(w);
            if (star.isClosed() || j != 0 && j != star.getSize()) {
                int elLocInd = (j - 1 + star.getSize()) % star.getSize();
                int elInd = star.getElement().getEntry(elLocInd);
                PiVector elem = geom.getElement(elInd);
                int locInd = (elem.getIndexOf(w) - 1 + elem.getSize()) % elem.getSize();
                int ne = geom.getNeighbour(elInd).getEntry(locInd);
                elements.m_data[2 * i] = elInd;
                elements.m_data[2 * i + 1] = ne;
            }
            ++i;
        }
        return elements;
    }

    private void markVertex(int v) {
        if (System.currentTimeMillis() - this.m_lastUpdateTime > (long)this.updateInterval()) {
            this.m_lastUpdateTime = System.currentTimeMillis();
            this.m_geom.setUpdateBranchpoints(true);
            this.m_geom.setVertexSize(v, 4.0);
            this.m_geom.update((Object)this.m_geom);
        }
    }

    private boolean branchPointMovement() {
        PiVector branchPoints = this.m_geom.getCovering().getBranchPoints();
        PuQueue queue = new PuQueue(branchPoints.getSize());
        int i = 0;
        while (i < branchPoints.getSize()) {
            queue.enqueue(branchPoints.getEntry(i));
            ++i;
        }
        double energyBefore = this.m_minVal;
        while (!queue.isEmpty() && !this.isAborted()) {
            PiVector path;
            int v = queue.extractFirst();
            if (!branchPoints.contains(v) || this.m_geom.hasTagVertex(v, 1)) continue;
            this.markVertex(v);
            PiVector link = this.m_smoother.getLink(v);
            int linkSize = link.getSize();
            PdVector values = new PdVector(linkSize);
            int i2 = 0;
            while (i2 < linkSize) {
                int w = link.getEntry(i2);
                path = new PiVector(v, w);
                int change = -this.m_smoother.getIndex(v);
                this.m_smoother.applyChange(path, change);
                values.m_data[i2] = this.solveAndEval();
                this.m_smoother.applyChange(path, -change);
                ++i2;
            }
            if (values.min() < this.m_minVal - 1.0E-10) {
                PiVector changes;
                this.m_minVal = values.min();
                int w = link.getEntry(values.indexOfMin());
                int change = -this.m_smoother.getIndex(v);
                path = new PiVector(v, w);
                this.m_smoother.applyChange(path, change);
                if (this.m_optAlignment && (changes = PmAlignmentOptimizer.flipElements(this.m_smoother, this.m_geom, this.getElements(path))).sqrLength() > 0) {
                    double eVal = this.solveAndEval();
                    if (eVal < this.m_minVal) {
                        PsDebug.message((String)("FlipElements: " + (float)this.m_minVal + "\t--> " + (float)eVal));
                        this.m_minVal = eVal;
                    } else {
                        PmAlignmentOptimizer.unflipElements(this.m_smoother, changes);
                    }
                }
                this.update();
                queue.enqueue(w);
            }
            this.m_geom.setUpdateBranchpoints(true);
        }
        return this.m_minVal / energyBefore < 0.97;
    }

    private void update() {
        if (System.currentTimeMillis() - this.m_lastUpdateTime <= (long)this.updateInterval()) {
            return;
        }
        PsDebug.showStatus((String)("Iteration: " + this.m_smoother.getNumSystemsSolved() + ",    energy decreased to " + PuString.toString((double)(100.0 * this.m_minVal / this.m_initialEnergy), (int)1) + "%" + ",    branch points: " + this.m_initialBrachPoints + " --> " + this.m_geom.getCovering().getNumBranchPoints()));
        this.m_lastUpdateTime = System.currentTimeMillis();
        this.m_energy.show(this.m_minVal);
        this.m_geom.setUpdateBranchpoints(true);
        this.m_geom.update((Object)this.m_geom);
    }

    private double solveAndEval() {
        return this.m_energy.eval();
    }

    private int updateInterval() {
        return 500 + this.m_geom.getNumElements() / 50;
    }

    public void setEnergy(PmRelaxEnergyIf energy) {
        if (this.m_energy == energy) {
            return;
        }
        if (this.m_energy != null) {
            this.m_energy.cleanup();
        }
        this.m_energy = energy;
        if (this.m_energy == null) {
            return;
        }
        if (this.getParameterizer() != null) {
            this.m_energy.setParameterizer(this.getParameterizer());
        }
        this.setName("Relaxer (" + this.m_energy.toString() + ")");
        if (this.getHeadBar() != null) {
            this.getHeadBar().setName(this.getName());
        }
    }

    public static double pathLength(PgElementSet geom, PiVector path) {
        double sum = 0.0;
        int[] v = path.m_data;
        int j = 0;
        while (j < path.getSize() / 2) {
            sum += PdVector.dist((PdVector)geom.getVertex(v[j]), (PdVector)geom.getVertex(v[j + 1]));
            ++j;
        }
        return sum;
    }

    public PmRelaxEnergyIf getEnergy() {
        return this.m_energy;
    }

    public void setMinDist(double minDist) {
        this.m_minDist.setValue(minDist);
    }
}

