/*
 * Decompiled with CFR 0.152.
 */
package devParameterize.modules.fieldGenerator;

import dev6.numeric.PnCSparseCholesky;
import dev6.numeric.PnConjugateGradientMatrixMT;
import devCovering.PgCovering;
import devCovering.PgFrameField;
import devCovering.PnCovering;
import devCovering.PnFrameField;
import devCovering.PnStiffMatrix;
import devCovering.PnStiffMatrixOnCovering;
import devParameterize.modules.PnModule;
import devParameterize.modules.fieldGenerator.PmSparseFieldGenerator;
import jv.geom.PgElementSet;
import jv.geom.PgVectorField;
import jv.number.PuBoolean;
import jv.number.PuDouble;
import jv.object.PsDebug;
import jv.object.PsUpdateIf;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuMath;
import jvx.geom.PwCurvature;
import jvx.geom.PwShapeOperator;
import jvx.numeric.PnSparseMatrix;

public class PmFrameFieldScaler
extends PnModule {
    protected PuBoolean m_generalScaling;
    protected PuDouble m_minScale;
    protected PuDouble m_maxScale;
    protected PuDouble m_exponent;
    protected PuDouble m_amount;
    protected PuBoolean m_curl;
    private static PdVector m_coord;
    private static PnCSparseCholesky.PnCSparseCholeskyFactor m_choleskyFact;

    public PmFrameFieldScaler() {
        this.setName("Frame field scaler");
        this.setStatusMessage("Frame field scaling");
        this.m_generalScaling = new PuBoolean("General Scaling", (PsUpdateIf)this);
        this.m_minScale = new PuDouble("Min Scale", (PsUpdateIf)this);
        this.m_maxScale = new PuDouble("Max Scale", (PsUpdateIf)this);
        this.m_exponent = new PuDouble("Exponent", (PsUpdateIf)this);
        this.m_amount = new PuDouble("Conformal or Anisotropic Scaling", (PsUpdateIf)this);
        this.m_curl = new PuBoolean("Reduce Curl", (PsUpdateIf)this);
        if (((Object)((Object)this)).getClass() == PmFrameFieldScaler.class) {
            this.init();
        }
    }

    @Override
    public void init() {
        super.init();
        this.m_generalScaling.init();
        this.m_generalScaling.setDefState(true);
        this.m_minScale.setDefBounds(0.0, 16.0, 1.0, 1.0);
        this.m_minScale.setDefValue(0.2);
        this.m_minScale.init();
        this.m_maxScale.setDefBounds(0.1, 16.0, 1.0, 1.0);
        this.m_maxScale.setDefValue(2.0);
        this.m_maxScale.init();
        this.m_exponent.setDefBounds(0.0, 2.0, 0.1, 0.1);
        this.m_exponent.setDefValue(0.5);
        this.m_exponent.init();
        this.m_amount.setDefBounds(-1.0, 30.0, 0.1, 1.0);
        this.m_amount.setDefValue(0.0);
        this.m_amount.init();
        this.m_curl.init();
        this.m_curl.setDefState(false);
        this.setEnabled(true);
    }

    @Override
    public boolean start() {
        double amount;
        if (!super.start()) {
            return false;
        }
        if (this.m_geom.getFrameField() == null || this.m_geom.getCovering() == null) {
            PsDebug.warning((String)"missing field or covering.");
            return false;
        }
        if (this.m_geom.getCurvatureValues() == null) {
            boolean tmp = PwShapeOperator.isEnabledAbsoluteValue();
            PwShapeOperator.enableAbsoluteValue((boolean)true);
            int numE = this.m_geom.getNumElements();
            this.m_geom.setCurvatureValues(new PdVector[numE]);
            PwShapeOperator.makeElementBasedPrincipalCurvatures((PgElementSet)this.m_geom, (PdVector[])this.m_geom.getCurvatureValues(), (boolean)false);
            PwShapeOperator.enableAbsoluteValue((boolean)tmp);
        }
        if (this.m_generalScaling.getState()) {
            this.generalScaling();
        }
        if ((amount = this.m_amount.getValue()) < 0.0) {
            this.conformalScaling(-amount);
        } else if (amount > 0.0) {
            this.anisoScaling(amount);
        }
        if (this.m_curl.getState()) {
            this.reduceCurl();
        }
        if (this.m_geom.getFrameField() == null) {
            PsDebug.warning((String)"missing frame field after scaling");
            return false;
        }
        return true;
    }

    private void generalScaling() {
        int numE = this.m_geom.getNumElements();
        PdVector[] curvatureValues = this.m_geom.getCurvatureValues();
        int e = 0;
        while (e < numE) {
            double curv = Math.max(Math.abs(curvatureValues[e].m_data[0]), Math.abs(curvatureValues[e].m_data[1]));
            double scale = Math.pow(curv, this.m_exponent.getValue());
            if (Double.isNaN(scale) || scale >= this.m_maxScale.getValue()) {
                scale = this.m_maxScale.getValue();
            } else if (scale <= this.m_minScale.getValue()) {
                scale = this.m_minScale.getValue();
            }
            this.m_geom.getFrameField().getField(0).getVector(e).setLength(scale);
            this.m_geom.getFrameField().getField(1).getVector(e).setLength(scale);
            ++e;
        }
        this.m_geom.setUpdateField(true);
    }

    private void conformalScaling(double amount) {
        PdVector vertexExponent = PmFrameFieldScaler.calcVertexScale(this.m_geom.getFrameField());
        vertexExponent.multScalar(amount);
        PmFrameFieldScaler.scaleFrameField(this.m_geom.getFrameField(), vertexExponent);
    }

    private static PdVector calcVertexScale(PgFrameField field) {
        PgCovering covering = field.getCovering();
        PgElementSet geom = covering.getGeometry();
        PnSparseMatrix stiff = PnStiffMatrix.computeMatrixEntries((PgElementSet)geom, (boolean)true, (boolean)false);
        int size = stiff.getNumRows();
        stiff.addDiagonal(1.0E-7);
        stiff.setSize(size - 1);
        stiff.validate();
        PiVector indices = PnFrameField.calcIndices((PgFrameField)field, (int)covering.getSymmetryOrder(), null);
        PdVector gauss = new PdVector(geom.getNumVertices());
        PwCurvature.getGaussCurvature((PgElementSet)geom, (PdVector)gauss);
        PdVector rightSide = new PdVector(size - 1);
        double angle = Math.PI * 2 / (double)covering.getSymmetryOrder();
        int i = 0;
        while (i < gauss.getSize() - 1) {
            rightSide.m_data[i] = angle * (double)indices.m_data[i] - gauss.m_data[i];
            ++i;
        }
        PdVector vertexScale = new PdVector(size - 1);
        PnCSparseCholesky.solve(stiff, vertexScale, rightSide);
        vertexScale.add(-vertexScale.average());
        vertexScale.addEntry(0.0);
        return vertexScale;
    }

    private static PdVector scaleFrameField(PgFrameField field, PdVector vertexScale) {
        PgElementSet geom = field.getGeometry();
        PdVector faceScaling = new PdVector(geom.getNumElements());
        int e = 0;
        while (e < geom.getNumElements()) {
            faceScaling.m_data[e] = PmFrameFieldScaler.faceScale(geom, vertexScale, e);
            ++e;
        }
        e = 0;
        while (e < geom.getNumElements()) {
            int f = 0;
            while (f < 2) {
                PdVector v = field.getFields()[f].getVector(e);
                v.setLength(faceScaling.m_data[e]);
                ++f;
            }
            ++e;
        }
        return faceScaling;
    }

    private static double faceScale(PgElementSet geom, PdVector vertexExponent, int e) {
        PiVector elem = geom.getElement(e);
        double a = vertexExponent.m_data[elem.m_data[0]];
        double b = vertexExponent.m_data[elem.m_data[1]];
        double c = vertexExponent.m_data[elem.m_data[2]];
        if (Math.abs(a - b) < 1.0E-10 || Math.abs(a - c) < 1.0E-10) {
            return Math.exp(0.6666666666666666 * (a + b + c));
        }
        double faceScaling = Math.exp(b + c) * PuMath.sinh((double)(a - b)) * PuMath.sinh((double)(a - c)) / ((a - b) * (a - c));
        return faceScaling;
    }

    private void anisoScaling(double anisotropy) {
        PgFrameField field = this.m_geom.getFrameField();
        int numFrames = field.getField(0).getNumVectors();
        PdVector[] curvatures = this.m_geom.getCurvatureValues();
        PmSparseFieldGenerator fieldGenerator = (PmSparseFieldGenerator)this.getParameterizer().createModule(0);
        double curvRadius = fieldGenerator.getCurvRadius();
        PgVectorField curvatureVectors = this.m_geom.getCurvatureVectorField();
        int flip = curvRadius > 0.0 ? 0 : 1;
        double avgFactorLog = 0.0;
        double avg = 1.0E-10;
        int j = 0;
        while (j < numFrames) {
            avg += Math.abs(curvatures[j].m_data[0]);
            avg += Math.abs(curvatures[j].m_data[1]);
            ++j;
        }
        avg /= (double)(2 * numFrames);
        int i = 0;
        while (i < numFrames) {
            PdVector field0 = field.getField(0).getVector(i);
            PdVector field1 = field.getField(1).getVector(i);
            double curv0 = curvatures[i].m_data[flip] / avg;
            double curv1 = curvatures[i].m_data[1 - flip] / avg;
            PdVector curvVec0 = curvatureVectors.getVector(i);
            PdVector curvVec1 = PdVector.crossNew((PdVector)curvVec0, (PdVector)this.m_geom.getElementNormal(i));
            double normalCurvature0 = curv0 * PdVector.dot((PdVector)field0, (PdVector)curvVec0) / field0.length() / curvVec0.length() + curv1 * PdVector.dot((PdVector)field0, (PdVector)curvVec1) / field0.length() / curvVec1.length();
            double normalCurvature1 = curv0 * PdVector.dot((PdVector)field1, (PdVector)curvVec0) / field1.length() / curvVec0.length() + curv1 * PdVector.dot((PdVector)field1, (PdVector)curvVec1) / field1.length() / curvVec1.length();
            double s0 = Math.sqrt(1.0 + anisotropy * PuMath.sqr((double)normalCurvature0));
            double s1 = Math.sqrt(1.0 + anisotropy * PuMath.sqr((double)normalCurvature1));
            avgFactorLog += Math.log(s0 * s1);
            field0.multScalar(s1);
            field1.multScalar(s0);
            ++i;
        }
        field.multScalar(Math.exp(-avgFactorLog / (double)(2 * numFrames)));
    }

    private void reduceCurl() {
        PgFrameField field = this.m_geom.getFrameField();
        float oldCurl = 0.0f;
        if (this.m_parameterizer.isEnabledConsoleLog()) {
            oldCurl = (float)PmFrameFieldScaler.curlPart(field).normL2();
        }
        PgFrameField curlField = null;
        int i = 0;
        while (i < 10) {
            curlField = this.applyLengthsOfCurlFreeField(field);
            if (this.isAborted()) break;
            ++i;
        }
        if (curlField != null && this.m_parameterizer.isEnabledConsoleLog()) {
            PsDebug.messageWithoutNewline((String)(oldCurl + " --> " + (float)curlField.normL2()));
        }
        m_choleskyFact = null;
        m_coord = null;
    }

    private PgFrameField applyLengthsOfCurlFreeField(PgFrameField field) {
        double normL2 = field.normL2();
        PgFrameField curlField = PmFrameFieldScaler.curlPart(field);
        PgFrameField curlFreeField = PgFrameField.subNew((PgFrameField)field, (PgFrameField)curlField);
        int numE = this.m_geom.getNumElements();
        int e = 0;
        while (e < numE) {
            field.getField(0).getVector(e).setLength(curlFreeField.getField(0).getVector(e).length());
            field.getField(1).getVector(e).setLength(curlFreeField.getField(1).getVector(e).length());
            ++e;
        }
        double normL2b = field.normL2();
        field.multScalar(normL2 / normL2b);
        return curlField;
    }

    protected PgFrameField applyRotationOfCurlFreeField(PgFrameField field) {
        PgFrameField curlField = PmFrameFieldScaler.curlPart(field);
        field.sub(curlField);
        int numE = this.m_geom.getNumElements();
        int e = 0;
        while (e < numE) {
            PdVector v = field.getField(0).getVector(e);
            PdVector w = field.getField(1).getVector(e);
            w.cross(w, this.m_geom.getElementNormal(e));
            v.add(w);
            v.normalize();
            w.copyArray(v);
            w.cross(this.m_geom.getElementNormal(e), w);
            ++e;
        }
        return curlField;
    }

    private static PgFrameField curlPart(PgFrameField field) {
        PnSparseMatrix matrix;
        boolean useCSparse;
        PgElementSet geom = field.getGeometry();
        PgCovering covering = field.getCovering();
        PiVector[] vertexRotation = PnCovering.makeVertexRotation((PgCovering)field.getCovering());
        PdVector rv = PnStiffMatrixOnCovering.computeRightVector((PgElementSet)geom, (PgFrameField)field, (PiVector[])vertexRotation, null, (boolean)false, (boolean)true, null);
        if (m_coord == null) {
            m_coord = new PdVector(2 * geom.getNumEdges());
        }
        if (useCSparse = true) {
            matrix = PnStiffMatrixOnCovering.computeStiffnessMatrix((PgElementSet)geom, (PgCovering)field.getCovering(), (PiVector[])vertexRotation, (boolean)false, null);
            matrix.compress();
            matrix.addDiagonal(1.0E-10);
            if (m_choleskyFact == null) {
                m_choleskyFact = PnCSparseCholesky.solve(matrix, m_coord, rv);
            } else {
                PnCSparseCholesky.solveUseFactorization(m_choleskyFact, m_coord, rv);
            }
        } else {
            matrix = PnStiffMatrixOnCovering.computeStiffnessMatrix((PgElementSet)geom, (PgCovering)field.getCovering(), (PiVector[])vertexRotation, (boolean)false, null);
            matrix.compress();
            PnConjugateGradientMatrixMT solver = new PnConjugateGradientMatrixMT();
            solver.solve(matrix, m_coord, rv);
        }
        PgFrameField curlField = new PgFrameField(covering);
        curlField.assureFields();
        PdVector gradX = new PdVector(3);
        PdVector gradY = new PdVector(3);
        int numE = geom.getNumElements();
        int e = 0;
        while (e < numE) {
            gradX = curlField.getField(0).getVector(e);
            gradY = curlField.getField(1).getVector(e);
            PnStiffMatrixOnCovering.calcGradNonConf((PgElementSet)geom, (PgCovering)covering, (int)e, (PdVector)m_coord, (PdVector)gradX, (PdVector)gradY, (boolean)true);
            ++e;
        }
        return curlField;
    }

    public boolean update(Object event) {
        if (event == this) {
            return true;
        }
        if (event == this.m_minScale || event == this.m_maxScale || event == this.m_exponent || event == this.m_amount || event == this.m_curl) {
            return true;
        }
        if (event == this.m_generalScaling) {
            return true;
        }
        return super.update(event);
    }
}

