/*
 * Decompiled with CFR 0.152.
 */
package devParameterize.modules.fieldGenerator;

import devCovering.PgFrameField;
import devParameterize.covering.PnFrameFieldSmoother;
import devParameterize.geom.PgParamGeom;
import devParameterize.modules.PnModule;
import jv.geom.PgElementSet;
import jv.object.PsDebug;

public class PmFrameAngleSmoother
extends PnModule {
    protected boolean m_useMatching;

    public PmFrameAngleSmoother() {
        this(false);
    }

    public PmFrameAngleSmoother(boolean useMatching) {
        this.setName("Frame angle smoother " + (useMatching ? "with" : "without") + " matching");
        this.setStatusMessage("Smooth frame field by angles");
        this.m_useMatching = useMatching;
        if (((Object)((Object)this)).getClass() == PmFrameAngleSmoother.class) {
            this.init();
        }
    }

    @Override
    public boolean setGeometry(PgParamGeom geom) {
        if (!super.setGeometry(geom)) {
            return false;
        }
        this.getParameterizer().assureSmoother();
        return true;
    }

    @Override
    public void init() {
        super.init();
    }

    public boolean update(Object event) {
        return true;
    }

    @Override
    public boolean start() {
        if (!super.start()) {
            return false;
        }
        if (this.m_geom.getFrameField() == null) {
            PsDebug.warning((String)"missing frame field.");
            return false;
        }
        if (this.getParameterizer().getSmoother() == null) {
            PsDebug.warning((String)"missing frame field smoother.");
            return false;
        }
        if (this.m_geom.getTrustWeights() == null) {
            PsDebug.warning((String)"missing trust weights.");
            return false;
        }
        if (!this.m_useMatching && this.m_geom.getFixMatching()) {
            return false;
        }
        PgFrameField field = this.m_geom.getFrameField();
        PnFrameFieldSmoother.smoothCurvatureField((PgElementSet)this.m_geom, field.getFields(), this.m_geom.getTrustWeights(), this.getParameterizer().getSmoother().getSmoothingFactor(), this.m_useMatching ? field.getCovering() : null, this.m_geom.getCovering().getSymmetryOrder(), field.getCovering().getSymmetryOrder() == 2, null, this.getParameterizer().getThreadPool(), this.getParameterizer().getNumThreads());
        this.m_geom.setUpdateField(true);
        return true;
    }
}

