/*
 * Decompiled with CFR 0.152.
 */
package devParameterize.modules.fieldGenerator;

import devCovering.PgFrameField;
import devParameterize.geom.PgParamGeom;
import devParameterize.loader.PgFFLoader;
import devParameterize.loader.PgNdfLoader;
import devParameterize.modules.PnModule;
import java.awt.Color;
import java.awt.FileDialog;
import java.io.IOException;
import jv.geom.PgElementSet;
import jv.geom.PgVectorField;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.vecmath.PdVector;
import jv.vecmath.PuVectorGeom;
import jvx.geom.PwShapeOperator;

public class PmFrameAngleEditor
extends PnModule {
    protected double[] m_frameAngles;
    protected PgVectorField m_orgFrame1;
    protected PgVectorField m_orgFrame2;
    protected boolean m_rotation;
    protected boolean m_arrow;
    protected double m_angle;
    protected final Object m_continueWaiter;
    protected Color[] colFrame2;

    public PmFrameAngleEditor() {
        this.setName("Edit angle between frames");
        this.setStatusMessage("Adjust Frame Angle");
        this.m_continueWaiter = new Object();
        if (((Object)((Object)this)).getClass() == PmFrameAngleEditor.class) {
            this.init();
        }
    }

    @Override
    public void init() {
        super.init();
        this.setEnabled(false);
    }

    @Override
    public boolean setGeometry(PgParamGeom geom) {
        return super.setGeometry(geom);
    }

    public boolean update(Object event) {
        if (event == this) {
            int field = 0;
            this.m_angle = -0.1;
            if (!this.m_arrow) {
                field = 1;
            }
            if (this.m_rotation) {
                this.m_angle = -this.m_angle;
            }
            this.changeFrameAngle(field, this.m_angle);
            this.m_geom.update((Object)this.m_geom);
        }
        return super.update(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean start() {
        if (!super.start()) {
            return false;
        }
        this.m_orgFrame1 = new PgVectorField(3);
        this.m_orgFrame1.copy((PsObject)this.m_geom.getFrameField().getField(0));
        this.m_orgFrame2 = new PgVectorField(3);
        this.m_orgFrame2.copy((PsObject)this.m_geom.getFrameField().getField(1));
        PgVectorField[] tmp = new PgVectorField[]{this.m_orgFrame1, this.m_orgFrame2};
        this.m_geom.setGradientField(tmp);
        Color[] colFrame0 = new Color[this.m_geom.getNumElements()];
        Color[] colFrame1 = new Color[this.m_geom.getNumElements()];
        this.colFrame2 = new Color[this.m_geom.getNumElements()];
        int i = 0;
        while (i < this.m_geom.getNumElements()) {
            colFrame0[i] = Color.blue;
            colFrame1[i] = Color.red;
            this.colFrame2[i] = Color.black;
            ++i;
        }
        if (this.m_geom.getFrameField() == null) {
            PsDebug.error((String)"Missing frame field");
            return false;
        }
        if (this.m_geom.getCurvatureField() == null && this.m_geom.getCurvatureVectorField() == null) {
            PdVector[] m_curvatureValues = new PdVector[this.m_geom.getNumElements()];
            PgVectorField m_curvatureVectors = PwShapeOperator.makeElementBasedPrincipalCurvatures((PgElementSet)this.m_geom, (PdVector[])m_curvatureValues, (boolean)false)[0];
            int i2 = 0;
            while (i2 < m_curvatureVectors.getNumVectors()) {
                m_curvatureVectors.getVector(i2).normalize();
                ++i2;
            }
            this.m_geom.setCurvatureVectorField(m_curvatureVectors);
            this.m_geom.setCurvatureValues(m_curvatureValues);
        }
        this.m_geom.getFrameField().getField(0).setVectorColors(colFrame0);
        this.m_geom.getFrameField().getField(1).setVectorColors(colFrame1);
        this.m_geom.getSparseField().setVectorColors(this.colFrame2);
        this.m_geom.getGradientField()[0].setVectorColors(colFrame0);
        this.m_geom.getGradientField()[1].setVectorColors(colFrame1);
        this.m_geom.showField(true);
        this.m_geom.showVectorColors(true);
        this.m_geom.showVectorArrows(true);
        i3 = 0;
        while (i3 < this.m_geom.getNumElements()) {
            this.m_geom.getElement(i3).clearTag(1);
            ++i3;
        }
        this.m_geom.update((Object)this.m_geom);
        try {
            Object i3 = this.m_continueWaiter;
            synchronized (i3) {
                this.m_continueWaiter.wait();
            }
        }
        catch (Exception e) {
            System.err.println("Exception in start() in PmSparseFieldEditor");
        }
        this.m_geom.showField(false);
        this.m_geom.showGradientField(false);
        this.m_geom.showVectorColors(false);
        this.m_geom.showVectorArrows(false);
        int i4 = 0;
        while (i4 < this.m_geom.getNumElements()) {
            this.m_geom.getElement(i4).clearTag(1);
            ++i4;
        }
        this.m_geom.update((Object)this.m_geom);
        return true;
    }

    private void changeFrameAngle(int index, double angle) {
        int noe = this.m_geom.getNumElements();
        PgFrameField ff = this.m_geom.getFrameField();
        PgVectorField[] vf = ff.getFields();
        int i = 0;
        while (i < noe) {
            if (this.m_geom.getElement(i).hasTag(1)) {
                PdVector normal = this.m_geom.getElementNormal(i);
                PuVectorGeom.rotatePointAroundVector((PdVector)vf[index].getVector(i), (PdVector)vf[index].getVector(i), (PdVector)normal, (double)angle);
            }
            ++i;
        }
        this.m_geom.update((Object)this.m_geom);
    }

    public void setRotation(boolean flag) {
        this.m_rotation = flag;
    }

    public void setArrow(boolean flag) {
        this.m_arrow = flag;
    }

    public void loadFrameField() throws IOException {
        FileDialog fileDialog = new FileDialog(PsConfig.getFrame(), "Load frame field", 0);
        fileDialog.setDirectory(".");
        fileDialog.setFile("*.ff;*.ndf");
        fileDialog.setVisible(true);
        if (fileDialog.getFile() == null) {
            return;
        }
        String filename = fileDialog.getDirectory();
        filename = filename == null ? fileDialog.getFile() : (filename.endsWith("/") || filename.endsWith("\\") ? String.valueOf(filename) + fileDialog.getFile() : String.valueOf(filename) + "/" + fileDialog.getFile());
        fileDialog.dispose();
        if (filename == null) {
            return;
        }
        if (filename.contains(".ff")) {
            PgFFLoader loader = new PgFFLoader();
            loader.read(filename, this.m_geom);
        } else if (filename.contains(".ndf")) {
            PgNdfLoader loader = new PgNdfLoader();
            loader.read(filename, this.m_geom);
        } else {
            return;
        }
        this.m_geom.update((Object)this.m_geom);
    }

    public void saveFrameField() {
        FileDialog fileDialog = new FileDialog(PsConfig.getFrame(), "Save frame field", 1);
        fileDialog.setDirectory(".");
        fileDialog.setFile("*.ff");
        fileDialog.setVisible(true);
        String filename = fileDialog.getDirectory();
        this.saveFrameField(String.valueOf(filename) + fileDialog.getFile());
    }

    private void saveFrameField(String path) {
        PgFFLoader loader = new PgFFLoader();
        loader.saveFrameField(this.m_geom, path);
    }
}

