/*
 * Decompiled with CFR 0.152.
 */
package devParameterize.modules.fieldGenerator;

import devCovering.PgCovering;
import devCovering.PgFrameField;
import devParameterize.apps.PwParameterizerBase;
import devParameterize.geom.PgParamGeom;
import devParameterize.modules.PnModule;
import devParameterize.modules.fieldGenerator.PmCoveringGenerator;
import devParameterize.modules.fieldGenerator.PmFieldExtender_IP;
import devParameterize.modules.fieldGenerator.PmFrameAngleSmoother;
import devParameterize.modules.fieldGenerator.PwExtenderAngle;
import devParameterize.modules.fieldGenerator.PwExtenderParallel;
import jv.geom.PgVectorField;
import jv.object.PsDebug;
import jv.project.PvDisplayIf;
import jv.vecmath.PbVector;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.vector.PwVectorField;

public class PmFieldExtender
extends PnModule {
    public static final int EXTENDER_PARALLEL = 0;
    public static final int EXTENDER_ANGLE = 1;
    protected static final String[] NAMES = new String[]{"Parallel extender", "Angle-based externder"};
    protected int m_method;
    protected PwExtenderParallel m_parallelExtender;
    protected PmFrameAngleSmoother m_preSmoother;
    protected PmCoveringGenerator m_covGenerator;

    public PmFieldExtender() {
        this.setName("Field extender");
        this.setStatusMessage("Field extender");
        this.m_preSmoother = new PmFrameAngleSmoother(false);
        this.m_covGenerator = new PmCoveringGenerator();
        this.m_parallelExtender = new PwExtenderParallel();
        this.m_method = 0;
        if (((Object)((Object)this)).getClass() == PmFieldExtender.class) {
            this.init();
        }
    }

    @Override
    public boolean setGeometry(PgParamGeom geom) {
        if (!super.setGeometry(geom)) {
            return false;
        }
        this.m_preSmoother.setGeometry(geom);
        this.m_covGenerator.setGeometry(geom);
        this.m_parallelExtender.setGeometry(geom);
        if (this.getParameterizer().getSmoother() != null) {
            ((PmFieldExtender_IP)this.getInfoPanel()).makeLayout();
        }
        boolean activate = this.m_geom.getFrameField() == null || this.m_geom.getCovering() == null;
        this.setEnabled(activate);
        return true;
    }

    @Override
    public void setDisplay(PvDisplayIf display) {
        super.setDisplay(display);
        this.m_preSmoother.setDisplay(display);
        this.m_covGenerator.setDisplay(display);
        this.m_parallelExtender.setDisplay(display);
    }

    @Override
    public void setParameterizer(PwParameterizerBase parameterizer) {
        super.setParameterizer(parameterizer);
        this.m_preSmoother.setParameterizer(parameterizer);
        this.m_covGenerator.setParameterizer(parameterizer);
        this.m_parallelExtender.setParameterizer(parameterizer);
    }

    @Override
    public boolean start() {
        if (!super.start()) {
            return false;
        }
        if (this.m_geom.getCovering().getSymmetryOrder() <= 0) {
            PsDebug.error((String)"symmetry order non-positive.");
            return false;
        }
        if (this.m_geom.getSparseField() == null) {
            PsDebug.error((String)"missing sparse field.");
            return false;
        }
        if (this.m_geom.getFrameField() == null) {
            this.m_geom.setFrameField(new PgFrameField(this.m_geom.getCovering()));
            this.m_geom.getFrameField().setName("Frame Field");
            this.m_geom.getFrameField().assureFields();
        }
        this.getParameterizer().assureSmoother();
        switch (this.m_method) {
            case 1: {
                PbVector bTrusted = new PbVector(this.m_geom.getNumElements());
                int i = 0;
                while (i < this.m_geom.getNumElements()) {
                    bTrusted.m_data[i] = this.m_geom.getTrustWeights() == null || this.m_geom.getTrustWeights().getEntry(i) > 0.0;
                    ++i;
                }
                PgCovering customCovering = null;
                if (this.m_geom.getFixMatching()) {
                    if (this.m_geom.getRefVectors() == null) {
                        this.makeRefVectors(this.m_geom.getSparseField(), this.m_geom.getCovering());
                    }
                    customCovering = this.m_geom.getCovering();
                } else if (this.m_geom.getRefVectors() == null) {
                    this.makeRefVectors(null, null);
                }
                PwExtenderAngle.extend(this.m_geom.getSparseField(), this.m_geom.getCovering().getSymmetryOrder(), bTrusted, customCovering, this.m_geom.getRefVectors(), this.m_geom.getEdgeAngles(), this.m_geom.getFrameField());
                this.m_geom.setUpdateField(true);
                this.m_geom.getFrameField().setCovering(this.m_geom.getCovering());
                break;
            }
            case 0: {
                if (this.m_geom.getFixMatching()) {
                    this.m_geom.setFrameField(new PgFrameField(this.m_geom.getCovering()));
                    this.m_geom.getFrameField().setName("Frame Field");
                    this.m_geom.getFrameField().assureFields();
                }
                this.m_parallelExtender.start();
                if (!this.m_geom.getFixMatching()) {
                    this.m_preSmoother.start();
                    this.m_covGenerator.start();
                    this.m_geom.getFrameField().setCovering(this.m_geom.getCovering());
                }
                if (this.m_geom.getRefVectors() == null) {
                    this.makeRefVectors(this.m_geom.getFrameField().getField(0), this.m_geom.getFrameField().getCovering());
                }
                this.getParameterizer().getSmoother().reset();
                this.getParameterizer().getSmoother().start();
                break;
            }
            default: {
                PsDebug.warning((String)"wrong method.");
            }
        }
        this.m_geom.update((Object)this.m_geom);
        return true;
    }

    private void makeRefVectors(PgVectorField field, PgCovering covering) {
        int numE = this.m_geom.getNumElements();
        this.m_geom.setRefVectors(PdVector.realloc(null, (int)numE, (int)3));
        this.m_geom.setEdgeAngles(PdVector.realloc(null, (int)numE, (int)3));
        int symmOrder = this.m_geom.getCovering().getSymmetryOrder();
        if (field != null && covering != null) {
            int e = 0;
            while (e < numE) {
                this.m_geom.getRefVectors()[e].copy(field.getVector(e));
                this.m_geom.getRefVectors()[e].normalize();
                ++e;
            }
            e = 0;
            while (e < numE) {
                int i = 0;
                while (i < 3) {
                    int ne = this.m_geom.getNeighbour((int)e).m_data[i];
                    if (ne > e) {
                        double angle = PwVectorField.angleWithNormals((PdVector)this.m_geom.getRefVectors()[e], (PdVector)this.m_geom.getElementNormal(e), (PdVector)this.m_geom.getRefVectors()[ne], (PdVector)this.m_geom.getElementNormal(ne));
                        int m = covering.getMatching(e, i);
                        angle += (double)m * 2.0 * Math.PI / (double)symmOrder;
                        while (angle >= Math.PI) {
                            angle -= Math.PI * 2;
                        }
                        this.m_geom.getEdgeAngles()[e].m_data[i] = angle -= (double)m * 2.0 * Math.PI / (double)symmOrder;
                        int nLocInd = this.m_geom.getOppVertexLocInd(e, i);
                        this.m_geom.getEdgeAngles()[ne].m_data[nLocInd] = -angle;
                    }
                    ++i;
                }
                ++e;
            }
        } else {
            int e = 0;
            while (e < numE) {
                PiVector element = this.m_geom.getElement(e);
                this.m_geom.getRefVectors()[e].sub(this.m_geom.getVertex(element.m_data[1]), this.m_geom.getVertex(element.m_data[0]));
                this.m_geom.getRefVectors()[e].normalize();
                ++e;
            }
            e = 0;
            while (e < numE) {
                int i = 0;
                while (i < 3) {
                    int ne = this.m_geom.getNeighbour((int)e).m_data[i];
                    if (ne > e) {
                        this.m_geom.getEdgeAngles()[e].m_data[i] = PwVectorField.angleWithNormals((PdVector)this.m_geom.getRefVectors()[e], (PdVector)this.m_geom.getElementNormal(e), (PdVector)this.m_geom.getRefVectors()[ne], (PdVector)this.m_geom.getElementNormal(ne));
                        if (this.m_geom.getEdgeAngles()[e].m_data[i] >= Math.PI) {
                            int n = i;
                            this.m_geom.getEdgeAngles()[e].m_data[n] = this.m_geom.getEdgeAngles()[e].m_data[n] - Math.PI * 2;
                        }
                        int nLocInd = this.m_geom.getOppVertexLocInd(e, i);
                        this.m_geom.getEdgeAngles()[ne].m_data[nLocInd] = -this.m_geom.getEdgeAngles()[e].m_data[i];
                    }
                    ++i;
                }
                ++e;
            }
        }
    }
}

