/*
 * Decompiled with CFR 0.152.
 */
package devParameterize.modules.fieldGenerator;

import devParameterize.apps.PwParameterizerBase;
import devParameterize.geom.PgSharpConstraints;
import devParameterize.modules.PnModule;
import jv.number.PuBoolean;

public class PmConstraintsGenerator
extends PnModule {
    protected PuBoolean m_makeBoundaryConstraints;
    protected PuBoolean m_makeSharpEdgeConstraints;

    public PmConstraintsGenerator() {
        this.setName("Boundary constraints generator");
        this.setStatusMessage("Make constraints");
        this.m_makeBoundaryConstraints = new PuBoolean("Make boundary constraints");
        this.m_makeSharpEdgeConstraints = new PuBoolean("Make sharp edges constraints");
        if (((Object)((Object)this)).getClass() == PmConstraintsGenerator.class) {
            this.init();
        }
    }

    @Override
    public void init() {
        super.init();
        this.setEnabled(true);
        this.m_makeBoundaryConstraints.setDefState(false);
        this.m_makeBoundaryConstraints.init();
        this.m_makeSharpEdgeConstraints.setDefState(false);
        this.m_makeSharpEdgeConstraints.init();
    }

    @Override
    public boolean start() {
        PgSharpConstraints sharpConstraints;
        if (!super.start()) {
            return false;
        }
        if (this.m_geom == null || this.m_geom.getFrameField() == null || this.m_geom.getFixSharpConstraints()) {
            return false;
        }
        if (this.m_makeBoundaryConstraints.getState()) {
            sharpConstraints = new PgSharpConstraints();
            sharpConstraints.setGeometry(this.m_geom);
            this.m_geom.setSharpConstraints(sharpConstraints);
            PwParameterizerBase wParm = this.getParameterizer();
            wParm.setUpdateSharpConstraints(true);
            this.m_geom.getSharpConstraints().makeBoundaryConstraints(this.m_geom.getFrameField());
        }
        if (this.m_makeSharpEdgeConstraints.getState() && this.m_geom.getSharpEdges() != null) {
            if (this.m_geom.getSharpConstraints() == null) {
                sharpConstraints = new PgSharpConstraints();
                sharpConstraints.setGeometry(this.m_geom);
                this.m_geom.setSharpConstraints(sharpConstraints);
            }
            this.m_geom.getSharpConstraints().makeSharpEdgesConstraints(this.m_geom.getSharpEdges());
        }
        return true;
    }

    public void setMakeSharpEdgeConstraints(boolean b) {
        this.m_makeSharpEdgeConstraints.setState(b);
    }

    public boolean getMakeSharpEdgeConstraints() {
        return this.m_makeSharpEdgeConstraints.getState();
    }

    public void setMakeBoundaryConstraints(boolean b) {
        this.m_makeBoundaryConstraints.setState(b);
    }

    public boolean getMakeBoundaryConstraints() {
        return this.m_makeBoundaryConstraints.getState();
    }
}

