/*
 * Decompiled with CFR 0.152.
 */
package devParameterize.modules.fieldGenerator;

import dev.vecmath.PiDynVector;
import devParameterize.geom.PgParamGeom;
import devParameterize.modules.PnModule;
import devParameterize.modules.fieldGenerator.PmRelaxEnergyCurl;
import devParameterize.modules.fieldGenerator.PmRelaxEnergyIf;
import devParameterize.modules.fieldGenerator.PmVectorAngleSmoother;
import java.util.Vector;
import jv.number.PuInteger;
import jv.number.PuString;
import jv.object.PsDebug;
import jv.object.PsUpdateIf;
import jv.vecmath.PiVector;
import jvx.util.PuQueue;

public class PmAlignmentOptimizer
extends PnModule {
    private static final int DEFAULT_NUM_PATHS = 5;
    private static final double MIN_IMPROVEMENT = 0.97;
    private double m_initialEnergy;
    private double m_minEnergy;
    private long m_lastUpdateTime = 0L;
    private final PuInteger m_numMergeNeighbors;
    private PmVectorAngleSmoother m_smoother;
    private PmRelaxEnergyIf m_energy;

    public PmAlignmentOptimizer() {
        this.setName("Alignment optimizer");
        this.setStatusMessage("Optimize Alignment");
        this.m_energy = new PmRelaxEnergyCurl();
        this.m_numMergeNeighbors = new PuInteger("# Merge neighbors", (PsUpdateIf)this);
        this.m_numMergeNeighbors.setDefBounds(0, 20, 1, 5);
        this.m_numMergeNeighbors.setDefValue(5);
        if (((Object)((Object)this)).getClass() == PmAlignmentOptimizer.class) {
            this.init();
        }
    }

    @Override
    public void init() {
        super.init();
        this.m_numMergeNeighbors.init();
        this.setEnabled(false);
    }

    @Override
    public boolean setGeometry(PgParamGeom geom) {
        return super.setGeometry(geom);
    }

    @Override
    public boolean start() {
        if (!super.start()) {
            return false;
        }
        if (this.m_geom.getFixMatching() || this.m_geom.getCovering().getBranchPoints().getSize() == 0) {
            return false;
        }
        this.m_energy.setParameterizer(this.getParameterizer());
        this.m_smoother = this.getParameterizer().getSmoother();
        this.m_minEnergy = this.m_initialEnergy = this.m_smoother.solveAndEval();
        Vector<PiVector> trustRegionComponents = this.trustRegionComponents();
        while (this.componentFlip(trustRegionComponents)) {
        }
        while (this.singleElementFlip()) {
        }
        this.m_lastUpdateTime = 0L;
        this.showStatus("");
        this.m_smoother.start();
        this.m_geom.setUpdateField(true);
        PsDebug.showStatus((String)"");
        this.update((Object)this);
        return true;
    }

    public boolean update(Object event) {
        if (event == this.m_numMergeNeighbors) {
            return true;
        }
        return super.update(event);
    }

    private boolean singleElementFlip() {
        PuQueue queue = new PuQueue(this.m_geom.getNumElements());
        int e = 0;
        while (e < this.m_geom.getNumElements()) {
            if (this.m_geom.getTrustWeights().m_data[e] > 0.0) {
                queue.enqueue(e);
            }
            ++e;
        }
        double energyBefore = this.m_minEnergy;
        while (!queue.isEmpty()) {
            int e2 = queue.extractFirst();
            if (energyBefore == -1.0) {
                energyBefore = this.m_minEnergy;
            }
            int change = 1;
            while (change >= -1) {
                PmAlignmentOptimizer.changeElement(this.m_smoother, e2, change);
                double eVal = this.m_smoother.solveAndEval();
                if (eVal < this.m_minEnergy - 1.0E-7) {
                    this.m_minEnergy = eVal;
                    PiVector neigh = this.m_geom.getNeighbour(e2);
                    queue.enqueue(e2);
                    int i = 0;
                    while (i < 3) {
                        int ne = neigh.m_data[i];
                        if (this.m_geom.getTrustWeights().m_data[ne] > 0.0) {
                            queue.enqueue(ne);
                        }
                        ++i;
                    }
                    this.showStatus(" (Alignment)");
                    PsDebug.message((String)("" + (float)this.m_minEnergy));
                } else {
                    PmAlignmentOptimizer.changeElement(this.m_smoother, e2, -change);
                }
                change -= 2;
            }
        }
        return this.m_minEnergy / energyBefore < 0.97;
    }

    private boolean componentFlip(Vector<PiVector> components) {
        double energyBefore = this.m_minEnergy;
        int k = 0;
        while (k < components.size()) {
            PiVector comp = components.elementAt(k);
            int change = 1;
            while (change >= -1) {
                int j = 0;
                while (j < comp.getSize()) {
                    PmAlignmentOptimizer.changeElement(this.m_smoother, comp.getEntry(j), change);
                    ++j;
                }
                double eVal = this.m_smoother.solveAndEval();
                if (eVal < this.m_minEnergy - 1.0E-7) {
                    this.m_minEnergy = eVal;
                    this.showStatus(" (Align component)");
                    PsDebug.message((String)("" + (float)this.m_minEnergy));
                } else {
                    int j2 = 0;
                    while (j2 < comp.getSize()) {
                        PmAlignmentOptimizer.changeElement(this.m_smoother, comp.getEntry(j2), -change);
                        ++j2;
                    }
                }
                change -= 2;
            }
            ++k;
        }
        return this.m_minEnergy / energyBefore < 0.97;
    }

    private static void changeElement(PmVectorAngleSmoother smoother, int e, int change) {
        PiVector neigh = smoother.getGeometry().getNeighbour(e);
        int i = 0;
        while (i < neigh.getSize()) {
            int ne = neigh.getEntry(i);
            if (ne >= 0) {
                smoother.changeMatching(e, ne, change, true);
            }
            ++i;
        }
    }

    public static PiVector flipElements(PmVectorAngleSmoother smoother, PgParamGeom geom, PiVector elements) {
        double energyBefore;
        if (geom != smoother.getGeometry()) {
            PsDebug.warning((String)"argument geometry and smoother geometry not the same.");
            return null;
        }
        PiVector changes = new PiVector(geom.getNumElements());
        PuQueue queue = new PuQueue(geom.getNumElements());
        int i = 0;
        while (i < elements.getSize()) {
            int e = elements.getEntry(i);
            if (geom.getTrustWeights().m_data[e] > 0.0) {
                queue.enqueue(e);
            }
            ++i;
        }
        double minEnergy = energyBefore = smoother.solveAndEval();
        boolean changed = false;
        while (!queue.isEmpty()) {
            int e = queue.extractFirst();
            PiVector neigh = geom.getNeighbour(e);
            int change = 1;
            while (change >= -1) {
                PmAlignmentOptimizer.changeElement(smoother, e, change);
                double value = smoother.solveAndEval();
                if (value < minEnergy - 1.0E-6) {
                    minEnergy = value;
                    int i2 = 0;
                    while (i2 < 3) {
                        int ne = neigh.m_data[i2];
                        if (geom.getTrustWeights().m_data[ne] > 0.0) {
                            queue.enqueue(ne);
                        }
                        ++i2;
                    }
                    queue.enqueue(e);
                    int n = e;
                    changes.m_data[n] = changes.m_data[n] + change;
                    changed = true;
                } else {
                    PmAlignmentOptimizer.changeElement(smoother, e, -change);
                }
                change -= 2;
            }
        }
        if (changed) {
            PsDebug.message((String)("FlipElements: " + (float)energyBefore + "\t--> " + (float)minEnergy));
        }
        return changes;
    }

    public static void unflipElements(PmVectorAngleSmoother smoother, PiVector changes) {
        int e = 0;
        while (e < changes.getSize()) {
            int change = changes.m_data[e];
            if (change != 0) {
                PmAlignmentOptimizer.changeElement(smoother, e, -change);
            }
            ++e;
        }
    }

    private void showStatus(String extraInfo) {
        PsDebug.showStatus((String)("[Alignment] Iteration: " + this.m_smoother.getNumSystemsSolved() + ",    energy decreased to " + PuString.toString((double)(100.0 * this.m_minEnergy / this.m_initialEnergy), (int)1) + "%" + ", " + (float)this.m_initialEnergy + " --> " + (float)this.m_minEnergy + extraInfo));
        if (System.currentTimeMillis() - this.m_lastUpdateTime > (long)this.updateInterval()) {
            this.m_lastUpdateTime = System.currentTimeMillis();
            this.m_geom.setUpdateBranchpoints(true);
            this.m_geom.update((Object)this.m_geom);
        }
    }

    private Vector<PiVector> trustRegionComponents() {
        boolean[] touched = new boolean[this.m_geom.getNumElements()];
        double[] trust = this.m_geom.getTrustWeights().m_data;
        Vector<PiVector> components = new Vector<PiVector>();
        int i = 0;
        while (i < this.m_geom.getNumElements()) {
            if (!(trust[i] <= 0.0) && !touched[i]) {
                PiDynVector elems = new PiDynVector();
                PuQueue q = new PuQueue();
                q.enqueue(i);
                touched[i] = true;
                while (!q.isEmpty()) {
                    int e = q.extractFirst();
                    elems.appendEntry(e);
                    int j = 0;
                    while (j < 3) {
                        int ne = this.m_geom.getNeighbour((int)e).m_data[j];
                        if (ne != -1 && !touched[ne] && !(trust[ne] <= 0.0)) {
                            touched[ne] = true;
                            q.enqueue(ne);
                        }
                        ++j;
                    }
                }
                components.addElement(elems.toPiVector());
            }
            ++i;
        }
        return components;
    }

    private int updateInterval() {
        return 500 + this.m_geom.getNumElements() / 20;
    }
}

