/*
 * Decompiled with CFR 0.152.
 */
package devParameterize.modules.editor;

import devParameterize.apps.PwParameterizerBase;
import devParameterize.geom.PgSharpConstraints;
import devParameterize.modules.editor.PmCoveringEditor;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import jv.object.PsDebug;
import jv.object.PsPanel;
import jv.object.PsStackLayout;
import jv.object.PsUpdateIf;

public class PmCoveringEditor_IP
extends PsPanel
implements ActionListener,
ItemListener {
    protected PmCoveringEditor m_pmCoveringEditor;
    protected Button m_restartWithCurrentFramefieldButton;
    protected Button m_makeFramesFromTextureGradientButton;
    protected Button m_smoothCurrentFramefieldButton;
    protected Button m_createSparseComplexButton;
    protected Button m_pushVectorsFromIntsButton;
    protected Button m_removeTrustButton;
    protected Button m_removeMarkedConstrButton;
    protected Panel m_constraintPanel = new Panel((LayoutManager)new PsStackLayout(0));
    private Checkbox[] m_markBox;
    private Checkbox[] m_hardBox;
    private Checkbox[] m_enabledBox;
    private TextField[] m_layerField;
    private TextField[] m_editValueField;
    private Checkbox m_moveSingulsBox;
    private Checkbox m_addConstrBox;
    private Checkbox m_addSingulsBox;

    public PmCoveringEditor_IP() {
        if (this.getClass() == PmCoveringEditor_IP.class) {
            this.init();
        }
    }

    public void init() {
        super.init();
    }

    public void setParent(PsUpdateIf parent) {
        if (parent == null) {
            return;
        }
        if (!(parent instanceof PmCoveringEditor)) {
            PsDebug.warning((String)"Parent has to be of type PmCoveringEditor");
            return;
        }
        super.setParent(parent);
        this.m_pmCoveringEditor = (PmCoveringEditor)parent;
        this.makeLayout();
    }

    public void makeLayout() {
        this.removeAll();
        this.setInsetSize(0);
        this.addSubTitle("Trust Region");
        Panel p = new Panel();
        this.m_removeTrustButton = new Button("Remove marked elements from Trustregion");
        p.add(this.m_removeTrustButton);
        this.m_removeTrustButton.addActionListener(this);
        this.add(p);
        this.addSubTitle("Initial Pick");
        p = new Panel(new GridLayout(1, 3));
        CheckboxGroup g = new CheckboxGroup();
        this.m_moveSingulsBox = new Checkbox("Move Singularities", this.m_pmCoveringEditor.m_editModus == 0, g);
        p.add(this.m_moveSingulsBox);
        this.m_moveSingulsBox.addItemListener(this);
        this.m_addConstrBox = new Checkbox("Add Constraints", this.m_pmCoveringEditor.m_editModus == 1, g);
        p.add(this.m_addConstrBox);
        this.m_addConstrBox.addItemListener(this);
        this.m_addSingulsBox = new Checkbox("Add Singularities", this.m_pmCoveringEditor.m_editModus == 2, g);
        p.add(this.m_addSingulsBox);
        this.m_addSingulsBox.addItemListener(this);
        this.add(p);
        p = new Panel();
        this.m_restartWithCurrentFramefieldButton = new Button("Restart (keep framefield and matching)");
        p.add(this.m_restartWithCurrentFramefieldButton);
        this.m_restartWithCurrentFramefieldButton.addActionListener(this);
        this.m_makeFramesFromTextureGradientButton = new Button("Create framefield from texture gradient");
        p.add(this.m_makeFramesFromTextureGradientButton);
        this.m_makeFramesFromTextureGradientButton.addActionListener(this);
        this.m_smoothCurrentFramefieldButton = new Button("Smooth current framefield");
        p.add(this.m_smoothCurrentFramefieldButton);
        this.m_smoothCurrentFramefieldButton.addActionListener(this);
        this.m_createSparseComplexButton = new Button("Create sparse complex");
        p.add(this.m_createSparseComplexButton);
        this.m_createSparseComplexButton.addActionListener(this);
        p.setPreferredSize(new Dimension(p.getWidth(), 140));
        this.add(p);
        this.addSubTitle("Constraints");
        this.add((Component)this.m_pmCoveringEditor.m_showConstraints.getInfoPanel());
        ScrollPane sp = new ScrollPane();
        sp.setPreferredSize(new Dimension(sp.getWidth(), 250));
        sp.add(this.m_constraintPanel);
        p = new Panel(new BorderLayout());
        p.setPreferredSize(new Dimension(sp.getWidth(), 300));
        p.add((Component)sp, "Center");
        p.add((Component)new Label(), "South");
        this.add(p);
        p = new Panel(new BorderLayout());
        this.m_removeMarkedConstrButton = new Button("Remove marked constraints");
        p.add(this.m_removeMarkedConstrButton);
        this.m_removeMarkedConstrButton.addActionListener(this);
        this.add(p);
    }

    public boolean update(Object event) {
        if (this.m_pmCoveringEditor == null) {
            PsDebug.notify((String)"missing parent");
            return true;
        }
        if (event == this.m_pmCoveringEditor) {
            this.updateConstraints();
        }
        return super.update(event);
    }

    private void updateConstraints() {
        int i;
        int oldNum;
        if (this.m_pmCoveringEditor.getGeometry() == null) {
            return;
        }
        PgSharpConstraints constr = this.m_pmCoveringEditor.getGeometry().getSharpConstraints();
        if (constr == null) {
            return;
        }
        int num = constr.getNumConstraints();
        int n = oldNum = this.m_markBox == null ? 0 : this.m_markBox.length;
        if (num != oldNum) {
            i = 0;
            while (i < oldNum) {
                this.m_markBox[i].removeItemListener(this);
                this.m_hardBox[i].removeItemListener(this);
                this.m_enabledBox[i].removeItemListener(this);
                ++i;
            }
            this.m_constraintPanel.removeAll();
            this.m_markBox = new Checkbox[num];
            this.m_hardBox = new Checkbox[num];
            this.m_enabledBox = new Checkbox[num];
            this.m_layerField = new TextField[num];
            this.m_editValueField = new TextField[num];
            i = 0;
            while (i < num) {
                Panel p = new Panel(new FlowLayout(0));
                this.m_markBox[i] = new Checkbox("" + i);
                p.add(this.m_markBox[i]);
                this.m_markBox[i].addItemListener(this);
                p.add(new Label(constr.isBoundary(i) ? "B" : "I"));
                this.m_hardBox[i] = new Checkbox("Hard");
                p.add(this.m_hardBox[i]);
                this.m_hardBox[i].addItemListener(this);
                this.m_enabledBox[i] = new Checkbox("Enabled");
                p.add(this.m_enabledBox[i]);
                this.m_enabledBox[i].addItemListener(this);
                this.m_layerField[i] = new TextField(1);
                p.add(this.m_layerField[i]);
                this.m_layerField[i].setEditable(false);
                this.m_editValueField[i] = new TextField(4);
                p.add(this.m_editValueField[i]);
                this.m_constraintPanel.add(p);
                ++i;
            }
            this.m_constraintPanel.invalidate();
            this.getParent().validate();
        }
        i = 0;
        while (i < num) {
            this.m_markBox[i].setState(constr.isMarked(i));
            this.m_hardBox[i].setState(constr.isHard(i));
            this.m_enabledBox[i].setState(constr.isEnabled(i));
            this.m_layerField[i].setText("" + constr.getLayer(i));
            this.m_editValueField[i].setText("" + constr.getConstraintValue(i));
            ++i;
        }
        this.m_pmCoveringEditor.getParameterizer().showSharpConstraints(this.m_pmCoveringEditor.getGeometry().m_showSharpConstraints.getState());
    }

    private void setConstraintValues() {
        if (this.m_pmCoveringEditor.getGeometry() == null) {
            return;
        }
        PgSharpConstraints constr = this.m_pmCoveringEditor.getGeometry().getSharpConstraints();
        if (constr == null) {
            return;
        }
        int num = constr.getNumConstraints();
        int i = 0;
        while (i < num) {
            constr.setConstraintValue(i, Double.valueOf(this.m_editValueField[i].getText()));
            ++i;
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (this.m_pmCoveringEditor == null) {
            return;
        }
        Object source = event.getSource();
        if (source == this.m_makeFramesFromTextureGradientButton) {
            this.m_pmCoveringEditor.createFrameFieldFromTexture();
        } else if (source == this.m_restartWithCurrentFramefieldButton) {
            this.setConstraintValues();
            this.m_pmCoveringEditor.restartWithCurrentFrameField();
        } else if (source == this.m_smoothCurrentFramefieldButton) {
            this.m_pmCoveringEditor.smoothCurrentFrameField();
        } else if (source == this.m_createSparseComplexButton) {
            this.m_pmCoveringEditor.createBaseComplex();
        } else if (source == this.m_removeTrustButton) {
            this.m_pmCoveringEditor.removeTrust();
        } else if (source == this.m_pushVectorsFromIntsButton) {
            this.m_pmCoveringEditor.moveVerticesFromInts();
        } else if (source == this.m_removeMarkedConstrButton) {
            this.m_pmCoveringEditor.removeMarkedConstr();
            PwParameterizerBase wParm = this.m_pmCoveringEditor.getParameterizer();
            wParm.setUpdateSharpConstraints(true);
            wParm.update(wParm);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        if (source == this.m_moveSingulsBox) {
            this.m_pmCoveringEditor.setEditModus(0);
        } else if (source == this.m_addConstrBox) {
            this.m_pmCoveringEditor.setEditModus(1);
        } else if (source == this.m_addSingulsBox) {
            this.m_pmCoveringEditor.setEditModus(2);
        } else {
            int num = this.m_markBox == null ? 0 : this.m_markBox.length;
            PgSharpConstraints constr = this.m_pmCoveringEditor.getGeometry().getSharpConstraints();
            PwParameterizerBase wParm = this.m_pmCoveringEditor.getParameterizer();
            int i = 0;
            while (i < num) {
                if (source == this.m_markBox[i]) {
                    constr.setMarked(i, this.m_markBox[i].getState());
                    wParm.setUpdateSharpConstraints(true);
                } else if (source == this.m_hardBox[i]) {
                    constr.setHard(i, this.m_hardBox[i].getState());
                } else if (source == this.m_enabledBox[i]) {
                    constr.setEnabled(i, this.m_enabledBox[i].getState());
                    wParm.setUpdateSharpConstraints(true);
                }
                ++i;
            }
            this.m_pmCoveringEditor.getGeometry().update((Object)this.m_pmCoveringEditor.getGeometry());
        }
    }
}

