/*
 * Decompiled with CFR 0.152.
 */
package devParameterize.modules.editor;

import dev.geom.PnStructureElementSet;
import devCovering.PgCovering;
import devCovering.PgFrameField;
import devGraph.PnGraphOnElementSet;
import devParameterize.apps.PwParameterizerBase;
import devParameterize.geom.PgParamGeom;
import devParameterize.geom.PgSharpConstraints;
import devParameterize.geom.PwBaseComplexParam;
import devParameterize.modules.PnModule;
import devParameterize.modules.fieldGenerator.PmVectorAngleSmoother;
import devParameterize.modules.parameterizer.PmAntiSpiraler;
import java.awt.Button;
import java.awt.Color;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgVectorField;
import jv.number.PuBoolean;
import jv.object.PsDebug;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.project.PvDisplayIf;
import jv.project.PvPickEvent;
import jv.project.PvPickListenerIf;
import jv.vecmath.PdBary;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.geom.PgVertexStar;
import jvx.project.PjWorkshop_Dialog;
import jvx.util.PuPriorityQueue;

public class PmCoveringEditor
extends PnModule
implements PvPickListenerIf,
Runnable {
    public static final int EDIT_SINGULARITIES = 0;
    public static final int EDIT_ADD_CONSTRAINTS = 1;
    public static final int EDIT_ADD_SINGULARITIES = 2;
    protected double m_energyValue = -1.0;
    private PiVector m_elementPerVertex;
    private int m_bpInd;
    private boolean m_running;
    public PuBoolean m_showConstraints;
    private Button m_restartButton;
    protected int m_editModus = 0;
    private int m_startV = -1;
    private double m_startVSize;
    protected PwBaseComplexParam m_pwBaseC;

    public PmCoveringEditor() {
        this.setName("Covering editor");
        this.setStatusMessage("Edit covering");
        this.m_showConstraints = new PuBoolean("Show Constraints", (PsUpdateIf)this);
        if (this.getClass() == PmCoveringEditor.class) {
            this.init();
        }
    }

    @Override
    public void init() {
        super.init();
        this.m_showConstraints.setDefState(false);
        this.m_showConstraints.init();
    }

    public void setEditModus(int mode) {
        this.m_editModus = mode;
    }

    @Override
    public boolean setGeometry(PgParamGeom geom) {
        if (!super.setGeometry(geom)) {
            return false;
        }
        if (this.m_geom != null) {
            this.m_geom.removeUpdateListener((PsUpdateIf)this);
            this.m_elementPerVertex = null;
        }
        super.setGeometry(geom);
        if (this.m_geom != null) {
            this.m_geom.addUpdateListener((PsUpdateIf)this);
            this.m_elementPerVertex = PgVertexStar.getElementPerVertex((PgElementSet)this.m_geom);
        }
        this.m_bpInd = -1;
        return true;
    }

    @Override
    public PvDisplayIf getDisplay() {
        return this.m_display;
    }

    @Override
    public void setDisplay(PvDisplayIf display) {
        if (this.m_display != null) {
            this.m_display.removePickListener((PvPickListenerIf)this);
        }
        super.setDisplay(display);
        this.m_bpInd = -1;
        if (this.m_display != null) {
            this.m_display.addPickListener((PvPickListenerIf)this);
        }
    }

    public void moveVerticesFromInts() {
        this.moveVerticesFromInts(this.getGeometry(), this.getGeometry().getParamTexture());
    }

    public void moveVerticesFromInts(PgParamGeom geom, PdVector[][] tex) {
        PiVector elementsPerVertex = PgVertexStar.getElementPerVertex((PgElementSet)geom);
        double PUSH_EPSILON = 1.0E-5;
        int numVs = geom.getNumVertices();
        int vInd = 0;
        while (vInd < numVs) {
            if (geom.getCovering().getBranchType(vInd) != 0) {
                int elemInd = elementsPerVertex.getEntry(vInd);
                int vIndLoc = 0;
                while (geom.getElement(elemInd).getEntry(vIndLoc) != vInd) {
                    if (++vIndLoc <= 2) continue;
                    PsDebug.warning((String)"Connectivity error!");
                    return;
                }
                int coord = 0;
                while (coord < 2) {
                    if (2.0 * tex[elemInd][vIndLoc].getEntry(coord) - 2.0 * (double)Math.round(tex[elemInd][vIndLoc].getEntry(coord)) < 1.0E-10) {
                        PdVector push = new PdVector(2);
                        push.setEntry(coord, PUSH_EPSILON);
                        PgVertexStar s = new PgVertexStar();
                        s.makeVertexStar((PgElementSet)geom, vInd, elemInd);
                        PiVector elems = s.getElement();
                        PiVector vertexLocInds = s.getVertexLocInd();
                        int e = 0;
                        while (e < elems.getSize()) {
                            if (e > 0) {
                                int locNbIndex = geom.getNeighbour(elems.getEntry(e - 1)).getIndexOf(elems.getEntry(e));
                                int turnBy = geom.getCovering().getMatching(elems.getEntry(e), locNbIndex);
                                push = PmAntiSpiraler.quarterRotationLeft(push, turnBy);
                            }
                            tex[elems.getEntry(e)][vertexLocInds.getEntry(e)].add(push);
                            ++e;
                        }
                    }
                    ++coord;
                }
            }
            ++vInd;
        }
        geom.setParamTexture(tex);
        geom.update((Object)geom);
    }

    public void createBaseComplex() {
        PwBaseComplexParam m_pwBaseComplexParam = new PwBaseComplexParam();
        m_pwBaseComplexParam.setGeometry((PgGeometry)this.m_geom);
        m_pwBaseComplexParam.setDisplay(this.getDisplay());
        m_pwBaseComplexParam.viewBaseComplex();
        PjWorkshop_Dialog dialog = new PjWorkshop_Dialog(false);
        dialog.setParent((PsUpdateIf)m_pwBaseComplexParam);
        dialog.update((Object)m_pwBaseComplexParam);
        dialog.setVisible(true);
    }

    public static PiVector getElementWithVertex(PgElementSet geom, int vertexInd) {
        PiVector elems = new PiVector(0);
        int numElements = geom.getNumElements();
        int i = 0;
        while (i < numElements) {
            int j = 0;
            while (j < geom.getElement(i).getSize()) {
                if (geom.getElement(i).getEntry(j) == vertexInd) {
                    elems.addEntry(i);
                    elems.addEntry(j);
                }
                ++j;
            }
            ++i;
        }
        return elems;
    }

    @Override
    public boolean start() {
        if (!super.start()) {
            return false;
        }
        if (this.m_geom.getFixMatching()) {
            return false;
        }
        this.update(this);
        return true;
    }

    private void moveSingularity(int bpInd, int destV) {
        int v = this.m_geom.getCovering().getBranchPoints().m_data[bpInd];
        PiVector path = PnGraphOnElementSet.makeShortestPath((PgElementSet)this.m_geom, (int)v, (int)destV, (int)0);
        PmVectorAngleSmoother smoother = this.getParameterizer().getSmoother();
        if (smoother != null) {
            this.m_geom.clearTagVertex(v, 1);
            this.m_geom.clearTagVertex(destV, 1);
            smoother.applyChange(path, -((int)Math.signum(smoother.getIndex(v))));
            this.m_geom.setUpdateBranchpoints(true);
            this.getParameterizer().setUpdateMatching(true);
            this.getParameterizer().showMatching(this.getParameterizer().isShowingMatching());
            smoother.start();
            this.m_geom.setUpdateField(true);
        }
        this.m_geom.update((Object)this.m_geom);
    }

    private void addSingularities(int vertexIndex, int elementIndex) {
        boolean foundFirst = false;
        int secondVertexIndex = -1;
        int elemCorner = 0;
        while (elemCorner < this.m_geom.getElement(elementIndex).getSize()) {
            if (this.m_geom.getElement(elementIndex).getEntry(elemCorner) == vertexIndex) {
                foundFirst = true;
            } else {
                secondVertexIndex = this.m_geom.getElement(elementIndex).getEntry(elemCorner);
            }
            ++elemCorner;
        }
        if (!foundFirst || secondVertexIndex < 0) {
            PsDebug.warning((String)"Error in addSingularities: illegal element or vertex index");
            return;
        }
        PiVector path = new PiVector(vertexIndex, secondVertexIndex);
        PmVectorAngleSmoother smoother = this.getParameterizer().getSmoother();
        smoother.applyChange(path, 1);
        this.m_geom.setUpdateBranchpoints(true);
        smoother.start();
        this.m_geom.setUpdateField(true);
    }

    private void moveSingularityAlongEdge(int bpInd, int to) {
        PgCovering covering = this.m_geom.getCovering();
        PiVector bp = covering.getBranchPoints();
        PiVector bt = covering.getBranchTypes();
        int from = bp.m_data[bpInd];
        int e = PnStructureElementSet.dualEdgeFromVertices((PgElementSet)this.m_geom, (int)from, (int)to, (int)this.m_elementPerVertex.m_data[from], null).m_data[0];
        int locInd = (this.m_geom.getElement(e).getIndexOf(from) + 1) % 3;
        int m = covering.getMatching(e, locInd);
        int branchIndex = bt.m_data[bpInd];
        covering.setMatching(e, locInd, m - branchIndex);
        int destInd = bp.getIndexOf(to);
        bp.m_data[bpInd] = to;
        if (destInd >= 0) {
            bt.m_data[bpInd] = (bt.m_data[bpInd] + bt.m_data[destInd]) % covering.getSymmetryOrder();
            if (bt.m_data[bpInd] == 0) {
                bp.removeEntry(bpInd);
                bt.removeEntry(bpInd);
                if (destInd > bpInd) {
                    --destInd;
                }
            }
            bp.removeEntry(destInd);
            bt.removeEntry(destInd);
        }
        covering.getBranchPoints().changeValue(from, to);
    }

    public boolean update(Object event) {
        if (event == null) {
            super.update(null);
        }
        if (event == this.m_geom) {
            this.update(this);
            PwParameterizerBase wParm = this.getParameterizer();
            this.m_showConstraints.setState(wParm.isShowingSharpConstraints());
            return true;
        }
        if (event == this.m_showConstraints) {
            PwParameterizerBase wParm = this.getParameterizer();
            wParm.showSharpConstraints(this.m_showConstraints.getState());
            wParm.update(wParm);
            return true;
        }
        return super.update(event);
    }

    public void selectGeometry(PgGeometryIf geom) {
    }

    public void pickDisplay(PvPickEvent pos) {
    }

    public void dragDisplay(PvPickEvent pos) {
    }

    public void pickInitial(PvPickEvent pos) {
        if (this.getParameterizer().isRunning()) {
            return;
        }
        if (this.m_editModus == 1) {
            this.pickInitialAddConstraints(pos);
            PwParameterizerBase wParm = this.getParameterizer();
            wParm.setUpdateSharpConstraints(true);
            wParm.update(wParm);
            return;
        }
        if (pos.getGeometry() != this.m_geom) {
            return;
        }
        if (this.m_geom == null || this.m_geom.getFrameField() == null) {
            PsDebug.warning((String)"Missing geometry or field set.");
            return;
        }
        PdBary b = pos.getBary();
        int e = b.getElementInd();
        if (e < 0) {
            return;
        }
        int locInd = b.m_data[0] >= b.m_data[1] && b.m_data[0] >= b.m_data[2] ? 0 : (b.m_data[1] >= b.m_data[2] ? 1 : 2);
        int v = this.m_geom.getElement((int)e).m_data[locInd];
        if (this.m_editModus == 0) {
            if (this.m_bpInd < 0) {
                int bpInd = this.m_geom.getCovering().getBranchPoints().getIndexOf(v);
                if (bpInd < 0) {
                    PsDebug.warning((String)"Pick a branch point.");
                    return;
                }
                this.m_geom.setTagVertex(v, 1);
                this.m_geom.update((Object)this.m_geom);
                this.m_bpInd = bpInd;
            } else {
                this.moveSingularity(this.m_bpInd, v);
                this.m_geom.setUpdateBranchpoints(true);
                this.m_geom.clearTagVertex(this.m_bpInd, 1);
                this.m_geom.update((Object)this.m_geom);
                this.m_bpInd = -1;
            }
        } else if (this.m_editModus == 2) {
            int el_corner = 0;
            while (el_corner < this.m_geom.getElement(e).getSize()) {
                if (this.m_geom.getCovering().getBranchPoints().getIndexOf(this.m_geom.getElement(e).getEntry(el_corner)) >= 0) {
                    PsDebug.warning((String)"There is already a branch point in the selected element. To remove branch points use 'move singularities'.");
                    return;
                }
                ++el_corner;
            }
            this.addSingularities(v, e);
            this.m_geom.update((Object)this.m_geom);
        }
        this.update(this);
    }

    private void pickInitialAddConstraints(PvPickEvent pos) {
        if (pos.getGeometry() != this.m_geom) {
            return;
        }
        if (this.m_geom == null || this.m_geom.getFrameField() == null) {
            PsDebug.warning((String)"Missing geometry or field set.");
            return;
        }
        PdBary b = pos.getBary();
        int e = b.getElementInd();
        if (e < 0) {
            return;
        }
        int locInd = b.m_data[0] >= b.m_data[1] && b.m_data[0] >= b.m_data[2] ? 0 : (b.m_data[1] >= b.m_data[2] ? 1 : 2);
        int v = this.m_geom.getElement((int)e).m_data[locInd];
        if (this.m_startV < 0) {
            this.m_geom.setTagVertex(v, 1);
            this.m_startV = v;
            this.m_startVSize = this.m_geom.getVertexSize(this.m_startV);
            this.m_geom.setVertexSize(this.m_startV, 2.0);
            this.m_geom.update((Object)this.m_geom);
        } else {
            if (!this.m_geom.getFixSharpConstraints()) {
                this.makeConstraint(this.m_startV, v);
                this.m_geom.setGaps(null);
                this.m_geom.setUpdateBranchpoints(true);
            }
            this.m_geom.clearTagVertex(this.m_startV, 1);
            this.m_geom.setVertexSize(this.m_startV, this.m_startVSize);
            this.m_geom.update((Object)this.m_geom);
            this.m_startV = -1;
        }
        this.update(this);
    }

    private void makeConstraint(int startV, int endV) {
        if (this.m_geom.getSharpConstraints() == null) {
            PgSharpConstraints sharpConstraints = new PgSharpConstraints();
            sharpConstraints.setGeometry(this.m_geom);
            this.m_geom.setSharpConstraints(sharpConstraints);
            PwParameterizerBase wParm = this.getParameterizer();
            wParm.setUpdateSharpConstraints(true);
        }
        if (startV == endV) {
            PiVector singleVertexConstraint = new PiVector(1);
            singleVertexConstraint.setEntry(0, startV);
            this.m_geom.getSharpConstraints().addConstraint(singleVertexConstraint);
            return;
        }
        int numV = this.m_geom.getNumVertices();
        boolean[] vertexBlocked = new boolean[numV];
        PuPriorityQueue queue = new PuPriorityQueue(numV);
        queue.enqueue(startV, 0.0);
        vertexBlocked[startV] = true;
        int[] parent = new int[numV];
        parent[startV] = -1;
        PgVertexStar star = new PgVertexStar();
        PiVector elementPerVertex = PgVertexStar.getElementPerVertex((PgElementSet)this.m_geom);
        while (!queue.isEmpty()) {
            double key = queue.getKeyOfMin();
            int v = queue.extractMin();
            star.makeVertexStar((PgElementSet)this.m_geom, v, elementPerVertex.m_data[v]);
            PiVector nVertices = star.getLink();
            int dim = nVertices.getSize();
            int i = 0;
            while (i < dim) {
                int nv = nVertices.m_data[i];
                if (nv == endV) {
                    parent[nv] = v;
                    int actV = endV;
                    int pathLen = 0;
                    while (parent[actV] >= 0) {
                        actV = parent[actV];
                        ++pathLen;
                    }
                    PiVector path = new PiVector(pathLen + 1);
                    actV = endV;
                    while (parent[actV] >= 0) {
                        path.m_data[pathLen] = actV;
                        actV = parent[actV];
                        --pathLen;
                    }
                    path.m_data[pathLen] = startV;
                    this.m_geom.getSharpConstraints().addConstraint(path);
                    return;
                }
                if (!vertexBlocked[nv]) {
                    vertexBlocked[nv] = true;
                    parent[nv] = v;
                    queue.enqueue(nv, key + this.m_geom.getVertex(v).dist(this.m_geom.getVertex(nv)));
                }
                ++i;
            }
        }
        PsDebug.warning((String)("Cannot find constraint: No possible path from vertex " + startV + " to vertex " + endV + "."));
    }

    public void dragInitial(PvPickEvent pos) {
    }

    public void pickVertex(PgGeometryIf geom, int index, PdVector vertex) {
    }

    public void dragVertex(PgGeometryIf geom, int index, PdVector vertex) {
    }

    public void markVertices(PvPickEvent pos) {
    }

    public void unmarkVertices(PvPickEvent pos) {
    }

    public void restartParameterizer() {
        new Thread(this).start();
    }

    protected void restartParameterizer(Button b) {
        this.m_restartButton = b;
        new Thread(this).start();
    }

    public void removeTrust() {
        int numE = this.m_geom.getNumElements();
        int e = 0;
        while (e < numE) {
            if (this.m_geom.hasTagElement(e, 1)) {
                this.m_geom.getTrustWeights().m_data[e] = 0.0;
                this.m_geom.clearTagElement(e, 1);
            }
            ++e;
        }
        this.m_geom.update((Object)this.m_geom);
    }

    public void removeMarkedConstr() {
        this.m_geom.getSharpConstraints().removeMarkedConstraints();
    }

    @Override
    public void run() {
        if (this.m_running) {
            return;
        }
        this.m_running = true;
        Color c = null;
        if (this.m_restartButton != null) {
            c = this.m_restartButton.getBackground();
        }
        this.m_parameterizer.startFFExtension();
        if (c != null && this.m_restartButton != null) {
            this.m_restartButton.setBackground(c);
        }
        this.m_running = false;
    }

    public void restartWithCurrentFrameField() {
        boolean fixMatching = this.m_geom.getFixMatching();
        boolean fixConstraints = this.m_geom.getFixSharpConstraints();
        this.m_geom.setFixMatching(true);
        this.m_geom.setFixSharpConstraints(true);
        this.m_parameterizer.getUsedModuleGlobalID(10).setEnabled(true);
        this.m_parameterizer.startUsedModulesFromCurrent(this.m_parameterizer.getUsedModuleGlobalID(10));
        this.m_geom.setFixSharpConstraints(fixConstraints);
        this.m_geom.setFixMatching(fixMatching);
    }

    public static PgFrameField getFrameFieldFromTexture(PgParamGeom geom) {
        PgFrameField field = new PgFrameField(geom.getCovering());
        field.setField(0, new PgVectorField(3, 1));
        field.setField(1, new PgVectorField(3, 1));
        field.getField(0).setGeometry((PgPointSet)geom);
        field.getField(1).setGeometry((PgPointSet)geom);
        PdVector[][] textureCoords = geom.getParamTexture();
        if (geom.getFrameField().getNumFields() == 2 && geom.getDimOfElements() == 3) {
            int e = 0;
            while (e < geom.getNumElements()) {
                int j = 0;
                while (j < 2) {
                    PdVector texValues = new PdVector(3);
                    int i = 0;
                    while (i < 3) {
                        texValues.setEntry(i, textureCoords[e][i].getEntry(j));
                        ++i;
                    }
                    PdVector grad = PmCoveringEditor.gradientOnTriangle(geom, e, texValues);
                    field.getField(j).setVector(e, grad);
                    ++j;
                }
                ++e;
            }
        } else {
            PsDebug.warning((String)"Can't create frame field from texture!");
            return null;
        }
        return field;
    }

    public void createFrameFieldFromTexture() {
        PgFrameField newField = PmCoveringEditor.getFrameFieldFromTexture(this.m_geom);
        if (newField != null) {
            newField.setName("Frame from Texture");
            this.m_geom.setFrameField(newField);
        }
        this.m_parameterizer.getSmoother().reset();
        this.m_geom.updateVisualizations();
        this.m_geom.update((Object)this.m_geom);
    }

    public static PdVector gradientOnTriangle(PgParamGeom m_geom, int e, PdVector texValues) {
        if (m_geom.getDimOfElements() != 3) {
            PsDebug.warning((String)"Geometry is not a triangulation!");
            return null;
        }
        PdMatrix A = new PdMatrix(3, 3);
        PdVector b = new PdVector(3);
        PdVector v1 = m_geom.getVertex(m_geom.getElement(e).getEntry(0));
        int i = 1;
        while (i < 3) {
            PdVector vCur = PdVector.subNew((PdVector)m_geom.getVertex(m_geom.getElement(e).getEntry(i)), (PdVector)v1);
            int j = 0;
            while (j < 3) {
                A.setEntry(i, j, vCur.getEntry(j));
                ++j;
            }
            b.setEntry(i, texValues.getEntry(i) - texValues.getEntry(0));
            ++i;
        }
        m_geom.assureElementNormals();
        PdVector norm = m_geom.getElementNormal(e);
        int j = 0;
        while (j < 3) {
            A.setEntry(0, j, norm.getEntry(j));
            ++j;
        }
        b.setEntry(0, 0);
        if (!A.invert()) {
            PsDebug.warning((String)("Error while calculating gradient of triangle " + e));
        }
        b.leftMultMatrix(A);
        b.multScalar(1.0 / m_geom.getFrameScaleFactor());
        return b;
    }

    public void smoothCurrentFrameField() {
        this.m_parameterizer.getSmoother().start();
        this.m_geom.setUpdateField(true);
        this.m_geom.updateVisualizations();
        this.m_geom.update((Object)this.m_geom);
    }
}

