/*
 * Decompiled with CFR 0.152.
 */
package devParameterize.modules;

import devParameterize.apps.PwParameterizerBase;
import devParameterize.geom.PgParamGeom;
import java.awt.event.ActionListener;
import java.io.File;
import jv.loader.PsXmlLoader;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.project.PvDisplayIf;
import jv.rsrc.PsXmlSrc;
import jvx.gui.PuHeaderBar;

public abstract class PnModule
extends PsObject {
    public static String MODULE_DESCRIPTIONS_FILE = "devParameterize/rsrc/moduleDescriptions.xml";
    public static boolean SHOW_TOOLTIPS = true;
    public static final boolean SIMPLE_GUI = false;
    protected PwParameterizerBase m_parameterizer;
    protected PvDisplayIf m_display;
    protected PgParamGeom m_geom;
    private PuHeaderBar m_headBar;
    private boolean m_abort;
    private long m_abortTime;
    private long m_timeLimit;
    private String m_statusMessage;

    public PnModule() {
        if (((Object)((Object)this)).getClass() == PnModule.class) {
            this.init();
        }
    }

    public void init() {
        this.m_headBar = new PuHeaderBar(this.getName());
        if (SHOW_TOOLTIPS && this.getHeadbarTooltip() != null) {
            this.m_headBar.setTooltip(this.getHeadbarTooltip());
        }
    }

    public String getModuleName() {
        String[] fullClassName = ((Object)((Object)this)).getClass().getName().split("\\.");
        if (fullClassName.length > 0) {
            return fullClassName[fullClassName.length - 1];
        }
        return ((Object)((Object)this)).getClass().getName();
    }

    public PuHeaderBar getHeadBar() {
        return this.m_headBar;
    }

    protected String getHeadbarTooltip() {
        if (!new File(MODULE_DESCRIPTIONS_FILE).isFile()) {
            return null;
        }
        PsXmlSrc moduleDescriptions = PsXmlLoader.read((String)MODULE_DESCRIPTIONS_FILE);
        if (moduleDescriptions == null) {
            PsDebug.warning((String)"Missing module description file...");
            return null;
        }
        if (moduleDescriptions.getRootNode().hasChild(this.getModuleName())) {
            return moduleDescriptions.getRootNode().getChild(this.getModuleName()).getContent();
        }
        return null;
    }

    public PgParamGeom getGeometry() {
        return this.m_geom;
    }

    public boolean setGeometry(PgParamGeom geom) {
        if (geom == null) {
            PsDebug.error((String)"missing geometry.");
            return false;
        }
        if (geom.getCovering() == null) {
            PsDebug.error((String)"missing covering.");
            return false;
        }
        this.m_geom = geom;
        return true;
    }

    public PvDisplayIf getDisplay() {
        return this.m_display;
    }

    public void setDisplay(PvDisplayIf display) {
        this.m_display = display;
    }

    public boolean getEnabled() {
        return this.m_headBar.isEnabledHeadbar();
    }

    public void setEnabled(boolean b) {
        this.m_headBar.setEnabledHeadbar(b);
    }

    public PwParameterizerBase getParameterizer() {
        return this.m_parameterizer;
    }

    public void setParameterizer(PwParameterizerBase parameterizer) {
        this.m_parameterizer = parameterizer;
        this.m_headBar.setActionListener((ActionListener)this.m_parameterizer);
    }

    public boolean start() {
        if (this.m_geom == null) {
            PsDebug.error((String)"missing geometry.");
            return false;
        }
        if (this.m_geom.getCovering() == null) {
            PsDebug.error((String)"missing covering.");
            return false;
        }
        this.m_abort = false;
        this.setAbortTime(this.m_timeLimit);
        return true;
    }

    public int jumpToModule() {
        return -1;
    }

    public void setTimeLimit(long milliseconds) {
        this.m_timeLimit = milliseconds;
    }

    public long getTimeLimit() {
        return this.m_timeLimit;
    }

    public void abort() {
        this.m_abort = true;
        PsDebug.showStatus((String)"abort ...");
    }

    protected boolean isAborted() {
        return this.m_abort || this.m_abortTime != 0L && System.currentTimeMillis() > this.m_abortTime;
    }

    private void setAbortTime(long milliseconds) {
        this.m_abortTime = milliseconds == 0L ? 0L : System.currentTimeMillis() + milliseconds;
    }

    public String getStatusMessage() {
        return this.m_statusMessage;
    }

    public void setStatusMessage(String msg) {
        this.m_statusMessage = msg;
    }
}

