/*
 * Decompiled with CFR 0.152.
 */
package devParameterize.loader;

import devParameterize.loader.PjImportParamModel;
import java.awt.Button;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;

public class PjImportParamModel_IP
extends PsPanel
implements ActionListener {
    private PjImportParamModel m_pjImportParamModel;
    private TextField m_filenameField;
    private Button m_loadButton;
    private Button m_saveButton;

    public PjImportParamModel_IP() {
        if (this.getClass() == PjImportParamModel_IP.class) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_filenameField = new TextField(22);
        this.m_filenameField.addActionListener(this);
        this.add(this.m_filenameField);
        Panel p = new Panel(new FlowLayout(1));
        this.m_loadButton = new Button("Load");
        this.m_loadButton.addActionListener(this);
        p.add(this.m_loadButton);
        this.m_saveButton = new Button("Save as...");
        this.m_saveButton.addActionListener(this);
        p.add(this.m_saveButton);
        this.add(p);
    }

    public void setParent(PsUpdateIf parent) {
        if (!(parent instanceof PjImportParamModel)) {
            PsDebug.warning((String)"Parent must be instance of PjImportParamModel");
            return;
        }
        super.setParent(parent);
        this.m_pjImportParamModel = (PjImportParamModel)parent;
    }

    public boolean update(Object event) {
        if (event == null) {
            return super.update(null);
        }
        if (event == this.m_pjImportParamModel) {
            this.m_filenameField.setText(this.m_pjImportParamModel.getFileName());
            return true;
        }
        return super.update(event);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.m_loadButton) {
            FileDialog fileDialog = new FileDialog(PsConfig.getFrame(), "Open parameterization", 0);
            fileDialog.setDirectory(".");
            if (this.m_pjImportParamModel.m_saveAsGp) {
                fileDialog.setFile("*.gp;*.jvx;*.obj;*.stl;*.wrl;*.byu");
            } else {
                fileDialog.setFile("*.jvx;*.obj;*.stl;*.wrl;*.byu");
            }
            fileDialog.setVisible(true);
            if (fileDialog.getFile() == null) {
                return;
            }
            String filename = fileDialog.getDirectory();
            filename = filename == null ? fileDialog.getFile() : (filename.endsWith("/") || filename.endsWith("\\") ? String.valueOf(filename) + fileDialog.getFile() : String.valueOf(filename) + "/" + fileDialog.getFile());
            fileDialog.dispose();
            if (filename == null) {
                return;
            }
            if (this.m_pjImportParamModel.load(filename)) {
                this.m_filenameField.setText(this.m_pjImportParamModel.getFileName());
                this.m_pjImportParamModel.fireAction(1001, "OK");
            }
        } else if (source == this.m_filenameField) {
            String filename = this.m_filenameField.getText().trim();
            if (filename.length() > 0 && this.m_pjImportParamModel.load(filename)) {
                this.m_filenameField.setText(this.m_pjImportParamModel.getFileName());
                this.m_pjImportParamModel.fireAction(1001, "OK");
            }
        } else if (source == this.m_saveButton) {
            if (this.m_pjImportParamModel.getGeometry() == null) {
                PsDebug.warning((String)"No geometry available");
                return;
            }
            String filename = ".obj";
            if (PsConfig.isApplication()) {
                FileDialog fileDialog = new FileDialog(PsConfig.getFrame(), "Save parameterization", 1);
                fileDialog.setDirectory(".");
                String ext = this.m_pjImportParamModel.m_saveAsGp ? ".gp" : ".obj";
                fileDialog.setFile("*" + ext);
                fileDialog.setVisible(true);
                filename = String.valueOf(fileDialog.getDirectory()) + fileDialog.getFile();
                fileDialog.dispose();
                if (!filename.endsWith(ext)) {
                    filename = String.valueOf(filename) + ext;
                }
                if (this.m_pjImportParamModel.saveFile(filename)) {
                    this.m_filenameField.setText(this.m_pjImportParamModel.getFileName());
                }
            } else {
                this.m_pjImportParamModel.saveFile(filename);
            }
        }
    }
}

