/*
 * Decompiled with CFR 0.152.
 */
package devParameterize.loader;

import devParameterize.geom.PgParamGeom;
import devParameterize.loader.PgGpLoader;
import jv.loader.PgLoader;
import jv.loader.PjImportModel;
import jv.object.PsDebug;
import jv.project.PgGeometryIf;

public class PjImportParamModel
extends PjImportModel {
    protected boolean m_saveAsGp = true;

    public boolean load(String fullFileName) {
        if (!fullFileName.endsWith(".gp")) {
            return super.load(fullFileName);
        }
        PgGpLoader loader = new PgGpLoader();
        PgParamGeom[] geoms = loader.loadGeometries(fullFileName);
        if (geoms == null || geoms.length == 0) {
            PsDebug.warning((String)"No geometry found in file.");
            return false;
        }
        this.setGeometry((PgGeometryIf)geoms[0]);
        this.setFileName(fullFileName);
        this.update((Object)this);
        return true;
    }

    public boolean setGeometry(PgGeometryIf geomNew) {
        this.m_geom = geomNew;
        return true;
    }

    public void setSaveAsGp(boolean saveAsGp) {
        this.m_saveAsGp = saveAsGp;
    }

    public boolean saveFile(String filename) {
        if (this.m_geom == null) {
            PsDebug.warning((String)"Missing geometry to save.");
            return false;
        }
        if (this.m_saveAsGp) {
            if (!(this.m_geom instanceof PgParamGeom)) {
                PsDebug.warning((String)"Geometry must be instance of PgParamGeom");
                return false;
            }
            PgGpLoader loader = new PgGpLoader();
            PgParamGeom[] geoms = new PgParamGeom[]{(PgParamGeom)this.m_geom};
            return loader.writeGeometries(geoms, filename);
        }
        PgLoader loader = new PgLoader();
        PgGeometryIf[] geoms = new PgGeometryIf[]{this.m_geom};
        return loader.saveGeometry(geoms, filename);
    }
}

