/*
 * Decompiled with CFR 0.152.
 */
package devParameterize.loader;

import devCovering.PgCovering;
import devCovering.PgFrameField;
import devParameterize.geom.PgParamGeom;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.StringTokenizer;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgVectorField;
import jv.number.PuDouble;
import jv.object.PsDebug;
import jv.object.PsUtil;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuVectorGeom;

public class PgNdfLoader {
    protected int m_numElements;
    private int m_numTags;
    private String m_keyString;
    private int m_lineNo;

    private void error(String errorMsg) {
        PsDebug.warning((String)("Error in line " + this.m_lineNo + ": " + errorMsg));
    }

    private boolean parseLine(String line) {
        if (!line.startsWith("#")) {
            return false;
        }
        int ind = line.indexOf(32);
        if (ind < 0 || line.length() <= ind - 1) {
            return false;
        }
        try {
            this.m_numTags = Integer.parseInt(line.substring(1, ind));
        }
        catch (NumberFormatException e) {
            return false;
        }
        this.m_keyString = line.substring(ind + 1);
        return true;
    }

    private String readLine(BufferedReader in) throws IOException {
        String line;
        do {
            ++this.m_lineNo;
            line = in.readLine();
            if (line != null) continue;
            return null;
        } while ((line = line.trim()).length() == 0 || line.startsWith("//"));
        return line;
    }

    private boolean parseGeometry(BufferedReader in, int numTags, PgParamGeom geom) throws IOException {
        int noe = geom.getNumElements();
        String line = this.readLine(in);
        int tag = 0;
        while (tag < numTags) {
            if (line == null) {
                PgVectorField field = (PgVectorField)geom.getFrameField().getField(0).clone();
                field.setGeometry((PgPointSet)geom);
                geom.setSparseField(field);
                PdVector trustWeight = new PdVector(noe);
                trustWeight.setConstant(1.0);
                geom.setTrustWeights(trustWeight);
                geom.getFrameField().setCovering(geom.getCovering());
                return false;
            }
            if (this.parseLine(line)) {
                if (this.m_keyString.equals("param_field")) {
                    PgFrameField fField;
                    PgVectorField field_0 = new PgVectorField(3, 1);
                    PgVectorField field_1 = new PgVectorField(3, 1);
                    field_0.setGeometry((PgPointSet)geom);
                    field_1.setGeometry((PgPointSet)geom);
                    PdVector[] vertex = geom.getVertices();
                    PiVector[] elt = geom.getElements();
                    PdVector[] normal = geom.getElementNormals();
                    line = this.readLine(in);
                    if (line == null) {
                        this.error("vector expected");
                        return false;
                    }
                    int elt_ind = -1;
                    int i = 0;
                    while (i < noe) {
                        StringTokenizer t = new StringTokenizer(line);
                        if (!line.contains("#")) {
                            elt_ind = Integer.parseInt(t.nextToken());
                        }
                        if (i == elt_ind) {
                            PdVector v0 = vertex[elt[i].m_data[1]];
                            PdVector v1 = vertex[elt[i].m_data[2]];
                            PdVector diff = PdVector.subNew((PdVector)v1, (PdVector)v0);
                            diff.normalize();
                            try {
                                PuVectorGeom.rotatePointAroundVector((PdVector)field_0.getVector(i), (PdVector)diff, (PdVector)normal[i], (double)PuDouble.parseDouble((String)t.nextToken()));
                                PuVectorGeom.rotatePointAroundVector((PdVector)field_1.getVector(i), (PdVector)diff, (PdVector)normal[i], (double)PuDouble.parseDouble((String)t.nextToken()));
                            }
                            catch (NumberFormatException f) {
                                this.error("not a number: " + f.getMessage());
                                return false;
                            }
                            line = this.readLine(in);
                            if (line == null) {
                                this.error("vector expected");
                                return false;
                            }
                        } else {
                            field_0.getVector(i).setConstant(0.0);
                            field_1.getVector(i).setConstant(0.0);
                        }
                        ++i;
                    }
                    if (geom.getFrameField() == null) {
                        fField = new PgFrameField(geom.getCovering());
                        fField.setField(0, field_0);
                        fField.setField(1, field_1);
                        geom.setFrameField(fField);
                    } else {
                        fField = geom.getFrameField();
                        int i2 = 0;
                        while (i2 < noe) {
                            if (Math.abs(field_0.getVector(i2).length()) > 1.0E-10) {
                                fField.getField(0).setVector(i2, field_0.getVector(i2));
                                fField.getField(1).setVector(i2, field_1.getVector(i2));
                            }
                            ++i2;
                        }
                        geom.setFrameField(fField);
                    }
                } else if (this.m_keyString.equals("scale_factor")) {
                    line = this.readLine(in);
                    if (line == null) {
                        this.error("vector expected");
                        return false;
                    }
                    int elt_ind = -1;
                    int i = 0;
                    while (i < noe) {
                        StringTokenizer t = new StringTokenizer(line);
                        if (!line.contains("#")) {
                            elt_ind = Integer.parseInt(t.nextToken());
                        }
                        if (i == elt_ind) {
                            try {
                                geom.getFrameField().getField(0).getVector(i).multScalar(1.0 + PuDouble.parseDouble((String)t.nextToken()));
                                geom.getFrameField().getField(1).getVector(i).multScalar(1.0 + PuDouble.parseDouble((String)t.nextToken()));
                            }
                            catch (NumberFormatException f) {
                                this.error("not a number: " + f.getMessage());
                                return false;
                            }
                            line = this.readLine(in);
                            if (line == null) {
                                this.error("vector expected");
                                return false;
                            }
                        }
                        ++i;
                    }
                } else if (this.m_keyString.equals("covering")) {
                    PgCovering covering = new PgCovering((PgElementSet)geom, 0);
                    if (!this.parseCovering(in, this.m_numTags, covering)) {
                        return false;
                    }
                    line = this.readLine(in);
                    geom.setCovering(covering);
                }
            }
            ++tag;
        }
        return true;
    }

    private boolean parseCovering(BufferedReader in, int numTags, PgCovering covering) throws IOException {
        int tag = 0;
        while (tag < numTags) {
            String line = this.readLine(in);
            if (line == null) {
                this.error("Covering expected");
                return false;
            }
            if (this.parseLine(line)) {
                if (this.m_keyString.equals("matching")) {
                    int num = this.m_numTags;
                    PiVector[] matching = new PiVector[num];
                    int i = 0;
                    while (i < num) {
                        line = this.readLine(in);
                        if (line == null) {
                            this.error("matching expected");
                            return false;
                        }
                        StringTokenizer t = new StringTokenizer(line);
                        int dim = t.countTokens();
                        matching[i] = new PiVector(dim);
                        int j = 0;
                        while (j < dim) {
                            try {
                                matching[i].m_data[j] = Integer.parseInt(t.nextToken());
                            }
                            catch (NumberFormatException e) {
                                this.error("invalid matching: " + e.getMessage());
                                return false;
                            }
                            ++j;
                        }
                        ++i;
                    }
                    covering.setMatching(matching);
                } else if (!this.skip(in, this.m_numTags)) {
                    return false;
                }
            } else {
                if (line.startsWith("SymmetryOrder:")) {
                    try {
                        int symm = Integer.parseInt(line.substring(14).trim());
                        covering.setSymmetryOrder(symm);
                    }
                    catch (NumberFormatException e) {
                        this.error("invalid symmetry order: " + line.substring(14).trim());
                        return false;
                    }
                }
                if (line.startsWith("BranchPoints:")) {
                    StringTokenizer t = new StringTokenizer(line.substring(13));
                    int num = t.countTokens();
                    PiVector bp = new PiVector(num);
                    int i = 0;
                    while (i < num) {
                        try {
                            bp.m_data[i] = Integer.parseInt(t.nextToken());
                        }
                        catch (NumberFormatException e) {
                            this.error("invalid branch point: " + e.getMessage());
                            return false;
                        }
                        ++i;
                    }
                    covering.setBranchPoints(bp);
                } else if (line.startsWith("BranchTypes:")) {
                    StringTokenizer t = new StringTokenizer(line.substring(12));
                    int num = t.countTokens();
                    PiVector bp = new PiVector(num);
                    int i = 0;
                    while (i < num) {
                        try {
                            bp.m_data[i] = Integer.parseInt(t.nextToken());
                        }
                        catch (NumberFormatException e) {
                            this.error("invalid branch type: " + e.getMessage());
                            return false;
                        }
                        ++i;
                    }
                    covering.setBranchTypes(bp);
                }
            }
            ++tag;
        }
        return true;
    }

    private boolean skip(BufferedReader in, int numTags) throws IOException {
        int i = 0;
        while (i < numTags) {
            int num;
            String line = this.readLine(in);
            if (line == null) {
                this.error("tag expected");
                return false;
            }
            if (this.parseLine(line) && !this.skip(in, num = this.m_numTags)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean read(String fileName, PgParamGeom geom) throws IOException {
        this.readInformation(fileName, geom);
        return true;
    }

    public boolean readInformation(String fileName, PgParamGeom geom) throws IOException {
        BufferedReader in = PsUtil.open((String)fileName);
        if (in == null) {
            PsDebug.warning((String)("could not open = " + fileName));
            return false;
        }
        this.m_lineNo = 0;
        String line = this.readLine(in);
        while (!line.contains("Faces")) {
            line = this.readLine(in);
        }
        int numElements = Integer.parseInt(line.substring(6));
        while (!line.contains("Singularities")) {
            line = this.readLine(in);
        }
        while (!line.equals("[Pjumps]")) {
            line = this.readLine(in);
        }
        line = this.readLine(in);
        String jumps = line.substring(7);
        String[] jumpArray = jumps.split(";");
        jumpArray[0] = jumpArray[0].substring(1);
        int numEdge = jumpArray.length - 1;
        int numGeomEdge = geom.getNumEdges();
        if (numEdge != numGeomEdge) {
            PsDebug.warning((String)"Number of edges does not agree");
        }
        PiVector[] element = geom.getElements();
        PiVector[] neighbor = geom.getNeighbours();
        boolean[] checked = new boolean[numElements];
        PiVector[] matching = new PiVector[numElements];
        PiVector.realloc((PiVector[])matching, (int)numElements, (int)3);
        int index = 0;
        int i = 0;
        while (i < numElements) {
            int j = 0;
            while (j < 3) {
                if (!checked[neighbor[i].m_data[(j + 2) % 3]]) {
                    matching[i].m_data[(j + 2) % 3] = -Integer.parseInt(jumpArray[index]);
                    matching[neighbor[i].m_data[(j + 2) % 3]].m_data[geom.getOppVertexLocInd((int)i, (int)((j + 2) % 3))] = -matching[i].m_data[(j + 2) % 3];
                    ++index;
                }
                ++j;
            }
            checked[i] = true;
            ++i;
        }
        PgVectorField field_0 = new PgVectorField(3, 1);
        PgVectorField field_1 = new PgVectorField(3, 1);
        PgVectorField field_2 = new PgVectorField(3, 1);
        PgVectorField field_3 = new PgVectorField(3, 1);
        field_0.setGeometry((PgPointSet)geom);
        field_1.setGeometry((PgPointSet)geom);
        field_2.setGeometry((PgPointSet)geom);
        field_3.setGeometry((PgPointSet)geom);
        while (!line.equals("[Theta]")) {
            line = this.readLine(in);
        }
        line = this.readLine(in);
        String angle = line.substring(8);
        String[] angleArray = angle.split(";");
        PdVector[] vertex = geom.getVertices();
        PdVector[] normal = geom.getElementNormals();
        int i2 = 0;
        while (i2 < numElements) {
            int indv0 = element[i2].m_data[0];
            int indv1 = element[i2].m_data[2];
            PdVector v0 = vertex[indv0];
            PdVector v1 = vertex[indv1];
            PdVector diff = PdVector.subNew((PdVector)v1, (PdVector)v0);
            diff.normalize();
            PuVectorGeom.rotatePointAroundVector((PdVector)field_0.getVector(i2), (PdVector)diff, (PdVector)normal[i2], (double)PuDouble.parseDouble((String)angleArray[i2]));
            PuVectorGeom.rotatePointAroundVector((PdVector)field_1.getVector(i2), (PdVector)diff, (PdVector)normal[i2], (double)(PuDouble.parseDouble((String)angleArray[i2]) + 1.5707963267948966));
            ++i2;
        }
        checked = new boolean[numElements];
        int[] processed = new int[numElements];
        checked[0] = true;
        processed[0] = 0;
        PgFrameField fField = new PgFrameField(geom.getCovering());
        fField.setField(0, field_0);
        fField.setField(1, field_1);
        geom.setFrameField(fField);
        while (!line.equals("[Singularities]")) {
            line = this.readLine(in);
        }
        line = this.readLine(in);
        String bp = line.substring(9);
        String[] bpArray = bp.split(";");
        int numSing = bpArray.length - 1;
        PiVector sing = new PiVector(numSing);
        int i3 = 0;
        while (i3 < numSing) {
            sing.m_data[i3] = Integer.parseInt(bpArray[i3]);
            ++i3;
        }
        line = this.readLine(in);
        bp = line.substring(15);
        bpArray = bp.split(";");
        PiVector bpType = new PiVector(numSing);
        int i4 = 0;
        while (i4 < numSing) {
            bpType.m_data[i4] = (Integer.parseInt(bpArray[i4]) + 4) % 4;
            ++i4;
        }
        PgCovering covering = new PgCovering((PgElementSet)geom, 0);
        geom.setCovering(covering);
        covering.setMatching(matching);
        covering.setSymmetryOrder(4);
        covering.setBranchPoints(sing);
        covering.setBranchTypes(bpType);
        return true;
    }
}

