/*
 * Decompiled with CFR 0.152.
 */
package devParameterize.loader;

import devCovering.PgCovering;
import devCovering.PgFrameField;
import devCovering.PgPathOnCovering;
import devGraph.PgGraphOnElementSet;
import devParameterize.geom.PgParamGeom;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.StringTokenizer;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgVectorField;
import jv.number.PuDouble;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.geom.PgVertexStar;
import jvx.vector.PwVectorField;

public class PgGpLoader {
    private int m_numTags;
    private String m_keyString;
    private int m_lineNo;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PgParamGeom[] loadGeometries(String filename) {
        try {
            BufferedReader in = new BufferedReader(new FileReader(filename));
            this.m_lineNo = 0;
            String line = this.readLine(in);
            if (line == null || !this.parseLine(line) || !this.m_keyString.equals("geometries")) {
                this.error("geometries tag expected");
                return null;
            }
            int numGeometries = this.m_numTags;
            PgParamGeom[] geoms = new PgParamGeom[numGeometries];
            int i = 0;
            while (true) {
                if (i >= numGeometries) {
                    in.close();
                    return geoms;
                }
                line = this.readLine(in);
                if (line == null || !this.parseLine(line) || !this.m_keyString.equals("elementset")) {
                    this.error("geometry tag expected");
                    return null;
                }
                geoms[i] = new PgParamGeom();
                if (!this.parseGeometry(in, this.m_numTags, geoms[i])) {
                    return null;
                }
                ++i;
            }
        }
        catch (IOException e) {
            PsDebug.warning((String)("I/O error: " + e.getMessage()));
            return null;
        }
    }

    private boolean parseGeometry(BufferedReader in, int numTags, PgParamGeom geom) throws IOException {
        geom.showEdges(false);
        PiVector[] paths = null;
        int tag = 0;
        while (tag < numTags) {
            String line = this.readLine(in);
            if (line == null) {
                this.error("Geometry expected");
                return false;
            }
            if (this.parseLine(line)) {
                int i;
                if (this.m_keyString.equals("vertices")) {
                    int numV = this.m_numTags;
                    geom.setNumVertices(numV);
                    int v = 0;
                    while (v < numV) {
                        line = this.readLine(in);
                        if (line == null) {
                            this.error("vertex expected");
                            return false;
                        }
                        StringTokenizer t = new StringTokenizer(line);
                        int dim = t.countTokens();
                        PdVector vertex = new PdVector(dim);
                        i = 0;
                        while (i < dim) {
                            try {
                                vertex.m_data[i] = PuDouble.parseDouble((String)t.nextToken());
                            }
                            catch (NumberFormatException e) {
                                this.error("Invalid vertex format");
                                return false;
                            }
                            ++i;
                        }
                        geom.setVertex(v, vertex);
                        ++v;
                    }
                } else if (this.m_keyString.equals("elements")) {
                    int numE = this.m_numTags;
                    geom.setNumElements(numE);
                    int e = 0;
                    while (e < numE) {
                        line = this.readLine(in);
                        if (line == null) {
                            this.error("element expected");
                            return false;
                        }
                        StringTokenizer t = new StringTokenizer(line);
                        int dim = t.countTokens();
                        PiVector element = new PiVector(dim);
                        i = 0;
                        while (i < dim) {
                            try {
                                element.m_data[i] = Integer.parseInt(t.nextToken());
                            }
                            catch (NumberFormatException f) {
                                this.error("Invalid element format");
                                return false;
                            }
                            ++i;
                        }
                        geom.setElement(e, element);
                        ++e;
                    }
                } else if (this.m_keyString.equals("param_textures")) {
                    int numE = this.m_numTags;
                    PdVector[][] tex = new PdVector[numE][];
                    int e = 0;
                    while (e < numE) {
                        line = this.readLine(in);
                        if (line == null) {
                            this.error("element expected");
                            return false;
                        }
                        StringTokenizer t = new StringTokenizer(line);
                        int dim = t.countTokens();
                        if (dim % 2 != 0) {
                            PsDebug.warning((String)"Texture size must be even");
                            return false;
                        }
                        tex[e] = PdVector.realloc(null, (int)(dim / 2), (int)2);
                        i = 0;
                        while (i < dim / 2) {
                            try {
                                tex[e][i].m_data[0] = PuDouble.parseDouble((String)t.nextToken());
                                tex[e][i].m_data[1] = PuDouble.parseDouble((String)t.nextToken());
                            }
                            catch (NumberFormatException f) {
                                this.error("Invalid texture format");
                                return false;
                            }
                            ++i;
                        }
                        ++e;
                    }
                    geom.setParamTexture(tex);
                } else if (this.m_keyString.equals("param_discoTextures")) {
                    int numE = this.m_numTags;
                    PdVector[][] tex = new PdVector[numE][];
                    int e = 0;
                    while (e < numE) {
                        line = this.readLine(in);
                        if (line == null) {
                            this.error("element expected");
                            return false;
                        }
                        StringTokenizer t = new StringTokenizer(line);
                        int dim = t.countTokens();
                        if (dim % 2 != 0) {
                            PsDebug.warning((String)"Texture size must be even");
                            return false;
                        }
                        tex[e] = PdVector.realloc(null, (int)(dim / 2), (int)2);
                        i = 0;
                        while (i < dim / 2) {
                            try {
                                tex[e][i].m_data[0] = PuDouble.parseDouble((String)t.nextToken());
                                tex[e][i].m_data[1] = PuDouble.parseDouble((String)t.nextToken());
                            }
                            catch (NumberFormatException f) {
                                this.error("Invalid texture format");
                                return false;
                            }
                            ++i;
                        }
                        ++e;
                    }
                    geom.setDiscontinuousTexture(tex);
                } else if (this.m_keyString.equals("covering")) {
                    PgCovering covering = new PgCovering((PgElementSet)geom, 0);
                    if (!this.parseCovering(in, this.m_numTags, covering)) {
                        return false;
                    }
                    geom.setCovering(covering);
                } else if (this.m_keyString.equals("param_sparseField")) {
                    int num = this.m_numTags;
                    PgVectorField field = new PgVectorField(3, 1);
                    field.setGeometry((PgPointSet)geom);
                    int e = 0;
                    while (e < num) {
                        line = this.readLine(in);
                        if (line == null) {
                            this.error("sparse field expected");
                            return false;
                        }
                        StringTokenizer t = new StringTokenizer(line);
                        if (t.countTokens() != 3) {
                            PsDebug.warning((String)"vector of dimension 3 expected");
                            return false;
                        }
                        try {
                            int i2 = 0;
                            while (i2 < 3) {
                                field.getVector((int)e).m_data[i2] = PuDouble.parseDouble((String)t.nextToken());
                                ++i2;
                            }
                        }
                        catch (NumberFormatException f) {
                            this.error("not a number: " + f.getMessage());
                            return false;
                        }
                        ++e;
                    }
                    field.setName("Sparse Field");
                    geom.setSparseField(field);
                } else if (this.m_keyString.equals("param_field")) {
                    int num = this.m_numTags;
                    PgVectorField field = new PgVectorField(3, 1);
                    field.setGeometry((PgPointSet)geom);
                    int e = 0;
                    while (e < num) {
                        line = this.readLine(in);
                        if (line == null) {
                            this.error("vector expected");
                            return false;
                        }
                        StringTokenizer t = new StringTokenizer(line);
                        if (t.countTokens() != 3) {
                            PsDebug.warning((String)"vector of dimension 3 expected");
                            return false;
                        }
                        try {
                            int i3 = 0;
                            while (i3 < 3) {
                                field.getVector((int)e).m_data[i3] = PuDouble.parseDouble((String)t.nextToken());
                                ++i3;
                            }
                        }
                        catch (NumberFormatException f) {
                            this.error("not a number: " + f.getMessage());
                            return false;
                        }
                        ++e;
                    }
                    field.setName("Field0");
                    PgFrameField fField = new PgFrameField(geom.getCovering());
                    fField.setField(0, field);
                    PgVectorField rotField = new PgVectorField(3, 1);
                    rotField.setGeometry((PgPointSet)geom);
                    rotField.setName("Field1");
                    rotField.copy((PsObject)field);
                    PwVectorField.rotateVectorField((PgVectorField)rotField);
                    fField.setField(1, rotField);
                    geom.setFrameField(fField);
                } else if (this.m_keyString.equals("param_curvatureValues")) {
                    int num = this.m_numTags;
                    PdVector[] cValues = new PdVector[num];
                    int e = 0;
                    while (e < num) {
                        line = this.readLine(in);
                        if (line == null) {
                            this.error("vector expected");
                            return false;
                        }
                        StringTokenizer t = new StringTokenizer(line);
                        if (t.countTokens() != 2) {
                            PsDebug.warning((String)("vector of dimension 2 expected (found vector of size " + t.countTokens() + ")"));
                            return false;
                        }
                        try {
                            cValues[e] = new PdVector(2);
                            int i4 = 0;
                            while (i4 < 2) {
                                cValues[e].m_data[i4] = PuDouble.parseDouble((String)t.nextToken());
                                ++i4;
                            }
                        }
                        catch (NumberFormatException f) {
                            this.error("not a number: " + f.getMessage());
                            return false;
                        }
                        ++e;
                    }
                    geom.setCurvatureValues(cValues);
                } else if (this.m_keyString.equals("param_curvatureField")) {
                    int num = this.m_numTags;
                    PgVectorField field = new PgVectorField(3, 1);
                    field.setGeometry((PgPointSet)geom);
                    int e = 0;
                    while (e < num) {
                        line = this.readLine(in);
                        if (line == null) {
                            this.error("vector expected");
                            return false;
                        }
                        StringTokenizer t = new StringTokenizer(line);
                        if (t.countTokens() != 3) {
                            PsDebug.warning((String)"vector of dimension 3 expected");
                            return false;
                        }
                        try {
                            int i5 = 0;
                            while (i5 < 3) {
                                field.getVector((int)e).m_data[i5] = PuDouble.parseDouble((String)t.nextToken());
                                ++i5;
                            }
                        }
                        catch (NumberFormatException f) {
                            this.error("not a number: " + f.getMessage());
                            return false;
                        }
                        ++e;
                    }
                    field.setName("curvature field");
                    geom.setCurvatureVectorField(field);
                } else if (this.m_keyString.equals("param_elementTree")) {
                    int num = this.m_numTags;
                    PgGraphOnElementSet graph = new PgGraphOnElementSet((PgElementSet)geom, 1);
                    int i6 = 0;
                    while (i6 < num) {
                        PiVector n;
                        line = this.readLine(in);
                        if (line == null) {
                            this.error("element tree expected");
                            return false;
                        }
                        if (line.startsWith("-")) {
                            n = new PiVector(0);
                        } else {
                            StringTokenizer t = new StringTokenizer(line);
                            int dim = t.countTokens();
                            n = new PiVector(dim);
                            try {
                                int j = 0;
                                while (j < dim) {
                                    n.m_data[j] = Integer.parseInt(t.nextToken());
                                    ++j;
                                }
                            }
                            catch (NumberFormatException e) {
                                this.error("invalid number: " + e.getMessage());
                                return false;
                            }
                        }
                        graph.setNeighbours(i6, n);
                        ++i6;
                    }
                    geom.setElementTree(graph);
                } else if (this.m_keyString.equals("param_cutPaths")) {
                    int num = this.m_numTags;
                    paths = new PiVector[num];
                    int i7 = 0;
                    while (i7 < num) {
                        line = this.readLine(in);
                        if (line == null) {
                            this.error("cut path expected");
                            return false;
                        }
                        StringTokenizer t = new StringTokenizer(line);
                        int size = t.countTokens();
                        paths[i7] = new PiVector(size);
                        try {
                            int j = 0;
                            while (j < size) {
                                paths[i7].m_data[j] = Integer.parseInt(t.nextToken());
                                ++j;
                            }
                        }
                        catch (NumberFormatException e) {
                            this.error("invalid number: " + e.getMessage());
                            return false;
                        }
                        ++i7;
                    }
                } else if (!this.skip(in, this.m_numTags)) {
                    return false;
                }
            } else if (line.startsWith("Name: ")) {
                String name = line.substring(6);
                geom.setName(name);
            } else {
                if (line.startsWith("param_frameScaleFactor:")) {
                    try {
                        geom.setFrameScaleFactor(PuDouble.parseDouble((String)line.substring(23)));
                    }
                    catch (NumberFormatException e) {
                        this.error("invalid frame scale factor: " + e.getMessage());
                        return false;
                    }
                }
                if (line.startsWith("param_trustWeights:")) {
                    StringTokenizer t = new StringTokenizer(line.substring(19));
                    int num = t.countTokens();
                    PdVector trustWeights = new PdVector(num);
                    try {
                        int i = 0;
                        while (i < num) {
                            trustWeights.m_data[i] = PuDouble.parseDouble((String)t.nextToken());
                            ++i;
                        }
                    }
                    catch (NumberFormatException e) {
                        this.error("invalid trust weight: " + e.getMessage());
                        return false;
                    }
                    geom.setTrustWeights(trustWeights);
                } else if (line.startsWith("param_gaps:")) {
                    StringTokenizer t = new StringTokenizer(line.substring(11));
                    int num = t.countTokens();
                    PdVector gaps = new PdVector(num);
                    try {
                        int i = 0;
                        while (i < num) {
                            gaps.m_data[i] = PuDouble.parseDouble((String)t.nextToken());
                            ++i;
                        }
                    }
                    catch (NumberFormatException e) {
                        this.error("invalid number: " + e.getMessage());
                        return false;
                    }
                    geom.setGaps(gaps);
                } else if (line.startsWith("param_bridges:")) {
                    StringTokenizer t = new StringTokenizer(line.substring(14));
                    int num = t.countTokens();
                    PiVector bridges = new PiVector(num);
                    try {
                        int i = 0;
                        while (i < num) {
                            bridges.m_data[i] = Integer.parseInt(t.nextToken());
                            ++i;
                        }
                    }
                    catch (NumberFormatException e) {
                        this.error("invalid number: " + e.getMessage());
                        return false;
                    }
                    geom.setBridges(bridges);
                }
            }
            ++tag;
        }
        geom.makeElementNormals();
        geom.makeNeighbour();
        if (paths != null) {
            int num = paths.length;
            geom.allocateEdgeStars();
            PgPathOnCovering[] cutPaths = new PgPathOnCovering[num];
            PiVector elementPerVertex = PgVertexStar.getElementPerVertex((PgElementSet)geom);
            int i = 0;
            while (i < num) {
                cutPaths[i] = new PgPathOnCovering(geom.getDimOfVertices());
                cutPaths[i].setGeometry((PgElementSet)geom, geom.getCovering());
                cutPaths[i].makePath((PiVector)paths[i], elementPerVertex);
                ++i;
            }
            geom.setCutPaths(cutPaths);
        }
        return true;
    }

    private boolean skip(BufferedReader in, int numTags) throws IOException {
        int i = 0;
        while (i < numTags) {
            int num;
            String line = this.readLine(in);
            if (line == null) {
                this.error("tag expected");
                return false;
            }
            if (this.parseLine(line) && !this.skip(in, num = this.m_numTags)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void error(String errorMsg) {
        PsDebug.warning((String)("Error in line " + this.m_lineNo + ": " + errorMsg));
    }

    private boolean parseLine(String line) {
        if (!line.startsWith("#")) {
            return false;
        }
        int ind = line.indexOf(32);
        if (ind < 0 || line.length() <= ind - 1) {
            return false;
        }
        try {
            this.m_numTags = Integer.parseInt(line.substring(1, ind));
        }
        catch (NumberFormatException e) {
            return false;
        }
        this.m_keyString = line.substring(ind + 1);
        return true;
    }

    private String readLine(BufferedReader in) throws IOException {
        String line;
        do {
            ++this.m_lineNo;
            line = in.readLine();
            if (line != null) continue;
            return null;
        } while ((line = line.trim()).length() == 0 || line.startsWith("//"));
        return line;
    }

    public boolean writeGeometries(PgParamGeom[] geomArr, String filename) {
        if (geomArr == null || geomArr.length == 0 || geomArr[0] == null) {
            PsDebug.warning((String)"missing geometry");
            return false;
        }
        try {
            FileWriter writer = new FileWriter(filename);
            writer.write("// GP geometry and parameterization file\n");
            writer.write("// File format by Matthias Nieser and Ulrich Reitebuch (2010)\n\n");
            int numGeometries = geomArr.length;
            writer.write("#" + numGeometries + " geometries\n\n");
            int g = 0;
            while (g < numGeometries) {
                this.writeGeometry(writer, geomArr[g]);
                ++g;
            }
            writer.close();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    private void writeGeometry(Writer writer, PgParamGeom geom) throws IOException {
        int d;
        int i;
        int dim;
        int e;
        PdVector[][] tex;
        int i2;
        int dim2;
        int numE;
        PiVector[] elements;
        int num = 0;
        ++num;
        if (geom.getVertices() != null) {
            ++num;
        }
        if (geom.getElements() != null) {
            ++num;
        }
        if (geom.getParamTexture() != null) {
            ++num;
        }
        if (geom.getDiscontinuousTexture() != null) {
            ++num;
        }
        if (geom.getCovering() != null) {
            ++num;
        }
        if (!Double.isNaN(geom.getFrameScaleFactor())) {
            ++num;
        }
        if (geom.getSparseField() != null) {
            ++num;
        }
        if (geom.getFrameField() != null) {
            ++num;
        }
        if (geom.getTrustWeights() != null) {
            ++num;
        }
        if (geom.getElementTree() != null) {
            ++num;
        }
        if (geom.getGaps() != null) {
            ++num;
        }
        if (geom.getBridges() != null) {
            ++num;
        }
        if (geom.getCutPaths() != null) {
            ++num;
        }
        if (geom.getCurvatureVectorField() != null) {
            ++num;
        }
        if (geom.getCurvatureValues() != null) {
            ++num;
        }
        writer.write("#" + num + " elementset\n");
        writer.write("Name: " + geom.getName() + "\n");
        writer.write(10);
        PdVector[] vertices = geom.getVertices();
        if (vertices != null) {
            int numV = vertices.length;
            writer.write("#" + numV + " vertices\n");
            int v = 0;
            while (v < numV) {
                PdVector vertex = vertices[v];
                int dim3 = vertex.getSize();
                int i3 = 0;
                while (i3 < dim3) {
                    writer.write(String.valueOf(i3 > 0 ? " " : "") + vertex.m_data[i3]);
                    ++i3;
                }
                writer.write(10);
                ++v;
            }
            writer.write(10);
        }
        if ((elements = geom.getElements()) != null) {
            numE = elements.length;
            writer.write("#" + numE + " elements\n");
            int e2 = 0;
            while (e2 < numE) {
                PiVector element = elements[e2];
                dim2 = element.getSize();
                i2 = 0;
                while (i2 < dim2) {
                    writer.write(String.valueOf(i2 > 0 ? " " : "") + element.m_data[i2]);
                    ++i2;
                }
                writer.write(10);
                ++e2;
            }
            writer.write(10);
        }
        numE = geom.getNumElements();
        if (geom.getParamTexture() != null) {
            tex = geom.getParamTexture();
            writer.write("#" + numE + " param_textures\n");
            e = 0;
            while (e < numE) {
                dim2 = tex[e] == null ? 0 : tex[e].length;
                i2 = 0;
                while (i2 < dim2) {
                    writer.write(String.valueOf(i2 > 0 ? " " : "") + tex[e][i2].m_data[0] + " " + tex[e][i2].m_data[1]);
                    ++i2;
                }
                writer.write("\n");
                ++e;
            }
            writer.write("\n");
        }
        if (geom.getDiscontinuousTexture() != null) {
            tex = geom.getDiscontinuousTexture();
            writer.write("#" + numE + " param_discoTextures\n");
            e = 0;
            while (e < numE) {
                dim2 = tex[e] == null ? 0 : tex[e].length;
                i2 = 0;
                while (i2 < dim2) {
                    writer.write(String.valueOf(i2 > 0 ? " " : "") + tex[e][i2].m_data[0] + " " + tex[e][i2].m_data[1]);
                    ++i2;
                }
                writer.write("\n");
                ++e;
            }
            writer.write("\n");
        }
        if (geom.getCovering() != null) {
            this.writeCovering(writer, geom.getCovering());
        }
        if (!Double.isNaN(geom.getFrameScaleFactor())) {
            writer.write("param_frameScaleFactor: " + geom.getFrameScaleFactor() + "\n");
        }
        if (geom.getSparseField() != null) {
            int numV = geom.getSparseField().getNumVectors();
            writer.write("#" + numV + " param_sparseField\n");
            int v = 0;
            while (v < numV) {
                PdVector vec = geom.getSparseField().getVector(v);
                int dim4 = vec.getSize();
                int i4 = 0;
                while (i4 < dim4) {
                    writer.write(String.valueOf(i4 > 0 ? " " : "") + vec.m_data[i4]);
                    ++i4;
                }
                writer.write("\n");
                ++v;
            }
            writer.write("\n");
        }
        if (geom.getFrameField() != null) {
            PgVectorField field = geom.getFrameField().getField(0);
            int numV = field.getNumVectors();
            writer.write("#" + numV + " param_field\n");
            int v = 0;
            while (v < numV) {
                PdVector vec = field.getVector(v);
                dim = vec.getSize();
                int i5 = 0;
                while (i5 < dim) {
                    writer.write(String.valueOf(i5 > 0 ? " " : "") + vec.m_data[i5]);
                    ++i5;
                }
                writer.write("\n");
                ++v;
            }
            writer.write("\n");
        }
        if (geom.getTrustWeights() != null) {
            int size = geom.getTrustWeights().getSize();
            writer.write("param_trustWeights: ");
            i = 0;
            while (i < size) {
                writer.write(String.valueOf(i > 0 ? " " : "") + geom.getTrustWeights().m_data[i]);
                ++i;
            }
            writer.write("\n");
        }
        if (geom.getElementTree() != null) {
            PiVector[] neighb = geom.getElementTree().getNeighbours();
            int size = neighb == null ? 0 : neighb.length;
            writer.write("#" + size + " param_elementTree\n");
            int i6 = 0;
            while (i6 < size) {
                PiVector n = neighb[i6];
                dim = n.getSize();
                if (dim == 0) {
                    writer.write("-");
                } else {
                    int j = 0;
                    while (j < dim) {
                        writer.write(String.valueOf(j > 0 ? " " : "") + n.m_data[j]);
                        ++j;
                    }
                }
                writer.write("\n");
                ++i6;
            }
            writer.write("\n");
        }
        if (geom.getCutPaths() != null) {
            int numPaths = geom.getCutPaths().length;
            writer.write("#" + numPaths + " param_cutPaths\n");
            i = 0;
            while (i < numPaths) {
                if (geom.getCutPaths()[i] == null) {
                    writer.write("null\n");
                    PsDebug.warning((String)("Path " + i + " is null."));
                } else {
                    PiVector vert = geom.getCutPaths()[i].getVertexIndices();
                    int dim5 = vert.getSize();
                    int j = 0;
                    while (j < dim5) {
                        writer.write(String.valueOf(j > 0 ? " " : "") + vert.m_data[j]);
                        ++j;
                    }
                    writer.write("\n");
                }
                ++i;
            }
            writer.write("\n");
        }
        if (geom.getGaps() != null) {
            writer.write("param_gaps: ");
            int size = geom.getGaps() == null ? 0 : geom.getGaps().getSize();
            i = 0;
            while (i < size) {
                writer.write(String.valueOf(i > 0 ? " " : "") + geom.getGaps().m_data[i]);
                ++i;
            }
            writer.write("\n\n");
        }
        if (geom.getBridges() != null) {
            writer.write("param_bridges: ");
            int size = geom.getBridges() == null ? 0 : geom.getBridges().getSize();
            i = 0;
            while (i < size) {
                writer.write(String.valueOf(i > 0 ? " " : "") + geom.getBridges().m_data[i]);
                ++i;
            }
            writer.write("\n\n");
        }
        if (geom.getCurvatureValues() != null) {
            writer.write("#" + geom.getCurvatureValues().length + " param_curvatureValues\n");
            if (geom.getNumElements() != geom.getCurvatureValues().length) {
                PsDebug.warning((String)"Illegal number of curvature values.");
            }
            int i7 = 0;
            while (i7 < geom.getCurvatureValues().length) {
                d = 0;
                while (d < geom.getCurvatureValues()[i7].getSize()) {
                    writer.write(String.valueOf(d > 0 ? " " : "") + geom.getCurvatureValues()[i7].m_data[d]);
                    ++d;
                }
                writer.write("\n");
                ++i7;
            }
            writer.write("\n\n");
        }
        if (geom.getCurvatureVectorField() != null) {
            writer.write("#" + geom.getCurvatureVectorField().getNumVectors() + " param_curvatureField\n");
            if (geom.getNumElements() != geom.getCurvatureVectorField().getNumVectors()) {
                PsDebug.warning((String)"Illegal number of curvature vectors.");
            }
            int i8 = 0;
            while (i8 < geom.getCurvatureVectorField().getNumVectors()) {
                d = 0;
                while (d < geom.getCurvatureVectorField().getDimOfVectors()) {
                    writer.write(String.valueOf(d > 0 ? " " : "") + geom.getCurvatureVectorField().getVector((int)i8).m_data[d]);
                    ++d;
                }
                writer.write("\n");
                ++i8;
            }
            writer.write("\n\n");
        }
    }

    private void writeCovering(Writer writer, PgCovering covering) throws IOException {
        int b;
        int num = 0;
        ++num;
        if (covering.getMatching() != null) {
            ++num;
        }
        if (covering.getBranchPoints() != null) {
            ++num;
        }
        if (covering.getBranchTypes() != null) {
            ++num;
        }
        writer.write("#" + num + " covering\n");
        writer.write("SymmetryOrder: " + covering.getSymmetryOrder() + "\n");
        if (covering.getBranchPoints() != null) {
            writer.write("BranchPoints: ");
            PiVector bp = covering.getBranchPoints();
            int numBp = bp == null ? 0 : bp.getSize();
            b = 0;
            while (b < numBp) {
                writer.write(String.valueOf(b > 0 ? " " : "") + bp.m_data[b]);
                ++b;
            }
            writer.write("\n");
        }
        if (covering.getBranchTypes() != null) {
            writer.write("BranchTypes: ");
            PiVector bt = covering.getBranchTypes();
            int numBt = bt == null ? 0 : bt.getSize();
            b = 0;
            while (b < numBt) {
                writer.write(String.valueOf(b > 0 ? " " : "") + bt.m_data[b]);
                ++b;
            }
            writer.write("\n");
        }
        if (covering.getMatching() != null) {
            PiVector[] m = covering.getMatching();
            int size = m == null ? 0 : m.length;
            writer.write("#" + size + " matching\n");
            int i = 0;
            while (i < size) {
                int dim = m[i].getSize();
                int j = 0;
                while (j < dim) {
                    writer.write(String.valueOf(j > 0 ? " " : "") + m[i].m_data[j]);
                    ++j;
                }
                writer.write("\n");
                ++i;
            }
        }
        writer.write("\n");
    }

    private boolean parseCovering(BufferedReader in, int numTags, PgCovering covering) throws IOException {
        int tag = 0;
        while (tag < numTags) {
            String line = this.readLine(in);
            if (line == null) {
                this.error("Covering expected");
                return false;
            }
            if (this.parseLine(line)) {
                if (this.m_keyString.equals("matching")) {
                    int num = this.m_numTags;
                    PiVector[] matching = new PiVector[num];
                    int i = 0;
                    while (i < num) {
                        line = this.readLine(in);
                        if (line == null) {
                            this.error("matching expected");
                            return false;
                        }
                        StringTokenizer t = new StringTokenizer(line);
                        int dim = t.countTokens();
                        matching[i] = new PiVector(dim);
                        int j = 0;
                        while (j < dim) {
                            try {
                                matching[i].m_data[j] = Integer.parseInt(t.nextToken());
                            }
                            catch (NumberFormatException e) {
                                this.error("invalid matching: " + e.getMessage());
                                return false;
                            }
                            ++j;
                        }
                        ++i;
                    }
                    covering.setMatching(matching);
                } else if (!this.skip(in, this.m_numTags)) {
                    return false;
                }
            } else {
                if (line.startsWith("SymmetryOrder:")) {
                    try {
                        int symm = Integer.parseInt(line.substring(14).trim());
                        covering.setSymmetryOrder(symm);
                    }
                    catch (NumberFormatException e) {
                        this.error("invalid symmetry order: " + line.substring(14).trim());
                        return false;
                    }
                }
                if (line.startsWith("BranchPoints:")) {
                    StringTokenizer t = new StringTokenizer(line.substring(13));
                    int num = t.countTokens();
                    PiVector bp = new PiVector(num);
                    int i = 0;
                    while (i < num) {
                        try {
                            bp.m_data[i] = Integer.parseInt(t.nextToken());
                        }
                        catch (NumberFormatException e) {
                            this.error("invalid branch point: " + e.getMessage());
                            return false;
                        }
                        ++i;
                    }
                    covering.setBranchPoints(bp);
                } else if (line.startsWith("BranchTypes:")) {
                    StringTokenizer t = new StringTokenizer(line.substring(12));
                    int num = t.countTokens();
                    PiVector bp = new PiVector(num);
                    int i = 0;
                    while (i < num) {
                        try {
                            bp.m_data[i] = Integer.parseInt(t.nextToken());
                        }
                        catch (NumberFormatException e) {
                            this.error("invalid branch type: " + e.getMessage());
                            return false;
                        }
                        ++i;
                    }
                    covering.setBranchTypes(bp);
                }
            }
            ++tag;
        }
        return true;
    }
}

