/*
 * Decompiled with CFR 0.152.
 */
package devParameterize.loader;

import devCovering.PgCovering;
import devCovering.PgFrameField;
import devParameterize.geom.PgParamGeom;
import java.io.BufferedReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.StringTokenizer;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgVectorField;
import jv.number.PuDouble;
import jv.number.PuString;
import jv.object.PsDebug;
import jv.object.PsUtil;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuVectorGeom;

public class PgFFLoader {
    protected int m_numElements;
    private int m_numTags;
    private String m_keyString;
    private int m_lineNo;

    public boolean saveFrameField(PgParamGeom geom, String fileName) {
        if (geom == null) {
            PsDebug.warning((String)"missing geometry controlPolygon to save.");
            return false;
        }
        if (fileName == null) {
            PsDebug.warning((String)"missing fileName");
            return false;
        }
        String ext = PsUtil.getFileExtension((String)fileName);
        if (PuString.isEmpty((String)ext)) {
            PsDebug.warning((String)"missing extension in file name.");
            return false;
        }
        ext = ext.toLowerCase();
        try {
            FileWriter writer = new FileWriter(fileName);
            writer.write("// Save frame field of the geometry with the corresponding matching and branch point\n");
            writer.write("// author: Faniry Razafindrazaka\n");
            this.writeGeometry(writer, geom);
            writer.close();
        }
        catch (IOException ex) {
            PsDebug.warning((String)"failed writing to outWriter,", (Object)ex);
        }
        return true;
    }

    private void writeGeometry(Writer writer, PgParamGeom geom) throws IOException {
        int num = 0;
        ++num;
        if (geom.getCovering() != null) {
            ++num;
        }
        if (!Double.isNaN(geom.getFrameScaleFactor())) {
            ++num;
        }
        if (geom.getFrameField() != null) {
            ++num;
        }
        writer.write("#" + num + " elementset\n");
        writer.write(10);
        if (geom.getFrameField() != null) {
            PdVector[] angleScale = PgFFLoader.computeAngleScale(geom);
            int numVec = angleScale.length;
            writer.write("#" + numVec + " param_field\n");
            int i = 0;
            while (i < numVec) {
                if (angleScale[i] != null) {
                    writer.write(String.valueOf(i) + " " + angleScale[i].m_data[0] + " " + angleScale[i].m_data[1] + "\n");
                }
                ++i;
            }
            writer.write("#" + numVec + " scale_factor\n");
            i = 0;
            while (i < numVec) {
                if (angleScale[i] != null) {
                    writer.write(String.valueOf(i) + " " + angleScale[i].m_data[2] + " " + angleScale[i].m_data[3] + "\n");
                }
                ++i;
            }
        }
        if (geom.getCovering() != null) {
            this.writeCovering(writer, geom.getCovering());
        }
    }

    private void writeCovering(Writer writer, PgCovering covering) throws IOException {
        int b;
        int num = 0;
        ++num;
        if (covering.getMatching() != null) {
            ++num;
        }
        if (covering.getBranchPoints() != null) {
            ++num;
        }
        if (covering.getBranchTypes() != null) {
            ++num;
        }
        writer.write("#" + num + " covering\n");
        writer.write("SymmetryOrder: " + covering.getSymmetryOrder() + "\n");
        if (covering.getBranchPoints() != null) {
            writer.write("BranchPoints: ");
            PiVector bp = covering.getBranchPoints();
            int numBp = bp == null ? 0 : bp.getSize();
            b = 0;
            while (b < numBp) {
                writer.write(String.valueOf(b > 0 ? " " : "") + bp.m_data[b]);
                ++b;
            }
            writer.write("\n");
        }
        if (covering.getBranchTypes() != null) {
            writer.write("BranchTypes: ");
            PiVector bt = covering.getBranchTypes();
            int numBt = bt == null ? 0 : bt.getSize();
            b = 0;
            while (b < numBt) {
                writer.write(String.valueOf(b > 0 ? " " : "") + bt.m_data[b]);
                ++b;
            }
            writer.write("\n");
        }
        if (covering.getMatching() != null) {
            PiVector[] m = covering.getMatching();
            int size = m == null ? 0 : m.length;
            writer.write("#" + size + " matching\n");
            int i = 0;
            while (i < size) {
                int dim = m[i].getSize();
                int j = 0;
                while (j < dim) {
                    writer.write(String.valueOf(j > 0 ? " " : "") + m[i].m_data[j]);
                    ++j;
                }
                writer.write("\n");
                ++i;
            }
        }
        writer.write("\n");
    }

    public static PdVector[] computeAngleScale(PgParamGeom geom) {
        PgFrameField ff = geom.getFrameField();
        int noe = geom.getNumElements();
        PdVector[] vertex = geom.getVertices();
        PiVector[] elt = geom.getElements();
        PdVector[] normal = geom.getElementNormals();
        PgVectorField[] field = ff.getFields();
        PdVector[] angle = new PdVector[noe];
        PdVector.realloc((PdVector[])angle, (int)noe, (int)4);
        int i = 0;
        while (i < noe) {
            PdVector v0 = vertex[elt[i].m_data[1]];
            PdVector v1 = vertex[elt[i].m_data[2]];
            PdVector diff = PdVector.subNew((PdVector)v1, (PdVector)v0);
            angle[i].m_data[0] = PdVector.angleWithOrientation((PdVector)diff, (PdVector)field[0].getVector(i), (PdVector)normal[i]);
            angle[i].m_data[1] = PdVector.angleWithOrientation((PdVector)diff, (PdVector)field[1].getVector(i), (PdVector)normal[i]);
            angle[i].m_data[2] = field[0].getVector(i).length() - 1.0;
            angle[i].m_data[3] = field[1].getVector(i).length() - 1.0;
            ++i;
        }
        boolean eltSelected = false;
        int i2 = 0;
        while (i2 < noe) {
            if (elt[i2].hasTag(1)) {
                eltSelected = true;
                break;
            }
            ++i2;
        }
        if (eltSelected) {
            i2 = 0;
            while (i2 < noe) {
                if (!elt[i2].hasTag(1)) {
                    angle[i2] = null;
                }
                ++i2;
            }
        }
        return angle;
    }

    private String readLine(BufferedReader in) throws IOException {
        String line;
        do {
            ++this.m_lineNo;
            line = in.readLine();
            if (line != null) continue;
            return null;
        } while ((line = line.trim()).length() == 0 || line.startsWith("//"));
        return line;
    }

    private boolean parseLine(String line) {
        if (!line.startsWith("#")) {
            return false;
        }
        int ind = line.indexOf(32);
        if (ind < 0 || line.length() <= ind - 1) {
            return false;
        }
        try {
            this.m_numTags = Integer.parseInt(line.substring(1, ind));
        }
        catch (NumberFormatException e) {
            return false;
        }
        this.m_keyString = line.substring(ind + 1);
        return true;
    }

    private void error(String errorMsg) {
        PsDebug.warning((String)("Error in line " + this.m_lineNo + ": " + errorMsg));
    }

    private boolean parseGeometry(BufferedReader in, int numTags, PgParamGeom geom) throws IOException {
        int noe = geom.getNumElements();
        String line = this.readLine(in);
        int tag = 0;
        while (tag < numTags) {
            if (line == null) {
                PgVectorField field = (PgVectorField)geom.getFrameField().getField(0).clone();
                field.setGeometry((PgPointSet)geom);
                geom.setSparseField(field);
                PdVector trustWeight = new PdVector(noe);
                trustWeight.setConstant(1.0);
                geom.setTrustWeights(trustWeight);
                geom.getFrameField().setCovering(geom.getCovering());
                return false;
            }
            if (this.parseLine(line)) {
                if (this.m_keyString.equals("param_field")) {
                    PgFrameField fField;
                    PgVectorField field_0 = new PgVectorField(3, 1);
                    PgVectorField field_1 = new PgVectorField(3, 1);
                    field_0.setGeometry((PgPointSet)geom);
                    field_1.setGeometry((PgPointSet)geom);
                    PdVector[] vertex = geom.getVertices();
                    PiVector[] elt = geom.getElements();
                    PdVector[] normal = geom.getElementNormals();
                    line = this.readLine(in);
                    if (line == null) {
                        this.error("vector expected");
                        return false;
                    }
                    int elt_ind = -1;
                    int i = 0;
                    while (i < noe) {
                        StringTokenizer t = new StringTokenizer(line);
                        if (!line.contains("#")) {
                            elt_ind = Integer.parseInt(t.nextToken());
                        }
                        if (i == elt_ind) {
                            PdVector v0 = vertex[elt[i].m_data[1]];
                            PdVector v1 = vertex[elt[i].m_data[2]];
                            PdVector diff = PdVector.subNew((PdVector)v1, (PdVector)v0);
                            diff.normalize();
                            try {
                                PuVectorGeom.rotatePointAroundVector((PdVector)field_0.getVector(i), (PdVector)diff, (PdVector)normal[i], (double)PuDouble.parseDouble((String)t.nextToken()));
                                PuVectorGeom.rotatePointAroundVector((PdVector)field_1.getVector(i), (PdVector)diff, (PdVector)normal[i], (double)PuDouble.parseDouble((String)t.nextToken()));
                            }
                            catch (NumberFormatException f) {
                                this.error("not a number: " + f.getMessage());
                                return false;
                            }
                            line = this.readLine(in);
                            if (line == null) {
                                this.error("vector expected");
                                return false;
                            }
                        } else {
                            field_0.getVector(i).setConstant(0.0);
                            field_1.getVector(i).setConstant(0.0);
                        }
                        ++i;
                    }
                    if (geom.getFrameField() == null) {
                        fField = new PgFrameField(geom.getCovering());
                        fField.setField(0, field_0);
                        fField.setField(1, field_1);
                        geom.setFrameField(fField);
                    } else {
                        fField = geom.getFrameField();
                        int i2 = 0;
                        while (i2 < noe) {
                            if (Math.abs(field_0.getVector(i2).length()) > 1.0E-10) {
                                fField.getField(0).setVector(i2, field_0.getVector(i2));
                                fField.getField(1).setVector(i2, field_1.getVector(i2));
                            }
                            ++i2;
                        }
                        geom.setFrameField(fField);
                    }
                } else if (this.m_keyString.equals("scale_factor")) {
                    line = this.readLine(in);
                    if (line == null) {
                        this.error("vector expected");
                        return false;
                    }
                    int elt_ind = -1;
                    int i = 0;
                    while (i < noe) {
                        StringTokenizer t = new StringTokenizer(line);
                        if (!line.contains("#")) {
                            elt_ind = Integer.parseInt(t.nextToken());
                        }
                        if (i == elt_ind) {
                            try {
                                geom.getFrameField().getField(0).getVector(i).multScalar(1.0 + PuDouble.parseDouble((String)t.nextToken()));
                                geom.getFrameField().getField(1).getVector(i).multScalar(1.0 + PuDouble.parseDouble((String)t.nextToken()));
                            }
                            catch (NumberFormatException f) {
                                this.error("not a number: " + f.getMessage());
                                return false;
                            }
                            line = this.readLine(in);
                            if (line == null) {
                                this.error("vector expected");
                                return false;
                            }
                        }
                        ++i;
                    }
                } else if (this.m_keyString.equals("covering")) {
                    PgCovering covering = new PgCovering((PgElementSet)geom, 0);
                    if (!this.parseCovering(in, this.m_numTags, covering)) {
                        return false;
                    }
                    line = this.readLine(in);
                    geom.setCovering(covering);
                }
            }
            ++tag;
        }
        return true;
    }

    private boolean parseCovering(BufferedReader in, int numTags, PgCovering covering) throws IOException {
        int tag = 0;
        while (tag < numTags) {
            String line = this.readLine(in);
            if (line == null) {
                this.error("Covering expected");
                return false;
            }
            if (this.parseLine(line)) {
                if (this.m_keyString.equals("matching")) {
                    int num = this.m_numTags;
                    PiVector[] matching = new PiVector[num];
                    int i = 0;
                    while (i < num) {
                        line = this.readLine(in);
                        if (line == null) {
                            this.error("matching expected");
                            return false;
                        }
                        StringTokenizer t = new StringTokenizer(line);
                        int dim = t.countTokens();
                        matching[i] = new PiVector(dim);
                        int j = 0;
                        while (j < dim) {
                            try {
                                matching[i].m_data[j] = Integer.parseInt(t.nextToken());
                            }
                            catch (NumberFormatException e) {
                                this.error("invalid matching: " + e.getMessage());
                                return false;
                            }
                            ++j;
                        }
                        ++i;
                    }
                    covering.setMatching(matching);
                } else if (!this.skip(in, this.m_numTags)) {
                    return false;
                }
            } else {
                if (line.startsWith("SymmetryOrder:")) {
                    try {
                        int symm = Integer.parseInt(line.substring(14).trim());
                        covering.setSymmetryOrder(symm);
                    }
                    catch (NumberFormatException e) {
                        this.error("invalid symmetry order: " + line.substring(14).trim());
                        return false;
                    }
                }
                if (line.startsWith("BranchPoints:")) {
                    StringTokenizer t = new StringTokenizer(line.substring(13));
                    int num = t.countTokens();
                    PiVector bp = new PiVector(num);
                    int i = 0;
                    while (i < num) {
                        try {
                            bp.m_data[i] = Integer.parseInt(t.nextToken());
                        }
                        catch (NumberFormatException e) {
                            this.error("invalid branch point: " + e.getMessage());
                            return false;
                        }
                        ++i;
                    }
                    covering.setBranchPoints(bp);
                } else if (line.startsWith("BranchTypes:")) {
                    StringTokenizer t = new StringTokenizer(line.substring(12));
                    int num = t.countTokens();
                    PiVector bp = new PiVector(num);
                    int i = 0;
                    while (i < num) {
                        try {
                            bp.m_data[i] = Integer.parseInt(t.nextToken());
                        }
                        catch (NumberFormatException e) {
                            this.error("invalid branch type: " + e.getMessage());
                            return false;
                        }
                        ++i;
                    }
                    covering.setBranchTypes(bp);
                }
            }
            ++tag;
        }
        return true;
    }

    private boolean skip(BufferedReader in, int numTags) throws IOException {
        int i = 0;
        while (i < numTags) {
            int num;
            String line = this.readLine(in);
            if (line == null) {
                this.error("tag expected");
                return false;
            }
            if (this.parseLine(line) && !this.skip(in, num = this.m_numTags)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean read(String fileName, PgParamGeom geom) throws IOException {
        BufferedReader in = PsUtil.open((String)fileName);
        if (in == null) {
            PsDebug.warning((String)("could not open = " + fileName));
            return false;
        }
        this.m_lineNo = 0;
        String line = this.readLine(in);
        if (line == null || !this.parseLine(line) || !this.m_keyString.equals("elementset")) {
            this.error("geometries tag expected");
            return false;
        }
        this.parseGeometry(in, this.m_numTags, geom);
        try {
            in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }
}

