/*
 * Decompiled with CFR 0.152.
 */
package devParameterize.geom;

import devParameterize.geom.PwRemesher;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import jv.object.PsDebug;
import jv.object.PsUpdateIf;
import jvx.project.PjWorkshop_IP;

public class PwRemesher_IP
extends PjWorkshop_IP
implements ItemListener {
    protected PwRemesher m_pwRemesher;
    private Checkbox m_removeNegBox;
    private Button m_quantizeTextureButton;
    private Button m_remeshFromTextureButton;
    private Label m_quantLabel;
    private Checkbox m_hierarchyModePowerOfTwo;
    private Checkbox m_hierarchyModeLinear;

    public PwRemesher_IP() {
        if (this.getClass() == PwRemesher_IP.class) {
            this.init();
        }
    }

    public void init() {
        super.init();
    }

    public void setParent(PsUpdateIf parent) {
        if (parent == null) {
            return;
        }
        if (!(parent instanceof PwRemesher)) {
            PsDebug.warning((String)"Parent has to be of type PwRemesher");
            return;
        }
        super.setParent(parent);
        this.m_pwRemesher = (PwRemesher)parent;
        this.makeLayout();
    }

    public void makeLayout() {
        this.removeAll();
        this.addSubTitle("Quantization:");
        this.add(new Label("Symmetry order: " + this.m_pwRemesher.m_geom.getCovering().getSymmetryOrder()));
        this.add((Component)this.m_pwRemesher.m_quantizationMult.getInfoPanel());
        Panel p = new Panel(new FlowLayout(2));
        this.m_quantLabel = new Label();
        p.add(this.m_quantLabel);
        this.updateQuantize();
        this.add(p);
        this.addSubTitle("Remeshing:");
        this.m_removeNegBox = new Checkbox("Remove negatively oriented triangles");
        this.add(this.m_removeNegBox);
        this.m_removeNegBox.setState(true);
        this.add((Component)this.m_pwRemesher.m_bAddLevelsAsVectorField.getInfoPanel());
        Panel p2 = new Panel(new GridLayout(1, 2));
        CheckboxGroup cbg = new CheckboxGroup();
        this.m_hierarchyModePowerOfTwo = new Checkbox("Hierarchy power of Two", cbg, true);
        this.m_hierarchyModePowerOfTwo.addItemListener(this);
        p2.add(this.m_hierarchyModePowerOfTwo);
        this.m_hierarchyModeLinear = new Checkbox("Hierarchy linear", cbg, false);
        this.m_hierarchyModeLinear.addItemListener(this);
        p2.add(this.m_hierarchyModeLinear);
        this.add(p2);
        this.add((Component)this.m_pwRemesher.m_numHierarchyLevels.getInfoPanel());
        p = new Panel(new GridLayout(1, 2));
        this.m_quantizeTextureButton = new Button("Quantize only");
        p.add(this.m_quantizeTextureButton);
        this.m_quantizeTextureButton.addActionListener((ActionListener)((Object)this));
        this.m_remeshFromTextureButton = new Button("Quantize & Remesh");
        p.add(this.m_remeshFromTextureButton);
        this.m_remeshFromTextureButton.addActionListener((ActionListener)((Object)this));
        this.add(p);
    }

    public boolean update(Object event) {
        if (this.m_pwRemesher == null) {
            PsDebug.notify((String)"missing parent");
            return true;
        }
        if (event == this.m_pwRemesher) {
            this.updateQuantize();
            return true;
        }
        return super.update(event);
    }

    private void updateQuantize() {
        this.m_quantLabel.setText("* " + this.m_pwRemesher.m_quantizationBase + " = " + this.m_pwRemesher.getQuantization());
    }

    public void actionPerformed(ActionEvent event) {
        if (this.m_pwRemesher == null) {
            return;
        }
        Object source = event.getSource();
        if (source == this.m_remeshFromTextureButton) {
            this.m_pwRemesher.remeshFromTexture(this.m_removeNegBox.getState(), true);
        } else if (source == this.m_quantizeTextureButton) {
            this.m_pwRemesher.quantizeTextures(this.m_removeNegBox.getState());
            this.m_pwRemesher.m_geom.update((Object)this.m_pwRemesher.m_geom);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        if (source == this.m_hierarchyModePowerOfTwo) {
            this.m_pwRemesher.m_hierarchyMode = 0;
        }
        if (source == this.m_hierarchyModeLinear) {
            this.m_pwRemesher.m_hierarchyMode = 1;
        }
    }
}

