/*
 * Decompiled with CFR 0.152.
 */
package devParameterize.geom;

import dev.geom.PwTex2Quad;
import dev.geom.PwTex2Triang;
import devParameterize.covering.PgIntTextureMapOnCovering;
import devParameterize.covering.PgTextureMapOnCovering;
import devParameterize.covering.PnTextureQuantizer;
import devParameterize.geom.PgParamGeom;
import jv.geom.PgElementSet;
import jv.geom.PgVectorField;
import jv.number.PuBoolean;
import jv.number.PuInteger;
import jv.object.PsDebug;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.project.PjWorkshop;

public class PwRemesher
extends PjWorkshop {
    public PgParamGeom m_geom;
    protected int m_quantizationBase = 1;
    public PuInteger m_quantizationMult = new PuInteger("Multiplier", (PsUpdateIf)this);
    public int m_hierarchyMode = 0;
    public PuInteger m_numHierarchyLevels;
    public PuBoolean m_bAddLevelsAsVectorField;

    public PwRemesher() {
        super("Remesher workshop");
        this.m_quantizationMult.setDefBounds(1, 128, 1, 1);
        this.m_quantizationMult.setDefValue(32);
        this.m_bAddLevelsAsVectorField = new PuBoolean("Add Hierarchy Levels as Vector Field", (PsUpdateIf)this, false);
        this.m_numHierarchyLevels = new PuInteger("# Hierarchy Levels:", (PsUpdateIf)this);
        this.m_numHierarchyLevels.setDefBounds(0, 5, 1, 1);
        this.m_numHierarchyLevels.setDefValue(0);
        if (((Object)((Object)this)).getClass() == PwRemesher.class) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_quantizationMult.init();
        this.m_numHierarchyLevels.init();
    }

    public void setGeometry(PgGeometry geom) {
        if (!(geom instanceof PgParamGeom)) {
            PsDebug.warning((String)"Geom is not a PgParamGeom.");
            return;
        }
        super.setGeometry(geom);
        this.m_geom = (PgParamGeom)geom;
        switch (this.m_geom.getCovering().getSymmetryOrder()) {
            case 4: {
                this.m_quantizationBase = 8;
                break;
            }
            case 6: {
                this.m_quantizationBase = 12;
                break;
            }
            default: {
                PsDebug.warning((String)"Only symmetry order of 4 or 6 supported.");
            }
        }
    }

    public boolean update(Object event) {
        if (event == null) {
            return super.update(null);
        }
        if (event == this.m_quantizationMult) {
            this.update((Object)this);
            return true;
        }
        if (event == this.m_bAddLevelsAsVectorField || event == this.m_numHierarchyLevels) {
            return true;
        }
        return super.update(event);
    }

    public int getQuantization() {
        return this.m_quantizationBase * this.m_quantizationMult.getValue();
    }

    protected PiVector[][] getQuantizedTextures(boolean removeNegTriangles) {
        int quantization = this.getQuantization();
        PnTextureQuantizer q = new PnTextureQuantizer(quantization);
        q.setGeometry(this.m_geom);
        PgTextureMapOnCovering tm = new PgTextureMapOnCovering();
        tm.setGeometry(this.m_geom);
        tm.setSummand(this.m_geom.getParamTexture());
        q.setTextureMap(tm);
        q.setPaths(this.m_geom.getCutPaths(), this.m_geom.getBridges());
        q.setGaps(this.m_geom.getGaps());
        PgIntTextureMapOnCovering intTexOC = q.makeQuantizedTextures();
        if (removeNegTriangles) {
            PgIntTextureMapOnCovering.removeNegativeTriangles((PgElementSet)this.m_geom, intTexOC);
        }
        PiVector[][] quantTex = intTexOC.getTextureValues(null);
        int postScale = this.m_geom.getPostScaleFactor();
        if (postScale != 1) {
            int numE = quantTex.length;
            int dim = quantTex[0].length;
            int e = 0;
            while (e < numE) {
                int i = 0;
                while (i < dim) {
                    quantTex[e][i].multScalar(postScale);
                    ++i;
                }
                ++e;
            }
        }
        PwRemesher.compactQuantizedTexture(quantTex, quantization);
        return quantTex;
    }

    protected static void compactQuantizedTexture(PiVector[][] texture, int quantization) {
        if (texture == null) {
            PsDebug.warning((String)"no texture");
            return;
        }
        PdVector min = new PdVector(2);
        PdVector max = new PdVector(2);
        int i = 0;
        while (i < texture.length) {
            PiVector[] tex = texture[i];
            max.setConstant(-2.147483648E9);
            min.setConstant(2.147483647E9);
            int k = 0;
            while (k < tex.length) {
                max.m_data[0] = Math.max(max.m_data[0], (double)tex[k].m_data[0]);
                max.m_data[1] = Math.max(max.m_data[1], (double)tex[k].m_data[1]);
                min.m_data[0] = Math.min(min.m_data[0], (double)tex[k].m_data[0]);
                min.m_data[1] = Math.min(min.m_data[1], (double)tex[k].m_data[1]);
                ++k;
            }
            max.add(min);
            max.multScalar(0.5);
            int dx = (int)Math.floor(max.m_data[0] / (double)quantization) * quantization;
            int dy = (int)Math.floor(max.m_data[1] / (double)quantization) * quantization;
            int j = 0;
            while (j < tex.length) {
                tex[j].m_data[0] = tex[j].m_data[0] - dx;
                tex[j].m_data[1] = tex[j].m_data[1] - dy;
                ++j;
            }
            ++i;
        }
    }

    public void quantizeTextures(boolean removeNegTriangles) {
        int symmetryOrder = this.m_geom.getCovering().getSymmetryOrder();
        if (symmetryOrder != 4 && symmetryOrder != 6) {
            PsDebug.warning((String)"Remeshing only possible if symmetryOrder is 4 or 6");
            return;
        }
        PiVector[][] quantTex = this.getQuantizedTextures(removeNegTriangles);
        int numElements = this.m_geom.getNumElements();
        PdVector[][] newTex = new PdVector[numElements][3];
        int e = 0;
        while (e < numElements) {
            int i = 0;
            while (i < 3) {
                newTex[e][i] = new PdVector(2);
                newTex[e][i].m_data[0] = quantTex[e][i].m_data[0];
                newTex[e][i].m_data[1] = quantTex[e][i].m_data[1];
                ++i;
            }
            ++e;
        }
        this.m_geom.setElementTextures(newTex);
    }

    public PgElementSet remeshFromTexture(boolean removeNegTriangles, boolean addToDisplay) {
        int symmetryOrder = this.m_geom.getCovering().getSymmetryOrder();
        PgElementSet geom = null;
        if (symmetryOrder == 4) {
            geom = this.remeshFromTexture4(removeNegTriangles, addToDisplay);
        } else if (symmetryOrder == 6) {
            geom = this.remeshFromTexture6(removeNegTriangles, addToDisplay);
        } else {
            PsDebug.warning((String)"Remeshing only possible if symmetryOrder is 4 or 6");
            return null;
        }
        return geom;
    }

    private PgElementSet remeshFromTexture4(boolean removeNegTriangles, boolean addToDisplay) {
        PgElementSet remeshed;
        int quantization = this.getQuantization();
        PiVector[][] quantTex = this.getQuantizedTextures(removeNegTriangles);
        PwTex2Quad.m_hierarchyMode = this.m_hierarchyMode;
        if (this.m_bAddLevelsAsVectorField.getState() || this.m_numHierarchyLevels.getValue() > 0) {
            PiVector levels = new PiVector();
            remeshed = PwTex2Quad.quantizedTex2Quad((PgElementSet)this.m_geom, (PiVector[][])quantTex, (int)quantization, (int)this.m_numHierarchyLevels.getValue(), (PiVector)levels);
            if (this.m_bAddLevelsAsVectorField.getState()) {
                PgVectorField vf = new PgVectorField(1);
                vf.setBasedOn(0);
                int nov = remeshed.getNumVertices();
                vf.setNumVectors(nov);
                int i = 0;
                while (i < nov) {
                    vf.setVector(i, (double)levels.m_data[i]);
                    ++i;
                }
                vf.setName("vertexLevels");
                vf.setVisible(false);
                remeshed.addVectorField(vf);
            }
        } else {
            remeshed = PwTex2Quad.quantizedTex2Quad((PgElementSet)this.m_geom, (PiVector[][])quantTex, (int)quantization, (int)0, null);
        }
        if (remeshed == null) {
            PsDebug.warning((String)"Error during remeshing.");
        } else if (addToDisplay) {
            this.getDisplay().addGeometry((PgGeometryIf)remeshed);
            this.getDisplay().update((Object)this.getDisplay());
        }
        return remeshed;
    }

    private PgElementSet remeshFromTexture6(boolean removeNegTriangles, boolean addToDisplay) {
        int quantization = this.getQuantization();
        PiVector[][] quantTex = this.getQuantizedTextures(removeNegTriangles);
        int numElements = this.m_geom.getNumElements();
        PdVector[][] testTex = new PdVector[numElements][3];
        int e = 0;
        while (e < numElements) {
            testTex[e] = PdVector.realloc(null, (int)3, (int)2);
            int i = 0;
            while (i < 3) {
                int k = 0;
                while (k < 2) {
                    testTex[e][i].m_data[k] = (double)quantTex[e][i].m_data[k] * 1.0;
                    ++k;
                }
                ++i;
            }
            ++e;
        }
        int numE = this.m_geom.getNumElements();
        PdVector[][] backupTex = new PdVector[numE][];
        int i = 0;
        while (i < numE) {
            backupTex[i] = PdVector.realloc(null, (int)3, (int)2);
            int j = 0;
            while (j < 3) {
                backupTex[i][j].copy(this.m_geom.getElementTexture(i)[j]);
                ++j;
            }
            ++i;
        }
        this.m_geom.setElementTextures(testTex);
        PgElementSet remeshed = PwTex2Triang.tex2Triang((PgElementSet)this.m_geom, (int)quantization);
        this.m_geom.setElementTextures(backupTex);
        if (remeshed == null) {
            PsDebug.warning((String)"Error during remeshing.");
        } else if (addToDisplay) {
            this.getDisplay().addGeometry((PgGeometryIf)remeshed);
            this.getDisplay().update((Object)this.getDisplay());
        }
        return remeshed;
    }
}

