/*
 * Decompiled with CFR 0.152.
 */
package devParameterize.geom;

import devParameterize.geom.PgParamGeom;
import devParameterize.modules.parameterizer.PmPositiveOrienter;
import devParameterize.number.PuTransitionFunction;
import jv.geom.PgElementSet;
import jv.object.PsDebug;
import jv.project.PgGeometry;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuMath;
import jvx.geom.PgVertexStar;
import jvx.project.PjWorkshop;

public class PwParamSanitization
extends PjWorkshop {
    protected PgParamGeom m_geom;

    public PwParamSanitization() {
        super("Repairing parametrization");
        if (((Object)((Object)this)).getClass() == PwParamSanitization.class) {
            this.init();
        }
    }

    public void init() {
        super.init();
    }

    public void setGeometry(PgGeometry geom) {
        this.m_geom = (PgParamGeom)geom;
    }

    public void start() {
        PwParamSanitization.sanitizeDisco(this.m_geom, this.m_geom.getDiscontinuousTexture(), 0.01);
        this.m_geom.setElementTextures(this.m_geom.getDiscontinuousTexture());
        this.m_geom.update((Object)this.m_geom);
    }

    public static void makePositiveOrientation(PgParamGeom geom) {
        PmPositiveOrienter pos = new PmPositiveOrienter();
        pos.setGeometry(geom);
        pos.makePositiveOrientation(false);
    }

    public static void makeVertexStar(PgParamGeom geom, PdVector[][] eltTex, int indv) {
        int inde = geom.getElementWithVertex(indv);
        PiVector[] corner_p = PwParamSanitization.getCornerOfVertex(indv, inde, geom);
        int size = corner_p.length;
        PuTransitionFunction[] g = new PuTransitionFunction[size];
        int j = 0;
        while (j < size) {
            int currElt = corner_p[j].m_data[1];
            int nextElt = corner_p[(j + 1) % size].m_data[1];
            int indOpp = geom.getNeighbour(currElt).getIndexOf(nextElt);
            g[j] = new PuTransitionFunction((PgElementSet)geom, currElt, indOpp);
            int k = 0;
            while (k < 3) {
                eltTex[nextElt][k] = g[j].evalInv(eltTex[nextElt][k]);
                ++k;
            }
            ++j;
        }
    }

    public static void sanitizeDisco(PgParamGeom geom, PdVector[][] eltTex, double eps) {
        int noe = geom.getNumElements();
        int i = 0;
        while (i < noe) {
            PdVector t = new PdVector(2);
            int j = 0;
            while (j < 3) {
                PdVector p1 = eltTex[i][j];
                PdVector p2 = eltTex[i][(j + 1) % 3];
                if (Math.abs(p1.m_data[0] - p2.m_data[0]) < eps) {
                    t.m_data[0] = eps * 0.1 + eps * Math.random();
                    t.m_data[1] = 0.0;
                    PwParamSanitization.moveVertex(geom, eltTex, i, j, t);
                    t.multScalar(-1.0);
                    PwParamSanitization.moveVertex(geom, eltTex, i, (j + 1) % 3, t);
                }
                if (Math.abs(p1.m_data[1] - p2.m_data[1]) < eps) {
                    t.m_data[0] = 0.0;
                    t.m_data[1] = eps * 0.1 + eps * Math.random();
                    PwParamSanitization.moveVertex(geom, eltTex, i, j, t);
                    t.multScalar(-1.0);
                    PwParamSanitization.moveVertex(geom, eltTex, i, (j + 1) % 3, t);
                }
                ++j;
            }
            ++i;
        }
    }

    public static void sanitizeParametrization(PgParamGeom geom, PdVector[][] eltTex, double eps) {
        int nov = geom.getNumVertices();
        PiVector bp = geom.getCovering().getBranchPoints();
        PiVector elementPerVertex = PgVertexStar.getElementPerVertex((PgElementSet)geom);
        int i = 0;
        while (i < nov) {
            if (!bp.contains(i)) {
                PiVector[] corner_p = PwParamSanitization.getCornerOfVertex(i, elementPerVertex.m_data[i], geom);
                int size = corner_p.length;
                int ind_p = -1;
                boolean needToRound = false;
                int _case = -1;
                PdVector t = new PdVector(2);
                int j = 0;
                while (j < size) {
                    PdVector p = eltTex[corner_p[j].m_data[1]][corner_p[j].m_data[0]];
                    if (Math.abs((double)((int)Math.round(p.m_data[0])) - p.m_data[0]) < eps && Math.abs((double)((int)Math.round(p.m_data[1])) - p.m_data[1]) < eps) {
                        _case = 0;
                        ind_p = j;
                        t.m_data[0] = eps;
                        t.m_data[1] = eps;
                        PwParamSanitization.moveVertex(geom, eltTex, corner_p[j].m_data[1], corner_p[j].m_data[0], t);
                        break;
                    }
                    if (Math.abs((double)((int)Math.round(p.m_data[0])) - p.m_data[0]) < eps) {
                        _case = 1;
                        ind_p = j;
                        t.m_data[0] = eps;
                        t.m_data[1] = 0.0;
                        PwParamSanitization.moveVertex(geom, eltTex, corner_p[j].m_data[1], corner_p[j].m_data[0], t);
                        break;
                    }
                    if (Math.abs((double)((int)Math.round(p.m_data[1])) - p.m_data[1]) < eps) {
                        _case = 2;
                        ind_p = j;
                        t.m_data[0] = 0.0;
                        t.m_data[1] = eps;
                        PwParamSanitization.moveVertex(geom, eltTex, corner_p[j].m_data[1], corner_p[j].m_data[0], t);
                        break;
                    }
                    ++j;
                }
                if (needToRound) {
                    int inde = corner_p[ind_p].m_data[1];
                    int indv = corner_p[ind_p].m_data[0];
                    PdVector u_0 = eltTex[inde][indv];
                    switch (_case) {
                        case 0: {
                            u_0.m_data[0] = u_0.m_data[0] + eps;
                            u_0.m_data[1] = u_0.m_data[1] + eps;
                            break;
                        }
                        case 1: {
                            u_0.m_data[0] = u_0.m_data[0] + eps;
                            break;
                        }
                        case 2: {
                            u_0.m_data[1] = u_0.m_data[1] + eps;
                        }
                    }
                    PuTransitionFunction[] g = new PuTransitionFunction[size];
                    int j2 = 0;
                    while (j2 < size) {
                        int currElt = corner_p[j2].m_data[1];
                        int nextElt = corner_p[(j2 + 1) % size].m_data[1];
                        int indOpp = geom.getNeighbour(currElt).getIndexOf(nextElt);
                        g[j2] = new PuTransitionFunction((PgElementSet)geom, currElt, indOpp);
                        ++j2;
                    }
                    j2 = 0;
                    while (j2 < ind_p) {
                        PdVector u_j = eltTex[corner_p[ind_p - j2].m_data[1]][corner_p[ind_p - j2].m_data[0]];
                        PdVector u_jmin1 = eltTex[corner_p[ind_p - j2 - 1].m_data[1]][corner_p[ind_p - j2 - 1].m_data[0]];
                        u_jmin1.copy(g[ind_p - j2 - 1].evalInv(u_j));
                        ++j2;
                    }
                    j2 = ind_p + 1;
                    while (j2 < size) {
                        PdVector u_j = eltTex[corner_p[j2].m_data[1]][corner_p[j2].m_data[0]];
                        PdVector u_jmin1 = eltTex[corner_p[j2 - 1].m_data[1]][corner_p[j2 - 1].m_data[0]];
                        u_j.copy(g[j2 - 1].evalNew(u_jmin1));
                        ++j2;
                    }
                }
            }
            ++i;
        }
    }

    public static void moveVertex(PgParamGeom geom, PdVector[][] eltTex, int inde, int locIndv, PdVector t) {
        if (t.getSize() != 2) {
            PsDebug.error((String)"Translation vector is not of dimension 2 in moveVertex ");
            return;
        }
        PdVector u_0 = eltTex[inde][locIndv];
        u_0.add(t);
        PiVector[] corner_p = PwParamSanitization.getCornerOfVertex(geom.getElement((int)inde).m_data[locIndv], inde, geom);
        int size = corner_p.length;
        PuTransitionFunction[] g = new PuTransitionFunction[size];
        int j = 0;
        while (j < size) {
            int currElt = corner_p[j].m_data[1];
            int nextElt = corner_p[(j + 1) % size].m_data[1];
            int indOpp = geom.getNeighbour(currElt).getIndexOf(nextElt);
            if (indOpp != -1) {
                g[j] = new PuTransitionFunction((PgElementSet)geom, currElt, indOpp);
            }
            ++j;
        }
        j = 1;
        while (j < size) {
            PdVector u_j = eltTex[corner_p[j].m_data[1]][corner_p[j].m_data[0]];
            PdVector u_jmin1 = eltTex[corner_p[j - 1].m_data[1]][corner_p[j - 1].m_data[0]];
            u_j.copy(g[j - 1].evalNew(u_jmin1));
            ++j;
        }
    }

    public static void moveVertex(PgParamGeom geom, PdVector[][] eltTex, PuTransitionFunction[][] transFunction, int inde, int locIndv, PdVector t) {
        if (t.getSize() != 2) {
            PsDebug.error((String)"Translation vector is not of dimension 2 in moveVertex ");
            return;
        }
        PiVector[] element = geom.getElements();
        PdVector u_0 = eltTex[inde][locIndv];
        u_0.add(t);
        int nextLoc = -1;
        PuTransitionFunction trans = PuTransitionFunction.identity();
        int currLoc = -1;
        int vert = element[inde].m_data[locIndv];
        int vertInd = -1;
        int currElt = inde;
        int nextElt = -2;
        while (nextElt != -1) {
            currLoc = element[currElt].getIndexOf(vert);
            vertInd = (currLoc + 1) % 3;
            nextElt = geom.getNeighbour((int)currElt).m_data[vertInd];
            if (nextElt == inde) break;
            trans.concatRight(transFunction[currElt][vertInd]);
            nextLoc = element[nextElt].getIndexOf(vert);
            PdVector u = eltTex[nextElt][nextLoc];
            u.copy(trans.evalNew(u_0));
            currElt = nextElt;
        }
    }

    public static void sanitize(PgParamGeom geom) {
        int nov = geom.getNumVertices();
        PiVector bp = geom.getCovering().getBranchPoints();
        PdVector[][] eltTex = geom.getElementTextures();
        PiVector elementPerVertex = PgVertexStar.getElementPerVertex((PgElementSet)geom);
        int i = 0;
        while (i < nov) {
            PiVector[] corner_p = PwParamSanitization.getCornerOfVertex(i, elementPerVertex.m_data[i], geom);
            int size = corner_p.length;
            PuTransitionFunction[] g = new PuTransitionFunction[size];
            int j = 0;
            while (j < size) {
                int currElt = corner_p[j].m_data[1];
                int nextElt = corner_p[(j + 1) % size].m_data[1];
                int indOpp = geom.getNeighbour(currElt).getIndexOf(nextElt);
                g[j] = new PuTransitionFunction((PgElementSet)geom, currElt, indOpp);
                ++j;
            }
            double maxCoord = -10000.0;
            int k = 0;
            while (k < size) {
                PdVector u_k = eltTex[corner_p[k].m_data[1]][corner_p[k].m_data[0]];
                double currMax = Math.abs(u_k.m_data[u_k.indexOfAbsMax()]);
                if (maxCoord < currMax) {
                    maxCoord = currMax;
                }
                ++k;
            }
            double delta = Math.pow(2.0, Math.ceil(PuMath.log((double)2.0, (double)maxCoord)));
            PdVector u_0 = eltTex[corner_p[0].m_data[1]][corner_p[0].m_data[0]];
            PdVector s = new PdVector(Math.signum(u_0.m_data[0]), Math.signum(u_0.m_data[1]));
            if (!bp.contains(i)) {
                PdVector delta_s = new PdVector(2);
                delta_s.add(delta, s);
                u_0.add(delta_s);
                u_0.sub(delta_s);
            } else {
                PwParamSanitization.fixSingularPoint(u_0, g);
            }
            int j2 = 1;
            while (j2 < size) {
                PdVector u_j = eltTex[corner_p[j2].m_data[1]][corner_p[j2].m_data[0]];
                PdVector u_jmin1 = eltTex[corner_p[j2 - 1].m_data[1]][corner_p[j2 - 1].m_data[0]];
                u_j.copy(g[j2 - 1].evalNew(u_jmin1));
                ++j2;
            }
            ++i;
        }
    }

    public static void fixSingularPoint(PdVector u, PuTransitionFunction[] comp) {
        PuTransitionFunction g = PuTransitionFunction.concat(comp);
        double t_1 = g.t_trans.m_data[0];
        double t_2 = g.t_trans.m_data[1];
        int r = g.r_matching;
        switch (r) {
            case 0: {
                u.m_data[0] = (int)Math.round(u.m_data[0]);
                u.m_data[1] = (int)Math.round(u.m_data[1]);
                break;
            }
            case 1: {
                u.m_data[0] = t_1 - t_2;
                u.m_data[1] = t_2 + t_1;
                u.multScalar(0.5);
                break;
            }
            case 2: {
                u.m_data[0] = t_1;
                u.m_data[1] = t_2;
                u.multScalar(0.5);
                break;
            }
            case 3: {
                u.m_data[0] = t_1 + t_2;
                u.m_data[1] = t_2 - t_1;
                u.multScalar(0.5);
            }
        }
    }

    public static PiVector[] getCornerOfVertex(int indV, int indElt, PgParamGeom geom) {
        PgVertexStar v = new PgVertexStar();
        v.makeVertexStar((PgElementSet)geom, indV, indElt);
        PiVector elems = v.getElement();
        int index = elems.getIndexOf(indElt);
        elems.shift(elems.getSize() - index);
        int size = elems.getSize();
        PiVector[] elemVertex = new PiVector[size];
        int i = 0;
        while (i < size) {
            elemVertex[i] = new PiVector(geom.getElement(elems.m_data[i]).getIndexOf(indV), elems.m_data[i]);
            ++i;
        }
        return elemVertex;
    }

    public static void moveAdjacentToEdge(PgParamGeom geom, PdVector[] oppTexPos, PuTransitionFunction[][] transition, int currElt, int localIndex, int oppElt, int localOppIndex) {
        if (currElt == -1 || oppElt == -1) {
            PsDebug.error((String)"Negative index.");
            return;
        }
        if (localOppIndex == -1) {
            PsDebug.warning((String)"Triangle is at a boundary");
            return;
        }
        if (oppTexPos == null) {
            PsDebug.error((String)"Missing texture coordinates");
            return;
        }
        if (transition == null || transition[currElt] == null) {
            PsDebug.error((String)"Missing transition functions");
            return;
        }
        if (transition[oppElt][localOppIndex].r_matching == 0 && Math.abs(transition[oppElt][localOppIndex].t_trans.length()) < 1.0E-8) {
            return;
        }
        PdVector.copy((PdVector[])oppTexPos, (int)0, (PdVector[])transition[oppElt][localOppIndex].eval(oppTexPos), (int)0, (int)3);
        int one = oppElt;
        int zero = currElt;
        int two = geom.getNeighbour((int)one).m_data[(localOppIndex + 1) % 3];
        int three = geom.getNeighbour((int)one).m_data[(localOppIndex + 2) % 3];
        int locTwoInOne = (localOppIndex + 1) % 3;
        int locOneInTwo = geom.getOppVertexLocInd(one, (localOppIndex + 1) % 3);
        transition[two][locOneInTwo].concatRight(transition[one][localOppIndex]);
        transition[one][locTwoInOne].concatLeft(transition[zero][localIndex]);
        int locThreeInOne = (localOppIndex + 2) % 3;
        int locOneInThree = geom.getOppVertexLocInd(one, (localOppIndex + 2) % 3);
        transition[three][locOneInThree].concatRight(transition[one][localOppIndex]);
        transition[one][locThreeInOne].concatLeft(transition[zero][localIndex]);
        transition[zero][localIndex].makeTrivial();
        transition[one][localOppIndex].makeTrivial();
    }

    public static void adjustPrecision(PgParamGeom geom, PuTransitionFunction[][] m_transition, PdVector[][] tex) {
    }

    public static void pertubeVertexTexture(PgParamGeom geom, PdVector[][] tex, PuTransitionFunction[][] m_transition, PgVertexStar[] vertexStar, double eps) {
        int nov = geom.getNumVertices();
        int i = 0;
        while (i < nov) {
            if (!geom.getCovering().getBranchPoints().contains(i)) {
                PdVector t = new PdVector(2);
                t.m_data[0] = eps + Math.random() * eps;
                t.m_data[1] = -eps - Math.random() * eps;
                int elt = vertexStar[i].getElement().m_data[0];
                int locInd = vertexStar[i].getVertexLocInd().m_data[0];
                PwParamSanitization.moveVertex(geom, tex, m_transition, vertexStar, elt, locInd, t);
            }
            ++i;
        }
    }

    private static void moveVertex(PgParamGeom geom, PdVector[][] tex, PuTransitionFunction[][] m_transition, PgVertexStar[] vertexStar, int inde, int locv, PdVector t) {
        PdVector u_0 = tex[inde][locv];
        u_0.add(t);
        int size = vertexStar[geom.getElement((int)inde).m_data[locv]].getSize();
        int currElt = inde;
        PuTransitionFunction I = PuTransitionFunction.identity();
        I.concatRight(m_transition[currElt][(locv + 1) % 3]);
        int i = 0;
        while (i < size) {
            int nextElt = geom.getNeighbour((int)currElt).m_data[(locv + 1) % 3];
            if (nextElt != -1) {
                int oppIndex = geom.getOppVertexLocInd(currElt, (locv + 1) % 3);
                PuTransitionFunction g = m_transition[currElt][(locv + 1) % 3];
                tex[nextElt][(oppIndex + 1) % 3].copy(g.evalNew(u_0));
                currElt = nextElt;
                locv = (oppIndex + 1) % 3;
                u_0.copy(tex[nextElt][(oppIndex + 1) % 3]);
            }
            ++i;
        }
    }
}

