/*
 * Decompiled with CFR 0.152.
 */
package devParameterize.geom;

import devParameterize.geom.PgParamGeom;
import devParameterize.geom.PwParamSanitization;
import devParameterize.modules.parameterizer.PmAntiSpiraler;
import devParameterize.number.PuTransitionFunction;
import java.awt.Color;
import java.util.Vector;
import jv.geom.PgElementSet;
import jv.geom.PgPolygon;
import jv.geom.PgPolygonSet;
import jv.number.PuBoolean;
import jv.number.PuDouble;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.project.PvDisplayIf;
import jv.vecmath.PdBary;
import jv.vecmath.PdBaryDir;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuMath;
import jv.vecmath.PuVectorGeom;
import jvx.geom.PgPolygonOnElementSet;
import jvx.geom.PgPolygonSetOnElementSet;
import jvx.geom.PgVertexStar;
import jvx.geom.PwBary;
import jvx.geom.PwCleanMesh;
import jvx.geom.PwGeodesic;
import jvx.project.PjWorkshop;

public class PwBaseComplexParam
extends PjWorkshop
implements Runnable {
    protected PgParamGeom m_geom;
    protected PgPolygonSetOnElementSet m_baseComplex;
    protected PiVector[][] m_neighbor;
    protected PiVector[] m_strip;
    protected static final double EPS = 1.0E-7;
    protected PiVector[] m_patch;
    protected PiVector[] m_patchNeighbor;
    protected PuDouble m_cutAngle;
    protected PiVector[] m_vertPatch;
    protected PiVector[][] m_loop;
    protected boolean m_hasPatchConnectivity;
    protected boolean m_hasPatchNeighbor;
    protected boolean m_hasPatchStrip;
    protected boolean[][] m_edgeOrientation;
    protected PvDisplayIf m_display;
    protected PdVector[] m_polygonsPerElement;
    protected Thread m_thread;
    protected boolean m_bRunning = false;
    protected boolean m_bStopped = true;

    public PwBaseComplexParam() {
        super("Base Complex");
        if (this.getClass() == PwBaseComplexParam.class) {
            this.init();
        }
    }

    public void init() {
        this.m_cutAngle = new PuDouble("Cut angle");
        this.m_cutAngle.setDefBounds(10.0, 720.0, 5.0, 20.0);
        this.m_cutAngle.setDefValue(180.0);
        this.m_cutAngle.init();
        super.init();
    }

    public void setGeometry(PgGeometry geom) {
        this.m_geom = (PgParamGeom)geom;
        this.m_baseComplex = new PgPolygonSetOnElementSet((PgElementSet)this.m_geom);
        this.m_baseComplex.setName("Base Complex");
    }

    public void setDisplay(PvDisplayIf disp) {
        this.m_display = disp;
    }

    public void updateDisplay() {
        if (!this.m_display.containsGeometry((PgGeometryIf)this.m_baseComplex)) {
            this.m_display.addGeometry((PgGeometryIf)this.m_baseComplex);
        }
        this.m_baseComplex.update((Object)this.m_baseComplex);
        this.m_display.selectGeometry((PgGeometryIf)this.m_baseComplex);
        this.m_geom.update((Object)this.m_geom);
    }

    public void baseComplexProperties() {
        this.m_baseComplex.showVertices(false);
        this.m_baseComplex.setGlobalPolygonSize(2.0);
        this.m_baseComplex.showVertices(false);
        this.m_baseComplex.setName("Base Complex");
        this.m_baseComplex.update((Object)this.m_baseComplex);
    }

    public void setBaseComplex(PgPolygonSetOnElementSet baseComplex) {
        if (baseComplex == null) {
            PsDebug.error((String)"The polygon line is null");
            return;
        }
        if (baseComplex.getGeometry() != this.m_geom) {
            PsDebug.error((String)"The polygon line does not live on the same geometry");
            return;
        }
        this.m_baseComplex = baseComplex;
        if (this.m_strip == null) {
            this.m_strip = this.makeStrip();
        }
        this.m_hasPatchConnectivity = false;
        this.m_hasPatchNeighbor = false;
        this.m_hasPatchStrip = false;
    }

    public boolean hasPatchConnectivity() {
        return this.m_hasPatchConnectivity;
    }

    public boolean hasPatchNeighbor() {
        return this.m_hasPatchNeighbor;
    }

    public boolean hasPatchStrip() {
        return this.m_hasPatchStrip;
    }

    public static boolean traceParameterLine(PgParamGeom geom, PgPolygonOnElementSet poly, int element, int vOpp, int constCoord, double niveau, PiVector singularity, PdVector[][] tex, PiVector[] indexSing, boolean[][] elementDir, int maxTracing, boolean integrable) {
        int noe = geom.getNumElements();
        boolean[][] _visitedLayer = new boolean[noe][4];
        int _layer = 0;
        int i = 0;
        while (i < maxTracing) {
            int v1 = (vOpp + 1) % 3;
            int v2 = (vOpp + 2) % 3;
            int v = -1;
            int newElement = -1;
            int vOppNew = -1;
            int thirdV = -1;
            int locInd = -1;
            if (Math.abs(tex[element][vOpp].getEntry(constCoord) - niveau) < 1.0E-8) {
                locInd = vOpp;
            } else if (Math.abs(tex[element][v1].getEntry(constCoord) - niveau) < 1.0E-8) {
                locInd = v1;
            }
            if (locInd != -1 && PuMath.modulo((int)geom.getCovering().getBranchType(geom.getElement(element).getEntry(locInd)), (int)geom.getCovering().getSymmetryOrder()) != 0) {
                PdVector bary = new PdVector(3);
                bary.setEntry(locInd, 1);
                bary.setEntry((locInd + 1) % 3, 0);
                bary.setEntry((locInd + 2) % 3, 0);
                poly.setNumVertices(poly.getNumVertices() + 1);
                poly.setVertexBary(poly.getNumVertices() - 1, new PdBary(element, bary.getEntry(0), bary.getEntry(1), bary.getEntry(2)));
                singularity.m_data[1] = geom.getElement(element).getEntry(locInd);
                elementDir[element][constCoord] = true;
                return true;
            }
            if (_visitedLayer[element][_layer] && !integrable) {
                return true;
            }
            _visitedLayer[element][_layer] = true;
            if (Math.signum((tex[element][vOpp].getEntry(constCoord) - niveau) * (tex[element][v1].getEntry(constCoord) - niveau)) <= 0.0) {
                v = v1;
                vOppNew = geom.getOppVertexLocInd(element, v2);
                newElement = geom.getNeighbour(element).getEntry(v2);
                thirdV = v2;
            } else if (Math.signum((tex[element][vOpp].getEntry(constCoord) - niveau) * (tex[element][v2].getEntry(constCoord) - niveau)) < 0.0) {
                v = v2;
                vOppNew = geom.getOppVertexLocInd(element, v1);
                newElement = geom.getNeighbour(element).getEntry(v1);
                thirdV = v1;
            } else {
                return false;
            }
            double val1 = tex[element][v].getEntry(constCoord) - niveau;
            double val2 = tex[element][vOpp].getEntry(constCoord) - niveau;
            if (val1 > 0.0) {
                double temp = val1;
                val1 = val2;
                val2 = temp;
                int tempInd = vOpp;
                vOpp = v;
                v = tempInd;
            }
            double a = -val1 / (val2 - val1);
            PdVector bary = new PdVector(3);
            bary.setEntry(v, 1.0 - a);
            bary.setEntry(vOpp, a);
            bary.setEntry(thirdV, 0);
            poly.setNumVertices(poly.getNumVertices() + 1);
            poly.setVertexBary(poly.getNumVertices() - 1, new PdBary(element, bary.getEntry(0), bary.getEntry(1), bary.getEntry(2)));
            int[] mutLocV = PmAntiSpiraler.getMutualVertex((PgElementSet)geom, element, newElement);
            int matching = geom.getCovering().getMatching(element, thirdV);
            _layer = PuMath.modulo((int)(_layer + matching), (int)4);
            PdVector coords = PdVector.copyNew((PdVector)tex[element][mutLocV[0]]);
            PdVector newCoords = PdVector.copyNew((PdVector)tex[newElement][mutLocV[1]]);
            newCoords = PmAntiSpiraler.quarterRotationRight(newCoords, matching);
            PdVector gap = PdVector.subNew((PdVector)newCoords, (PdVector)coords);
            PdVector niveauNew = new PdVector(2);
            niveauNew.setEntry(constCoord, niveau);
            niveauNew.add(gap);
            niveauNew = PmAntiSpiraler.quarterRotationLeft(niveauNew, matching);
            if (PuMath.modulo((int)matching, (int)2) == 1) {
                constCoord = constCoord == 1 ? 0 : 1;
            }
            element = newElement;
            vOpp = vOppNew;
            niveau = niveauNew.getEntry(constCoord);
            ++i;
        }
        return !integrable;
    }

    /*
     * Unable to fully structure code
     */
    public static void createSparseComplexPolygons(PgParamGeom m_geom, PgPolygonSetOnElementSet baseComplex, boolean isIntegrable, int maxTrace) {
        if (m_geom.getCovering().getSymmetryOrder() != 4) {
            PsDebug.warning((String)"Sparse complex creation works only on 4-symmetric coverings!");
            return;
        }
        baseComplex.init();
        tex = new PdVector[m_geom.getNumElements()][3];
        param = m_geom.getParamTexture();
        if (isIntegrable) {
            noe = m_geom.getNumElements();
            i = 0;
            while (i < noe) {
                j = 0;
                while (j < 3) {
                    tex[i][j] = (PdVector)param[i][j].clone();
                    tex[i][j].multScalar((double)m_geom.getPostScaleFactor());
                    ++j;
                }
                ++i;
            }
        } else {
            tex = m_geom.getElementTextures();
        }
        PwParamSanitization.sanitizeParametrization(m_geom, tex, 1.0E-7);
        bp = m_geom.getCovering().getBranchPoints();
        connectivity = new PiVector[m_geom.getNumVertices()];
        PiVector.realloc((PiVector[])connectivity, (int)m_geom.getNumVertices(), (int)0);
        indPol = 0;
        noe = m_geom.getNumElements();
        visitedElement = new PiVector[noe];
        PiVector.realloc((PiVector[])visitedElement, (int)noe, (int)0);
        elementDir = new boolean[noe][2];
        singConnect = new boolean[m_geom.getNumVertices()][m_geom.getNumVertices()];
        tracingLine = false;
        numSingularity = bp.getSize();
        i = 0;
        while (i < numSingularity) {
            elems = PwBaseComplexParam.getElementWithVertex((PgElementSet)m_geom, bp.getEntry(i));
            eltSize = elems.getSize();
            j = 0;
            while (j < eltSize) {
                curEl = elems.getEntry(j);
                singLocIndex = elems.getEntry(j + 1);
                dir = 0;
                while (dir <= 1) {
                    block30: {
                        block31: {
                            if (elementDir[curEl][dir]) break block30;
                            elementDir[curEl][dir] = true;
                            singularity = new PiVector(2);
                            curPol = new PgPolygonOnElementSet((PgElementSet)m_geom);
                            bary = new PdVector(3);
                            bary.setEntry(singLocIndex, 1);
                            curPol.setNumVertices(1);
                            curPol.setVertexBary(0, new PdBary(curEl, bary.getEntry(0), bary.getEntry(1), bary.getEntry(2)));
                            interval = new Vector<PiVector>();
                            tracingLine = PwBaseComplexParam.traceParameterLine(m_geom, curPol, curEl, (singLocIndex + 1) % 3, dir, tex[curEl][singLocIndex].getEntry(dir), singularity, tex, connectivity, elementDir, maxTrace, isIntegrable);
                            if (!tracingLine) break block30;
                            if (isIntegrable) break block31;
                            baseComplex.addPolygonBary(curPol);
                            break block30;
                        }
                        singularity.m_data[0] = bp.m_data[i];
                        if ((singConnect[singularity.m_data[0]][singularity.m_data[1]] || singConnect[singularity.m_data[1]][singularity.m_data[0]]) && curPol.getNumVertices() == 2) break block30;
                        singConnect[singularity.m_data[0]][singularity.m_data[1]] = true;
                        singConnect[singularity.m_data[1]][singularity.m_data[0]] = true;
                        vertex = curPol.getVertexBary();
                        _2DStart = new PdVector(3);
                        _2DEnd = new PdVector(3);
                        newVertex = new Vector<PdBary>();
                        numVert = curPol.getNumVertices();
                        size = curPol.getNumEdges();
                        tmp = new PiVector();
                        k = 0;
                        while (k < size) {
                            block34: {
                                block33: {
                                    block32: {
                                        start = k;
                                        end = k + 1;
                                        tmp.addEntry(k);
                                        if (k == 0) {
                                            connectivity[singularity.m_data[0]].addEntry(indPol);
                                            connectivity[singularity.m_data[0]].addEntry(0);
                                        }
                                        bStart = PdBary.copyNew((PdBary)vertex[start]);
                                        bEnd = PdBary.copyNew((PdBary)vertex[end]);
                                        refElt = bEnd.m_elementInd;
                                        PwBaseComplexParam.makeCommonBarycenctricDescription((PgElementSet)m_geom, bStart, bEnd, 1.0E-8);
                                        bStart.getVertex(_2DStart, tex[refElt][0], tex[refElt][1], tex[refElt][2]);
                                        bEnd.getVertex(_2DEnd, tex[refElt][0], tex[refElt][1], tex[refElt][2]);
                                        min = -10000.0;
                                        max = 100000.0;
                                        down = false;
                                        dist_x = Math.abs(_2DStart.m_data[0] - _2DEnd.m_data[0]);
                                        dist_y = Math.abs(_2DStart.m_data[1] - _2DEnd.m_data[1]);
                                        errS_x = Math.abs((double)((int)Math.round(_2DStart.m_data[0])) - _2DStart.m_data[0]);
                                        errS_y = Math.abs((double)((int)Math.round(_2DStart.m_data[1])) - _2DStart.m_data[1]);
                                        errE_x = Math.abs((double)((int)Math.round(_2DEnd.m_data[0])) - _2DEnd.m_data[0]);
                                        errE_y = Math.abs((double)((int)Math.round(_2DEnd.m_data[1])) - _2DEnd.m_data[1]);
                                        if (!(errS_x < 1.0E-10) || !(errS_y < 1.0E-10) || !(errE_x < 1.0E-10) || !(errE_y < 1.0E-10 & k != size - 1)) break block32;
                                        tmp.addEntry(k + 1);
                                        interval.addElement(tmp);
                                        visitedElement[refElt].addEntry(indPol);
                                        visitedElement[refElt].addEntry(tmp.getSize() - 1);
                                        tmp = new PiVector();
                                        tmp.addEntry(k + 1);
                                        visitedElement[refElt].addEntry(++indPol + 1);
                                        visitedElement[refElt].addEntry(0);
                                        break block33;
                                    }
                                    if (!(dist_x < 1.0E-10) || !(dist_y < 1.0E-10)) {
                                        if (dist_x < 1.0E-10) {
                                            if (_2DStart.m_data[1] > _2DEnd.m_data[1]) {
                                                max = _2DStart.m_data[1];
                                                min = _2DEnd.m_data[1];
                                                max = _2DStart.m_data[1] == Math.floor(_2DStart.m_data[1]) ? (max -= 1.0) : Math.floor(_2DStart.m_data[1]);
                                                down = true;
                                            } else {
                                                min = _2DStart.m_data[1];
                                                max = _2DEnd.m_data[1];
                                                min = _2DStart.m_data[1] == Math.ceil(_2DStart.m_data[1]) ? (min += 1.0) : Math.ceil(_2DStart.m_data[1]);
                                                down = false;
                                            }
                                            while (min < max) {
                                                newVert = new PdBary(3);
                                                if (!down) {
                                                    PdBary.getBary((PdBary)newVert, (PdVector)new PdVector(_2DStart.m_data[0], min), (PdVector[])tex[refElt]);
                                                    min = Math.ceil(min + 0.5);
                                                } else {
                                                    PdBary.getBary((PdBary)newVert, (PdVector)new PdVector(_2DStart.m_data[0], max), (PdVector[])tex[refElt]);
                                                    max = Math.floor(max - 0.5);
                                                }
                                                tmp.addEntry(numVert);
                                                newVert.setElementInd(refElt);
                                                newVertex.addElement(newVert);
                                                interval.addElement(tmp);
                                                visitedElement[refElt].addEntry(indPol);
                                                visitedElement[refElt].addEntry(tmp.getSize() - 1);
                                                tmp = new PiVector();
                                                tmp.addEntry(numVert);
                                                visitedElement[refElt].addEntry(indPol + 1);
                                                visitedElement[refElt].addEntry(0);
                                                ++indPol;
                                                ++numVert;
                                            }
                                        } else if (dist_y < 1.0E-10) {
                                            if (_2DStart.m_data[0] > _2DEnd.m_data[0]) {
                                                max = _2DStart.m_data[0];
                                                min = _2DEnd.m_data[0];
                                                max = _2DStart.m_data[0] == Math.floor(_2DStart.m_data[0]) ? (max -= 1.0) : Math.floor(_2DStart.m_data[0]);
                                                down = true;
                                            } else {
                                                max = _2DEnd.m_data[0];
                                                min = _2DStart.m_data[0];
                                                min = _2DStart.m_data[0] == Math.ceil(_2DStart.m_data[0]) ? (min += 1.0) : Math.ceil(_2DStart.m_data[0]);
                                                down = false;
                                            }
                                            while (min < max) {
                                                newVert = new PdBary(3);
                                                if (!down) {
                                                    PdBary.getBary((PdBary)newVert, (PdVector)new PdVector(min, _2DStart.m_data[1]), (PdVector[])tex[refElt]);
                                                    min = Math.ceil(min + 0.5);
                                                } else {
                                                    PdBary.getBary((PdBary)newVert, (PdVector)new PdVector(max, _2DStart.m_data[1]), (PdVector[])tex[refElt]);
                                                    max = Math.floor(max - 0.5);
                                                }
                                                tmp.addEntry(numVert);
                                                newVert.setElementInd(refElt);
                                                newVertex.addElement(newVert);
                                                interval.addElement(tmp);
                                                visitedElement[refElt].addEntry(indPol);
                                                visitedElement[refElt].addEntry(tmp.getSize() - 1);
                                                tmp = new PiVector();
                                                tmp.addEntry(numVert);
                                                visitedElement[refElt].addEntry(indPol + 1);
                                                visitedElement[refElt].addEntry(0);
                                                ++indPol;
                                                ++numVert;
                                            }
                                        } else {
                                            ** GOTO lbl197
                                        }
                                    }
                                    break block34;
                                }
                                if (k == size - 1) {
                                    tmp.addEntry(size);
                                    interval.addElement(tmp);
                                    visitedElement[refElt].addEntry(indPol);
                                    visitedElement[refElt].addEntry(tmp.getSize() - 1);
                                    connectivity[singularity.m_data[1]].addEntry(indPol);
                                    connectivity[singularity.m_data[1]].addEntry(tmp.getSize() - 1);
                                    ++indPol;
                                }
                                if (size == 2) {
                                    PsDebug.message((String)tmp.toShortString());
                                }
                            }
                            ++k;
                        }
                        addnop = interval.size();
                        currnov = baseComplex.getNumVertices();
                        nov = curPol.getNumVertices();
                        newVert = newVertex.size();
                        baseComplex.setNumVertices(currnov + nov + newVert);
                        k = 0;
                        while (k < nov) {
                            baseComplex.setVertexBary(currnov + k, curPol.getVertexBary(k));
                            ++k;
                        }
                        k = 0;
                        while (k < newVert) {
                            baseComplex.setVertexBary(currnov + nov + k, (PdBary)newVertex.get(k));
                            ++k;
                        }
                        currnop = baseComplex.getNumPolygons();
                        baseComplex.setNumPolygons(currnop + addnop);
                        k = 0;
                        while (k < addnop) {
                            pol = (PiVector)interval.get(k);
                            pol.add(currnov);
                            baseComplex.setPolygon(currnop + k, pol);
                            ++k;
                        }
                    }
                    ++dir;
                }
                j += 2;
            }
            ++i;
        }
        m_geom.showElementTexture(false);
        if (isIntegrable) {
            PwBaseComplexParam.mergeAtInteger(baseComplex, connectivity, visitedElement, bp);
        }
    }

    private static void mergeAtInteger(PgPolygonSetOnElementSet sparseC, PiVector[] connectivity, PiVector[] visitedElement, PiVector bp) {
        int len;
        int size = bp.getSize();
        double eps = 1.0E-8;
        PiVector[] polygon = sparseC.getPolygons();
        int noe = sparseC.getGeometry().getNumElements();
        int i = 0;
        while (i < size) {
            PiVector adjPolToSing = connectivity[bp.m_data[i]];
            len = adjPolToSing.getSize();
            int vertIndex = polygon[adjPolToSing.m_data[0]].m_data[adjPolToSing.m_data[1]];
            int j = 2;
            while (j < len) {
                polygon[adjPolToSing.m_data[j]].m_data[adjPolToSing.m_data[j + 1]] = vertIndex;
                j += 2;
            }
            ++i;
        }
        i = 0;
        while (i < noe) {
            PiVector info = visitedElement[i];
            len = info.getSize();
            if (len == 4) {
                int pol1 = info.m_data[0];
                int pol2 = info.m_data[2];
                int locInd1 = info.m_data[1];
                int locInd2 = info.m_data[3];
                polygon[pol2].m_data[locInd2] = polygon[pol1].m_data[locInd1];
            } else {
                int j = 0;
                while (j < len) {
                    int currPol = info.m_data[j];
                    int locInd = info.m_data[j + 1];
                    PdVector currVertex = sparseC.getVertex(polygon[currPol].m_data[locInd]);
                    int k = 0;
                    while (k < len) {
                        if (k != j) {
                            int nextPol = info.m_data[k];
                            int nextlocInd = info.m_data[k + 1];
                            PdVector nextVertex = sparseC.getVertex(polygon[nextPol].m_data[nextlocInd]);
                            if (PdVector.subNew((PdVector)currVertex, (PdVector)nextVertex).length() < eps) {
                                polygon[nextPol].m_data[nextlocInd] = polygon[currPol].m_data[locInd];
                            }
                        }
                        k += 2;
                    }
                    j += 2;
                }
            }
            ++i;
        }
        sparseC.removeUnusedVertices();
        PwCleanMesh.joinPolygons((PgPolygonSet)sparseC);
    }

    public int getOppositeLocIndex(int indPatch, int locIndex) {
        if (this.m_patchNeighbor == null) {
            PsDebug.error((String)"Neighbor is not computed.");
            return -1;
        }
        return this.m_patchNeighbor[this.m_patchNeighbor[indPatch].m_data[locIndex]].getIndexOf(indPatch);
    }

    public PiVector[] getGlobalIndexOfVerticesOfPatch() {
        return this.m_vertPatch;
    }

    public void createSparseComplexPolygons() {
        if (this.m_geom.getCovering().getSymmetryOrder() != 4) {
            PsDebug.warning((String)"Sparse complex creation works only on 4-symmetric coverings!");
            return;
        }
        this.m_baseComplex.showPolygonColors(false);
        this.m_polygonsPerElement = new PdVector[this.m_geom.getNumElements()];
        int i = 0;
        while (i < this.m_geom.getNumElements()) {
            this.m_polygonsPerElement[i] = new PdVector();
            ++i;
        }
        PwParamSanitization.sanitizeParametrization(this.m_geom, this.m_geom.getElementTextures(), 1.0E-7);
        PiVector bp = this.m_geom.getCovering().getBranchPoints();
        PdVector[][] tex = this.m_geom.getElementTextures();
        int noe = this.m_geom.getNumElements();
        boolean[][] elementDir = new boolean[noe][2];
        int[] singVertexIndices = new int[bp.getSize()];
        int i2 = 0;
        while (i2 < bp.getSize()) {
            PiVector elems = PwBaseComplexParam.getElementWithVertex((PgElementSet)this.m_geom, bp.getEntry(i2));
            singVertexIndices[i2] = this.m_baseComplex.addVertex(this.m_geom.getVertex(bp.getEntry(i2)));
            int j = 0;
            while (j < elems.getSize()) {
                int curEl = elems.getEntry(j);
                int singLocIndex = elems.getEntry(j + 1);
                int dir = 0;
                while (dir <= 1) {
                    if (!elementDir[curEl][dir]) {
                        elementDir[curEl][dir] = true;
                        PgPolygonOnElementSet curPol = new PgPolygonOnElementSet((PgElementSet)this.m_geom);
                        PdVector bary = new PdVector(3);
                        bary.setEntry(singLocIndex, 1);
                        curPol.setNumVertices(1);
                        curPol.setVertexBary(0, new PdBary(curEl, bary.getEntry(0), bary.getEntry(1), bary.getEntry(2)));
                        if (PwBaseComplexParam.traceParameterLine(this.m_geom, curPol, curEl, (singLocIndex + 1) % 3, dir, tex[curEl][singLocIndex].getEntry(dir), elementDir, -1, this.m_baseComplex.getNumPolygons(), this.m_polygonsPerElement)) {
                            int pInd = this.m_baseComplex.addPolygonBary(curPol);
                            PwBaseComplexParam.cutPolygonsAlongPolygon(this.m_geom, this.m_baseComplex, this.m_neighbor, this.m_polygonsPerElement, pInd, 0);
                        }
                    }
                    ++dir;
                }
                j += 2;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < this.m_baseComplex.getNumPolygons()) {
            PiVector p1 = this.m_baseComplex.getPolygon(i2);
            PdVector b11 = this.m_baseComplex.getVertex(p1.getFirstEntry());
            PdVector b12 = this.m_baseComplex.getVertex(p1.getLastEntry());
            int j = 0;
            while (j < i2) {
                PiVector p2 = this.m_baseComplex.getPolygon(j);
                PdVector b21 = this.m_baseComplex.getVertex(p2.getFirstEntry());
                PdVector b22 = this.m_baseComplex.getVertex(p2.getLastEntry());
                if (PdVector.dist((PdVector)b11, (PdVector)b21) == 0.0) {
                    p1.setEntry(0, p2.getEntry(0));
                }
                if (PdVector.dist((PdVector)b12, (PdVector)b22) == 0.0) {
                    p1.setEntry(p1.getSize() - 1, p2.getEntry(p2.getSize() - 1));
                }
                if (PdVector.dist((PdVector)b12, (PdVector)b21) == 0.0) {
                    p1.setEntry(p1.getSize() - 1, p2.getEntry(0));
                }
                if (PdVector.dist((PdVector)b11, (PdVector)b22) == 0.0) {
                    p1.setEntry(0, p2.getEntry(p2.getSize() - 1));
                }
                ++j;
            }
            ++i2;
        }
        this.m_geom.showElementTexture(false);
        this.makeNeighbor();
    }

    public void setNeighbor(PiVector[][] neighbor) {
        this.m_neighbor = neighbor;
    }

    public PiVector[][] getNeighbors() {
        return this.m_neighbor;
    }

    public PiVector[] getNeighbor(int indPol) {
        if (this.m_neighbor[indPol] == null) {
            PsDebug.error((String)"Neighbor array is not generated ");
            return null;
        }
        return this.m_neighbor[indPol];
    }

    public void setStrip(PiVector[] strip) {
        if (strip.length != this.m_baseComplex.getNumPolygons()) {
            PsDebug.error((String)"Number of triangle run is not the same as the number of polygon");
            return;
        }
        this.m_strip = strip;
    }

    public void makePatchNeighbor() {
        if (this.m_patch == null) {
            this.makePatchConnectivity();
        }
        int numPatch = this.m_patch.length;
        int numPol = this.m_baseComplex.getNumPolygons();
        PiVector[] patchAdjToPol = new PiVector[numPol];
        PiVector.realloc((PiVector[])patchAdjToPol, (int)numPol, (int)0);
        int i = 0;
        while (i < numPatch) {
            int k = 0;
            while (k < this.m_patch[i].getSize()) {
                patchAdjToPol[this.m_patch[i].m_data[k]].addEntry(i);
                ++k;
            }
            ++i;
        }
        this.m_patchNeighbor = new PiVector[numPatch];
        i = 0;
        while (i < numPatch) {
            this.m_patchNeighbor[i] = new PiVector();
            int j = 0;
            while (j < this.m_patch[i].getSize()) {
                int indPatch = patchAdjToPol[this.m_patch[i].m_data[(j + 1) % this.m_patch[i].getSize()]].m_data[0];
                if (indPatch == i) {
                    indPatch = patchAdjToPol[this.m_patch[i].m_data[(j + 1) % this.m_patch[i].getSize()]].m_data[1];
                }
                this.m_patchNeighbor[i].addEntry(indPatch);
                ++j;
            }
            ++i;
        }
        this.m_hasPatchNeighbor = true;
    }

    public void makeLoopStripDual() {
        if (this.m_patchNeighbor == null) {
            this.makePatchNeighbor();
        }
        Vector loop = new Vector();
        int numPatch = this.m_patch.length;
        int nop = this.m_baseComplex.getNumPolygons();
        boolean[] visited = new boolean[nop];
        PiVector _loop = new PiVector(2);
        int polIndex = -1;
        int i = 0;
        while (i < numPatch) {
            int j = 0;
            while (j < 4) {
                Vector<PiVector> _tmp = new Vector<PiVector>();
                int currPatch = i;
                int locCurrIndex = j;
                polIndex = this.m_patch[currPatch].m_data[(locCurrIndex + 1) % 4];
                if (!visited[polIndex]) {
                    _loop.m_data[0] = currPatch;
                    _loop.m_data[1] = locCurrIndex;
                    _tmp.addElement((PiVector)_loop.clone());
                    visited[polIndex] = true;
                    int nextPatch = this.m_patchNeighbor[currPatch].m_data[locCurrIndex];
                    int locOppIndex = (this.getOppositeLocIndex(currPatch, locCurrIndex) + 2) % 4;
                    int nextPolygon = this.m_patch[nextPatch].m_data[(locOppIndex + 1) % 4];
                    int MAX_TRACE = 100;
                    int iteration = 0;
                    while (nextPolygon != polIndex && iteration < MAX_TRACE) {
                        _loop.m_data[0] = nextPatch;
                        _loop.m_data[1] = locOppIndex;
                        _tmp.addElement((PiVector)_loop.clone());
                        int _polIndex = this.m_patch[nextPatch].m_data[(locOppIndex + 1) % 4];
                        visited[_polIndex] = true;
                        currPatch = nextPatch;
                        locCurrIndex = locOppIndex;
                        nextPatch = this.m_patchNeighbor[currPatch].m_data[locCurrIndex];
                        locOppIndex = (this.getOppositeLocIndex(currPatch, locCurrIndex) + 2) % 4;
                        nextPolygon = this.m_patch[nextPatch].m_data[(locOppIndex + 1) % 4];
                        if (iteration + 1 > MAX_TRACE) {
                            PsDebug.error((String)"Strip loop exceed allowed maximal length");
                            break;
                        }
                        ++iteration;
                    }
                    loop.addElement(_tmp);
                }
                ++j;
            }
            ++i;
        }
        int len = loop.size();
        this.m_loop = new PiVector[len][];
        int i2 = 0;
        while (i2 < len) {
            int len1 = ((Vector)loop.get(i2)).size();
            this.m_loop[i2] = new PiVector[len1];
            int j = 0;
            while (j < len1) {
                this.m_loop[i2][j] = (PiVector)((Vector)loop.get(i2)).get(j);
                ++j;
            }
            ++i2;
        }
        this.m_hasPatchStrip = true;
    }

    public PiVector[][] getLoopStrip() {
        return this.m_loop;
    }

    public PiVector[] getPatch() {
        return this.m_patch;
    }

    public PiVector[] getPatchNeighbor() {
        return this.m_patchNeighbor;
    }

    public void makeConnectedStripFromPath(PgPolygonOnElementSet line, PiVector strip) {
        PgPolygonSetOnElementSet tmp = new PgPolygonSetOnElementSet(line.getGeometry());
        tmp.addPolygonBary(line);
        PwBaseComplexParam.makeConnectedStripFromPath(tmp, strip, 0);
    }

    public static void makeConnectedStripFromPath(PgPolygonSetOnElementSet line, PiVector strip, int indPol) {
        if (line == null || strip == null || indPol == -1) {
            PsDebug.error((String)"Geometry or strip is missing in makeConnectedStrip");
            return;
        }
        PgElementSet geom = line.getGeometry();
        if (geom == null) {
            PsDebug.error((String)"PolygonSet does not live on the geometry");
            return;
        }
        PiVector pol = line.getPolygon(indPol);
        int numVert = pol.getSize();
        if (strip.getSize() != 0) {
            int start = strip.getFirstEntry();
            int end = strip.getLastEntry();
            PwBary.makeBaryDescription((PgElementSet)geom, (PdBary)line.getVertexBary(pol.m_data[0]), (int)start, (double)1.0E-7);
            PwBary.makeBaryDescription((PgElementSet)geom, (PdBary)line.getVertexBary(pol.m_data[numVert - 1]), (int)end, (double)1.0E-7);
        }
        strip.setSize(0);
        PgVertexStar v1 = new PgVertexStar();
        PgVertexStar v2 = new PgVertexStar();
        int i = 0;
        while (i < numVert - 1) {
            int j;
            PiVector eltStar_2;
            int indNext;
            int indCurr;
            PdBary currVert = (PdBary)line.getVertexBary(pol.m_data[i]).clone();
            PdBary nextVert = (PdBary)line.getVertexBary(pol.m_data[i + 1]).clone();
            int currElt = line.getVertexElemInd(pol.m_data[i]);
            int nextElt = line.getVertexElemInd(pol.m_data[i + 1]);
            int currOnVertex = currVert.isOnVertex(1.0E-8);
            int nextOnVertex = nextVert.isOnVertex(1.0E-8);
            if (currOnVertex != -1) {
                if (currElt == nextElt || geom.getNeighbour(currElt).contains(nextElt)) {
                    if (strip.getSize() == 0 || strip.getLastEntry() != currElt) {
                        strip.addEntry(currElt);
                    }
                } else {
                    v1.makeVertexStar(geom, geom.getElement((int)currElt).m_data[currOnVertex], currElt);
                    PiVector eltStar_1 = v1.getElement();
                    indCurr = eltStar_1.getIndexOf(currElt);
                    eltStar_1.shift(-indCurr);
                    indNext = eltStar_1.getIndexOf(nextElt);
                    if (indNext == -1) {
                        if (nextOnVertex != -1) {
                            v2.makeVertexStar(geom, geom.getElement((int)nextElt).m_data[nextOnVertex], nextElt);
                            eltStar_2 = v2.getElement();
                            indNext = -1;
                            int j2 = 0;
                            while (j2 < eltStar_2.getSize()) {
                                indNext = eltStar_1.getIndexOf(eltStar_2.m_data[j2]);
                                if (indNext != -1) {
                                    nextElt = eltStar_1.m_data[indNext];
                                    if (!PwBary.makeBaryDescription((PgElementSet)geom, (PdBary)nextVert, (int)nextElt, (double)1.0E-7)) break;
                                    break;
                                }
                                ++j2;
                            }
                        } else {
                            PiVector neighbor = geom.getNeighbour(nextElt);
                            int j3 = 0;
                            while (j3 < neighbor.getSize()) {
                                indNext = eltStar_1.getIndexOf(neighbor.m_data[j3]);
                                if (indNext == -1 || !PwBary.makeBaryDescription((PgElementSet)geom, (PdBary)nextVert, (int)(nextElt = eltStar_1.m_data[indNext]), (double)1.0E-7)) {
                                    ++j3;
                                    continue;
                                }
                                break;
                            }
                        }
                        if (indNext == -1) {
                            PsDebug.error((String)"No neighbor has been found");
                            return;
                        }
                    }
                    PiVector invStar_1 = PiVector.copyNew((PiVector)eltStar_1);
                    invStar_1.invert();
                    invStar_1.shift(1);
                    int indInvNext = invStar_1.getIndexOf(nextElt);
                    PiVector star = eltStar_1;
                    if (indNext > indInvNext) {
                        star = invStar_1;
                        indNext = indInvNext;
                    }
                    j = 0;
                    while (j < indNext) {
                        if (strip.getSize() == 0 || strip.getLastEntry() != star.m_data[j]) {
                            strip.addEntry(star.m_data[j]);
                        }
                        ++j;
                    }
                }
            } else if (currElt == nextElt || geom.getNeighbour(currElt).contains(nextElt)) {
                if (strip.getSize() == 0 || strip.getLastEntry() != currElt) {
                    strip.addEntry(currElt);
                }
            } else if (nextOnVertex != -1) {
                v2.makeVertexStar(geom, geom.getElement((int)nextElt).m_data[nextOnVertex], nextElt);
                eltStar_2 = v2.getElement();
                indCurr = eltStar_2.getIndexOf(currElt);
                int indNbCurr = -1;
                int nbCurrElt = -1;
                if (indCurr == -1) {
                    PiVector neighbor = geom.getNeighbour(currElt);
                    j = 0;
                    while (j < neighbor.getSize()) {
                        indNbCurr = eltStar_2.getIndexOf(neighbor.m_data[j]);
                        if (indNbCurr != -1) {
                            nbCurrElt = eltStar_2.m_data[indNbCurr];
                            break;
                        }
                        ++j;
                    }
                    if (nbCurrElt == -1) {
                        PsDebug.error((String)"No neighbor has been found");
                        return;
                    }
                } else {
                    indNbCurr = indCurr;
                    nbCurrElt = currElt;
                }
                eltStar_2.shift(-indNbCurr);
                indNext = eltStar_2.getIndexOf(nextElt);
                PiVector invStar_2 = PiVector.copyNew((PiVector)eltStar_2);
                invStar_2.invert();
                invStar_2.shift(1);
                int indInvNext = invStar_2.getIndexOf(nextElt);
                PiVector star = eltStar_2;
                if (indNext > indInvNext) {
                    star = invStar_2;
                    indNext = indInvNext;
                }
                if (strip.getSize() == 0 || strip.getLastEntry() != currElt) {
                    strip.addEntry(currElt);
                }
                int j4 = 0;
                while (j4 < indNext) {
                    if (strip.getSize() == 0 || strip.getLastEntry() != star.m_data[j4]) {
                        strip.addEntry(star.m_data[j4]);
                    }
                    ++j4;
                }
            } else {
                PiVector nbh_1 = geom.getNeighbour(currElt);
                PiVector nbh_2 = geom.getNeighbour(nextElt);
                indNext = -1;
                int j5 = 0;
                while (j5 < nbh_2.getSize()) {
                    indNext = nbh_1.getIndexOf(nbh_2.m_data[j5]);
                    if (indNext != -1 && PwBary.makeBaryDescription((PgElementSet)geom, (PdBary)nextVert, (int)nbh_1.m_data[indNext], (double)1.0E-7)) break;
                    ++j5;
                }
                if (indNext == -1) {
                    PsDebug.error((String)"No neighbor has been found");
                    return;
                }
                if (strip.getSize() == 0 || strip.getLastEntry() != currElt) {
                    strip.addEntry(currElt);
                }
            }
            ++i;
        }
        if (strip.getSize() == 0 || strip.getLastEntry() != line.getVertexElemInd(pol.getLastEntry())) {
            strip.addEntry(line.getVertexElemInd(pol.getLastEntry()));
        }
    }

    public PiVector getLocIndexOfCommonVertex(int indPol_1, int indPol_2) {
        PiVector indCommonVert = new PiVector(2);
        if (this.m_neighbor == null) {
            this.makeLineNeighbor();
        }
        if (this.m_neighbor[indPol_1][0].contains(indPol_2)) {
            indCommonVert.m_data[0] = 0;
            indCommonVert.m_data[1] = this.m_neighbor[indPol_2][0].contains(indPol_1) ? 0 : this.m_baseComplex.getPolygon(indPol_2).getSize() - 1;
        } else if (this.m_neighbor[indPol_1][1].contains(indPol_2)) {
            indCommonVert.m_data[0] = this.m_baseComplex.getPolygon(indPol_1).getSize() - 1;
            indCommonVert.m_data[1] = this.m_neighbor[indPol_2][0].contains(indPol_1) ? 0 : this.m_baseComplex.getPolygon(indPol_2).getSize() - 1;
        } else {
            PsDebug.message((String)("Polygon " + indPol_1 + " and " + indPol_2 + " does not have a common vertex at"));
            return null;
        }
        return indCommonVert;
    }

    public PiVector[] makeStrip(PgPolygonSetOnElementSet baseComplex) {
        int nop = baseComplex.getNumPolygons();
        PiVector[] strip = new PiVector[nop];
        PiVector.realloc((PiVector[])strip, (int)nop, (int)0);
        int i = 0;
        while (i < nop) {
            PwBaseComplexParam.makeConnectedStripFromPath(this.m_baseComplex, strip[i], i);
            ++i;
        }
        return strip;
    }

    public PiVector[] makeStrip() {
        int nop = this.m_baseComplex.getNumPolygons();
        PiVector[] strip = new PiVector[nop];
        PiVector.realloc((PiVector[])strip, (int)nop, (int)0);
        int i = 0;
        while (i < nop) {
            PiVector pol = this.m_baseComplex.getPolygon(i);
            int size = pol.getSize();
            int j = 0;
            while (j < size - 1) {
                PdBary end;
                PdBary start = (PdBary)this.m_baseComplex.getVertexBary(pol.m_data[j]).clone();
                if (!PwBaseComplexParam.makeCommonBarycenctricDescription((PgElementSet)this.m_geom, start, end = (PdBary)this.m_baseComplex.getVertexBary(pol.m_data[j + 1]).clone(), 1.0E-8)) {
                    PsDebug.warning((String)"Does not succeed to make common barycentric");
                } else {
                    strip[i].addEntry(start.m_elementInd);
                }
                ++j;
            }
            ++i;
        }
        return strip;
    }

    public void makeLineNeighbor() {
        int nop = this.m_baseComplex.getNumPolygons();
        int nov = this.m_baseComplex.getNumVertices();
        PiVector[] polygon = this.m_baseComplex.getPolygons();
        PdVector[] vertex = this.m_baseComplex.getVertices();
        if (this.m_neighbor == null) {
            this.m_neighbor = new PiVector[nop][2];
        }
        if (this.m_strip == null) {
            this.m_strip = this.makeStrip();
        }
        if (!this.m_geom.hasVertexNormals()) {
            this.m_geom.makeVertexNormals();
        }
        PiVector[] adjToVert = new PiVector[nov];
        PiVector[] adjType = new PiVector[nov];
        PiVector.realloc((PiVector[])adjToVert, (int)nov, (int)0);
        PiVector.realloc((PiVector[])adjType, (int)nov, (int)0);
        int i = 0;
        while (i < nop) {
            adjToVert[polygon[i].m_data[0]].addEntry(i);
            adjType[polygon[i].m_data[0]].addEntry(0);
            adjToVert[polygon[i].getLastEntry()].addEntry(i);
            adjType[polygon[i].getLastEntry()].addEntry(polygon[i].getSize() - 1);
            ++i;
        }
        i = 0;
        while (i < nop) {
            int[] nArray = new int[2];
            nArray[1] = polygon[i].getSize() - 1;
            int[] nArray2 = nArray;
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int j = nArray2[n2];
                int indx = polygon[i].m_data[j];
                PiVector adj = adjToVert[indx];
                PiVector adjT = adjType[indx];
                PdBary node = this.m_baseComplex.getVertexBary(indx);
                int onVertex = node.isOnVertex(1.0E-7);
                int numAdj = adj.getSize();
                double[] alpha_s = new double[numAdj];
                PdVector normal = this.m_geom.getElementNormal(this.m_baseComplex.getVertexElemInd(indx));
                if (onVertex != -1) {
                    int geomIndx = this.m_geom.getElement((int)this.m_baseComplex.getVertexElemInd((int)indx)).m_data[onVertex];
                    normal = this.m_geom.getVertexNormal(geomIndx);
                }
                if (normal == null) {
                    PsDebug.error((String)"Missing vertex normal");
                    return;
                }
                normal.normalize();
                PdVector[] pvs = new PdVector[numAdj];
                PdVector[] dir_s = new PdVector[numAdj];
                int k = 0;
                while (k < numAdj) {
                    int indxAdj = adjT.m_data[k] == 0 ? 1 : adjT.m_data[k] - 1;
                    dir_s[k] = PdVector.subNew((PdVector)vertex[polygon[adj.m_data[k]].m_data[indxAdj]], (PdVector)vertex[indx]);
                    pvs[k] = new PdVector(3);
                    PuVectorGeom.projectOntoPlane((PdVector)pvs[k], (PdVector)dir_s[k], (PdVector)normal);
                    ++k;
                }
                PdVector dirEdge = PdVector.subNew((PdVector)vertex[polygon[i].m_data[j == 0 ? 1 : j - 1]], (PdVector)vertex[indx]);
                PuVectorGeom.projectOntoPlane((PdVector)dirEdge, (PdVector)normal);
                int k2 = 0;
                while (k2 < numAdj) {
                    alpha_s[k2] = PdVector.angleWithOrientation((PdVector)dirEdge, (PdVector)pvs[k2], (PdVector)normal);
                    if (alpha_s[k2] < 0.0) {
                        int n3 = k2;
                        alpha_s[n3] = alpha_s[n3] + Math.PI * 2;
                    }
                    ++k2;
                }
                int[] index = new int[numAdj];
                PuMath.heapsort((int)numAdj, (double[])alpha_s, (int[])index);
                PiVector sorted = new PiVector(numAdj);
                PiVector tmp = new PiVector(numAdj);
                int k3 = 0;
                while (k3 < numAdj) {
                    sorted.m_data[k3] = adj.m_data[index[k3]];
                    tmp.m_data[k3] = adjT.m_data[index[k3]];
                    ++k3;
                }
                adjToVert[indx].copy(sorted);
                adjT.copy(tmp);
                k3 = 0;
                while (k3 < numAdj) {
                    int next;
                    int curr;
                    int currIndex = k3;
                    int nextIndex = (k3 + 1) % numAdj;
                    if (Math.abs(alpha_s[currIndex] - alpha_s[nextIndex]) < 1.0E-10 && !this.isRight(this.m_baseComplex, this.m_strip, curr = adjToVert[indx].m_data[currIndex], next = adjToVert[indx].m_data[nextIndex], adjT.m_data[currIndex], adjT.m_data[nextIndex])) {
                        int d = next;
                        adjToVert[indx].m_data[nextIndex] = curr;
                        adjToVert[indx].m_data[currIndex] = d;
                        d = adjType[indx].m_data[nextIndex];
                        adjType[indx].m_data[nextIndex] = adjType[indx].m_data[currIndex];
                        adjType[indx].m_data[currIndex] = d;
                    }
                    ++k3;
                }
                this.m_neighbor[i][j == 0 ? 0 : 1] = PiVector.copyNew((PiVector)adj);
                ++n2;
            }
            ++i;
        }
    }

    public void makePatchConnectivity() {
        if (this.m_neighbor == null) {
            this.makeLineNeighbor();
        }
        Vector<PiVector> p = new Vector<PiVector>();
        Vector<PiVector> pIndx = new Vector<PiVector>();
        int nop = this.m_baseComplex.getNumPolygons();
        PiVector[] polygon = this.m_baseComplex.getPolygons();
        boolean[][] check = new boolean[nop][2];
        int MAX_SIDE = 6;
        int i = 0;
        while (i < nop) {
            int[] nArray = new int[2];
            nArray[1] = polygon[i].getSize() - 1;
            int[] endPoint = nArray;
            int j = 0;
            while (j < 2) {
                PiVector tmp = new PiVector();
                PiVector tmp1 = new PiVector();
                if (!check[i][j]) {
                    check[i][j] = true;
                    int endVert = polygon[i].m_data[endPoint[j]];
                    endPoint[j] = endPoint[j] == 0 ? 0 : 1;
                    int s = i;
                    int sn = this.m_neighbor[i][endPoint[j]].m_data[1];
                    tmp.addEntry(s);
                    tmp1.addEntry(endVert);
                    int count = 0;
                    while (sn != s && count < MAX_SIDE) {
                        tmp.addEntry(sn);
                        int indx = polygon[sn].getIndexOf(endVert);
                        if (indx == -1) {
                            PsDebug.error((String)"Neighbor is not right");
                            return;
                        }
                        endVert = indx == 0 ? polygon[sn].getLastEntry() : polygon[sn].getFirstEntry();
                        check[sn][indx == 0 ? 1 : 0] = true;
                        sn = this.m_neighbor[sn][indx == 0 ? 1 : 0].m_data[1];
                        tmp1.addEntry(endVert);
                        if (++count > MAX_SIDE) {
                            PsDebug.warning((String)"Non rectangular patch.");
                        }
                        if (count <= MAX_SIDE + 1) continue;
                        PsDebug.error((String)"Neighbor is not correct.");
                        return;
                    }
                    p.add(tmp);
                    pIndx.add(tmp1);
                }
                ++j;
            }
            ++i;
        }
        int numPatch = p.size();
        this.m_patch = new PiVector[numPatch];
        this.m_vertPatch = new PiVector[numPatch];
        int i2 = 0;
        while (i2 < numPatch) {
            this.m_patch[i2] = (PiVector)p.get(i2);
            this.m_vertPatch[i2] = (PiVector)pIndx.get(i2);
            this.m_patch[i2].invert();
            this.m_vertPatch[i2].invert();
            ++i2;
        }
        this.m_edgeOrientation = new boolean[numPatch][];
        int i3 = 0;
        while (i3 < numPatch) {
            int size = this.m_patch[i3].getSize();
            this.m_edgeOrientation[i3] = new boolean[size];
            int j = 0;
            while (j < size) {
                int c = this.m_patch[i3].m_data[j];
                int cn = this.m_patch[i3].m_data[(j + 1) % size];
                PiVector comonVert = this.getLocIndexOfCommonVertex(c, cn);
                if (comonVert != null) {
                    this.m_edgeOrientation[i3][(j + 1) % size] = comonVert.m_data[1] == 0;
                }
                ++j;
            }
            ++i3;
        }
        this.m_hasPatchConnectivity = true;
    }

    public static boolean traceParameterLine(PgParamGeom geom, PgPolygonOnElementSet poly, int element, int vOpp, int constCoord, double niveau, boolean[][] elementDir, int endAtElement, int addAtIndex, PdVector[] polygonsPerElement) {
        boolean success;
        int v1 = (vOpp + 1) % 3;
        int v2 = (vOpp + 2) % 3;
        PdVector[][] tex = geom.getElementTextures();
        int v = -1;
        int newElement = -1;
        int vOppNew = -1;
        int thirdV = -1;
        int locInd = -1;
        if (Math.abs(tex[element][vOpp].getEntry(constCoord) - niveau) < 1.0E-8) {
            locInd = vOpp;
        } else if (Math.abs(tex[element][v1].getEntry(constCoord) - niveau) < 1.0E-8) {
            locInd = v1;
        }
        if (locInd != -1 && PuMath.modulo((int)geom.getCovering().getBranchType(geom.getElement(element).getEntry(locInd)), (int)geom.getCovering().getSymmetryOrder()) != 0) {
            PdVector bary = new PdVector(3);
            bary.setEntry(locInd, 1);
            bary.setEntry((locInd + 1) % 3, 0);
            bary.setEntry((locInd + 2) % 3, 0);
            poly.setNumVertices(poly.getNumVertices() + 1);
            poly.setVertexBary(poly.getNumVertices() - 1, new PdBary(element, bary.getEntry(0), bary.getEntry(1), bary.getEntry(2)));
            if (elementDir != null) {
                elementDir[element][constCoord] = true;
            }
            return true;
        }
        if (Math.signum((tex[element][vOpp].getEntry(constCoord) - niveau) * (tex[element][v1].getEntry(constCoord) - niveau)) <= 0.0) {
            v = v1;
            vOppNew = geom.getOppVertexLocInd(element, v2);
            newElement = geom.getNeighbour(element).getEntry(v2);
            thirdV = v2;
        } else if (Math.signum((tex[element][vOpp].getEntry(constCoord) - niveau) * (tex[element][v2].getEntry(constCoord) - niveau)) < 0.0) {
            v = v2;
            vOppNew = geom.getOppVertexLocInd(element, v1);
            newElement = geom.getNeighbour(element).getEntry(v1);
            thirdV = v1;
        } else {
            return false;
        }
        double val1 = tex[element][v].getEntry(constCoord) - niveau;
        double val2 = tex[element][vOpp].getEntry(constCoord) - niveau;
        if (val1 > 0.0) {
            double temp = val1;
            val1 = val2;
            val2 = temp;
            int tempInd = vOpp;
            vOpp = v;
            v = tempInd;
        }
        double a = -val1 / (val2 - val1);
        PdBary bary = new PdBary(3);
        bary.setEntry(v, 1.0 - a);
        bary.setEntry(vOpp, a);
        bary.setEntry(thirdV, 0.0);
        bary.setElementInd(element);
        poly.setNumVertices(poly.getNumVertices() + 1);
        poly.setVertexBary(poly.getNumVertices() - 1, bary);
        if (newElement == endAtElement) {
            if (poly.getVertexBary(0).getElementInd() == endAtElement) {
                PdVector curPos = new PdVector(3);
                PdVector[] curEl = geom.getElementVertices(bary.getElementInd());
                bary.getVertex(curPos, curEl[0], curEl[1], curEl[2]);
                PdVector[] nextEl = geom.getElementVertices(newElement);
                PdBary lastV = new PdBary(3);
                PdBary.getBary((PdBary)lastV, (PdVector)curPos, (PdVector[])nextEl);
                lastV.setElementInd(newElement);
                poly.setNumVertices(poly.getNumVertices() + 1);
                poly.setVertexBary(poly.getNumVertices() - 1, lastV);
                poly.setClosed(true);
            }
            return true;
        }
        int[] mutLocV = PmAntiSpiraler.getMutualVertex((PgElementSet)geom, element, newElement);
        int matching = geom.getCovering().getMatching(element, thirdV);
        PdVector coords = PdVector.copyNew((PdVector)tex[element][mutLocV[0]]);
        PdVector newCoords = PdVector.copyNew((PdVector)tex[newElement][mutLocV[1]]);
        newCoords = PmAntiSpiraler.quarterRotationRight(newCoords, matching);
        PdVector gap = PdVector.subNew((PdVector)newCoords, (PdVector)coords);
        PdVector niveauNew = new PdVector(2);
        niveauNew.setEntry(constCoord, niveau);
        niveauNew.add(gap);
        niveauNew = PmAntiSpiraler.quarterRotationLeft(niveauNew, matching);
        if (PuMath.modulo((int)matching, (int)2) == 1) {
            int n = constCoord = constCoord == 1 ? 0 : 1;
        }
        if (success = PwBaseComplexParam.traceParameterLine(geom, poly, newElement, vOppNew, constCoord, niveauNew.getEntry(constCoord), elementDir, endAtElement, addAtIndex, polygonsPerElement)) {
            int j = 0;
            while (j < polygonsPerElement[element].getSize()) {
                if (polygonsPerElement[element].getEntry(j) == (double)addAtIndex && polygonsPerElement[element].getEntry(j + 1) == (double)constCoord) {
                    return true;
                }
                j += 3;
            }
            polygonsPerElement[element].addEntry((double)addAtIndex);
            polygonsPerElement[element].addEntry((double)constCoord);
            polygonsPerElement[element].addEntry(niveau);
            return true;
        }
        return false;
    }

    public static boolean traceParameterLine(PgParamGeom geom, PgPolygonOnElementSet poly, int element, int vOpp, int constCoord, double niveau, boolean[][] elementDir) {
        return PwBaseComplexParam.traceParameterLine(geom, poly, element, vOpp, constCoord, niveau, elementDir, -1, -1, null);
    }

    public static boolean traceParameterLine(PgParamGeom geom, PgPolygonOnElementSet poly, int element, int vOpp, int constCoord, double niveau, int endAtElement, int addAtIndex, PdVector[] polygonsPerElement) {
        return PwBaseComplexParam.traceParameterLine(geom, poly, element, vOpp, constCoord, niveau, null, endAtElement, addAtIndex, polygonsPerElement);
    }

    public static int isInsideEdge(PdBary v, double eps) {
        int numZero = 0;
        int numNonZero = 0;
        int indZero = -1;
        int i = 0;
        while (i < 3) {
            if (Math.abs(v.m_data[i]) < eps) {
                indZero = i;
                ++numZero;
            } else {
                ++numNonZero;
            }
            ++i;
        }
        if (numZero == 1 && numNonZero == 2) {
            return indZero;
        }
        return -1;
    }

    public static boolean makeCommonBarycenctricDescription(PgElementSet geom, PdBary node, PdBary nextNode, double eps) {
        if (geom == null) {
            PsDebug.error((String)"Missing geometry");
            return false;
        }
        if (node == null || nextNode == null) {
            PsDebug.error((String)"Missing barycentric information");
            return false;
        }
        if (node.m_elementInd == -1 || nextNode.m_elementInd == -1) {
            PsDebug.error((String)"Missing element index");
            return false;
        }
        if (node.m_elementInd == nextNode.m_elementInd) {
            return true;
        }
        int nElt = node.m_elementInd;
        int nnElt = nextNode.m_elementInd;
        if (nElt == nnElt) {
            return true;
        }
        boolean isTriangle = true;
        if (geom.getDimOfElements() == 4) {
            isTriangle = false;
        }
        int nIndVert = node.isOnVertex(eps);
        int nnIndVert = nextNode.isOnVertex(eps);
        int indCommonElt = -1;
        boolean bNode = false;
        boolean bNextNode = false;
        if (nIndVert != -1) {
            PiVector neighborArray;
            int indVert = geom.getElement((int)nElt).m_data[nIndVert];
            PgVertexStar starNode = new PgVertexStar();
            starNode.makeVertexStar(geom, indVert, nElt);
            PiVector nodeEltStar = starNode.getElement();
            int indNextInStar = nodeEltStar.getIndexOf(nnElt);
            if (indNextInStar != -1) {
                if (isTriangle) {
                    return PwBary.makeBaryDescription((PgElementSet)geom, (PdBary)node, (int)nnElt, (double)eps);
                }
                return PwBaseComplexParam.makeBaryDescriptionQuad(geom, node, nnElt, eps);
            }
            if (nnIndVert == -1) {
                neighborArray = geom.getNeighbour(nnElt);
            } else {
                int indNextVert = geom.getElement((int)nnElt).m_data[nnIndVert];
                PgVertexStar starNextNode = new PgVertexStar();
                starNextNode.makeVertexStar(geom, indNextVert, nnElt);
                neighborArray = starNextNode.getElement();
            }
            int i = 0;
            while (i < neighborArray.getSize()) {
                indCommonElt = nodeEltStar.getIndexOf(neighborArray.m_data[i]);
                if (indCommonElt != -1) break;
                ++i;
            }
            if (indCommonElt == -1) {
                PsDebug.error((String)"Cannot find a common element");
                return false;
            }
            if (isTriangle) {
                bNode = PwBary.makeBaryDescription((PgElementSet)geom, (PdBary)node, (int)nodeEltStar.m_data[indCommonElt], (double)eps);
                bNextNode = PwBary.makeBaryDescription((PgElementSet)geom, (PdBary)nextNode, (int)nodeEltStar.m_data[indCommonElt], (double)eps);
            } else {
                bNode = PwBaseComplexParam.makeBaryDescriptionQuad(geom, node, nodeEltStar.m_data[indCommonElt], eps);
                bNextNode = PwBaseComplexParam.makeBaryDescriptionQuad(geom, nextNode, nodeEltStar.m_data[indCommonElt], eps);
            }
            return bNode && bNextNode;
        }
        int nOnEdge = -1;
        nOnEdge = isTriangle ? PwBaseComplexParam.isInsideEdge(node, eps) : PwBaseComplexParam.isInsideEdgeQuad(node, eps);
        if (nOnEdge != -1) {
            PiVector neighborArray;
            PiVector neighborNode = geom.getNeighbour(nElt);
            indCommonElt = neighborNode.getIndexOf(nnElt);
            if (indCommonElt != -1) {
                if (isTriangle) {
                    bNode = PwBary.makeBaryDescription((PgElementSet)geom, (PdBary)node, (int)nnElt, (double)eps);
                    if (!bNode) {
                        bNode = true;
                        bNextNode = PwBary.makeBaryDescription((PgElementSet)geom, (PdBary)nextNode, (int)nElt, (double)eps);
                        return bNextNode;
                    }
                } else {
                    bNode = PwBaseComplexParam.makeBaryDescriptionQuad(geom, node, nnElt, eps);
                    if (!bNode) {
                        bNode = true;
                        bNextNode = PwBaseComplexParam.makeBaryDescriptionQuad(geom, nextNode, nElt, eps);
                        return bNextNode;
                    }
                }
                return bNode;
            }
            if (nnIndVert != -1) {
                int indNextVert = geom.getElement((int)nnElt).m_data[nnIndVert];
                PgVertexStar starNextNode = new PgVertexStar();
                starNextNode.makeVertexStar(geom, indNextVert, nnElt);
                neighborArray = starNextNode.getElement();
            } else {
                neighborArray = geom.getNeighbour(nnElt);
            }
            if (neighborArray.contains(nElt)) {
                bNextNode = isTriangle ? PwBary.makeBaryDescription((PgElementSet)geom, (PdBary)nextNode, (int)nElt, (double)eps) : PwBaseComplexParam.makeBaryDescriptionQuad(geom, nextNode, nElt, eps);
                return bNextNode;
            }
            int i = 0;
            while (i < neighborArray.getSize()) {
                indCommonElt = neighborNode.getIndexOf(neighborArray.m_data[i]);
                if (indCommonElt != -1) {
                    if (isTriangle) {
                        bNode = PwBary.makeBaryDescription((PgElementSet)geom, (PdBary)node, (int)neighborNode.m_data[indCommonElt], (double)eps);
                        bNextNode = PwBary.makeBaryDescription((PgElementSet)geom, (PdBary)nextNode, (int)neighborNode.m_data[indCommonElt], (double)eps);
                    } else {
                        bNode = PwBaseComplexParam.makeBaryDescriptionQuad(geom, node, neighborNode.m_data[indCommonElt], eps);
                        bNextNode = PwBaseComplexParam.makeBaryDescriptionQuad(geom, nextNode, neighborNode.m_data[indCommonElt], eps);
                    }
                    if (bNode && bNextNode) {
                        return bNode && bNextNode;
                    }
                }
                ++i;
            }
            return bNode && bNextNode;
        }
        if (isTriangle) {
            return PwBary.makeBaryDescription((PgElementSet)geom, (PdBary)nextNode, (int)nElt, (double)eps);
        }
        return PwBaseComplexParam.makeBaryDescriptionQuad(geom, nextNode, nElt, eps);
    }

    public static int isInsideEdgeQuad(PdBary node, double eps) {
        if (node.isOnEdge(1.0E-10) == -1) {
            return -1;
        }
        int i = 0;
        while (i < 4) {
            if (node.m_data[i] <= eps && node.m_data[i] >= -eps && node.m_data[(i + 1) % 4] > eps) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static boolean makeBaryDescriptionQuad(PgElementSet geom, PdBary bary, int newElement, double eps) {
        if (bary.getElementInd() == newElement) {
            return true;
        }
        int locV = bary.isOnVertex(eps);
        if (locV >= 0) {
            PiVector element = geom.getElement(bary.getElementInd());
            int v = element.m_data[locV];
            PiVector nElement = geom.getElement(newElement);
            int newLocV = nElement.getIndexOf(v);
            if (newLocV < 0) {
                return false;
            }
            int i = 0;
            while (i < bary.getSize()) {
                bary.m_data[i] = 0.0;
                ++i;
            }
            bary.m_data[newLocV] = 1.0;
            bary.m_elementInd = newElement;
            return true;
        }
        int locEdge = PwBaseComplexParam.isInsideEdgeQuad(bary, eps);
        if (locEdge >= 0) {
            PiVector neigh = geom.getNeighbour(bary.getElementInd());
            int ne = neigh.m_data[locEdge];
            if (ne != newElement) {
                return false;
            }
            int indexOpp = geom.getOppVertexLocInd(bary.getElementInd(), locEdge);
            double tmp1 = bary.m_data[(locEdge + 1) % 4];
            double tmp2 = bary.m_data[(locEdge + 2) % 4];
            bary.m_data[indexOpp] = 0.0;
            bary.m_data[(indexOpp + 1) % 4] = tmp2;
            bary.m_data[(indexOpp + 2) % 4] = tmp1;
            bary.m_data[(indexOpp + 3) % 4] = 0.0;
            bary.m_elementInd = newElement;
            return true;
        }
        return false;
    }

    public static PiVector getElementWithVertex(PgElementSet geom, int vertexInd) {
        PiVector elems = new PiVector(0);
        int numElements = geom.getNumElements();
        int i = 0;
        while (i < numElements) {
            int j = 0;
            while (j < geom.getElement(i).getSize()) {
                if (geom.getElement(i).getEntry(j) == vertexInd) {
                    elems.addEntry(i);
                    elems.addEntry(j);
                }
                ++j;
            }
            ++i;
        }
        return elems;
    }

    public void localGeodesicStraighting(PgPolygonSetOnElementSet sc, PiVector strip, int indPol) {
        PiVector polygon = sc.getPolygon(indPol);
        PgElementSet geom = sc.getGeometry();
        PgPolygonOnElementSet newPoly = new PgPolygonOnElementSet(geom);
        PdBary start = PdBary.copyNew((PdBary)sc.getVertexBary(polygon.m_data[0]));
        PdBary end = PdBary.copyNew((PdBary)sc.getVertexBary(polygon.getLastEntry()));
        int eltStart = start.m_elementInd;
        int eltEnd = end.m_elementInd;
        if (eltStart != strip.m_data[0]) {
            eltStart = strip.m_data[0];
            PwBary.makeBaryDescription((PgElementSet)geom, (PdBary)start, (int)eltStart, (double)0.0);
        }
        if (eltEnd != strip.m_data[strip.getSize() - 1]) {
            eltEnd = strip.m_data[strip.getSize() - 1];
            PwBary.makeBaryDescription((PgElementSet)geom, (PdBary)end, (int)eltEnd, (double)0.0);
        }
        PwGeodesic.getShortest((PgElementSet)geom, (PdBary)start, (int)eltStart, (PdBary)end, (int)eltEnd, (PiVector)strip, (PgPolygonOnElementSet)newPoly);
        int nov = sc.getNumVertices();
        int numPolyVert = newPoly.getNumVertices();
        int newnov = nov + numPolyVert - 2;
        sc.setNumVertices(newnov);
        PiVector polIndex = new PiVector(numPolyVert);
        int i = 1;
        while (i < numPolyVert - 1) {
            sc.setVertexBary(nov + i - 1, newPoly.getVertexBary(i));
            polIndex.m_data[i] = nov + i - 1;
            ++i;
        }
        polIndex.m_data[0] = polygon.m_data[0];
        polIndex.m_data[numPolyVert - 1] = polygon.getLastEntry();
        sc.setPolygon(indPol, polIndex);
        strip = new PiVector(numPolyVert);
        i = 0;
        while (i < numPolyVert) {
            strip.m_data[i] = newPoly.getVertexElemInd(i);
            ++i;
        }
    }

    public void localFrameAlignGeodesicStraighting(PgParamGeom geom, PuTransitionFunction[][] transition, PgPolygonSetOnElementSet line, PiVector strip, int indPol, PiVector singularityIndex) {
        if (geom == null) {
            PsDebug.error((String)"Missing parametrized geometry");
            return;
        }
        if (line == null) {
            PsDebug.error((String)"Missing polygonal line");
            return;
        }
        if (strip == null) {
            PsDebug.error((String)"Missing strip");
            return;
        }
        if (indPol < 0) {
            PsDebug.error((String)"Negative index");
            return;
        }
        PiVector polygon = line.getPolygon(indPol);
        PgPolygonOnElementSet newPoly = new PgPolygonOnElementSet((PgElementSet)geom);
        PdBary start = PdBary.copyNew((PdBary)line.getVertexBary(polygon.m_data[0]));
        PdBary end = PdBary.copyNew((PdBary)line.getVertexBary(polygon.getLastEntry()));
        int eltStart = start.m_elementInd;
        int eltEnd = end.m_elementInd;
        if (strip.getSize() != 0) {
            int i;
            int[] extraStrip;
            if (eltStart != strip.m_data[0]) {
                extraStrip = PwGeodesic.getConnectingStrip((PgElementSet)geom, (int)strip.m_data[0], (int)eltStart);
                strip.invert();
                i = 1;
                while (i < extraStrip.length) {
                    strip.addEntry(extraStrip[i]);
                    ++i;
                }
                strip.invert();
            }
            if (eltEnd != strip.getLastEntry()) {
                extraStrip = PwGeodesic.getConnectingStrip((PgElementSet)geom, (int)strip.getLastEntry(), (int)eltEnd);
                i = 1;
                while (i < extraStrip.length) {
                    strip.addEntry(extraStrip[i]);
                    ++i;
                }
            }
        }
        PgElementSet stripInDisco = new PgElementSet(3);
        PwBaseComplexParam.getShortest((PgElementSet)geom, transition, start, eltStart, end, eltEnd, strip, newPoly, stripInDisco, null, null, null, null, null, null, null, null, indPol, false, null, singularityIndex);
        if (newPoly.getNumVertices() == 0) {
            return;
        }
        int nov = line.getNumVertices();
        int numPolyVert = newPoly.getNumVertices();
        int newnov = nov + numPolyVert - 2;
        line.setNumVertices(newnov);
        PiVector polIndex = new PiVector(numPolyVert);
        int i = 1;
        while (i < numPolyVert - 1) {
            line.setVertexBary(nov + i - 1, newPoly.getVertexBary(i));
            polIndex.m_data[i] = nov + i - 1;
            ++i;
        }
        polIndex.m_data[0] = polygon.m_data[0];
        polIndex.m_data[numPolyVert - 1] = polygon.getLastEntry();
        line.setPolygon(indPol, polIndex);
        PwBaseComplexParam.makeConnectedStripFromPath(line, strip, indPol);
    }

    /*
     * Unable to fully structure code
     */
    public static PgPolygonOnElementSet getShortest(PgParamGeom geom, PuTransitionFunction[][] transition, PdBary start, int startelem, PdBary end, int endelem, PiVector trianglerun, PgPolygonOnElementSet outpoly, PgElementSet unfolded, PgPolygon twoDpolygon, PiVector vertexlist, PiVector left, PiVector right, PdVector previous, PdVector next, PdVector t2d, PdBary tempbary, int indPol, boolean keepSingularity, PuBoolean isThroughSingularity) {
        if (geom == null) {
            PsDebug.warning((String)"Missing geometry.");
            return null;
        }
        if (geom.getDimOfElements() != 3) {
            PsDebug.warning((String)"No valid geometry.");
            return null;
        }
        if (start == null || end == null) {
            PsDebug.warning((String)"missing PdBary argument.");
            return null;
        }
        noe = geom.getNumElements();
        nov = geom.getNumVertices();
        if (endelem >= noe || startelem >= noe || startelem < 0 || endelem < 0) {
            PsDebug.warning((String)("No valid start and/or end element,start=" + startelem + ",end=" + endelem + "."));
            return null;
        }
        if (trianglerun == null || trianglerun.getSize() == 0 || trianglerun.m_data[0] != startelem || trianglerun.m_data[trianglerun.getSize() - 1] != endelem) {
            strip = PwGeodesic.getConnectingStrip((PgElementSet)geom, (int)startelem, (int)endelem);
            if (strip == null || strip.length == 0) {
                PsDebug.error((String)"Could not find a way at all.");
                return null;
            }
            trianglerun = new PiVector(strip);
        }
        if (unfolded == null) {
            unfolded = new PgElementSet(3);
        }
        if (outpoly == null) {
            outpoly = new PgPolygonOnElementSet((PgElementSet)geom);
        }
        elem = geom.getElements();
        runlength = trianglerun.getSize();
        if (runlength == 1) {
            outpoly.setNumVertices(2);
            outpoly.setVertexBary(0, startelem, start);
            outpoly.setVertexBary(1, endelem, end);
            return outpoly;
        }
        _index = new PiVector();
        bEndit = false;
        count = 0;
        MAXCOUNT = 5 * nov;
        if (left == null) {
            left = new PiVector();
        }
        if (right == null) {
            right = new PiVector();
        }
        if (previous == null) {
            previous = new PdVector(2);
        }
        previous.setSize(2);
        if (next == null) {
            next = new PdVector(2);
        }
        next.setSize(2);
        if (t2d == null) {
            t2d = new PdVector(2);
        }
        t2d.setSize(2);
        if (tempbary == null) {
            tempbary = new PdBary(3);
        }
        tempbary.setSize(3);
        unoe = -1;
        uvert = null;
        uelem = null;
        star = new PgVertexStar();
        itemp = new PiVector();
        unModified = new PgElementSet(3);
        startVert = start.isOnVertex(1.0E-8);
        endVert = end.isOnVertex(1.0E-8);
        if (startVert != -1) {
            startVert = geom.getElement((int)startelem).m_data[startVert];
        }
        if (endVert != -1) {
            endVert = geom.getElement((int)startelem).m_data[endVert];
        }
        while (!bEndit) {
            endelem = PwBaseComplexParam.findLastElementInStrip(end, endelem, trianglerun, elem);
            startelem = PwBaseComplexParam.findFirstElementInStrip(start, startelem, trianglerun, elem);
            if (trianglerun.getSize() == 1) {
                outpoly.setNumVertices(2);
                outpoly.setVertexBary(0, startelem, start);
                outpoly.setVertexBary(1, endelem, end);
                return outpoly;
            }
            if (++count > MAXCOUNT) {
                PsDebug.error((String)"Caught in loop.");
            }
            if (count > MAXCOUNT + 1) {
                return null;
            }
            trianglerun = PwBaseComplexParam.makeUnfoldedStripInDisco((PgElementSet)geom, transition, trianglerun, unfolded, left, right);
            unModified = new PgElementSet(3);
            unModified.copy((PsObject)unfolded);
            if (trianglerun == null) {
                return null;
            }
            uvert = unfolded.getVertices();
            unoe = unfolded.getNumElements();
            uelem = unfolded.getElements();
            start.getVertex(uvert[left.m_data[0]], uvert[uelem[0].m_data[0]], uvert[uelem[0].m_data[1]], uvert[uelem[0].m_data[2]]);
            end.getVertex(uvert[left.m_data[left.getSize() - 1]], uvert[uelem[unoe - 1].m_data[0]], uvert[uelem[unoe - 1].m_data[1]], uvert[uelem[unoe - 1].m_data[2]]);
            vertexlist = PwGeodesic.getShortestInUnfoldedTriangleRun((PgElementSet)unfolded, (PiVector)left, (PiVector)right, (PiVector)vertexlist);
            numvert = vertexlist.getSize() - 2;
            bEndit = true;
            act = 1;
            i = 0;
            while (i < numvert && bEndit) {
                block58: {
                    block59: {
                        a = vertexlist.m_data[i] >= 0 ? left.m_data[vertexlist.m_data[i]] : right.m_data[-vertexlist.m_data[i]];
                        index = vertexlist.m_data[act];
                        if (index >= 0) {
                            leftside = true;
                        } else {
                            leftside = false;
                            index = -index;
                        }
                        b = leftside != false ? left.m_data[index] : right.m_data[index];
                        c = vertexlist.m_data[i + 2] >= 0 ? left.m_data[vertexlist.m_data[i + 2]] : right.m_data[-vertexlist.m_data[i + 2]];
                        firstelemind = index;
                        firstelem = trianglerun.m_data[--firstelemind];
                        locvertind = -1;
                        k = 0;
                        while (k < 3) {
                            if (uelem[firstelemind].m_data[k] == b) {
                                locvertind = k;
                                break;
                            }
                            ++k;
                        }
                        star.makeVertexStar((PgElementSet)geom, elem[firstelem].m_data[locvertind], firstelem);
                        isClosed = star.isClosed();
                        if (geom.getCovering().getBranchType(elem[firstelem].m_data[locvertind]) != 0 && keepSingularity) {
                            isClosed = false;
                            if (isThroughSingularity != null) {
                                isThroughSingularity.setState(true);
                            }
                        }
                        if (!isClosed) break block58;
                        eltTex = geom.getElementTextures();
                        corner_p = star.getElement();
                        locIndexInStar = star.getVertexLocInd();
                        previous.sub(uvert[a], uvert[b]);
                        next.sub(uvert[c], uvert[b]);
                        angle = PdVector.angle((PdVector)previous, (PdVector)next) / 180.0 * 3.141592653589793;
                        eps = 1.0E-8;
                        if (leftside) {
                            if (previous.m_data[0] * next.m_data[1] - previous.m_data[1] * next.m_data[0] < -eps) {
                                angle = 6.283185307179586 - angle;
                            }
                        } else if (next.m_data[0] * previous.m_data[1] - next.m_data[1] * previous.m_data[0] < -eps) {
                            angle = 6.283185307179586 - angle;
                        }
                        vertexangle = 0.0;
                        j = 0;
                        while (j < locIndexInStar.getSize()) {
                            dir1 = PdVector.subNew((PdVector)eltTex[corner_p.m_data[j]][(locIndexInStar.m_data[j] + 1) % 3], (PdVector)eltTex[corner_p.m_data[j]][locIndexInStar.m_data[j]]);
                            dir2 = PdVector.subNew((PdVector)eltTex[corner_p.m_data[j]][(locIndexInStar.m_data[j] + 2) % 3], (PdVector)eltTex[corner_p.m_data[j]][locIndexInStar.m_data[j]]);
                            vertexangle = dir1.m_data[0] * dir2.m_data[1] - dir1.m_data[1] * dir2.m_data[0] < -eps ? (vertexangle -= PdVector.angle((PdVector)dir1, (PdVector)dir2)) : (vertexangle += PdVector.angle((PdVector)dir1, (PdVector)dir2));
                            ++j;
                        }
                        vertexangle *= 0.017453292519943295;
                        lastelemind = firstelemind;
                        if (!leftside) ** GOTO lbl153
                        while (lastelemind < unoe && left.m_data[lastelemind + 1] == left.m_data[firstelemind + 1]) {
                            ++lastelemind;
                        }
                        break block59;
lbl-1000:
                        // 1 sources

                        {
                            ++lastelemind;
lbl153:
                            // 2 sources

                            ** while (lastelemind < unoe && right.m_data[lastelemind + 1] == right.m_data[firstelemind + 1])
                        }
                    }
                    lastelem = trianglerun.m_data[lastelemind];
                    size = star.getSize();
                    defekt = vertexangle - angle;
                    if (defekt < 3.141592653589793 - eps || (double)(lastelemind - firstelemind + 1) > (double)size + eps) {
                        bEndit = false;
                        otherlen = 0;
                        tmp = null;
                        if (lastelemind - firstelemind + 1 <= size) {
                            starelem = star.getElement();
                            tmp = new int[size];
                            ind = 0;
                            do {
                                ind = leftside ? --ind : ++ind;
                                if (ind < 0) {
                                    ind += size;
                                } else if (ind >= size) {
                                    ind -= size;
                                }
                                tmp[otherlen] = starelem.m_data[ind];
                                ++otherlen;
                            } while (starelem.m_data[ind] != lastelem);
                            newsize = unoe - (size - --otherlen) + otherlen + 2;
                        } else {
                            newsize = unoe - size;
                        }
                        itemp.setSize(newsize);
                        System.arraycopy(trianglerun.m_data, 0, itemp.m_data, 0, firstelemind + 1);
                        if (lastelemind - firstelemind + 1 <= size) {
                            System.arraycopy(tmp, 0, itemp.m_data, firstelemind + 1, otherlen);
                            System.arraycopy(trianglerun.m_data, lastelemind, itemp.m_data, firstelemind + otherlen + 1, unoe - lastelemind);
                        } else {
                            System.arraycopy(trianglerun.m_data, firstelemind + size + 1, itemp.m_data, firstelemind + 1, unoe - firstelemind - 1 - size);
                        }
                        trianglerun.setSize(newsize);
                        trianglerun.copy(itemp);
                    }
                }
                ++act;
                ++i;
            }
        }
        outpoly.setGeometry((PgElementSet)geom);
        check = new PgPolygon(2);
        check.setNumVertices(unoe + 1);
        vertex = new PdVector[unoe + 1];
        PdVector.realloc((PdVector[])vertex, (int)(unoe + 1), (int)2);
        pos = unModified.getElementVertices(0);
        start.getVertex(vertex[0], pos[0], pos[1], pos[2]);
        check.setVertex(0, vertex[0]);
        _index.setSize(unoe + 1);
        _index.m_data[0] = startelem;
        outpoly.setNumVertices(unoe + 1);
        outpoly.setVertexBary(0, startelem, start);
        numv = 1;
        diag = 1;
        size = vertexlist.getSize();
        prevVertIndex = left.m_data[0];
        thisVertIndex = -1;
        i = 1;
        while (i < size) {
            block60: {
                index = vertexlist.m_data[i];
                if (index < 0) {
                    index = -index;
                    leftside = false;
                } else {
                    leftside = true;
                }
                thisVertIndex = leftside != false ? left.m_data[index] : right.m_data[index];
                next.sub(uvert[thisVertIndex], uvert[prevVertIndex]);
                next.normalize();
                while (diag < index) {
                    previous.sub(uvert[left.m_data[diag]], uvert[right.m_data[diag]]);
                    diagLen = previous.length();
                    if (diagLen < 1.0E-10) {
                        PsDebug.error((String)"Geometry degenerated");
                        return null;
                    }
                    previous.multScalar(1.0 / diagLen);
                    s = PuVectorGeom.intersectionOfLineAndLine((PdVector)t2d, (PdVector)uvert[right.m_data[diag]], (PdVector)previous, (PdVector)uvert[prevVertIndex], (PdVector)next);
                    s /= diagLen;
                    locindex = -1;
                    diagvert = left.m_data[diag] != left.m_data[diag + 1] ? left.m_data[diag + 1] : right.m_data[diag + 1];
                    k = 0;
                    while (k < 3) {
                        if (uelem[diag].m_data[k] == diagvert) {
                            locindex = k;
                            break;
                        }
                        ++k;
                    }
                    tempbary.m_data[locindex] = 0.0;
                    tempbary.m_data[(locindex + 1) % 3] = s;
                    tempbary.m_data[(locindex + 2) % 3] = 1.0 - s;
                    pos = unModified.getElementVertices(diag);
                    tempbary.getVertex(vertex[numv], pos[0], pos[1], pos[2]);
                    check.setVertex(numv, vertex[numv]);
                    outpoly.setVertexBary(numv, trianglerun.m_data[diag], tempbary);
                    _index.m_data[numv] = trianglerun.m_data[diag];
                    ++numv;
                    ++diag;
                }
                if (!leftside) ** GOTO lbl265
                while (index < unoe && left.m_data[index] == left.m_data[index + 1]) {
                    ++index;
                }
                break block60;
lbl-1000:
                // 1 sources

                {
                    ++index;
lbl265:
                    // 2 sources

                    ** while (index < unoe && right.m_data[index] == right.m_data[index + 1])
                }
            }
            if (index >= unoe) {
                index = unoe - 1;
            }
            diag = index + 1;
            locindex = -1;
            k = 0;
            while (k < 3) {
                if (uelem[index].m_data[k] == thisVertIndex) {
                    locindex = k;
                    break;
                }
                ++k;
            }
            tempbary.copy(PdBary.TRIANGLE_VERTEX[locindex]);
            pos = unModified.getElementVertices(index);
            tempbary.getVertex(vertex[numv], pos[0], pos[1], pos[2]);
            check.setVertex(numv, vertex[numv]);
            outpoly.setVertexBary(numv, trianglerun.m_data[index], tempbary);
            _index.m_data[numv] = trianglerun.m_data[index];
            ++numv;
            prevVertIndex = thisVertIndex;
            ++i;
        }
        pos = unfolded.getElementVertices(unfolded.getNumElements() - 1);
        tempbary.getVertex(vertex[numv - 1], pos[0], pos[1], pos[2]);
        check.setVertex(numv - 1, vertex[numv - 1]);
        outpoly.setVertexBary(numv - 1, endelem, end);
        _index.m_data[numv - 1] = endelem;
        _index.setSize(numv);
        outpoly.setNumVertices(numv);
        check.setNumVertices(numv);
        if (twoDpolygon != null) {
            twoDpolygon.copy((PsObject)check);
        }
        return outpoly;
    }

    /*
     * Unable to fully structure code
     */
    public static PgPolygonOnElementSet getShortest(PgElementSet geom, PuTransitionFunction[][] transition, PdBary start, int startelem, PdBary end, int endelem, PiVector trianglerun, PgPolygonOnElementSet outpoly, PgElementSet unfolded, PgPolygon twoDpolygon, PiVector vertexlist, PiVector left, PiVector right, PdVector previous, PdVector next, PdVector t2d, PdBary tempbary, int indPol, boolean keepSingularity, PuBoolean isThroughSingularity, PiVector singularityIndex) {
        if (geom == null) {
            PsDebug.warning((String)"Missing geometry.");
            return null;
        }
        if (geom.getDimOfElements() != 3) {
            PsDebug.warning((String)"No valid geometry.");
            return null;
        }
        if (start == null || end == null) {
            PsDebug.warning((String)"missing PdBary argument.");
            return null;
        }
        noe = geom.getNumElements();
        nov = geom.getNumVertices();
        if (endelem >= noe || startelem >= noe || startelem < 0 || endelem < 0) {
            PsDebug.warning((String)("No valid start and/or end element,start=" + startelem + ",end=" + endelem + "."));
            return null;
        }
        if (trianglerun == null || trianglerun.getSize() == 0 || trianglerun.m_data[0] != startelem || trianglerun.m_data[trianglerun.getSize() - 1] != endelem) {
            strip = PwGeodesic.getConnectingStrip((PgElementSet)geom, (int)startelem, (int)endelem);
            if (strip == null || strip.length == 0) {
                PsDebug.error((String)"Could not find a way at all.");
                return null;
            }
            trianglerun = new PiVector(strip);
        }
        if (unfolded == null) {
            unfolded = new PgElementSet(3);
        }
        if (outpoly == null) {
            outpoly = new PgPolygonOnElementSet(geom);
        }
        elem = geom.getElements();
        runlength = trianglerun.getSize();
        if (runlength == 1) {
            outpoly.setNumVertices(2);
            outpoly.setVertexBary(0, startelem, start);
            outpoly.setVertexBary(1, endelem, end);
            return outpoly;
        }
        _index = new PiVector();
        bEndit = false;
        count = 0;
        MAXCOUNT = 5 * nov;
        if (left == null) {
            left = new PiVector();
        }
        if (right == null) {
            right = new PiVector();
        }
        if (previous == null) {
            previous = new PdVector(2);
        }
        previous.setSize(2);
        if (next == null) {
            next = new PdVector(2);
        }
        next.setSize(2);
        if (t2d == null) {
            t2d = new PdVector(2);
        }
        t2d.setSize(2);
        if (tempbary == null) {
            tempbary = new PdBary(3);
        }
        tempbary.setSize(3);
        unoe = -1;
        uvert = null;
        uelem = null;
        star = new PgVertexStar();
        itemp = new PiVector();
        unModified = new PgElementSet(3);
        startVert = start.isOnVertex(1.0E-8);
        endVert = end.isOnVertex(1.0E-8);
        if (startVert != -1) {
            startVert = geom.getElement((int)startelem).m_data[startVert];
        }
        if (endVert != -1) {
            endVert = geom.getElement((int)startelem).m_data[endVert];
        }
        while (!bEndit) {
            endelem = PwBaseComplexParam.findLastElementInStrip(end, endelem, trianglerun, elem);
            startelem = PwBaseComplexParam.findFirstElementInStrip(start, startelem, trianglerun, elem);
            if (trianglerun.getSize() == 1) {
                outpoly.setNumVertices(2);
                outpoly.setVertexBary(0, startelem, start);
                outpoly.setVertexBary(1, endelem, end);
                return outpoly;
            }
            if (++count > MAXCOUNT) {
                PsDebug.error((String)"Caught in loop.");
            }
            if (count > MAXCOUNT + 1) break;
            trianglerun = PwBaseComplexParam.makeUnfoldedStripInDisco(geom, transition, trianglerun, unfolded, left, right);
            unModified = new PgElementSet(3);
            unModified.copy((PsObject)unfolded);
            if (trianglerun == null) {
                return null;
            }
            uvert = unfolded.getVertices();
            unoe = unfolded.getNumElements();
            uelem = unfolded.getElements();
            start.getVertex(uvert[left.m_data[0]], uvert[uelem[0].m_data[0]], uvert[uelem[0].m_data[1]], uvert[uelem[0].m_data[2]]);
            end.getVertex(uvert[left.m_data[left.getSize() - 1]], uvert[uelem[unoe - 1].m_data[0]], uvert[uelem[unoe - 1].m_data[1]], uvert[uelem[unoe - 1].m_data[2]]);
            vertexlist = PwGeodesic.getShortestInUnfoldedTriangleRun((PgElementSet)unfolded, (PiVector)left, (PiVector)right, (PiVector)vertexlist);
            numvert = vertexlist.getSize() - 2;
            bEndit = true;
            act = 1;
            i = 0;
            while (i < numvert && bEndit) {
                block57: {
                    block58: {
                        a = vertexlist.m_data[i] >= 0 ? left.m_data[vertexlist.m_data[i]] : right.m_data[-vertexlist.m_data[i]];
                        index = vertexlist.m_data[act];
                        if (index >= 0) {
                            leftside = true;
                        } else {
                            leftside = false;
                            index = -index;
                        }
                        b = leftside != false ? left.m_data[index] : right.m_data[index];
                        c = vertexlist.m_data[i + 2] >= 0 ? left.m_data[vertexlist.m_data[i + 2]] : right.m_data[-vertexlist.m_data[i + 2]];
                        firstelemind = index;
                        firstelem = trianglerun.m_data[--firstelemind];
                        locvertind = -1;
                        k = 0;
                        while (k < 3) {
                            if (uelem[firstelemind].m_data[k] == b) {
                                locvertind = k;
                                break;
                            }
                            ++k;
                        }
                        star.makeVertexStar(geom, elem[firstelem].m_data[locvertind], firstelem);
                        isClosed = star.isClosed();
                        if (singularityIndex != null && singularityIndex.getIndexOf(elem[firstelem].m_data[locvertind]) != -1 && keepSingularity) {
                            isClosed = false;
                            if (isThroughSingularity != null) {
                                isThroughSingularity.setState(true);
                            }
                        }
                        if (!isClosed) break block57;
                        eltTex = geom.getElementTextures();
                        corner_p = star.getElement();
                        locIndexInStar = star.getVertexLocInd();
                        previous.sub(uvert[a], uvert[b]);
                        next.sub(uvert[c], uvert[b]);
                        angle = PdVector.angle((PdVector)previous, (PdVector)next) / 180.0 * 3.141592653589793;
                        eps = 1.0E-8;
                        if (leftside) {
                            if (previous.m_data[0] * next.m_data[1] - previous.m_data[1] * next.m_data[0] < -eps) {
                                angle = 6.283185307179586 - angle;
                            }
                        } else if (next.m_data[0] * previous.m_data[1] - next.m_data[1] * previous.m_data[0] < -eps) {
                            angle = 6.283185307179586 - angle;
                        }
                        vertexangle = 0.0;
                        j = 0;
                        while (j < locIndexInStar.getSize()) {
                            dir1 = PdVector.subNew((PdVector)eltTex[corner_p.m_data[j]][(locIndexInStar.m_data[j] + 1) % 3], (PdVector)eltTex[corner_p.m_data[j]][locIndexInStar.m_data[j]]);
                            dir2 = PdVector.subNew((PdVector)eltTex[corner_p.m_data[j]][(locIndexInStar.m_data[j] + 2) % 3], (PdVector)eltTex[corner_p.m_data[j]][locIndexInStar.m_data[j]]);
                            vertexangle = dir1.m_data[0] * dir2.m_data[1] - dir1.m_data[1] * dir2.m_data[0] < -eps ? (vertexangle -= PdVector.angle((PdVector)dir1, (PdVector)dir2)) : (vertexangle += PdVector.angle((PdVector)dir1, (PdVector)dir2));
                            ++j;
                        }
                        vertexangle *= 0.017453292519943295;
                        lastelemind = firstelemind;
                        if (!leftside) ** GOTO lbl152
                        while (lastelemind < unoe && left.m_data[lastelemind + 1] == left.m_data[firstelemind + 1]) {
                            ++lastelemind;
                        }
                        break block58;
lbl-1000:
                        // 1 sources

                        {
                            ++lastelemind;
lbl152:
                            // 2 sources

                            ** while (lastelemind < unoe && right.m_data[lastelemind + 1] == right.m_data[firstelemind + 1])
                        }
                    }
                    lastelem = trianglerun.m_data[lastelemind];
                    size = star.getSize();
                    defekt = vertexangle - angle;
                    if (defekt < 3.141592653589793 - eps || (double)(lastelemind - firstelemind + 1) > (double)size + eps) {
                        bEndit = false;
                        otherlen = 0;
                        tmp = null;
                        if (lastelemind - firstelemind + 1 <= size) {
                            starelem = star.getElement();
                            tmp = new int[size];
                            ind = 0;
                            do {
                                ind = leftside ? --ind : ++ind;
                                if (ind < 0) {
                                    ind += size;
                                } else if (ind >= size) {
                                    ind -= size;
                                }
                                tmp[otherlen] = starelem.m_data[ind];
                                ++otherlen;
                            } while (starelem.m_data[ind] != lastelem);
                            newsize = unoe - (size - --otherlen) + otherlen + 2;
                        } else {
                            newsize = unoe - size;
                        }
                        itemp.setSize(newsize);
                        System.arraycopy(trianglerun.m_data, 0, itemp.m_data, 0, firstelemind + 1);
                        if (lastelemind - firstelemind + 1 <= size) {
                            System.arraycopy(tmp, 0, itemp.m_data, firstelemind + 1, otherlen);
                            System.arraycopy(trianglerun.m_data, lastelemind, itemp.m_data, firstelemind + otherlen + 1, unoe - lastelemind);
                        } else {
                            System.arraycopy(trianglerun.m_data, firstelemind + size + 1, itemp.m_data, firstelemind + 1, unoe - firstelemind - 1 - size);
                        }
                        trianglerun.setSize(newsize);
                        trianglerun.copy(itemp);
                    }
                }
                ++act;
                ++i;
            }
        }
        outpoly.setGeometry(geom);
        check = new PgPolygon(2);
        check.setNumVertices(unoe + 1);
        vertex = new PdVector[unoe + 1];
        PdVector.realloc((PdVector[])vertex, (int)(unoe + 1), (int)2);
        pos = unModified.getElementVertices(0);
        start.getVertex(vertex[0], pos[0], pos[1], pos[2]);
        check.setVertex(0, vertex[0]);
        _index.setSize(unoe + 1);
        _index.m_data[0] = startelem;
        outpoly.setNumVertices(unoe + 1);
        outpoly.setVertexBary(0, startelem, start);
        numv = 1;
        diag = 1;
        size = vertexlist.getSize();
        prevVertIndex = left.m_data[0];
        thisVertIndex = -1;
        i = 1;
        while (i < size) {
            block59: {
                index = vertexlist.m_data[i];
                if (index < 0) {
                    index = -index;
                    leftside = false;
                } else {
                    leftside = true;
                }
                thisVertIndex = leftside != false ? left.m_data[index] : right.m_data[index];
                next.sub(uvert[thisVertIndex], uvert[prevVertIndex]);
                next.normalize();
                while (diag < index) {
                    previous.sub(uvert[left.m_data[diag]], uvert[right.m_data[diag]]);
                    diagLen = previous.length();
                    if (diagLen < 1.0E-10) {
                        PsDebug.error((String)"Geometry degenerated");
                        return null;
                    }
                    previous.multScalar(1.0 / diagLen);
                    s = PuVectorGeom.intersectionOfLineAndLine((PdVector)t2d, (PdVector)uvert[right.m_data[diag]], (PdVector)previous, (PdVector)uvert[prevVertIndex], (PdVector)next);
                    s /= diagLen;
                    locindex = -1;
                    diagvert = left.m_data[diag] != left.m_data[diag + 1] ? left.m_data[diag + 1] : right.m_data[diag + 1];
                    k = 0;
                    while (k < 3) {
                        if (uelem[diag].m_data[k] == diagvert) {
                            locindex = k;
                            break;
                        }
                        ++k;
                    }
                    tempbary.m_data[locindex] = 0.0;
                    tempbary.m_data[(locindex + 1) % 3] = s;
                    tempbary.m_data[(locindex + 2) % 3] = 1.0 - s;
                    pos = unModified.getElementVertices(diag);
                    tempbary.getVertex(vertex[numv], pos[0], pos[1], pos[2]);
                    check.setVertex(numv, vertex[numv]);
                    outpoly.setVertexBary(numv, trianglerun.m_data[diag], tempbary);
                    _index.m_data[numv] = trianglerun.m_data[diag];
                    ++numv;
                    ++diag;
                }
                if (!leftside) ** GOTO lbl264
                while (index < unoe && left.m_data[index] == left.m_data[index + 1]) {
                    ++index;
                }
                break block59;
lbl-1000:
                // 1 sources

                {
                    ++index;
lbl264:
                    // 2 sources

                    ** while (index < unoe && right.m_data[index] == right.m_data[index + 1])
                }
            }
            if (index >= unoe) {
                index = unoe - 1;
            }
            diag = index + 1;
            locindex = -1;
            k = 0;
            while (k < 3) {
                if (uelem[index].m_data[k] == thisVertIndex) {
                    locindex = k;
                    break;
                }
                ++k;
            }
            tempbary.copy(PdBary.TRIANGLE_VERTEX[locindex]);
            pos = unModified.getElementVertices(index);
            tempbary.getVertex(vertex[numv], pos[0], pos[1], pos[2]);
            check.setVertex(numv, vertex[numv]);
            outpoly.setVertexBary(numv, trianglerun.m_data[index], tempbary);
            _index.m_data[numv] = trianglerun.m_data[index];
            ++numv;
            prevVertIndex = thisVertIndex;
            ++i;
        }
        pos = unfolded.getElementVertices(unfolded.getNumElements() - 1);
        tempbary.getVertex(vertex[numv - 1], pos[0], pos[1], pos[2]);
        check.setVertex(numv - 1, vertex[numv - 1]);
        outpoly.setVertexBary(numv - 1, endelem, end);
        _index.m_data[numv - 1] = endelem;
        _index.setSize(numv);
        outpoly.setNumVertices(numv);
        check.setNumVertices(numv);
        if (twoDpolygon != null) {
            twoDpolygon.copy((PsObject)check);
        }
        return outpoly;
    }

    /*
     * Unable to fully structure code
     */
    public static PgPolygonOnElementSet getShortestInStrip(PgParamGeom geom, PuTransitionFunction[][] transition, PdBary start, int startelem, PdBary end, int endelem, PiVector trianglerun, PgPolygonOnElementSet outpoly, PgPolygon twoDPolygon) {
        if (geom == null) {
            PsDebug.warning((String)"Missing geometry.");
            return null;
        }
        if (geom.getDimOfElements() != 3) {
            PsDebug.warning((String)"No valid geometry.");
            return null;
        }
        if (start == null || end == null) {
            PsDebug.warning((String)"missing PdBary argument.");
            return null;
        }
        noe = geom.getNumElements();
        if (endelem >= noe || startelem >= noe || startelem < 0 || endelem < 0) {
            PsDebug.warning((String)("No valid start and/or end element,start=" + startelem + ",end=" + endelem + "."));
            return null;
        }
        if (trianglerun == null || trianglerun.getSize() == 0 || trianglerun.m_data[0] != startelem || trianglerun.m_data[trianglerun.getSize() - 1] != endelem) {
            strip = PwGeodesic.getConnectingStrip((PgElementSet)geom, (int)startelem, (int)endelem);
            if (strip == null || strip.length == 0) {
                PsDebug.error((String)"Could not find a way at all.");
                return null;
            }
            trianglerun = new PiVector(strip);
        }
        unfolded = new PgElementSet(3);
        if (outpoly == null) {
            outpoly = new PgPolygonOnElementSet((PgElementSet)geom);
        }
        elem = geom.getElements();
        runlength = trianglerun.getSize();
        tex = geom.getElementTextures();
        if (runlength == 1) {
            outpoly.setNumVertices(2);
            outpoly.setVertexBary(0, startelem, start);
            outpoly.setVertexBary(1, endelem, end);
            if (twoDPolygon != null) {
                twoDPolygon.setNumVertices(2);
                vert = twoDPolygon.getVertices();
                start.getVertex(vert[0], tex[trianglerun.m_data[0]][0], tex[trianglerun.m_data[0]][1], tex[trianglerun.m_data[0]][2]);
                end.getVertex(vert[1], tex[trianglerun.m_data[0]][0], tex[trianglerun.m_data[0]][1], tex[trianglerun.m_data[0]][2]);
            }
            return outpoly;
        }
        _index = new PiVector();
        left = new PiVector();
        right = new PiVector();
        previous = new PdVector(2);
        previous.setSize(2);
        next = new PdVector(2);
        next.setSize(2);
        t2d = new PdVector(2);
        t2d.setSize(2);
        tempbary = new PdBary(3);
        tempbary.setSize(3);
        unoe = -1;
        uvert = null;
        uelem = null;
        vertexlist = null;
        unModified = new PgElementSet(3);
        startVert = start.isOnVertex(1.0E-8);
        endVert = end.isOnVertex(1.0E-8);
        if (startVert != -1) {
            startVert = geom.getElement((int)startelem).m_data[startVert];
        }
        if (endVert != -1) {
            endVert = geom.getElement((int)startelem).m_data[endVert];
        }
        endelem = PwBaseComplexParam.findLastElementInStrip(end, endelem, trianglerun, elem);
        startelem = PwBaseComplexParam.findFirstElementInStrip(start, startelem, trianglerun, elem);
        if (trianglerun.getSize() == 1) {
            outpoly.setNumVertices(2);
            outpoly.setVertexBary(0, startelem, start);
            outpoly.setVertexBary(1, endelem, end);
            return outpoly;
        }
        trianglerun = PwBaseComplexParam.makeUnfoldedStripInDisco((PgElementSet)geom, transition, trianglerun, unfolded, left, right);
        unModified = new PgElementSet(3);
        unModified.copy((PsObject)unfolded);
        if (trianglerun == null) {
            return null;
        }
        uvert = unfolded.getVertices();
        unoe = unfolded.getNumElements();
        uelem = unfolded.getElements();
        start.getVertex(uvert[left.m_data[0]], uvert[uelem[0].m_data[0]], uvert[uelem[0].m_data[1]], uvert[uelem[0].m_data[2]]);
        end.getVertex(uvert[left.m_data[left.getSize() - 1]], uvert[uelem[unoe - 1].m_data[0]], uvert[uelem[unoe - 1].m_data[1]], uvert[uelem[unoe - 1].m_data[2]]);
        vertexlist = PwGeodesic.getShortestInUnfoldedTriangleRun((PgElementSet)unfolded, (PiVector)left, (PiVector)right, vertexlist);
        outpoly.setGeometry((PgElementSet)geom);
        check = new PgPolygon(3);
        check.setNumVertices(unoe + 1);
        vertex = new PdVector[unoe + 1];
        PdVector.realloc((PdVector[])vertex, (int)(unoe + 1), (int)2);
        pos = unModified.getElementVertices(0);
        start.getVertex(vertex[0], pos[0], pos[1], pos[2]);
        check.setVertex(0, vertex[0]);
        _index.setSize(unoe + 1);
        _index.m_data[0] = startelem;
        outpoly.setNumVertices(unoe + 1);
        outpoly.setVertexBary(0, startelem, start);
        numv = 1;
        diag = 1;
        size = vertexlist.getSize();
        prevVertIndex = left.m_data[0];
        thisVertIndex = -1;
        i = 1;
        while (i < size) {
            block26: {
                index = vertexlist.m_data[i];
                if (index < 0) {
                    index = -index;
                    leftside = false;
                } else {
                    leftside = true;
                }
                thisVertIndex = leftside != false ? left.m_data[index] : right.m_data[index];
                next.sub(uvert[thisVertIndex], uvert[prevVertIndex]);
                next.normalize();
                while (diag < index) {
                    previous.sub(uvert[left.m_data[diag]], uvert[right.m_data[diag]]);
                    diagLen = previous.length();
                    if (diagLen < 1.0E-10) {
                        PsDebug.error((String)"Geometry degenerated");
                        return null;
                    }
                    previous.multScalar(1.0 / diagLen);
                    s = PuVectorGeom.intersectionOfLineAndLine((PdVector)t2d, (PdVector)uvert[right.m_data[diag]], (PdVector)previous, (PdVector)uvert[prevVertIndex], (PdVector)next);
                    s /= diagLen;
                    locindex = -1;
                    diagvert = left.m_data[diag] != left.m_data[diag + 1] ? left.m_data[diag + 1] : right.m_data[diag + 1];
                    k = 0;
                    while (k < 3) {
                        if (uelem[diag].m_data[k] == diagvert) {
                            locindex = k;
                            break;
                        }
                        ++k;
                    }
                    tempbary.m_data[locindex] = 0.0;
                    tempbary.m_data[(locindex + 1) % 3] = s;
                    tempbary.m_data[(locindex + 2) % 3] = 1.0 - s;
                    pos = unModified.getElementVertices(diag);
                    tempbary.getVertex(vertex[numv], pos[0], pos[1], pos[2]);
                    check.setVertex(numv, vertex[numv]);
                    outpoly.setVertexBary(numv, trianglerun.m_data[diag], tempbary);
                    _index.m_data[numv] = trianglerun.m_data[diag];
                    ++numv;
                    ++diag;
                }
                if (!leftside) ** GOTO lbl154
                while (index < unoe && left.m_data[index] == left.m_data[index + 1]) {
                    ++index;
                }
                break block26;
lbl-1000:
                // 1 sources

                {
                    ++index;
lbl154:
                    // 2 sources

                    ** while (index < unoe && right.m_data[index] == right.m_data[index + 1])
                }
            }
            if (index >= unoe) {
                index = unoe - 1;
            }
            diag = index + 1;
            locindex = -1;
            k = 0;
            while (k < 3) {
                if (uelem[index].m_data[k] == thisVertIndex) {
                    locindex = k;
                    break;
                }
                ++k;
            }
            tempbary.copy(PdBary.TRIANGLE_VERTEX[locindex]);
            pos = unModified.getElementVertices(index);
            tempbary.getVertex(vertex[numv], pos[0], pos[1], pos[2]);
            check.setVertex(numv, vertex[numv]);
            outpoly.setVertexBary(numv, trianglerun.m_data[index], tempbary);
            _index.m_data[numv] = trianglerun.m_data[index];
            ++numv;
            prevVertIndex = thisVertIndex;
            ++i;
        }
        pos = unfolded.getElementVertices(unfolded.getNumElements() - 1);
        tempbary.getVertex(vertex[numv - 1], pos[0], pos[1], pos[2]);
        check.setVertex(numv - 1, vertex[numv - 1]);
        outpoly.setVertexBary(numv - 1, endelem, end);
        _index.m_data[numv - 1] = endelem;
        _index.setSize(numv);
        outpoly.setNumVertices(numv);
        check.setNumVertices(numv);
        if (twoDPolygon != null) {
            twoDPolygon.copy((PsObject)check);
        }
        return outpoly;
    }

    public static PiVector makeUnfoldedStripInDisco(PgElementSet geom, PuTransitionFunction[][] g, PiVector run, PgElementSet unfolded, PiVector left, PiVector right) {
        PdVector[][] disco = geom.getElementTextures();
        PiVector[] elem = geom.getElements();
        PiVector[] neighb = geom.getNeighbours();
        int noe = run.getSize();
        int nov = noe + 2;
        if (left == null) {
            left = new PiVector();
        }
        if (right == null) {
            right = new PiVector();
        }
        left.setSize(noe + 1);
        right.setSize(noe + 1);
        int boundsize = 0;
        if (unfolded == null) {
            unfolded = new PgElementSet(2);
        }
        unfolded.setDimOfVertices(2);
        PgElementSet u = new PgElementSet(3);
        u.setNumElements(noe);
        u.setNumVertices(3 * noe);
        unfolded.setNumElements(noe);
        unfolded.setNumVertices(nov);
        unfolded.setDimOfElements(3);
        PdVector[] uvert = unfolded.getVertices();
        PiVector[] uelem = unfolded.getElements();
        int currentElem = run.m_data[0];
        int i = 0;
        while (i < 3) {
            unfolded.setVertex(i, disco[currentElem][i]);
            u.setVertex(i, disco[currentElem][i]);
            ++i;
        }
        unfolded.setElement(0, 0, 1, 2);
        u.setElement(0, 0, 1, 2);
        unfolded.getElement(0).setName("" + currentElem);
        int index = 1;
        int vindex = 3;
        int previousElem = -1;
        int localIndex = -1;
        int localOppIndex = -1;
        int previousAddedVertexInGeom = -1;
        PuTransitionFunction tmp = PuTransitionFunction.identity();
        int i2 = 1;
        while (i2 < noe) {
            int prepreviousElem = previousElem;
            previousElem = currentElem;
            currentElem = run.m_data[i2];
            if (currentElem == prepreviousElem) {
                --vindex;
                currentElem = prepreviousElem;
                previousElem = --index - 2 >= 0 ? run.m_data[index - 2] : -1;
                --boundsize;
                if (index < 2) {
                    previousAddedVertexInGeom = -1;
                } else {
                    int tmpind = left.m_data[boundsize] == left.m_data[boundsize - 1] ? right.m_data[boundsize] : left.m_data[boundsize];
                    int j = 0;
                    while (j < 3) {
                        if (uelem[index - 1].m_data[j] == tmpind) {
                            tmpind = j;
                            break;
                        }
                        ++j;
                    }
                    previousAddedVertexInGeom = elem[currentElem].m_data[tmpind];
                }
            } else {
                run.m_data[index] = run.m_data[i2];
                localIndex = -1;
                int n = neighb[previousElem].getSize();
                int j = 0;
                while (j < n) {
                    if (neighb[previousElem].m_data[j] == currentElem) {
                        localIndex = j;
                        localOppIndex = geom.getOppVertexLocInd(previousElem, localIndex);
                    }
                    ++j;
                }
                if (localIndex < 0) {
                    PsDebug.error((String)"triangle run not connected");
                    PsDebug.error((String)("Element " + currentElem + " is not neighbor to " + previousElem));
                    return null;
                }
                tmp.concatLeft(g[currentElem][localOppIndex]);
                uvert[vindex] = tmp.evalNew(disco[currentElem][localOppIndex]);
                uelem[index].m_data[localOppIndex] = vindex;
                uelem[index].m_data[(localOppIndex + 1) % 3] = uelem[index - 1].m_data[(localIndex + 2) % 3];
                uelem[index].m_data[(localOppIndex + 2) % 3] = uelem[index - 1].m_data[(localIndex + 1) % 3];
                unfolded.getElement(index).setName("" + currentElem);
                if (previousAddedVertexInGeom != -1) {
                    if (previousAddedVertexInGeom == elem[currentElem].m_data[(localOppIndex + 1) % 3]) {
                        left.m_data[boundsize] = vindex - 1;
                        right.m_data[boundsize] = right.m_data[boundsize - 1];
                        ++boundsize;
                    } else {
                        left.m_data[boundsize] = left.m_data[boundsize - 1];
                        right.m_data[boundsize] = vindex - 1;
                        ++boundsize;
                    }
                } else {
                    left.m_data[0] = uelem[index - 1].m_data[localIndex];
                    right.m_data[0] = left.m_data[0];
                    left.m_data[1] = uelem[index - 1].m_data[(localIndex + 2) % 3];
                    right.m_data[1] = uelem[index - 1].m_data[(localIndex + 1) % 3];
                    boundsize = 2;
                }
                previousAddedVertexInGeom = elem[currentElem].m_data[localOppIndex];
                ++index;
                ++vindex;
            }
            ++i2;
        }
        left.m_data[boundsize] = vindex - 1;
        right.m_data[boundsize] = vindex - 1;
        left.setSize(boundsize + 1);
        right.setSize(boundsize + 1);
        run.setSize(index);
        unfolded.setNumElements(index);
        unfolded.setNumVertices(vindex);
        u.setName("Unfolded unmodified");
        return run;
    }

    private static int findFirstElementInStrip(PdBary start, int startelem, PiVector trianglerun, PiVector[] elem) {
        int ind;
        if (start == null || trianglerun == null) {
            PsDebug.warning((String)"missing argument.");
            return -1;
        }
        int len = trianglerun.getSize();
        if (len > 1 && (ind = PwBary.liesOnVertex((PdBary)start)) != -1) {
            int i;
            int locind = ind;
            ind = elem[startelem].m_data[ind];
            int prevlocind = -1;
            int index = 0;
            block0: while (locind != -1 && index < len - 1) {
                ++index;
                prevlocind = locind;
                locind = -1;
                i = 0;
                while (i < 3) {
                    if (elem[trianglerun.m_data[index]].m_data[i] == ind) {
                        locind = i;
                        continue block0;
                    }
                    ++i;
                }
            }
            if (locind == -1) {
                --index;
                start.copy(PdBary.TRIANGLE_VERTEX[prevlocind]);
            } else {
                start.copy(PdBary.TRIANGLE_VERTEX[locind]);
            }
            startelem = trianglerun.m_data[index];
            i = index;
            while (i < len) {
                trianglerun.m_data[i - index] = trianglerun.m_data[i];
                ++i;
            }
            trianglerun.setSize(len - index);
        }
        return startelem;
    }

    private static int findLastElementInStrip(PdBary end, int endelem, PiVector trianglerun, PiVector[] elem) {
        int ind;
        int len = trianglerun.getSize();
        if (len > 1 && (ind = PwBary.liesOnVertex((PdBary)end)) != -1) {
            int locind = ind;
            ind = elem[endelem].m_data[ind];
            int prevlocind = -1;
            block0: while (locind != -1 && len > 1) {
                --len;
                prevlocind = locind;
                locind = -1;
                int i = 0;
                while (i < 3) {
                    if (elem[trianglerun.m_data[len - 1]].m_data[i] == ind) {
                        locind = i;
                        continue block0;
                    }
                    ++i;
                }
            }
            if (locind == -1) {
                ++len;
                end.copy(PdBary.TRIANGLE_VERTEX[prevlocind]);
            } else {
                end.copy(PdBary.TRIANGLE_VERTEX[locind]);
            }
            endelem = trianglerun.m_data[len - 1];
            trianglerun.setSize(len);
        }
        return endelem;
    }

    public void makeNeighbor() {
        int nop = this.m_baseComplex.getNumPolygons();
        int nov = this.m_baseComplex.getNumVertices();
        PiVector[] polygon = this.m_baseComplex.getPolygons();
        if (this.m_neighbor == null) {
            this.m_neighbor = new PiVector[nop][2];
        }
        this.m_strip = this.makeStrip(this.m_baseComplex);
        PiVector[] adjToVert = new PiVector[nov];
        PiVector[] adjType = new PiVector[nov];
        PiVector.realloc((PiVector[])adjToVert, (int)nov, (int)0);
        PiVector.realloc((PiVector[])adjType, (int)nov, (int)0);
        int i = 0;
        while (i < nop) {
            adjToVert[polygon[i].m_data[0]].addEntry(i);
            adjType[polygon[i].m_data[0]].addEntry(0);
            adjToVert[polygon[i].getLastEntry()].addEntry(i);
            adjType[polygon[i].getLastEntry()].addEntry(polygon[i].getSize() - 1);
            ++i;
        }
        boolean[] check = new boolean[nov];
        int i2 = 0;
        while (i2 < nop) {
            int[] nArray = new int[2];
            nArray[1] = polygon[i2].getSize() - 1;
            int[] nArray2 = nArray;
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int endPoint = nArray2[n2];
                int currPol = polygon[i2].m_data[endPoint];
                if (!check[currPol]) {
                    PiVector adjToStart = adjToVert[currPol];
                    int size = adjToStart.getSize();
                    int j = size - 1;
                    while (j > 0) {
                        int k = 0;
                        while (k < j) {
                            int curr = adjToStart.m_data[k];
                            int next = adjToStart.m_data[k + 1];
                            if (!this.isRight(this.m_baseComplex, this.m_strip, curr, next, adjType[currPol].m_data[k], adjType[currPol].m_data[k + 1])) {
                                int d = next;
                                adjToStart.m_data[k + 1] = curr;
                                adjToStart.m_data[k] = next;
                                d = adjType[currPol].m_data[k + 1];
                                adjType[currPol].m_data[k + 1] = adjType[currPol].m_data[k];
                                adjType[currPol].m_data[k] = d;
                            }
                            ++k;
                        }
                        --j;
                    }
                    int shift = adjToStart.getIndexOf(i2);
                    adjToStart.shift(-shift);
                    adjType[currPol].shift(-shift);
                    this.m_neighbor[i2][endPoint == 0 ? 0 : 1] = PiVector.copyNew((PiVector)adjToStart);
                    check[currPol] = true;
                    int j2 = 1;
                    while (j2 < size) {
                        int indPol = adjToStart.m_data[1];
                        adjToStart.shift(-1);
                        adjType[currPol].shift(-1);
                        this.m_neighbor[indPol][adjType[currPol].m_data[0] == 0 ? 0 : 1] = PiVector.copyNew((PiVector)adjToStart);
                        check[polygon[indPol].m_data[adjType[currPol].m_data[0]]] = true;
                        ++j2;
                    }
                }
                ++n2;
            }
            ++i2;
        }
    }

    public boolean isRight(PgPolygonSetOnElementSet sc, PiVector[] strip, int indPol_1, int indPol_2, int s1, int s2) {
        int s2_size;
        PiVector[] polygon = sc.getPolygons();
        if (polygon[indPol_1].m_data[s1] != polygon[indPol_2].m_data[s2]) {
            PsDebug.error((String)"Polygons do not share the same vertex");
            return false;
        }
        PiVector strip_1 = strip[indPol_1];
        PiVector strip_2 = strip[indPol_2];
        int s1_size = s1 > 0 ? strip_1.getSize() - 1 : s1;
        int n = s2_size = s2 > 0 ? strip_2.getSize() - 1 : s2;
        if (strip_1.m_data[s1_size] != strip_2.m_data[s2_size]) {
            PdBary vert = sc.getVertexBary(polygon[indPol_1].m_data[s1]);
            int locInd = vert.isOnVertex(1.0E-8);
            int indVert = this.m_geom.getElement((int)vert.m_elementInd).m_data[locInd];
            PgVertexStar v = new PgVertexStar();
            v.makeVertexStar((PgElementSet)this.m_geom, indVert, -1);
            PiVector element = v.getElement();
            int indElt_1 = element.getIndexOf(strip_1.m_data[s1_size]);
            int indElt_2 = element.getIndexOf(strip_2.m_data[s2_size]);
            if (indElt_1 == -1 || indElt_2 == -1) {
                PsDebug.error((String)"Index of the strip element is not in the element star of the node at isRight()");
                return false;
            }
            if ((indElt_2 + 1) % element.getSize() > (indElt_1 + 1) % element.getSize()) {
                return true;
            }
        } else {
            int numWalk = Math.min(strip_1.getSize(), strip_2.getSize());
            int walk_1 = 0;
            int walk_2 = 0;
            boolean success = false;
            int i = 1;
            while (i < numWalk) {
                int elt_2;
                walk_1 = s1_size > 0 ? -i : i;
                int elt_1 = strip_1.m_data[s1_size + walk_1];
                if (elt_1 != (elt_2 = strip_2.m_data[s2_size + (walk_2 = s2_size > 0 ? -i : i)])) {
                    success = true;
                    int prevElt = strip_1.m_data[s1_size + walk_1 - (int)Math.signum(walk_1)];
                    PiVector neighbor = this.m_geom.getNeighbour(prevElt);
                    if (!neighbor.contains(elt_1) || !neighbor.contains(elt_2)) {
                        PsDebug.error((String)("Check strip connection in isRight(), polygon indices " + indPol_1 + " and " + indPol_2));
                        return false;
                    }
                    return (neighbor.getIndexOf(elt_1) + 1) % 3 == neighbor.getIndexOf(elt_2);
                }
                ++i;
            }
            if (!success) {
                int ind_1 = s1 > 0 ? s1 - 1 : 1;
                int ind_2 = s2 > 0 ? s2 - 1 : 1;
                PdVector normal = this.m_geom.getElementNormal(sc.getVertexElemInd(polygon[indPol_1].m_data[ind_1]));
                PdVector node = sc.getVertex(polygon[indPol_1].m_data[s1]);
                PdVector dir_1 = PdVector.copyNew((PdVector)sc.getVertex(polygon[indPol_1].m_data[ind_1]));
                PdVector dir_2 = PdVector.copyNew((PdVector)sc.getVertex(polygon[indPol_2].m_data[ind_2]));
                dir_1.sub(node);
                dir_2.sub(node);
                if (PdVector.angleWithOrientation((PdVector)dir_1, (PdVector)dir_2, (PdVector)normal) > 0.0) {
                    return true;
                }
            }
        }
        return false;
    }

    public void viewBaseComplex() {
        this.createSparseComplexPolygons();
        this.baseComplexProperties();
        this.updateDisplay();
    }

    public void startLocalGeodesicStraighting() {
        if (!this.m_bStopped || this.m_bRunning) {
            return;
        }
        this.m_bRunning = true;
        this.m_thread = new Thread((Runnable)this, "JavaView: Smooth local straightning");
        this.m_thread.setPriority(5);
        this.m_thread.start();
        PsDebug.notify((String)"Thread started");
    }

    @Override
    public void run() {
        PgPolygonSetOnElementSet smooth = new PgPolygonSetOnElementSet((PgElementSet)this.m_geom);
        smooth.setName("smooth");
        this.m_display.addGeometry((PgGeometryIf)smooth);
        PiVector[] strip = this.makeStrip(this.m_baseComplex);
        int i = 0;
        while (i < this.m_baseComplex.getNumPolygons()) {
            this.localGeodesicStraighting(this.m_baseComplex, strip[i], i);
            smooth.showVertices(false);
            smooth.update((Object)smooth);
            this.updateDisplay();
            ++i;
        }
    }

    public void straightenSelected() {
        int nop = this.m_baseComplex.getNumPolygons();
        PiVector[] polygon = this.m_baseComplex.getPolygons();
        if (this.m_strip == null) {
            this.m_strip = this.makeStrip(this.m_baseComplex);
        }
        int i = 0;
        while (i < nop) {
            if (polygon[i].hasTag(1)) {
                this.m_baseComplex.setPolygonColor(i, Color.white);
                this.localGeodesicStraighting(this.m_baseComplex, this.m_strip[i], i);
                int j = 0;
                while (j < this.m_strip[i].getSize()) {
                    this.m_geom.getElement(this.m_strip[i].m_data[j]).setTag(1);
                    ++j;
                }
            }
            ++i;
        }
        this.m_baseComplex.update((Object)this.m_baseComplex);
        this.m_geom.update((Object)this.m_geom);
    }

    public void subdivideBaseComplex() {
        double cutAngle = this.m_cutAngle.getValue();
        this.m_neighbor = null;
        this.m_baseComplex.showPolygonColors(true);
        int nop = this.m_baseComplex.getNumPolygons();
        this.m_baseComplex.showVertices(false);
        this.m_baseComplex.showVertexColors(true);
        this.m_baseComplex.showVertexSizes(true);
        int i = 0;
        while (i < this.m_baseComplex.getNumVertices()) {
            this.m_baseComplex.setVertexSize(i, 2.0);
            ++i;
        }
        boolean didSubdivide = false;
        didSubdivide = false;
        nop = this.m_baseComplex.getNumPolygons();
        int i2 = 0;
        while (i2 < nop) {
            int cutTimes = 0;
            do {
                double curv = PwBaseComplexParam.integratePolygonCurvature(this.m_geom, this.m_baseComplex, i2, -1);
                cutTimes = (int)Math.ceil(curv / cutAngle);
                if (curv < cutAngle + 5.0) {
                    cutTimes = 0;
                }
                if (cutTimes <= 1) continue;
                System.out.println("deg: " + curv);
                i2 = this.subdividePolygon(this.m_geom, this.m_baseComplex, i2, curv / (double)cutTimes);
                if (i2 < 0) continue;
                didSubdivide = true;
            } while (cutTimes > 1 && i2 >= 0);
            if (didSubdivide) break;
            ++i2;
        }
        this.makeNeighbor();
        this.m_baseComplex.update((Object)this.m_baseComplex);
        this.m_display.update((Object)this.m_baseComplex);
    }

    private int subdividePolygon(PgParamGeom geom, PgPolygonSetOnElementSet baseComplex, int pInd, double cutAngle) {
        double EPS_COORDS = 1.0E-8f;
        PiVector baseP = baseComplex.getPolygon(pInd);
        int i = 0;
        while (i < baseP.getSize() - 1) {
            if (PwBaseComplexParam.integratePolygonCurvature(geom, baseComplex, pInd, i + 1) >= cutAngle) {
                PdVector v1 = PdVector.copyNew((PdVector)baseComplex.getVertex(baseP.getEntry(i)));
                PdVector v2 = PdVector.copyNew((PdVector)baseComplex.getVertex(baseP.getEntry(i + 1)));
                PdBary b1 = baseComplex.getVertexBary(baseP.getEntry(i));
                PdBary b2 = baseComplex.getVertexBary(baseP.getEntry(i + 1));
                PdBary baryV1 = new PdBary(3);
                PdBary baryV2 = new PdBary(3);
                int elemInd = b1.getElementInd();
                PdBary.getBary((PdBary)baryV1, (PdVector)v1, (PdVector[])this.m_geom.getElementVertices(b1.getElementInd()));
                PdBary.getBary((PdBary)baryV2, (PdVector)v2, (PdVector[])this.m_geom.getElementVertices(b1.getElementInd()));
                if (b1.getElementInd() != b2.getElementInd() && (baryV1.isOutside(-1.0E-7) >= 0 || baryV2.isOutside(-1.0E-7) >= 0)) {
                    PdBary.getBary((PdBary)baryV1, (PdVector)v1, (PdVector[])this.m_geom.getElementVertices(b2.getElementInd()));
                    PdBary.getBary((PdBary)baryV2, (PdVector)v2, (PdVector[])this.m_geom.getElementVertices(b2.getElementInd()));
                    elemInd = b2.getElementInd();
                }
                PdVector[] texCoordsEl = this.m_geom.getElementTexture(elemInd);
                PdVector texCoordsV1 = new PdVector(2);
                PdVector texCoordsV2 = new PdVector(2);
                int j = 0;
                while (j < 3) {
                    texCoordsV1.add(baryV1.getEntry(j), texCoordsEl[j]);
                    texCoordsV2.add(baryV2.getEntry(j), texCoordsEl[j]);
                    ++j;
                }
                int constCoord = 0;
                if (Math.abs(texCoordsV1.getEntry(0) - texCoordsV2.getEntry(0)) < EPS_COORDS) {
                    constCoord = 1;
                }
                double niveau = texCoordsV1.getEntry(constCoord);
                int vIndOpp_1 = -1;
                int j2 = 0;
                while (j2 < 3) {
                    int j_next = (j2 + 1) % 3;
                    if (Math.signum(texCoordsEl[j2].getEntry(constCoord) - niveau) == Math.signum(texCoordsEl[j_next].getEntry(constCoord) - niveau)) {
                        vIndOpp_1 = j2;
                        break;
                    }
                    ++j2;
                }
                if (vIndOpp_1 == -1) {
                    PsDebug.warning((String)"Error while trying to trace subdeviding parameter-line!");
                    return -1;
                }
                int secondHalfInd = PwBaseComplexParam.splitPolygon(this.m_baseComplex, this.m_polygonsPerElement, this.m_neighbor, baryV1, pInd, i - 1, baseP.getEntry(i));
                this.m_baseComplex.getPolygon(secondHalfInd).removeSuccessiveDuplicates();
                PgPolygonOnElementSet poly = new PgPolygonOnElementSet((PgElementSet)this.m_geom);
                poly.setNumVertices(1);
                poly.setVertexBary(0, elemInd, this.m_baseComplex.getVertexBary(this.m_baseComplex.getPolygon(secondHalfInd).getEntry(0)));
                int newExpectedInd = this.m_baseComplex.getNumPolygons();
                if (PwBaseComplexParam.traceParameterLine(this.m_geom, poly, elemInd, vIndOpp_1, constCoord, niveau, elemInd, newExpectedInd, this.m_polygonsPerElement)) {
                    int splitVertexInd;
                    int newPInd = this.m_baseComplex.addPolygonBary(poly);
                    if (newPInd != newExpectedInd) {
                        PsDebug.error((String)"Wrong polygon indexing in per element information!");
                    }
                    if ((splitVertexInd = this.m_baseComplex.getPolygon(secondHalfInd).getEntry(0)) == 22) {
                        boolean bl = true;
                    }
                    if (this.m_baseComplex.getVertexBary(splitVertexInd).isOutside(-1.0E-7) >= 0) {
                        PsDebug.warning((String)"Wrong barycentric coordinates for intersection vertex!");
                    }
                    PiVector newPoly = this.m_baseComplex.getPolygon(newPInd);
                    newPoly.setEntry(0, splitVertexInd);
                    newPoly.setEntry(newPoly.getSize() - 1, splitVertexInd);
                    PwBaseComplexParam.cutPolygonsAlongPolygon(this.m_geom, this.m_baseComplex, this.m_neighbor, this.m_polygonsPerElement, newPInd, 0);
                    return secondHalfInd;
                }
                PsDebug.error((String)"Error while tracing parameter line!");
                return -1;
            }
            ++i;
        }
        return -1;
    }

    /*
     * Unable to fully structure code
     */
    public static int cutPolygonsAlongPolygon(PgParamGeom geom, PgPolygonSetOnElementSet baseComplex, PiVector[][] neighbor, PdVector[] polygonsPerElement, int pInd, int rec) {
        p = baseComplex.getPolygon(pInd);
        i = 0;
        while (i < p.getSize() - 1) {
            v1 = baseComplex.getVertex(p.getEntry(i));
            v1Bary = PdBary.copyNew((PdBary)baseComplex.getVertexBary(p.getEntry(i)));
            curEl = v1Bary.getElementInd();
            v2 = baseComplex.getVertex(p.getEntry(i + 1));
            v2Bary = new PdBary(3);
            PdBary.getBary((PdBary)v2Bary, (PdVector)v2, (PdVector[])geom.getElementVertices(v1Bary.getElementInd()));
            v2Bary.setElementInd(curEl);
            if (v2Bary.isOutside(-1.0E-7) < 0) ** GOTO lbl-1000
            v2Bary = PdBary.copyNew((PdBary)baseComplex.getVertexBary(p.getEntry(i + 1)));
            PdBary.getBary((PdBary)v1Bary, (PdVector)v1, (PdVector[])geom.getElementVertices(v2Bary.getElementInd()));
            curEl = v2Bary.getElementInd();
            v1Bary.setElementInd(curEl);
            if (v1Bary.isOutside(-1.0E-7) >= 0) {
                PsDebug.warning((String)("Polygon with index " + pInd + " has two successive vertices which are not epsilon close (or inside) of a common triangle. (local v.inds.: " + i + " and " + (i + 1) + ", size: " + p.getSize() + ")"));
            } else if ((polysInCurEl = polygonsPerElement[curEl]).getSize() > 3) {
                ownConstCoord = -1;
                j = 0;
                while (j < polysInCurEl.getSize()) {
                    if (polysInCurEl.getEntry(j) == (double)pInd) {
                        ownConstCoord = (int)polysInCurEl.getEntry(j + 1);
                    }
                    j += 3;
                }
                j = 0;
                while (j < polysInCurEl.getSize()) {
                    if (polysInCurEl.getEntry(j) != (double)pInd) {
                        otherPInd = (int)polysInCurEl.getEntry(j);
                        otherConstCoord = (int)polysInCurEl.getEntry(j + 1);
                        if (otherConstCoord != ownConstCoord) {
                            otherP = baseComplex.getPolygon((int)polysInCurEl.getEntry(j));
                            e = 0;
                            while (e < otherP.getSize() - 1) {
                                oV1Bary = baseComplex.getVertexBary(otherP.getEntry(e));
                                oV1 = baseComplex.getVertex(otherP.getEntry(e));
                                oV2Bary = baseComplex.getVertexBary(otherP.getEntry(e + 1));
                                oV2 = baseComplex.getVertex(otherP.getEntry(e + 1));
                                if (oV1Bary.getElementInd() == curEl || oV2Bary.getElementInd() == curEl) {
                                    oV1Bary = new PdBary(3);
                                    PdBary.getBary((PdBary)oV1Bary, (PdVector)oV1, (PdVector[])geom.getElementVertices(curEl));
                                    oV2Bary = new PdBary(3);
                                    PdBary.getBary((PdBary)oV2Bary, (PdVector)oV2, (PdVector[])geom.getElementVertices(curEl));
                                    if (!(oV1Bary.isOutside(-1.0E-7) >= 0 || oV2Bary.isOutside(-1.0E-7) >= 0 || i == 0 && e == 0 && PdBary.dist((PdBary)v1Bary, (PdBary)oV1Bary) < 1.0E-7 || i == p.getSize() - 2 && e == 0 && PdBary.dist((PdBary)v2Bary, (PdBary)oV1Bary) < 1.0E-7 || i == 0 && e == otherP.getSize() - 2 && PdBary.dist((PdBary)v1Bary, (PdBary)oV2Bary) < 1.0E-7 || i == p.getSize() - 2 && e == otherP.getSize() - 2 && PdBary.dist((PdBary)v2Bary, (PdBary)oV2Bary) < 1.0E-7 || (intersect = PwBaseComplexParam.getIntersection(v1Bary, v2Bary, oV1Bary, oV2Bary)) == null)) {
                                        intersect.setElementInd(curEl);
                                        newPInds = PwBaseComplexParam.splitPolygons(baseComplex, polygonsPerElement, neighbor, intersect, pInd, i, otherPInd, e);
                                        if (rec < 500) {
                                            PwBaseComplexParam.cutPolygonsAlongPolygon(geom, baseComplex, neighbor, polygonsPerElement, newPInds[0], rec + 1);
                                        }
                                        return newPInds[0];
                                    }
                                }
                                ++e;
                            }
                        }
                    }
                    j += 3;
                }
            }
            ++i;
        }
        return -1;
    }

    private static int splitPolygon(PgPolygonSetOnElementSet baseComplex, PdVector[] polygonsPerElement, PiVector[][] neighbor, PdBary intersect, int pInd, int i, int ind) {
        if (ind < 0) {
            PdVector pInter = new PdVector(3);
            int elInd = intersect.getElementInd();
            PdVector[] elVs = baseComplex.getGeometry().getElementVertices(elInd);
            intersect.getVertex(pInter, elVs[0], elVs[1], elVs[2]);
            ind = baseComplex.addVertex(pInter);
            baseComplex.setVertexBary(ind, intersect);
            baseComplex.setVertexSize(ind, 2.0);
            baseComplex.setVertexColor(ind, Color.orange);
        }
        PiVector p1 = baseComplex.getPolygon(pInd);
        PiVector p3 = new PiVector();
        p3.addEntry(ind);
        p3.setSize(p1.getSize() - i);
        p3.copy(1, p1, i + 1, p1.getSize() - i - 1);
        p1.setSize(i + 1);
        p1.addEntry(ind);
        p1.removeSuccessiveDuplicates();
        p3.removeSuccessiveDuplicates();
        int newPol = baseComplex.addPolygon(p3);
        PdVector[] tempInfo = new PdVector[baseComplex.getGeometry().getNumElements()];
        int[][] polyInds = new int[][]{{pInd, pInd}, {newPol, pInd}};
        int cp = 0;
        while (cp < polyInds.length) {
            PiVector curPol = baseComplex.getPolygon(polyInds[cp][0]);
            int refPolyInd = polyInds[cp][1];
            int cv = 0;
            while (cv < curPol.getSize()) {
                int cElem = baseComplex.getVertexBary(curPol.getEntry(cv)).getElementInd();
                PdVector curInfo = polygonsPerElement[cElem];
                int j = 0;
                while (j < curInfo.getSize()) {
                    if (curInfo.getEntry(j) == (double)refPolyInd) {
                        if (tempInfo[cElem] == null) {
                            tempInfo[cElem] = new PdVector();
                        }
                        int k = 0;
                        while (k < tempInfo[cElem].getSize()) {
                            if (tempInfo[cElem].getEntry(k) == (double)polyInds[cp][0]) break;
                            k += 3;
                        }
                        tempInfo[cElem].addEntry((double)polyInds[cp][0]);
                        tempInfo[cElem].addEntry(curInfo.getEntry(j + 1));
                        tempInfo[cElem].addEntry(curInfo.getEntry(j + 1));
                        break;
                    }
                    j += 3;
                }
                ++cv;
            }
            ++cp;
        }
        int cElem = 0;
        while (cElem < tempInfo.length) {
            if (tempInfo[cElem] != null) {
                PdVector curInfo = polygonsPerElement[cElem];
                PdVector newInfo = new PdVector();
                int j = 0;
                while (j < curInfo.getSize()) {
                    if (curInfo.getEntry(j) != (double)pInd) {
                        newInfo.addEntry(curInfo.getEntry(j));
                        newInfo.addEntry(curInfo.getEntry(j + 1));
                        newInfo.addEntry(curInfo.getEntry(j + 2));
                    }
                    j += 3;
                }
                j = 0;
                while (j < tempInfo[cElem].getSize()) {
                    newInfo.addEntry(tempInfo[cElem].getEntry(j));
                    ++j;
                }
                polygonsPerElement[cElem] = newInfo;
            }
            ++cElem;
        }
        baseComplex.update((Object)baseComplex);
        return newPol;
    }

    private static int[] splitPolygons(PgPolygonSetOnElementSet baseComplex, PdVector[] polygonsPerElement, PiVector[][] neighbor, PdBary intersect, int pInd, int i, int otherPInd, int e) {
        PdVector pInter = new PdVector(3);
        int elInd = intersect.getElementInd();
        PdVector[] elVs = baseComplex.getGeometry().getElementVertices(elInd);
        intersect.getVertex(pInter, elVs[0], elVs[1], elVs[2]);
        int ind = -1;
        if (PdVector.dist((PdVector)baseComplex.getVertex(baseComplex.getPolygon(pInd).getEntry(i)), (PdVector)pInter) < 1.0E-7) {
            ind = baseComplex.getPolygon(pInd).getEntry(i);
        } else if (PdVector.dist((PdVector)baseComplex.getVertex(baseComplex.getPolygon(pInd).getEntry(i + 1)), (PdVector)pInter) < 1.0E-7) {
            ind = baseComplex.getPolygon(pInd).getEntry(i + 1);
        } else if (PdVector.dist((PdVector)baseComplex.getVertex(baseComplex.getPolygon(otherPInd).getEntry(e)), (PdVector)pInter) < 1.0E-7) {
            ind = baseComplex.getPolygon(otherPInd).getEntry(e);
        } else if (PdVector.dist((PdVector)baseComplex.getVertex(baseComplex.getPolygon(otherPInd).getEntry(e + 1)), (PdVector)pInter) < 1.0E-7) {
            ind = baseComplex.getPolygon(otherPInd).getEntry(e + 1);
        } else {
            ind = baseComplex.addVertex(pInter);
            baseComplex.setVertexBary(ind, intersect);
            baseComplex.setVertexSize(ind, 2.0);
            baseComplex.setVertexColor(ind, Color.orange);
        }
        return new int[]{PwBaseComplexParam.splitPolygon(baseComplex, polygonsPerElement, neighbor, intersect, pInd, i, ind), PwBaseComplexParam.splitPolygon(baseComplex, polygonsPerElement, neighbor, intersect, otherPInd, e, ind)};
    }

    public static PdBary getIntersection(PdBary p1, PdBary p2, PdBary q1, PdBary q2) {
        double p1x = p1.getEntry(0);
        double p1y = p1.getEntry(1);
        double p2x = p2.getEntry(0);
        double p2y = p2.getEntry(1);
        double q1x = q1.getEntry(0);
        double q1y = q1.getEntry(1);
        double q2x = q2.getEntry(0);
        double q2y = q2.getEntry(1);
        double s = (p1y - q1y + (q1x - p1x) * (p2y - p1y) / (p2x - p1x)) / (q2y - q1y - (q2x - q1x) * (p2y - p1y) / (p2x - p1x));
        double t = (q1x - p1x + s * (q2x - q1x)) / (p2x - p1x);
        if (s < 0.0 || s > 1.0 || t < 0.0 || t > 1.0 || Double.isNaN(s) || Double.isNaN(t)) {
            return null;
        }
        PdBaryDir d = new PdBaryDir(p2x - p1x, p2y - p1y, p2.getEntry(2) - p1.getEntry(2));
        PdBary x = new PdBary(3);
        PdBary.add((PdBary)p1, (double)t, (PdBaryDir)d, (PdBary)x);
        return x;
    }

    public static double integratePolygonCurvature(PgParamGeom geom, PgPolygonSetOnElementSet baseComplex, int pInd, int toVInd) {
        PiVector p = baseComplex.getPolygon(pInd);
        double curvSum = 0.0;
        if (p == null) {
            return -1.0;
        }
        if (toVInd == -1) {
            toVInd = p.getSize() - 1;
        }
        if (toVInd > p.getSize() - 1) {
            return -1.0;
        }
        int elem = -1;
        double edgeSum = 0.0;
        int numEdges = 0;
        double maxDist = 0.0;
        int i = 0;
        while (i <= toVInd) {
            double curDist;
            if (elem != baseComplex.getVertexBary(p.getEntry(i)).getElementInd()) {
                elem = baseComplex.getVertexBary(p.getEntry(i)).getElementInd();
                PiVector elInds = geom.getElement(elem);
                int j = 0;
                while (j < 3) {
                    edgeSum += PdVector.dist((PdVector)geom.getVertex(elInds.getEntry(j)), (PdVector)geom.getVertex(elInds.getEntry((j + 1) % 3)));
                    ++numEdges;
                    ++j;
                }
            }
            if ((curDist = PdVector.dist((PdVector)baseComplex.getVertex(p.getEntry(0)), (PdVector)baseComplex.getVertex(p.getEntry(i)))) > maxDist) {
                maxDist = curDist;
            }
            ++i;
        }
        double minEdgeLength = Math.min(edgeSum / (double)numEdges, maxDist / 3.0);
        int v1Ind = 0;
        int v2Ind = 0;
        int v3Ind = 0;
        while (PdVector.dist((PdVector)baseComplex.getVertex(p.getEntry(v1Ind)), (PdVector)baseComplex.getVertex(p.getEntry(v2Ind))) < minEdgeLength && v2Ind < toVInd - 1) {
            ++v2Ind;
        }
        do {
            v3Ind = v2Ind + 1;
            while (PdVector.dist((PdVector)baseComplex.getVertex(p.getEntry(v2Ind)), (PdVector)baseComplex.getVertex(p.getEntry(v3Ind))) < minEdgeLength && v3Ind < toVInd) {
                ++v3Ind;
            }
            PdVector e1 = PdVector.subNew((PdVector)baseComplex.getVertex(p.getEntry(v2Ind)), (PdVector)baseComplex.getVertex(p.getEntry(v1Ind)));
            PdVector e2 = PdVector.subNew((PdVector)baseComplex.getVertex(p.getEntry(v3Ind)), (PdVector)baseComplex.getVertex(p.getEntry(v2Ind)));
            curvSum += PdVector.angle((PdVector)e1, (PdVector)e2);
            v1Ind = v2Ind;
            v2Ind = v3Ind;
        } while (v3Ind < toVInd);
        return curvSum;
    }

    public static double integratePolygonCurvatureOld(PgPolygonSetOnElementSet baseComplex, int pInd, int toVInd) {
        PiVector p = baseComplex.getPolygon(pInd);
        double curvSum = 0.0;
        if (p == null) {
            return -1.0;
        }
        if (toVInd == -1) {
            toVInd = p.getSize() - 1;
        }
        if (toVInd > p.getSize() - 1) {
            return -1.0;
        }
        int i = 0;
        while (i < toVInd - 1) {
            PdVector e1 = PdVector.subNew((PdVector)baseComplex.getVertex(p.getEntry(i + 1)), (PdVector)baseComplex.getVertex(p.getEntry(i)));
            PdVector e2 = PdVector.subNew((PdVector)baseComplex.getVertex(p.getEntry(i + 2)), (PdVector)baseComplex.getVertex(p.getEntry(i + 1)));
            curvSum += PdVector.angle((PdVector)e1, (PdVector)e2);
            ++i;
        }
        return curvSum;
    }

    public PgPolygonSetOnElementSet makeDualLineFromStrip(PiVector[] quadStrip, PiVector singularityIndex) {
        PgPolygonSetOnElementSet dual = new PgPolygonSetOnElementSet((PgElementSet)this.m_geom);
        PgPolygonOnElementSet _dual = new PgPolygonOnElementSet((PgElementSet)this.m_geom);
        PiVector[] patch = this.getPatch();
        PiVector[] currStrip = quadStrip;
        int noe = this.m_geom.getNumElements();
        PuTransitionFunction[][] discoTransition = new PuTransitionFunction[noe][3];
        this.m_geom.setElementTextures(this.m_geom.getElementTextures());
        int i = 0;
        while (i < noe) {
            int j = 0;
            while (j < 3) {
                discoTransition[i][j] = new PuTransitionFunction((PgElementSet)this.m_geom, i, j);
                ++j;
            }
            ++i;
        }
        PdBary midEdgePrev = new PdBary(3);
        PiVector stripPrev = new PiVector();
        this.getMidEdge(midEdgePrev, stripPrev, discoTransition, currStrip[0], patch);
        PdBary midEdgeCurr = new PdBary(3);
        PiVector stripCurr = new PiVector();
        int stripLen = currStrip.length;
        PgVertexStar v1 = new PgVertexStar();
        int i2 = 1;
        while (i2 < stripLen + 1) {
            int k;
            int indNext;
            int indCurr;
            PiVector eltStar;
            int onVertex;
            int indVert;
            int lastCurr;
            int curr = i2 % stripLen;
            int prev = i2 - 1;
            this.getMidEdge(midEdgeCurr, stripCurr, discoTransition, currStrip[curr], patch);
            PiVector stripNewEdge = (PiVector)stripPrev.clone();
            int indPatchCurr = currStrip[curr].m_data[0];
            int locIndCurr = currStrip[curr].m_data[1];
            int indECurr = patch[indPatchCurr].m_data[locIndCurr];
            int indPatchPrev = currStrip[prev].m_data[0];
            int locIndPrev = currStrip[prev].m_data[1];
            int startNext = this.m_strip[indECurr].getFirstEntry();
            if (!this.m_edgeOrientation[indPatchCurr][locIndCurr]) {
                startNext = this.m_strip[indECurr].getLastEntry();
            }
            if ((lastCurr = stripNewEdge.getLastEntry()) != startNext) {
                indVert = this.m_baseComplex.getPolygon(patch[indPatchPrev].m_data[(locIndPrev + 1) % 4]).getFirstEntry();
                if (!this.m_edgeOrientation[indPatchPrev][(locIndPrev + 1) % 4]) {
                    indVert = this.m_baseComplex.getPolygon(patch[indPatchPrev].m_data[(locIndPrev + 1) % 4]).getLastEntry();
                }
                PdBary startBary = this.m_baseComplex.getVertexBary(indVert);
                PwBary.makeBaryDescription((PgElementSet)this.m_geom, (PdBary)startBary, (int)lastCurr, (double)1.0E-8);
                onVertex = startBary.isOnVertex(1.0E-7);
                if (onVertex == -1) {
                    PsDebug.warning((String)"The strip cannot be connected, please check");
                } else {
                    v1.makeVertexStar((PgElementSet)this.m_geom, this.m_geom.getElement((int)lastCurr).m_data[onVertex], lastCurr);
                    eltStar = v1.getElement();
                    eltStar.invert();
                    indCurr = eltStar.getIndexOf(lastCurr);
                    eltStar.shift(-indCurr);
                    indNext = eltStar.getIndexOf(startNext);
                    if (indNext == -1) {
                        PsDebug.warning((String)"Star does not contain element");
                    }
                    k = 1;
                    while (k < indNext) {
                        stripNewEdge.addEntry(eltStar.m_data[k]);
                        ++k;
                    }
                }
            }
            int ind = -1;
            int j = 0;
            while (j < this.m_strip[indECurr].getSize()) {
                ind = j;
                if (!this.m_edgeOrientation[indPatchCurr][locIndCurr]) {
                    ind = this.m_strip[indECurr].getSize() - 1 - j;
                }
                if (stripNewEdge.getLastEntry() != this.m_strip[indECurr].m_data[ind]) {
                    stripNewEdge.addEntry(this.m_strip[indECurr].m_data[ind]);
                }
                ++j;
            }
            startNext = stripCurr.getLastEntry();
            lastCurr = stripNewEdge.getLastEntry();
            if (lastCurr != startNext) {
                indVert = this.m_baseComplex.getPolygon(patch[indPatchCurr].m_data[locIndCurr]).getLastEntry();
                if (!this.m_edgeOrientation[indPatchCurr][locIndCurr]) {
                    indVert = this.m_baseComplex.getPolygon(patch[indPatchCurr].m_data[locIndCurr]).getFirstEntry();
                }
                PdBary startBary = this.m_baseComplex.getVertexBary(indVert);
                PwBary.makeBaryDescription((PgElementSet)this.m_geom, (PdBary)startBary, (int)lastCurr, (double)1.0E-8);
                onVertex = startBary.isOnVertex(1.0E-7);
                if (onVertex == -1) {
                    PsDebug.warning((String)"The strip cannot be connected, please check");
                } else {
                    v1.makeVertexStar((PgElementSet)this.m_geom, this.m_geom.getElement((int)lastCurr).m_data[onVertex], lastCurr);
                    eltStar = v1.getElement();
                    eltStar.invert();
                    indCurr = eltStar.getIndexOf(lastCurr);
                    eltStar.shift(-indCurr);
                    indNext = eltStar.getIndexOf(startNext);
                    if (indNext == -1) {
                        PsDebug.warning((String)"Star does not contain element");
                    }
                    k = 1;
                    while (k < indNext) {
                        if (stripNewEdge.getLastEntry() != eltStar.m_data[k]) {
                            stripNewEdge.addEntry(eltStar.m_data[k]);
                        }
                        ++k;
                    }
                }
            }
            j = 0;
            while (j < stripCurr.getSize()) {
                if (stripNewEdge.getLastEntry() != stripCurr.m_data[stripCurr.getSize() - j - 1]) {
                    stripNewEdge.addEntry(stripCurr.m_data[stripCurr.getSize() - j - 1]);
                }
                ++j;
            }
            PgPolygonOnElementSet _poly = new PgPolygonOnElementSet((PgElementSet)this.m_geom);
            if ((_poly = PwBaseComplexParam.getShortest((PgElementSet)this.m_geom, discoTransition, midEdgePrev, midEdgePrev.m_elementInd, midEdgeCurr, midEdgeCurr.m_elementInd, stripNewEdge, _poly, null, null, null, null, null, null, null, null, null, i2, false, null, singularityIndex)) == null) {
                PsDebug.warning((String)("Cannot compute geodesic " + i2));
                int[] nArray = stripNewEdge.m_data;
                int n = stripNewEdge.m_data.length;
                int n2 = 0;
                while (n2 < n) {
                    int k2 = nArray[n2];
                    this.m_geom.getElement(k2).setTag(1);
                    ++n2;
                }
                System.out.println(stripNewEdge.toShortString());
                break;
            }
            _dual.merge((PgGeometryIf)_poly);
            stripPrev = (PiVector)stripCurr.clone();
            midEdgePrev.copy(midEdgeCurr);
            ++i2;
        }
        dual.addPolygonBary(_dual);
        dual.getPolygon(0).addEntry(0);
        return dual;
    }

    public void getMidEdge(PdBary midEdge, PiVector strip, PuTransitionFunction[][] g, PiVector index, PiVector[] patch) {
        if (strip.getSize() != 0) {
            strip.setSize(0);
        }
        int indEdge = patch[index.m_data[0]].m_data[(index.m_data[1] + 1) % 4];
        PiVector triangleStrip = new PiVector();
        PiVector pol = this.m_baseComplex.getPolygon(indEdge);
        int size = pol.getSize();
        int j = 0;
        while (j < size - 1) {
            PdBary end;
            PdBary start = (PdBary)this.m_baseComplex.getVertexBary(pol.m_data[j]).clone();
            if (!PwBaseComplexParam.makeCommonBarycenctricDescription((PgElementSet)this.m_geom, start, end = (PdBary)this.m_baseComplex.getVertexBary(pol.m_data[j + 1]).clone(), 1.0E-8)) {
                PsDebug.warning((String)"Does not succeed to make common barycentric");
                return;
            }
            triangleStrip.addEntry(start.m_elementInd);
            ++j;
        }
        PgElementSet unfolded = new PgElementSet(3);
        PwBaseComplexParam.makeUnfoldedStripInDisco((PgElementSet)this.m_geom, g, triangleStrip, unfolded, null, null);
        PiVector polygon = this.m_baseComplex.getPolygon(indEdge);
        PdBary startBary = this.m_baseComplex.getVertexBary(polygon.getFirstEntry());
        PdBary endBary = this.m_baseComplex.getVertexBary(polygon.getLastEntry());
        if (startBary.m_elementInd != triangleStrip.m_data[0]) {
            PwBary.makeBaryDescription((PgElementSet)this.m_geom, (PdBary)startBary, (int)triangleStrip.m_data[0], (double)1.0E-7);
        }
        if (endBary.m_elementInd != triangleStrip.getLastEntry()) {
            PwBary.makeBaryDescription((PgElementSet)this.m_geom, (PdBary)endBary, (int)triangleStrip.getLastEntry(), (double)1.0E-7);
        }
        PdVector startPos = new PdVector(2);
        PdVector endPos = new PdVector(2);
        int sElt = 0;
        int eElt = unfolded.getNumElements() - 1;
        PiVector[] unfoldedElt = unfolded.getElements();
        PdVector[] vertex = unfolded.getVertices();
        startBary.getVertex(startPos, vertex[unfoldedElt[sElt].m_data[0]], vertex[unfoldedElt[sElt].m_data[1]], vertex[unfoldedElt[sElt].m_data[2]]);
        endBary.getVertex(endPos, vertex[unfoldedElt[eElt].m_data[0]], vertex[unfoldedElt[eElt].m_data[1]], vertex[unfoldedElt[eElt].m_data[2]]);
        PdVector midPoint = new PdVector(2);
        midPoint.blend(0.5, startPos, 0.5, endPos);
        int noe = unfoldedElt.length;
        boolean found = false;
        int ind = -1;
        int i = 0;
        while (i < noe) {
            ind = i;
            if (!this.m_edgeOrientation[index.m_data[0]][(index.m_data[1] + 1) % 4]) {
                ind = noe - 1 - i;
            }
            PdBary.getBary((PdBary)midEdge, (PdVector)midPoint, (PdVector)vertex[unfoldedElt[ind].m_data[0]], (PdVector)vertex[unfoldedElt[ind].m_data[1]], (PdVector)vertex[unfoldedElt[ind].m_data[2]]);
            strip.addEntry(triangleStrip.m_data[ind]);
            if (midEdge.isInside(1.0E-8)) {
                midEdge.setElementInd(triangleStrip.m_data[ind]);
                found = true;
                break;
            }
            ++i;
        }
        strip.invert();
        if (!found) {
            PsDebug.warning((String)"Midpoint barycentric coordinates is not found");
        }
    }

    public static void makeUnfoldedStripInDiscoPreservesRun(PgElementSet geom, PuTransitionFunction[][] g, PiVector run, PgElementSet unfolded) {
        PdVector[][] disco = geom.getElementTextures();
        PiVector[] neighb = geom.getNeighbours();
        int noe = run.getSize();
        int nov = noe + 2;
        if (unfolded == null) {
            unfolded = new PgElementSet(2);
        }
        unfolded.setDimOfVertices(2);
        unfolded.setNumElements(noe);
        unfolded.setNumVertices(nov);
        unfolded.setDimOfElements(3);
        PdVector[] uvert = unfolded.getVertices();
        PiVector[] uelem = unfolded.getElements();
        int currentElem = run.m_data[0];
        int i = 0;
        while (i < 3) {
            unfolded.setVertex(i, disco[currentElem][i]);
            ++i;
        }
        unfolded.setElement(0, 0, 1, 2);
        unfolded.getElement(0).setName("" + currentElem);
        int index = 1;
        int vindex = 3;
        int prepreviousElem = -1;
        int previousElem = -1;
        int localIndex = -1;
        int localOppIndex = -1;
        PuTransitionFunction tmp = PuTransitionFunction.identity();
        int i2 = 1;
        while (i2 < noe) {
            prepreviousElem = previousElem;
            currentElem = run.m_data[i2];
            previousElem = currentElem;
            if (currentElem != previousElem) {
                localIndex = -1;
                int n = neighb[previousElem].getSize();
                int j = 0;
                while (j < n) {
                    if (neighb[previousElem].m_data[j] == currentElem) {
                        localIndex = j;
                        localOppIndex = geom.getOppVertexLocInd(previousElem, localIndex);
                    }
                    ++j;
                }
                if (localIndex < 0) {
                    PsDebug.error((String)"triangle run not connected");
                    j = 0;
                    while (j < noe) {
                        geom.getElement(run.m_data[j]).setTag(1);
                        geom.update((Object)geom);
                        ++j;
                    }
                    return;
                }
                tmp.concatLeft(g[currentElem][localOppIndex]);
                uvert[vindex] = tmp.evalNew(disco[currentElem][localOppIndex]);
                uelem[index].m_data[localOppIndex] = vindex++;
                uelem[index].m_data[(localOppIndex + 1) % 3] = uelem[index - 1].m_data[(localIndex + 2) % 3];
                uelem[index].m_data[(localOppIndex + 2) % 3] = uelem[index - 1].m_data[(localIndex + 1) % 3];
                uelem[index].setName("" + currentElem);
                ++index;
            }
            ++i2;
        }
        unfolded.setNumElements(index);
        unfolded.setNumVertices(vindex);
    }

    public void computeDualComplex(PgPolygonSetOnElementSet dual, PiVector singularityIndex) {
        if (this.m_baseComplex == null) {
            PsDebug.error((String)"Missing primal complex");
            return;
        }
        if (!this.m_hasPatchConnectivity) {
            this.makePatchConnectivity();
        }
        if (!this.m_hasPatchNeighbor) {
            this.makePatchNeighbor();
        }
        if (!this.m_hasPatchStrip) {
            this.makeLoopStripDual();
        }
        PiVector[][] quadStrip = this.getLoopStrip();
        int numStrip = quadStrip.length;
        int i = 0;
        while (i < numStrip) {
            dual.merge((PgGeometryIf)this.makeDualLineFromStrip(quadStrip[i], singularityIndex));
            ++i;
        }
    }

    public static boolean getStraightest(PgParamGeom geom, PuTransitionFunction[][] transitionParm, PdBary base, int elementInd, PdBary end, int elementInd2, PiVector run, PgPolygonOnElementSet outPoly, PgElementSet unfolded, PgVertexStar[] vertexStar, PvDisplayIf m_display) {
        int m;
        if (unfolded == null) {
            unfolded = new PgElementSet(2);
        }
        PwBaseComplexParam.makeUnfoldedStripInDiscoPreservesRun((PgElementSet)geom, transitionParm, run, unfolded);
        unfolded.setName("Unfolded");
        PdBary start = (PdBary)base.clone();
        PdVector pStart = new PdVector(2);
        PdVector pEnd = new PdVector(2);
        PdVector[] triS = unfolded.getElementVertices(0);
        PdVector[] triE = unfolded.getElementVertices(unfolded.getNumElements() - 1);
        start.getVertex(pStart, triS[0], triS[1], triS[2]);
        end.getVertex(pEnd, triE[0], triE[1], triE[2]);
        int initElt = start.m_elementInd;
        PdBary bEnd = new PdBary(3);
        PdBary.getBary((PdBary)bEnd, (PdVector)pEnd, (PdVector)triS[0], (PdVector)triS[1], (PdVector)triS[2]);
        bEnd.m_elementInd = start.m_elementInd;
        if (outPoly == null) {
            outPoly = new PgPolygonOnElementSet((PgElementSet)geom);
        }
        double length = PdVector.subNew((PdVector)pEnd, (PdVector)pStart).length();
        PdBaryDir dir = new PdBaryDir(3);
        dir.sub(bEnd, start);
        dir.setElementInd(start.m_elementInd);
        PdVector[][] disco = geom.getElementTextures();
        if (initElt == -1) {
            System.out.println("stop");
        }
        if ((m = PwBaseComplexParam.createVectorAtVertexThatShowsIntoElement(pStart, pEnd, initElt, start, dir, transitionParm, disco, vertexStar, (PgElementSet)geom, m_display)) == -1) {
            return false;
        }
        length = PdVector.subNew((PdVector)pEnd, (PdVector)pStart).length();
        return PwBaseComplexParam.evalNew(outPoly, start, pStart, pEnd, geom, length, transitionParm);
    }

    private static boolean evalNew(PgPolygonOnElementSet poly, PdBary m_base, PdVector basePos, PdVector endPos, PgParamGeom geom, double maxTracing, PuTransitionFunction[][] transition) {
        PdVector[][] tex = geom.getElementTextures();
        int element = m_base.m_elementInd;
        int singLocIndex = m_base.isOnVertex(1.0E-8);
        int vOpp = (singLocIndex + 1) % 3;
        PdVector startPos = (PdVector)basePos.clone();
        PdVector lastPos = (PdVector)endPos.clone();
        PdVector dir = PdVector.subNew((PdVector)endPos, (PdVector)startPos);
        PdVector Jdir = new PdVector(2);
        Jdir.m_data[0] = -dir.m_data[1];
        Jdir.m_data[1] = dir.m_data[0];
        PdVector[] triangleDir = new PdVector[3];
        int i = 0;
        while (i < 3) {
            triangleDir[i] = PdVector.subNew((PdVector)tex[element][i], (PdVector)startPos);
            ++i;
        }
        PdVector currPoint = new PdVector(2);
        currPoint.copy(tex[element][(vOpp + 2) % 3]);
        PdVector nextPoint = new PdVector(2);
        PdBary nextBary = new PdBary(3);
        PdBary currBary = new PdBary(3);
        currBary.m_data[vOpp] = 0.0;
        currBary.m_data[(vOpp + 1) % 3] = 0.0;
        currBary.m_data[(vOpp + 2) % 3] = 1.0;
        currBary.m_elementInd = element;
        int MAX_COUNT = geom.getNumElements();
        poly.setNumVertices(1);
        poly.setVertexBary(0, m_base);
        double currLength = 0.0;
        int i2 = 0;
        while (i2 < MAX_COUNT) {
            int v1 = (vOpp + 1) % 3;
            int v2 = (vOpp + 2) % 3;
            int v = -1;
            int newElement = -1;
            int vOppNew = -1;
            int thirdV = -1;
            int locInd = -1;
            double a = PdVector.dot((PdVector)Jdir, (PdVector)triangleDir[vOpp]);
            double b = PdVector.dot((PdVector)Jdir, (PdVector)triangleDir[v1]);
            double c = PdVector.dot((PdVector)Jdir, (PdVector)triangleDir[v2]);
            if (Math.abs(a) < 1.0E-8) {
                locInd = v1;
            } else if (Math.abs(b) < 1.0E-8) {
                locInd = vOpp;
            }
            if (locInd != -1 && PuMath.modulo((int)geom.getCovering().getBranchType(geom.getElement(element).getEntry(locInd)), (int)geom.getCovering().getSymmetryOrder()) != 0) {
                PdVector bary = new PdVector(3);
                bary.setEntry(locInd, 1);
                bary.setEntry((locInd + 1) % 3, 0);
                bary.setEntry((locInd + 2) % 3, 0);
                poly.setNumVertices(poly.getNumVertices() + 1);
                poly.setVertexBary(poly.getNumVertices() - 1, new PdBary(element, bary.getEntry(0), bary.getEntry(1), bary.getEntry(2)));
                return true;
            }
            if (locInd != -1) {
                PsDebug.warning((String)"Path goes through a vertex");
            }
            double val1 = -1.0;
            double val2 = a;
            if (Math.signum(a * b) <= 0.0) {
                v = v1;
                vOppNew = geom.getOppVertexLocInd(element, v2);
                newElement = geom.getNeighbour(element).getEntry(v2);
                thirdV = v2;
                val1 = b;
            } else if (Math.signum(a * c) < 0.0) {
                v = v2;
                vOppNew = geom.getOppVertexLocInd(element, v1);
                newElement = geom.getNeighbour(element).getEntry(v1);
                thirdV = v1;
                val1 = c;
            } else {
                PsDebug.warning((String)"Cannot trace on the current triangle");
                return false;
            }
            if (val1 > 0.0) {
                double temp = val1;
                val1 = val2;
                val2 = temp;
                int tempInd = vOpp;
                vOpp = v;
                v = tempInd;
            }
            double d = -val1 / (val2 - val1);
            PdVector bary = new PdVector(3);
            bary.setEntry(v, 1.0 - d);
            bary.setEntry(vOpp, d);
            bary.setEntry(thirdV, 0);
            poly.setNumVertices(poly.getNumVertices() + 1);
            poly.setVertexBary(poly.getNumVertices() - 1, new PdBary(element, bary.getEntry(0), bary.getEntry(1), bary.getEntry(2)));
            nextBary = new PdBary(3);
            nextBary.m_data[v] = 1.0 - d;
            nextBary.m_data[vOpp] = d;
            nextBary.m_data[thirdV] = 0.0;
            nextBary.m_elementInd = element;
            currBary.getVertex(currPoint, tex[element][0], tex[element][1], tex[element][2]);
            nextBary.getVertex(nextPoint, tex[element][0], tex[element][1], tex[element][2]);
            currLength += PdVector.subNew((PdVector)currPoint, (PdVector)nextPoint).length();
            if (maxTracing + 1.0 < currLength) {
                return false;
            }
            PuTransitionFunction _tmp = transition[element][thirdV];
            if (_tmp == null) {
                return true;
            }
            currBary.m_data[vOppNew] = 0.0;
            if (v == (vOpp + 1) % 3) {
                currBary.m_data[(vOppNew + 1) % 3] = 1.0 - d;
                currBary.m_data[(vOppNew + 2) % 3] = d;
            } else {
                currBary.m_data[(vOppNew + 1) % 3] = d;
                currBary.m_data[(vOppNew + 2) % 3] = 1.0 - d;
            }
            currBary.m_elementInd = newElement;
            element = newElement;
            vOpp = vOppNew;
            _tmp.eval(startPos);
            _tmp.eval(lastPos);
            dir = PdVector.subNew((PdVector)lastPos, (PdVector)startPos);
            Jdir.m_data[0] = -dir.m_data[1];
            Jdir.m_data[1] = dir.m_data[0];
            int j = 0;
            while (j < 3) {
                triangleDir[j] = PdVector.subNew((PdVector)tex[element][j], (PdVector)startPos);
                ++j;
            }
            ++i2;
        }
        return false;
    }

    static final int eval(PdBary base, PdBaryDir dir, PgPolygonOnElementSet outPoly, PuTransitionFunction[][] g, PdVector[][] disco, PgVertexStar[] vertexStar, PvDisplayIf m_display) {
        boolean baseOnEdgeDirPointsOutside;
        int zero = PwBary.liesOnVertex((PdBary)base);
        if (zero != -1 && !PwBary.showsIntoElement((PdBaryDir)dir, (int)zero)) {
            PsDebug.error((String)"Assure that direction point into element");
            return -1;
        }
        PgElementSet geom = outPoly.getGeometry();
        if (base.m_elementInd < 0) {
            return -1;
        }
        PdBary[] polyVertex = null;
        int numPolyVertices = 1;
        Object outPoint = null;
        PdBaryDir m_transformedDir = new PdBaryDir(3);
        double m_accuracy = 1.0E-10;
        PdBary m_intersectionPoint = new PdBary(3);
        outPoly.setMaxNumVertices(1000);
        outPoly.setNumVertices(2);
        polyVertex = outPoly.getVertexBary();
        PdBary transformedPoint = polyVertex[0];
        PdBaryDir transformedDir = m_transformedDir;
        boolean baseOutside = false;
        boolean baseOnEdge = false;
        boolean baseOnVertex = false;
        boolean dirPointsOutside = false;
        transformedPoint.copy(base);
        transformedDir.copy(dir);
        double[] p = transformedPoint.m_data;
        double[] d = transformedDir.m_data;
        int i = 0;
        while (i < 3) {
            if (p[i] < -m_accuracy) break;
            if (p[i] <= m_accuracy) {
                int n = i;
                d[n] = d[n] + p[i];
                p[i] = 0.0;
                baseOnVertex = baseOnEdge;
                baseOnEdge = true;
                dirPointsOutside |= d[i] < -m_accuracy;
            }
            ++i;
        }
        if (baseOnEdge) {
            transformedPoint.validate();
            transformedDir.validate();
        }
        if (baseOutside) {
            return -1;
        }
        if (baseOnVertex) {
            // empty if block
        }
        boolean bl = baseOnEdgeDirPointsOutside = baseOnEdge && !baseOnVertex && dirPointsOutside;
        if (!baseOnEdgeDirPointsOutside) {
            numPolyVertices = 2;
            polyVertex[0].copy(transformedPoint);
            transformedPoint = polyVertex[1];
            transformedPoint.add(polyVertex[0], transformedDir);
            transformedPoint.m_elementInd = polyVertex[0].m_elementInd;
            p = transformedPoint.m_data;
        } else {
            transformedPoint.add(transformedDir);
        }
        int result = 1;
        PdBary intersectionPoint = m_intersectionPoint;
        PuTransitionFunction transition = PuTransitionFunction.identity();
        PdVector[] currTriangle = new PdVector[3];
        PdVector.realloc((PdVector[])currTriangle, (int)3, (int)2);
        int i2 = 0;
        while (i2 < 3) {
            currTriangle[i2].copy(disco[transformedPoint.m_elementInd][i2]);
            ++i2;
        }
        PdVector[] nextTriangle = new PdVector[3];
        PdVector.realloc((PdVector[])nextTriangle, (int)3, (int)2);
        PgElementSet unfolded = new PgElementSet(2);
        unfolded.setDimOfVertices(2);
        int noe = 1000;
        int nov = 1000;
        unfolded.setNumElements(noe);
        unfolded.setNumVertices(nov);
        unfolded.setDimOfElements(3);
        int vindex = 3;
        int index = 1;
        int i3 = 0;
        while (i3 < 3) {
            unfolded.setVertex(i3, currTriangle[i3]);
            ++i3;
        }
        unfolded.setElement(0, 0, 1, 2);
        PdVector[] uvert = unfolded.getVertices();
        PiVector[] uelem = unfolded.getElements();
        PgPolygon gon = new PgPolygon(2);
        PdVector v = new PdVector(2);
        polyVertex[0].getVertex(v, currTriangle[0], currTriangle[1], currTriangle[2]);
        gon.addVertex(v);
        boolean finish = false;
        block3: while (true) {
            int j;
            PdVector _t;
            int intersectionVertex = -1;
            double m = 0.0;
            int opposing = -1;
            int i4 = 0;
            while (i4 < 3) {
                double m_temp;
                if (p[i4] < -m_accuracy && d[i4] < 0.0 && (m_temp = p[i4] / d[i4]) > m) {
                    m = m_temp;
                    opposing = i4;
                }
                ++i4;
            }
            if (m < 1.0E-8) {
                int j2 = 0;
                while (j2 < 3) {
                    if (p[j2] < 1.0E-8) {
                        p[j2] = 0.0;
                    }
                    if (Math.abs(p[j2] - 1.0) < 1.0E-8) {
                        p[j2] = 1.0;
                    }
                    ++j2;
                }
                break;
            }
            if (opposing == -1) break;
            outPoly.setNumVertices(numPolyVertices + 1);
            polyVertex = outPoly.getVertexBary();
            intersectionPoint = polyVertex[numPolyVertices];
            polyVertex[numPolyVertices] = transformedPoint;
            polyVertex[numPolyVertices - 1] = intersectionPoint;
            ++numPolyVertices;
            boolean intersectionOnVertex = false;
            i4 = 0;
            while (i4 < 3) {
                if (i4 != opposing) {
                    if (p[i4] < m_accuracy && Math.abs(p[i4] - m * d[i4]) < m_accuracy) {
                        intersectionOnVertex = true;
                    } else {
                        intersectionVertex = i4;
                    }
                }
                ++i4;
            }
            if (intersectionOnVertex) {
                PsDebug.error((String)"Intersection is on a vertex");
                break;
            }
            int currElem = transformedPoint.m_elementInd;
            int nextElem = geom.getNeighbour((int)currElem).m_data[opposing];
            int localOppIndex = geom.getOppVertexLocInd(currElem, opposing);
            transition.concatLeft(g[nextElem][localOppIndex]);
            nextTriangle[localOppIndex].copy(transition.evalNew(disco[nextElem][localOppIndex]));
            nextTriangle[(localOppIndex + 1) % 3].copy(currTriangle[(opposing + 2) % 3]);
            nextTriangle[(localOppIndex + 2) % 3].copy(currTriangle[(opposing + 1) % 3]);
            uvert[vindex] = (PdVector)nextTriangle[localOppIndex].clone();
            uelem[index].m_data[localOppIndex] = vindex++;
            uelem[index].m_data[(localOppIndex + 1) % 3] = uelem[index - 1].m_data[(opposing + 2) % 3];
            uelem[index].m_data[(localOppIndex + 2) % 3] = uelem[index - 1].m_data[(opposing + 1) % 3];
            uelem[index].setName("" + transformedPoint.m_elementInd);
            ++index;
            if (PdVector.area((PdVector[])currTriangle) < 0.001) {
                _t = new PdVector(2);
                transformedPoint.getVertex(_t, currTriangle[0], currTriangle[1], currTriangle[2]);
                PdBaryDir.getVector((PdVector)_t, (PdBaryDir)transformedDir, (PdVector)currTriangle[0], (PdVector)currTriangle[1], (PdVector)currTriangle[2]);
                PdBary.add((PdBary)transformedPoint, (double)(-m), (PdBaryDir)transformedDir, (PdBary)intersectionPoint);
                intersectionPoint.m_data[opposing] = 0.0;
                intersectionPoint.m_elementInd = transformedPoint.m_elementInd;
                intersectionPoint.getVertex(v, currTriangle[0], currTriangle[1], currTriangle[2]);
                gon.addVertex(v);
                PdBary.getBary((PdBary)transformedPoint, (PdVector)_t, (PdVector)nextTriangle[0], (PdVector)nextTriangle[1], (PdVector)nextTriangle[2]);
                PdBaryDir.getBaryDir((PdBaryDir)transformedDir, (PdVector)_t, (PdVector)nextTriangle[0], (PdVector)nextTriangle[1], (PdVector)nextTriangle[2]);
                j = 0;
                while (true) {
                    if (j >= 3) continue block3;
                    currTriangle[j].copy(nextTriangle[j]);
                    ++j;
                }
            }
            _t = new PdVector(2);
            transformedPoint.getVertex(_t, currTriangle[0], currTriangle[1], currTriangle[2]);
            PdBary.getBary((PdBary)transformedPoint, (PdVector)_t, (PdVector)nextTriangle[0], (PdVector)nextTriangle[1], (PdVector)nextTriangle[2]);
            PdBaryDir.getVector((PdVector)_t, (PdBaryDir)transformedDir, (PdVector)currTriangle[0], (PdVector)currTriangle[1], (PdVector)currTriangle[2]);
            PdBaryDir.getBaryDir((PdBaryDir)transformedDir, (PdVector)_t, (PdVector)nextTriangle[0], (PdVector)nextTriangle[1], (PdVector)nextTriangle[2]);
            j = 0;
            while (j < 3) {
                currTriangle[j].copy(nextTriangle[j]);
                ++j;
            }
            PdBary.add((PdBary)transformedPoint, (double)(-m), (PdBaryDir)transformedDir, (PdBary)intersectionPoint);
            int ovli = geom.getOppVertexLocInd(transformedPoint.m_elementInd, opposing);
            intersectionPoint.m_data[ovli] = 0.0;
            intersectionPoint.m_elementInd = nextElem;
            if (gon.getNumVertices() == 30) {
                System.out.println(PdVector.area((PdVector[])currTriangle));
                System.out.println("debug");
            }
            intersectionPoint.getVertex(v, currTriangle[0], currTriangle[1], currTriangle[2]);
            gon.addVertex(v);
            transformedPoint.m_elementInd = nextElem;
        }
        if (result == 0) {
            outPoly.setNumVertices(--numPolyVertices);
            polyVertex[numPolyVertices - 1] = transformedPoint;
            polyVertex[numPolyVertices] = intersectionPoint;
        }
        outPoly.computeVertices();
        gon.setName("path");
        unfolded.setName("strip");
        m_display.addGeometry((PgGeometryIf)unfolded);
        m_display.addGeometry((PgGeometryIf)gon);
        return result;
    }

    private static int createVectorAtVertexThatShowsIntoElement(PdVector startPos, PdVector endPos, int iniElem, PdBary iniBary, PdBaryDir iniDir, PuTransitionFunction[][] g, PdVector[][] tex, PgVertexStar[] vertexStar, PgElementSet geom, PvDisplayIf m_display) {
        int zero = PwBary.liesOnVertex((PdBary)iniBary);
        PdVector[] prevTriangle = new PdVector[3];
        int i = 0;
        while (i < 3) {
            prevTriangle[i] = (PdVector)tex[iniElem][i].clone();
            ++i;
        }
        PgPolygon check = new PgPolygon(2);
        PdVector start = new PdVector(2);
        iniBary.getVertex(start, prevTriangle[0], prevTriangle[1], prevTriangle[2]);
        PdVector end = new PdVector(2);
        PdBary copy = new PdBary(3);
        copy.add(iniBary, iniDir);
        copy.getVertex(end, prevTriangle[0], prevTriangle[1], prevTriangle[2]);
        check.addVertex(start);
        check.addVertex(end);
        check.setName("dir");
        if (zero == -1 || PwBary.showsIntoElement((PdBaryDir)iniDir, (int)zero)) {
            return iniElem;
        }
        PiVector[] element = geom.getElements();
        PgVertexStar vs = vertexStar[element[iniElem].m_data[zero]];
        PiVector adjElt = (PiVector)vs.getElement().clone();
        PiVector locIndx = (PiVector)vs.getVertexLocInd().clone();
        int indeStar = adjElt.getIndexOf(iniElem);
        boolean isPositive = true;
        if (iniDir.m_data[(locIndx.m_data[indeStar] + 2) % 3] <= 0.0) {
            isPositive = false;
        }
        PdVector[] triangleDir = new PdVector[3];
        int size = adjElt.getSize();
        int oppLocIndex = -1;
        int currElt = adjElt.m_data[indeStar];
        int nextElt = -1;
        PuTransitionFunction trans = PuTransitionFunction.identity();
        int vertInd = -1;
        int vert = element[iniElem].m_data[zero];
        int currLoc = locIndx.m_data[indeStar];
        int nextLoc = -1;
        PdVector dir = null;
        PdVector Jdir = new PdVector(2);
        int i2 = 0;
        while (i2 < size) {
            currLoc = element[currElt].getIndexOf(vert);
            vertInd = (currLoc + 1) % 3;
            if (!isPositive) {
                vertInd = (currLoc + 2) % 3;
            }
            nextElt = geom.getNeighbour((int)currElt).m_data[vertInd];
            oppLocIndex = geom.getOppVertexLocInd(currElt, vertInd);
            trans.concatLeft(g[currElt][vertInd]);
            trans.eval(startPos);
            trans.eval(endPos);
            dir = PdVector.subNew((PdVector)endPos, (PdVector)startPos);
            Jdir.m_data[0] = -dir.m_data[1];
            Jdir.m_data[1] = dir.m_data[0];
            int j = 0;
            while (j < 3) {
                triangleDir[j] = PdVector.subNew((PdVector)tex[nextElt][j], (PdVector)startPos);
                ++j;
            }
            int v2 = nextLoc = element[nextElt].getIndexOf(vert);
            int vOpp = (nextLoc + 1) % 3;
            int v1 = (nextLoc + 2) % 3;
            double a = PdVector.dot((PdVector)Jdir, (PdVector)triangleDir[vOpp]);
            double b = PdVector.dot((PdVector)Jdir, (PdVector)triangleDir[v1]);
            double c = PdVector.dot((PdVector)Jdir, (PdVector)triangleDir[v2]);
            if (Math.signum(a * b) <= 0.0 || Math.signum(a * c) < 0.0) {
                iniBary.m_data[v2] = 1.0;
                iniBary.m_data[vOpp] = 0.0;
                iniBary.m_data[v1] = 0.0;
                iniBary.m_elementInd = nextElt;
                return nextElt;
            }
            currElt = nextElt;
            ++i2;
        }
        return -1;
    }
}

