/*
 * Decompiled with CFR 0.152.
 */
package devParameterize.geom;

import dev.vecmath.PiDynVector;
import devCovering.PgCovering;
import devCovering.PgFrameField;
import devParameterize.geom.PgParamGeom;
import java.awt.Color;
import java.util.Vector;
import jv.geom.PgElementSet;
import jv.geom.PgPolygonSet;
import jv.object.PsDebug;
import jv.vecmath.PbVector;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuMath;
import jvx.geom.PgVertexStar;

public class PgSharpConstraints {
    private PgParamGeom m_geom;
    private Vector m_vertexPolygon = new Vector();
    private Vector<Boolean> m_isMarked = new Vector();
    private Vector<Boolean> m_isHard = new Vector();
    private Vector<Boolean> m_isBoundary;
    private Vector<Boolean> m_isEnabled = new Vector();
    private Vector<PiVector> m_vertexPolygonCut;
    private PiVector[] m_elementsRight;
    private PiVector[] m_locVertexIndRight;
    private PiVector[] m_layerRight;
    private Vector<Boolean> m_isHardCut;
    private boolean m_cutConstraints = false;
    private PdVector m_softConstraintRv;

    public PgSharpConstraints() {
        this.m_isBoundary = new Vector();
        this.m_vertexPolygonCut = new Vector();
        this.m_isHardCut = new Vector();
        this.m_softConstraintRv = new PdVector();
    }

    protected PgParamGeom getGeometry() {
        return this.m_geom;
    }

    public void setGeometry(PgParamGeom geom) {
        this.m_geom = geom;
    }

    public PgPolygonSet getConstraintsAsPolygonSet() {
        PgPolygonSet ps = new PgPolygonSet(3);
        ps.setName("Sharp constraints");
        ps.setEnabledInstanceSharing(true);
        ps.setNumVertices(this.m_geom.getNumVertices());
        ps.setMaxNumVertices(this.m_geom.getMaxNumVertices());
        ps.setVertices(this.m_geom.getVertices());
        ps.setEnabledInstanceSharing(false);
        ps.showVertices(false);
        int numP = this.m_vertexPolygon.size();
        ps.setNumPolygons(numP);
        int p = 0;
        while (p < numP) {
            PiVector poly = (PiVector)this.m_vertexPolygon.elementAt(p);
            ps.setPolygon(p, poly);
            if (this.isMarked(p)) {
                ps.setTagPolygon(p, 1);
            } else if (!this.isEnabled(p)) {
                ps.assurePolygonColors();
                ps.showPolygonColors(true);
                ps.setPolygonColor(p, Color.gray);
            }
            ++p;
        }
        return ps;
    }

    public Vector getVertexPolygon() {
        return this.m_vertexPolygon;
    }

    public PiVector[] getElementsRight() {
        return this.m_elementsRight;
    }

    public PiVector[] getLocVertexIndRight() {
        return this.m_locVertexIndRight;
    }

    public PiVector[] getLayerRight() {
        return this.m_layerRight;
    }

    public void setConstraintValue(int index, double value) {
        if (index < 0 || index >= this.m_softConstraintRv.getSize()) {
            return;
        }
        this.m_softConstraintRv.m_data[index] = value;
    }

    public double getConstraintValue(int index) {
        if (index < 0 || index >= this.m_softConstraintRv.getSize()) {
            return 0.0;
        }
        return this.m_softConstraintRv.m_data[index];
    }

    public PdVector getConstraintValues() {
        return this.m_softConstraintRv;
    }

    public void removeAllConstraints() {
        this.m_vertexPolygon.clear();
        this.m_vertexPolygonCut.clear();
        this.m_isMarked.clear();
        this.m_isHard.clear();
        this.m_isEnabled.clear();
        this.m_isBoundary.clear();
        this.m_softConstraintRv.setSize(0);
        this.m_elementsRight = null;
        this.m_locVertexIndRight = null;
        this.m_layerRight = null;
    }

    public void removeMarkedConstraints() {
        int num;
        int i = num = this.m_vertexPolygon.size() - 1;
        while (i >= 0) {
            if (this.m_isMarked.elementAt(i).booleanValue()) {
                this.m_vertexPolygon.remove(i);
                this.m_vertexPolygonCut.clear();
                this.m_isMarked.remove(i);
                this.m_isHard.remove(i);
                this.m_isEnabled.remove(i);
                this.m_isBoundary.remove(i);
                this.m_softConstraintRv.removeEntry(i);
                this.m_elementsRight = null;
                this.m_locVertexIndRight = null;
                this.m_layerRight = null;
            }
            --i;
        }
    }

    private void addConstraint(PiVector vertexPolygon, boolean isBoundary, double constraintValue) {
        this.m_vertexPolygon.addElement(vertexPolygon);
        this.m_isMarked.addElement(Boolean.FALSE);
        this.m_isHard.addElement(Boolean.TRUE);
        this.m_isEnabled.addElement(Boolean.TRUE);
        this.m_isBoundary.addElement(isBoundary);
        int numC = this.m_softConstraintRv.getSize();
        this.m_softConstraintRv.setSize(numC + 1);
        this.m_softConstraintRv.m_data[numC] = constraintValue;
        this.m_elementsRight = null;
        this.m_locVertexIndRight = null;
        this.m_layerRight = null;
        this.m_vertexPolygonCut.clear();
    }

    public void addConstraint(PiVector vertexPolygon) {
        this.addConstraint(vertexPolygon, false, 0.0);
    }

    public void addConstraint(PiVector vertexPolygon, double constraintValue) {
        this.addConstraint(vertexPolygon, false, constraintValue);
    }

    public void updateConstraints() {
        this.m_isHardCut.clear();
        this.m_vertexPolygonCut.clear();
        int numC = this.m_vertexPolygon.size();
        int c = 0;
        while (c < numC) {
            PiVector vertexPolygon = (PiVector)this.m_vertexPolygon.elementAt(c);
            if (this.m_cutConstraints) {
                PiVector elements0 = new PiVector();
                PiVector locVertInd0 = new PiVector();
                PiVector layer0 = new PiVector();
                boolean bSwitchLayer = this.m_isHard.elementAt(c) == false && this.m_softConstraintRv.m_data[c] != 0.0;
                if (this.tracePolygon(vertexPolygon, elements0, locVertInd0, layer0, bSwitchLayer)) {
                    this.cutPolygonByLayer(vertexPolygon, elements0, locVertInd0, layer0, this.m_vertexPolygonCut, this.m_isHardCut, this.m_isHard.elementAt(c));
                } else {
                    PiVector invVertexPolygon = PiVector.copyNew((PiVector)vertexPolygon);
                    invVertexPolygon.invert();
                    PiVector elements1 = new PiVector();
                    PiVector locVertInd1 = new PiVector();
                    PiVector layer1 = new PiVector();
                    if (this.tracePolygon(invVertexPolygon, elements1, locVertInd1, layer1, bSwitchLayer)) {
                        this.cutPolygonByLayer(vertexPolygon, elements1, locVertInd1, layer1, this.m_vertexPolygonCut, this.m_isHardCut, this.m_isHard.elementAt(c));
                    } else {
                        PsDebug.warning((String)("Illegal polygon: " + c));
                    }
                }
            } else {
                this.m_vertexPolygonCut.addElement(vertexPolygon);
                this.m_isHardCut.addElement(this.m_isHard.elementAt(c));
            }
            ++c;
        }
        numC = this.m_vertexPolygonCut.size();
        this.m_elementsRight = new PiVector[numC];
        this.m_locVertexIndRight = new PiVector[numC];
        this.m_layerRight = new PiVector[numC];
        c = 0;
        while (c < numC) {
            boolean bSwitchLayer = this.m_isHard.elementAt(c) == false && this.m_softConstraintRv.m_data[c] != 0.0;
            this.m_elementsRight[c] = new PiVector();
            this.m_locVertexIndRight[c] = new PiVector();
            this.m_layerRight[c] = new PiVector();
            PiVector vertexPolygon = this.m_vertexPolygonCut.elementAt(c);
            if (!this.tracePolygon(vertexPolygon, this.m_elementsRight[c], this.m_locVertexIndRight[c], this.m_layerRight[c], bSwitchLayer)) {
                this.m_vertexPolygonCut.set(c, vertexPolygon.invert());
                if (!this.tracePolygon(vertexPolygon, this.m_elementsRight[c], this.m_locVertexIndRight[c], this.m_layerRight[c], bSwitchLayer)) {
                    PsDebug.warning((String)"Illegal cut polygon, should never happen");
                }
            }
            ++c;
        }
    }

    private void cutPolygonByLayer(PiVector vertexPolygon, PiVector elements, PiVector locVertInd, PiVector layer, Vector<PiVector> vertexPolygonCut, Vector<Boolean> hardCut, Boolean isHard) {
        int dim = elements.getSize();
        int r = layer.getFirstEntry();
        int pos = 0;
        int lastPos = 0;
        PiVector cutVertexPolygon = new PiVector(dim);
        int prevE = elements.getFirstEntry();
        int symmOrder = this.m_geom.getCovering().getSymmetryOrder();
        int i = 0;
        while (i < dim - 1) {
            if (elements.m_data[i] == prevE) {
                int v;
                int e = elements.m_data[i];
                cutVertexPolygon.m_data[pos] = v = this.m_geom.getElement((int)e).m_data[locVertInd.m_data[i]];
                int actR = layer.m_data[i];
                if (PuMath.modulo((int)(actR - r), (int)symmOrder) != 0) {
                    PiVector poly = new PiVector(pos - lastPos + 1);
                    int j = 0;
                    while (j < pos - lastPos + 1) {
                        poly.m_data[j] = cutVertexPolygon.m_data[lastPos + j];
                        ++j;
                    }
                    vertexPolygonCut.addElement(poly);
                    hardCut.addElement(isHard);
                    lastPos = pos;
                    r = actR;
                }
                ++pos;
            } else {
                prevE = elements.m_data[i];
            }
            ++i;
        }
        PiVector poly = new PiVector(pos - lastPos + 1);
        int j = 0;
        while (j < pos - lastPos) {
            poly.m_data[j] = cutVertexPolygon.m_data[lastPos + j];
            ++j;
        }
        poly.m_data[pos - lastPos] = vertexPolygon.getLastEntry();
        vertexPolygonCut.addElement(poly);
        hardCut.addElement(isHard);
    }

    private boolean tracePolygon(PiVector vertexPolygon, PiVector pElements, PiVector pLocVertInd, PiVector pLayer, boolean switchLayer) {
        int i;
        PgVertexStar star = new PgVertexStar();
        PiVector elementPerVertex = PgVertexStar.getElementPerVertex((PgElementSet)this.m_geom);
        PiDynVector dynElements = new PiDynVector();
        PiDynVector dynLocVertexInd = new PiDynVector();
        PiDynVector dynLayer = new PiDynVector();
        int r = 0;
        int len = vertexPolygon.getSize();
        PgCovering covering = this.m_geom.getCovering();
        int symmOrder = covering.getSymmetryOrder();
        double[] scalarProducts = new double[symmOrder / 2];
        star.makeVertexStar((PgElementSet)this.m_geom, vertexPolygon.m_data[0], elementPerVertex.m_data[vertexPolygon.m_data[0]]);
        if (vertexPolygon.getSize() == 1) {
            PiVector vElement = this.m_geom.getElement(elementPerVertex.getEntry(vertexPolygon.m_data[0]));
            int locVInd = -1;
            int dim = 0;
            while (dim < vElement.getSize()) {
                if (vElement.getEntry(dim) == vertexPolygon.m_data[0]) {
                    locVInd = dim;
                    break;
                }
                ++dim;
            }
            if (locVInd < 0) {
                PsDebug.warning((String)"Error setting one point constraint.");
                return false;
            }
            i = 0;
            while (i < symmOrder / 2) {
                dynElements.appendEntry(elementPerVertex.getEntry(vertexPolygon.m_data[0]));
                dynLocVertexInd.appendEntry(locVInd);
                dynLayer.appendEntry(i);
                ++i;
            }
        } else {
            int linkSize = star.getLink().getSize();
            int nInd = star.getLink().getIndexOf(vertexPolygon.m_data[1]);
            if (nInd < 0) {
                PsDebug.warning((String)"Problems in neighbours");
                return false;
            }
            if (!star.isClosed() && nInd == 0) {
                return false;
            }
            dynElements.appendEntry(star.getElement().m_data[(nInd - 1 + linkSize) % linkSize]);
            dynLocVertexInd.appendEntry(star.getVertexLocInd().m_data[(nInd - 1 + linkSize) % linkSize]);
            dynLayer.appendEntry(r);
            i = 1;
            while (i < len) {
                int v = vertexPolygon.m_data[i];
                star.makeVertexStar((PgElementSet)this.m_geom, v, elementPerVertex.m_data[v]);
                PiVector elements = star.getElement();
                PiVector link = star.getLink();
                PiVector vLocInd = star.getVertexLocInd();
                int dim = link.getSize();
                int pv = vertexPolygon.m_data[i - 1];
                int pInd = link.getIndexOf(pv);
                if (pInd < 0) {
                    PsDebug.warning((String)"Problems in neighbours");
                    return false;
                }
                PdVector bndEdge = PdVector.subNew((PdVector)this.m_geom.getVertex(v), (PdVector)this.m_geom.getVertex(pv));
                int e = elements.m_data[pInd];
                int j = 0;
                while (j < symmOrder / 2) {
                    int n = j;
                    scalarProducts[n] = scalarProducts[n] + this.m_geom.getFrameField().getVector(e, (j + r) % symmOrder, 0, null).dot(bndEdge);
                    ++j;
                }
                dynElements.appendEntry(e);
                dynLocVertexInd.appendEntry(vLocInd.m_data[pInd]);
                dynLayer.appendEntry(r);
                if (i < len - 1) {
                    int nv = vertexPolygon.m_data[i + 1];
                    nInd = link.getIndexOf(nv);
                    if (nInd < 0) {
                        PsDebug.warning((String)"Problems in neighbours");
                        return false;
                    }
                    if (!star.isClosed() && nInd <= pInd) {
                        return false;
                    }
                    int locElementInVStar = pInd;
                    while ((locElementInVStar + 1) % dim != nInd) {
                        int locEdgeInd = (vLocInd.m_data[locElementInVStar] + 1) % 3;
                        r = PuMath.modulo((int)(r + covering.getMatching(e, locEdgeInd)), (int)symmOrder);
                        locElementInVStar = (locElementInVStar + 1) % dim;
                        e = elements.m_data[locElementInVStar];
                        dynElements.appendEntry(e);
                        dynLocVertexInd.appendEntry(vLocInd.m_data[locElementInVStar]);
                        dynLayer.appendEntry(r);
                    }
                    ++i;
                    continue;
                }
                break;
            }
        }
        dynLayer.toPiVector(pLayer);
        dynElements.toPiVector(pElements);
        dynLocVertexInd.toPiVector(pLocVertInd);
        double min = Double.MAX_VALUE;
        i = 0;
        while (i < symmOrder / 2) {
            if (Math.abs(scalarProducts[i]) < min) {
                min = Math.abs(scalarProducts[i]);
                r = i;
            }
            ++i;
        }
        if (switchLayer) {
            r = (r + 1) % (symmOrder / 2);
        }
        int size = pLayer.getSize();
        int i2 = 0;
        while (i2 < size) {
            pLayer.m_data[i2] = (pLayer.m_data[i2] + r) % symmOrder;
            ++i2;
        }
        return true;
    }

    public void makeBoundaryConstraints(PgFrameField field) {
        if (this.m_geom.getCovering() != field.getCovering()) {
            PsDebug.warning((String)"Coverings of geom and frameField do not coincide.");
            return;
        }
        int numV = this.m_geom.getNumVertices();
        boolean[] vertexVisited = new boolean[numV];
        PgVertexStar star = new PgVertexStar();
        PiVector elementPerVertex = PgVertexStar.getElementPerVertex((PgElementSet)this.m_geom);
        int v = 0;
        while (v < numV) {
            if (!vertexVisited[v]) {
                vertexVisited[v] = true;
                star.makeVertexStar((PgElementSet)this.m_geom, v, elementPerVertex.m_data[v]);
                if (!star.isClosed()) {
                    this.traceBoundary(v, vertexVisited, field);
                }
            }
            ++v;
        }
    }

    private void traceBoundary(int startV, boolean[] vertexVisited, PgFrameField field) {
        PgVertexStar star = new PgVertexStar();
        PiVector elementPerVertex = PgVertexStar.getElementPerVertex((PgElementSet)this.m_geom);
        int v = startV;
        PiDynVector vertexPolygon = new PiDynVector();
        do {
            vertexPolygon.appendEntry(v);
            vertexVisited[v] = true;
            star.makeVertexStar((PgElementSet)this.m_geom, v, elementPerVertex.m_data[v]);
            if (!star.isClosed()) continue;
            PsDebug.warning((String)"No boundary vertex.");
            return;
        } while ((v = star.getLink().getLastEntry()) != startV);
        vertexPolygon.appendEntry(v);
        PiVector elements = new PiVector();
        PiVector locVInd = new PiVector();
        PiVector layer = new PiVector();
        vertexPolygon.appendEntry(vertexPolygon.getEntry(1));
        this.tracePolygon(vertexPolygon.toPiVector(), elements, locVInd, layer, false);
        boolean cornersAtMarkedVertices = false;
        int numV = this.m_geom.getNumVertices();
        int ve = 0;
        while (ve < numV) {
            if (this.m_geom.hasTagVertex(ve, 1)) {
                cornersAtMarkedVertices = true;
            }
            ++ve;
        }
        int len = elements.getSize();
        int r = -1;
        int symmOrder = this.m_geom.getCovering().getSymmetryOrder();
        int lastCorner = -1;
        int firstCorner = -1;
        int i = 0;
        while (i < len - 1) {
            int e = elements.m_data[i];
            if (e == elements.m_data[i + 1]) {
                int loc = locVInd.m_data[i];
                int nLoc = locVInd.m_data[i + 1];
                v = this.m_geom.getElement((int)e).m_data[loc];
                int nv = this.m_geom.getElement((int)e).m_data[nLoc];
                int ly = layer.m_data[i];
                PdVector bndEdge = PdVector.subNew((PdVector)this.m_geom.getVertex(nv), (PdVector)this.m_geom.getVertex(v));
                int constrLayer = -1;
                double dot = Double.MAX_VALUE;
                int j = 0;
                while (j < symmOrder / 2) {
                    double d = Math.abs(field.getVector(e, j, 0, null).dot(bndEdge));
                    if (d < dot) {
                        dot = d;
                        constrLayer = j;
                    }
                    ++j;
                }
                if (r >= 0) {
                    boolean setCorner;
                    boolean bl = cornersAtMarkedVertices ? this.m_geom.hasTagVertex(v, 1) : (setCorner = PuMath.modulo((int)(ly + r), (int)(symmOrder / 2)) != constrLayer);
                    if (setCorner) {
                        if (lastCorner >= 0) {
                            PiDynVector poly = new PiDynVector();
                            int lastV = -1;
                            int j2 = lastCorner;
                            while (j2 <= i) {
                                int ve2 = this.m_geom.getElement((int)elements.m_data[j2]).m_data[locVInd.m_data[j2]];
                                if (ve2 != lastV) {
                                    poly.appendEntry(ve2);
                                    lastV = ve2;
                                }
                                ++j2;
                            }
                            this.addConstraint(poly.toPiVector());
                        }
                        if (firstCorner < 0) {
                            firstCorner = i;
                        }
                        lastCorner = i;
                    }
                }
                r = PuMath.modulo((int)(constrLayer - ly), (int)symmOrder);
            }
            ++i;
        }
        PiDynVector poly = new PiDynVector();
        if (lastCorner >= 0) {
            int ve3;
            int lastV = -1;
            int i2 = lastCorner;
            while (i2 < len) {
                ve3 = this.m_geom.getElement((int)elements.m_data[i2]).m_data[locVInd.m_data[i2]];
                if (ve3 != lastV) {
                    poly.appendEntry(ve3);
                    lastV = ve3;
                }
                ++i2;
            }
            i2 = 1;
            while (i2 <= firstCorner) {
                ve3 = this.m_geom.getElement((int)elements.m_data[i2]).m_data[locVInd.m_data[i2]];
                if (ve3 != lastV) {
                    poly.appendEntry(ve3);
                    lastV = ve3;
                }
                ++i2;
            }
            this.addConstraint(poly.toPiVector(), true, 0.0);
        } else {
            this.addConstraint(vertexPolygon.toPiVector(), true, 0.0);
        }
    }

    public int getNumConstraints() {
        return this.m_vertexPolygon.size();
    }

    public boolean isMarked(int i) {
        return this.m_isMarked.elementAt(i);
    }

    public void setMarked(int i, boolean marked) {
        this.m_isMarked.set(i, marked);
    }

    public boolean isHard(int i) {
        return this.m_isHard.elementAt(i);
    }

    public boolean isEnabled(int i) {
        return this.m_isEnabled.elementAt(i);
    }

    public boolean isHardCut(int i) {
        return this.m_isHardCut.elementAt(i);
    }

    public void setHard(int i, boolean hard) {
        this.m_isHard.set(i, hard);
    }

    public void setEnabled(int i, boolean enabled) {
        this.m_isEnabled.set(i, enabled);
    }

    public boolean isBoundary(int i) {
        return this.m_isBoundary.elementAt(i);
    }

    public int getLayer(int i) {
        if (this.m_layerRight == null) {
            return -1;
        }
        if (this.m_layerRight.length <= i) {
            return -1;
        }
        return this.m_layerRight[i].getFirstEntry();
    }

    /*
     * Exception decompiling
     */
    public void makeSharpEdgesConstraints(PbVector[] sharpEdges) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: CONTINUE without a while class org.benf.cfr.reader.bytecode.analysis.parse.statement.AnonBreakTarget
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.GotoStatement.getTargetStartBlock(GotoStatement.java:102)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.GotoStatement.getStructuredStatement(GotoStatement.java:116)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.getStructuredStatementPlaceHolder(Op03SimpleStatement.java:550)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:727)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public int getNumConstraintsCut() {
        return this.m_vertexPolygonCut.size();
    }
}

