/*
 * Decompiled with CFR 0.152.
 */
package devParameterize.geom;

import devParameterize.geom.PgParamGeom;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import jv.number.PuInteger;
import jv.object.PsDebug;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;
import jv.objectGui.PsSlotLayout;

public class PgParamGeom_CP
extends PsPanel
implements ItemListener,
ActionListener {
    protected PgParamGeom m_geom;
    private Button m_loadCacheButton = new Button("Load Cache");
    private Button m_saveCacheButton;
    private Checkbox m_sparseFieldBox;
    private Checkbox m_gradientFieldBox;
    private Checkbox m_curvatureFieldBox;
    private Checkbox m_trustWeightsBox;
    private Checkbox m_fieldBox;
    private Checkbox m_coveringBox;
    private TextField m_frameScaleFactorField;
    private Checkbox m_elementTreeBox;
    private Checkbox m_cutPathsBox;
    private Checkbox m_bridgesBox;
    private Checkbox m_gapsBox;
    private Checkbox m_discoTexBox;
    private Checkbox m_texBox;
    private TextField m_symmOrderField;
    private TextField m_branchPointField;
    protected Checkbox m_showColorNone;
    protected Checkbox m_showColorTrustRegion;
    protected Checkbox m_showColorDiscoTex;
    protected Checkbox m_showColorTexture;
    private PuInteger m_postScaleFactor;

    public PgParamGeom_CP() {
        this.m_loadCacheButton.addActionListener(this);
        this.m_saveCacheButton = new Button("Save Cache");
        this.m_saveCacheButton.addActionListener(this);
        this.m_sparseFieldBox = new Checkbox("Sparse Field");
        this.m_sparseFieldBox.addItemListener(this);
        this.m_gradientFieldBox = new Checkbox("Gradient Field");
        this.m_gradientFieldBox.addItemListener(this);
        this.m_curvatureFieldBox = new Checkbox("Curvature Field");
        this.m_curvatureFieldBox.addItemListener(this);
        this.m_trustWeightsBox = new Checkbox("Trust Weights");
        this.m_trustWeightsBox.addItemListener(this);
        this.m_fieldBox = new Checkbox("Extended Field");
        this.m_fieldBox.addItemListener(this);
        this.m_coveringBox = new Checkbox("Covering");
        this.m_coveringBox.addItemListener(this);
        this.m_frameScaleFactorField = new TextField();
        this.m_frameScaleFactorField.addActionListener(this);
        this.m_elementTreeBox = new Checkbox("Element Tree");
        this.m_elementTreeBox.addItemListener(this);
        this.m_cutPathsBox = new Checkbox("Cut Paths");
        this.m_cutPathsBox.addItemListener(this);
        this.m_bridgesBox = new Checkbox("Bridges");
        this.m_bridgesBox.addItemListener(this);
        this.m_gapsBox = new Checkbox("Gaps");
        this.m_gapsBox.addItemListener(this);
        this.m_symmOrderField = new TextField();
        this.m_symmOrderField.addActionListener(this);
        this.m_branchPointField = new TextField();
        this.m_branchPointField.setEditable(false);
        this.m_discoTexBox = new Checkbox("Disco Textures");
        this.m_discoTexBox.addItemListener(this);
        this.m_texBox = new Checkbox("Textures");
        this.m_texBox.addItemListener(this);
        this.m_postScaleFactor = new PuInteger("Post scale", (PsUpdateIf)this);
        if (this.getClass() == PgParamGeom_CP.class) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_postScaleFactor.setDefBounds(1, 8, 1, 1);
        this.m_postScaleFactor.setDefValue(2);
        this.m_postScaleFactor.init();
    }

    public void setParent(PsUpdateIf parent) {
        if (!(parent instanceof PgParamGeom)) {
            PsDebug.warning((String)"Parent must be instance of PgParamGeom");
            return;
        }
        super.setParent(parent);
        this.m_geom = (PgParamGeom)parent;
        this.makeLayout();
    }

    protected void makeLayout() {
        this.removeAll();
        this.addSubTitle("Color:");
        Panel p = new Panel(new GridLayout(2, 2));
        CheckboxGroup g = new CheckboxGroup();
        int col = this.m_geom.getShowingColor();
        this.m_showColorNone = new Checkbox("None", g, col == 0);
        p.add(this.m_showColorNone);
        this.m_showColorNone.addItemListener(this);
        this.m_showColorTrustRegion = new Checkbox("Trust Region", g, col == 1);
        p.add(this.m_showColorTrustRegion);
        this.m_showColorTrustRegion.addItemListener(this);
        this.m_showColorDiscoTex = new Checkbox("Disco Texture", g, col == 3);
        p.add(this.m_showColorDiscoTex);
        this.m_showColorDiscoTex.addItemListener(this);
        this.m_showColorTexture = new Checkbox("Texture", g, col == 2);
        p.add(this.m_showColorTexture);
        this.m_showColorTexture.addItemListener(this);
        this.add(p);
        this.addLine(1);
        this.addSubTitle("Show:");
        Vector<PsPanel> boxes = this.fillShowBoxes();
        p = new Panel(new GridLayout(4, (int)Math.ceil(boxes.size() / 3)));
        for (PsPanel box : boxes) {
            p.add((Component)box);
        }
        this.add(p);
        this.add((Component)this.m_postScaleFactor.getInfoPanel());
        this.addLine(1);
        this.addSubTitle("Parameterization data:");
        p = new Panel(new GridLayout(7, 2));
        p.add(this.m_sparseFieldBox);
        p.add(this.m_trustWeightsBox);
        p.add(this.m_fieldBox);
        p.add(this.m_coveringBox);
        Panel p2 = new Panel(new GridLayout(1, 2));
        p2.add(new Label("Scale factor"));
        p2.add(this.m_frameScaleFactorField);
        p.add(p2);
        p.add(this.m_elementTreeBox);
        p.add(this.m_cutPathsBox);
        p.add(this.m_bridgesBox);
        p.add(this.m_gapsBox);
        p.add(this.m_discoTexBox);
        p.add(this.m_texBox);
        p2 = new Panel(new GridLayout(1, 2));
        p2.add(new Label("Symmetry order"));
        p2.add(this.m_symmOrderField);
        p.add(p2);
        p2 = new Panel((LayoutManager)new PsSlotLayout(3));
        p2.add("2", new Label("Num Branch Points"));
        p2.add("1", this.m_branchPointField);
        p.add(p2);
        this.add(p);
        p = new Panel();
        p.add(this.m_loadCacheButton);
        p.add(this.m_saveCacheButton);
        this.add(p);
        p = new Panel(new GridLayout(1, 2));
        p.add((Component)this.m_geom.m_fixMatching.getInfoPanel());
        p.add((Component)this.m_geom.m_fixSharpConstraints.getInfoPanel());
        this.add(p);
        this.update((Object)this.m_geom);
    }

    protected Vector<PsPanel> fillShowBoxes() {
        Vector<PsPanel> boxes = new Vector<PsPanel>();
        boxes.addElement(this.m_geom.m_showBranchPoints.getInfoPanel());
        boxes.addElement(this.m_geom.m_showMatching.getInfoPanel());
        boxes.addElement(this.m_geom.m_showElementTree.getInfoPanel());
        boxes.addElement(this.m_geom.m_showCutPaths.getInfoPanel());
        boxes.addElement(this.m_geom.m_showSparseField.getInfoPanel());
        boxes.addElement(this.m_geom.m_showGradientField.getInfoPanel());
        boxes.addElement(this.m_geom.m_showCurvatureField.getInfoPanel());
        boxes.addElement(this.m_geom.m_showFrameField.getInfoPanel());
        boxes.addElement(this.m_geom.m_showSharpConstraints.getInfoPanel());
        return boxes;
    }

    public boolean update(Object event) {
        if (event == null) {
            return true;
        }
        if (event == this.m_geom) {
            this.m_sparseFieldBox.setState(this.m_geom.getSparseField() != null);
            this.m_sparseFieldBox.setEnabled(this.m_geom.getSparseField() != null);
            this.m_trustWeightsBox.setState(this.m_geom.getTrustWeights() != null);
            this.m_trustWeightsBox.setEnabled(this.m_geom.getTrustWeights() != null);
            this.m_fieldBox.setState(this.m_geom.getFrameField() != null);
            this.m_fieldBox.setEnabled(this.m_geom.getFrameField() != null);
            this.m_coveringBox.setState(this.m_geom.getCovering() != null);
            this.m_coveringBox.setEnabled(this.m_geom.getCovering() != null);
            this.m_frameScaleFactorField.setText("" + this.m_geom.getFrameScaleFactor());
            this.m_elementTreeBox.setState(this.m_geom.getElementTree() != null);
            this.m_elementTreeBox.setEnabled(this.m_geom.getElementTree() != null);
            this.m_cutPathsBox.setState(this.m_geom.getCutPaths() != null);
            this.m_cutPathsBox.setEnabled(this.m_geom.getCutPaths() != null);
            this.m_bridgesBox.setState(this.m_geom.getBridges() != null);
            this.m_bridgesBox.setEnabled(this.m_geom.getBridges() != null);
            this.m_gapsBox.setState(this.m_geom.getGaps() != null);
            this.m_gapsBox.setEnabled(this.m_geom.getGaps() != null);
            this.m_discoTexBox.setState(this.m_geom.getDiscontinuousTexture() != null);
            this.m_discoTexBox.setEnabled(this.m_geom.getDiscontinuousTexture() != null);
            this.m_texBox.setState(this.m_geom.getDiscontinuousTexture() != null);
            this.m_texBox.setEnabled(this.m_geom.getDiscontinuousTexture() != null);
            this.m_symmOrderField.setText("" + (this.m_geom.getCovering() == null ? 0 : this.m_geom.getCovering().getSymmetryOrder()));
            this.m_branchPointField.setText("" + (this.m_geom.getCovering() == null ? 0 : this.m_geom.getCovering().getNumBranchPoints()));
            this.m_postScaleFactor.setValue(this.m_geom.getPostScaleFactor());
            return true;
        }
        if (event == this.m_postScaleFactor) {
            this.m_geom.setPostScaleFactor(this.m_postScaleFactor.getValue());
            this.m_geom.update((Object)this.m_geom);
            return true;
        }
        return super.update(event);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (this.m_geom == null) {
            return;
        }
        Object source = e.getSource();
        if (source == this.m_sparseFieldBox) {
            if (!this.m_sparseFieldBox.getState()) {
                this.m_geom.setSparseField(null);
                this.m_geom.update((Object)this.m_geom);
            }
        } else if (source == this.m_trustWeightsBox) {
            if (!this.m_trustWeightsBox.getState()) {
                this.m_geom.setTrustWeights(null);
                this.m_geom.update((Object)this.m_geom);
            }
        } else if (source == this.m_fieldBox) {
            if (!this.m_fieldBox.getState()) {
                this.m_geom.setFrameField(null);
                this.m_geom.update((Object)this.m_geom);
            }
        } else if (source == this.m_coveringBox) {
            if (!this.m_coveringBox.getState()) {
                this.m_geom.setCovering(null);
                this.m_geom.update((Object)this.m_geom);
            }
        } else if (source == this.m_elementTreeBox) {
            if (!this.m_elementTreeBox.getState()) {
                this.m_geom.setElementTree(null);
                this.m_geom.update((Object)this.m_geom);
            }
        } else if (source == this.m_cutPathsBox) {
            if (!this.m_cutPathsBox.getState()) {
                this.m_geom.setCutPaths(null);
                this.m_geom.update((Object)this.m_geom);
            }
        } else if (source == this.m_bridgesBox) {
            if (!this.m_bridgesBox.getState()) {
                this.m_geom.setBridges(null);
                this.m_geom.update((Object)this.m_geom);
            }
        } else if (source == this.m_gapsBox) {
            if (!this.m_gapsBox.getState()) {
                this.m_geom.setGaps(null);
                this.m_geom.update((Object)this.m_geom);
            }
        } else if (source == this.m_discoTexBox) {
            if (!this.m_discoTexBox.getState()) {
                this.m_geom.setDiscontinuousTexture(null);
                this.m_geom.update((Object)this.m_geom);
            }
        } else if (source == this.m_texBox) {
            if (!this.m_texBox.getState()) {
                this.m_geom.setParamTexture(null);
                this.m_geom.update((Object)this.m_geom);
            }
        } else if (source == this.m_showColorNone || source == this.m_showColorTrustRegion || source == this.m_showColorDiscoTex || source == this.m_showColorTexture) {
            if (this.m_showColorNone.getState()) {
                this.m_geom.showColors(0);
            } else if (this.m_showColorTrustRegion.getState()) {
                this.m_geom.showColors(1);
            } else if (this.m_showColorDiscoTex.getState()) {
                this.m_geom.showColors(3);
            } else if (this.m_showColorTexture.getState()) {
                this.m_geom.showColors(2);
            }
            this.m_geom.update((Object)this.m_geom);
        }
        this.update((Object)this.m_geom);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.m_geom == null) {
            return;
        }
        Object source = e.getSource();
        if (source == this.m_frameScaleFactorField) {
            try {
                this.m_geom.setFrameScaleFactor(Double.parseDouble(this.m_frameScaleFactorField.getText()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.update((Object)this.m_geom);
        } else if (source == this.m_symmOrderField) {
            if (this.m_geom.getCovering() != null) {
                try {
                    int so = Integer.parseInt(this.m_frameScaleFactorField.getText());
                    this.m_geom.getCovering().setSymmetryOrder(so);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            this.update((Object)this.m_geom);
        } else if (source == this.m_loadCacheButton) {
            this.m_geom.loadCache();
            this.m_geom.update((Object)this.m_geom);
        } else if (source == this.m_saveCacheButton) {
            this.m_geom.saveCache();
            this.m_geom.update((Object)this.m_geom);
        }
    }
}

