/*
 * Decompiled with CFR 0.152.
 */
package devParameterize.geom;

import dev.numeric.PnTaucsSolver;
import devCovering.PgCovering;
import devCovering.PgCoveringSurface;
import devCovering.PgFrameField;
import devCovering.PgPathOnCovering;
import devCovering.PnCovering;
import devGraph.PgGraphOnElementSet;
import devParameterize.geom.PgSharpConstraints;
import java.awt.Color;
import java.util.Vector;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgVectorField;
import jv.number.PuBoolean;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.project.PgGeometryIf;
import jv.vecmath.PbVector;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuVectorGeom;

public class PgParamGeom
extends PgCoveringSurface {
    protected static final String DEFAULT_TEXTURE_NAME_4 = "images/gridArrow.gif";
    protected static final String DEFAULT_TEXTURE_NAME_6 = "images/6eck3.png";
    private static final double BRANCHPOINT_SIZE = 2.0;
    public static final Color UNTRUST_COLOR = Color.white;
    public static final Color TRUST_MIN_COLOR = new Color(248, 39, 39);
    public static final Color TRUST_MAX_COLOR = new Color(39, 248, 50);
    public static final int COLOR_NONE = 0;
    public static final int COLOR_BY_TRUST_WEIGHTS = 1;
    public static final int COLOR_BY_TEXTURE = 2;
    public static final int COLOR_BY_DISCO_TEXTURE = 3;
    public static final int COLOR_CUSTOM = 4;
    private PdVector[][] m_tmpTexture;
    protected PuBoolean m_showBranchPoints = new PuBoolean("Branch Points", (PsUpdateIf)this, true);
    protected PuBoolean m_showSparseField = new PuBoolean("Sparse Field", (PsUpdateIf)this, false);
    protected PuBoolean m_showGradientField = new PuBoolean("Gradient Field", (PsUpdateIf)this, false);
    protected PuBoolean m_showCurvatureField = new PuBoolean("Curvature Field", (PsUpdateIf)this, false);
    protected PuBoolean m_showFrameField = new PuBoolean("Frame Field", (PsUpdateIf)this, false);
    private boolean m_updateBranchpoints;
    private boolean m_isShowingTrustWeights;
    private boolean m_isShowingCustomColors;
    private boolean m_updateTrustWeights;
    private boolean m_updateSparseField;
    private boolean m_updateFrameField;
    private boolean m_isShowingTmpTexture;
    private boolean m_updateTmpTexture;
    private boolean m_isShowingTexture;
    private boolean m_updateTexture;
    private boolean m_isShowingDiscoTexture;
    private boolean m_updateDiscoTexture;
    private int m_showingColors = 2;
    protected PuBoolean m_fixMatching = new PuBoolean("Fix Matching", (PsUpdateIf)this, false);
    protected PuBoolean m_fixSharpConstraints = new PuBoolean("Fix Constraints", (PsUpdateIf)this, false);
    private String m_textureImageName;
    private Vector m_parameterKeys;
    private Vector m_parameterValues;
    private PdVector[][] m_paramTexture;
    private PdVector[][] m_discontinuousTexture;
    private PgFrameField m_frameField;
    private PgVectorField[] m_frameField_VF;
    private PgVectorField m_sparseField;
    private PgVectorField m_sparseField_VF;
    private PgVectorField[] m_gradientField;
    private PgVectorField[] m_gradientField_VF;
    private PgVectorField[] m_curvatureField;
    private PgVectorField[] m_curvatureField_VF;
    private PdVector m_trustWeights;
    private PiVector m_locSymmOrder;
    private int m_postScaleFactor = 2;
    private double m_frameScaleFactor;
    private PgGraphOnElementSet m_elementTree;
    private PgPathOnCovering[] m_cutPaths;
    private PiVector m_bridges;
    private PdVector m_gaps;
    private int m_solverType = PsConfig.isApplication() && PnTaucsSolver.isAvailable() ? 1 : 0;
    private boolean m_bFixMatching;
    private boolean m_bFixSharpConstraints;
    private PdVector[] m_curvatureValues;
    private PdVector[] m_refVectors;
    private PdVector[] m_edgeAngles;
    private PdVector m_weights;
    private PgSharpConstraints m_sharpConstraints;
    private PbVector[] m_sharpEdges;
    private PgVectorField m_curvatureVectorField;
    public PuBoolean m_showMatching;
    public PuBoolean m_showElementTree;
    public PuBoolean m_showCutPaths;
    public PuBoolean m_showSharpConstraints;

    public PgParamGeom() {
        this.m_parameterKeys = new Vector();
        this.m_parameterValues = new Vector();
        this.m_frameScaleFactor = Double.NaN;
        if (((Object)((Object)this)).getClass() == PgParamGeom.class) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_showBranchPoints.init();
        this.m_showSparseField.init();
        this.m_showGradientField.init();
        this.m_showCurvatureField.init();
        this.m_showFrameField.init();
        this.m_fixMatching.init();
        this.m_fixSharpConstraints.init();
    }

    public void reset() {
        super.reset();
        this.m_parameterKeys.clear();
        this.m_parameterValues.clear();
        this.m_paramTexture = null;
        this.m_sparseField = null;
        this.m_gradientField = null;
        this.m_curvatureField = null;
        this.m_trustWeights = null;
        this.m_frameField = null;
        this.setElementTree(null);
        this.m_cutPaths = null;
        this.m_bridges = null;
        this.m_gaps = null;
        this.m_curvatureVectorField = null;
        this.m_discontinuousTexture = null;
        this.m_sharpConstraints = null;
        this.m_locSymmOrder = null;
    }

    public int getPreferredSolver() {
        return this.m_solverType;
    }

    public void setUpdateParamTexture(boolean flag) {
        this.m_updateTexture = flag;
    }

    public void setUpdateSparseField(boolean flag) {
        this.m_updateSparseField = flag;
    }

    public void setUpdateTrustWeights(boolean flag) {
        this.m_updateTrustWeights = flag;
    }

    public void setUpdateField(boolean flag) {
        this.m_updateFrameField = flag;
    }

    public void setUpdateBranchpoints(boolean flag) {
        this.m_updateBranchpoints = flag;
    }

    public void setUpdateElementTree(boolean flag) {
    }

    public PdVector[][] getParamTexture() {
        return this.m_paramTexture;
    }

    public void setParamTexture(PdVector[][] paramTexture) {
        this.m_paramTexture = paramTexture;
        this.setUpdateParamTexture(true);
    }

    public PgVectorField getSparseField() {
        return this.m_sparseField;
    }

    public void setSparseField(PgVectorField sparseField) {
        if (sparseField != null && sparseField.getGeometry() != this) {
            PsDebug.warning((String)"geometry of sparseField missing or not this geometry");
        }
        this.m_sparseField = sparseField;
        this.setUpdateSparseField(true);
    }

    public PgVectorField[] getGradientField() {
        return this.m_gradientField;
    }

    public void setGradientField(PgVectorField[] curvatureField) {
        PgVectorField[] rotatedField = new PgVectorField[]{this.rotateVectorField(curvatureField[0]), this.rotateVectorField(curvatureField[1])};
        this.m_gradientField = new PgVectorField[2];
        this.m_gradientField[0] = new PgVectorField(3, 1);
        this.m_gradientField[0].setGeometry((PgPointSet)this);
        this.m_gradientField[0].setName("Gradient Field");
        this.m_gradientField[1] = new PgVectorField(3, 1);
        this.m_gradientField[1].setGeometry((PgPointSet)this);
        this.m_gradientField[1].setName("Gradient Field");
        int numE = this.getNumElements();
        PdVector v0 = new PdVector(3);
        PdVector v1 = new PdVector(3);
        PdVector w0 = new PdVector(3);
        PdVector w1 = new PdVector(3);
        int i = 0;
        while (i < numE) {
            v0 = rotatedField[0].getVector(i);
            v1 = rotatedField[1].getVector(i);
            w0 = curvatureField[0].getVector(i);
            w1 = curvatureField[1].getVector(i);
            this.m_gradientField[0].setVector(i, v1);
            this.m_gradientField[0].getVector(i).multScalar(1.0 / w0.dot(v1));
            this.m_gradientField[1].setVector(i, v0);
            this.m_gradientField[1].getVector(i).multScalar(1.0 / w1.dot(v0));
            ++i;
        }
    }

    private PgVectorField rotateVectorField(PgVectorField vectorField) {
        int numV = vectorField.getNumVectors();
        PdVector v = new PdVector(3);
        PgVectorField vectorFieldOrtho = new PgVectorField(3, 1);
        vectorFieldOrtho.setGeometry((PgPointSet)this);
        int i = 0;
        while (i < numV) {
            v = vectorFieldOrtho.getVector(i);
            PuVectorGeom.rotatePointAroundVector((PdVector)v, (PdVector)vectorField.getVector(i), (PdVector)this.getElementNormal(i), (double)1.5707963267948966);
            ++i;
        }
        return vectorFieldOrtho;
    }

    public PgVectorField[] getCurvatureField() {
        return this.m_curvatureField;
    }

    public void setCurvatureField(PgVectorField[] curvatureField) {
        this.m_curvatureField = (PgVectorField[])curvatureField.clone();
        this.m_curvatureField[0].setName("Curvature Field");
        this.m_curvatureField[0].setGlobalVectorColor(Color.BLUE);
        this.m_curvatureField[1].setName("Curvature Field");
        this.m_curvatureField[1].setGlobalVectorColor(Color.BLUE);
        this.setGradientField(curvatureField);
    }

    public PdVector getTrustWeights() {
        return this.m_trustWeights;
    }

    public void setTrustWeights(PdVector trustWeights) {
        this.m_trustWeights = trustWeights;
        this.setUpdateTrustWeights(true);
    }

    public PgFrameField getFrameField() {
        return this.m_frameField;
    }

    public void setFrameField(PgFrameField frameField) {
        if (frameField != null && frameField.getGeometry() != this) {
            PsDebug.warning((String)"geometry of frameField missing or not this geometry");
        }
        this.m_frameField = frameField;
        this.setUpdateField(true);
    }

    public void setCovering(PgCovering covering) {
        if (this.m_bFixMatching) {
            PsDebug.warning((String)"matching must be held fix, do not call setCovering().");
            return;
        }
        super.setCovering(covering);
        this.setUpdateBranchpoints(true);
    }

    public PgGraphOnElementSet getElementTree() {
        return this.m_elementTree;
    }

    public void setElementTree(PgGraphOnElementSet elementTree) {
        if (elementTree != null && elementTree.getGeometry() != this) {
            PsDebug.warning((String)"geometry of elementTree not this geometry");
        }
        this.m_elementTree = elementTree;
        this.setUpdateElementTree(true);
    }

    public PgPathOnCovering[] getCutPaths() {
        return this.m_cutPaths;
    }

    public void setCutPaths(PgPathOnCovering[] cutPaths) {
        if (cutPaths != null) {
            int i = cutPaths.length - 1;
            while (i >= 0) {
                if (cutPaths[i] != null && cutPaths[i].getGeometry() != this) {
                    PsDebug.warning((String)"geometry of a cutPath not this geometry");
                }
                --i;
            }
        }
        this.m_cutPaths = cutPaths;
    }

    public double getFrameScaleFactor() {
        return this.m_frameScaleFactor;
    }

    public void setFrameScaleFactor(double frameScaleFactor) {
        this.m_frameScaleFactor = frameScaleFactor;
    }

    public int getPostScaleFactor() {
        return this.m_postScaleFactor;
    }

    public void setPostScaleFactor(int postScaleFactor) {
        this.m_postScaleFactor = postScaleFactor;
        this.m_updateDiscoTexture = true;
        this.m_updateTexture = true;
    }

    public PiVector getBridges() {
        return this.m_bridges;
    }

    public void setBridges(PiVector bridges) {
        this.m_bridges = bridges;
    }

    public PdVector getGaps() {
        return this.m_gaps;
    }

    public void setGaps(PdVector gaps) {
        this.m_gaps = gaps;
    }

    public PdVector[][] getDiscontinuousTexture() {
        return this.m_discontinuousTexture;
    }

    public void setDiscontinuousTexture(PdVector[][] discontinuousTexture) {
        this.m_discontinuousTexture = discontinuousTexture;
        this.m_updateDiscoTexture = true;
    }

    public boolean getFixMatching() {
        return this.m_bFixMatching;
    }

    public void setFixMatching(boolean bFixCovering) {
        this.m_bFixMatching = bFixCovering;
    }

    public boolean getFixSharpConstraints() {
        return this.m_bFixSharpConstraints;
    }

    public void setFixSharpConstraints(boolean fix) {
        this.m_bFixSharpConstraints = fix;
    }

    public PbVector[] getSharpEdges() {
        return this.m_sharpEdges;
    }

    public void setSharpEdges(PbVector[] sharpEdges) {
        this.m_sharpEdges = sharpEdges;
    }

    public PgSharpConstraints getSharpConstraints() {
        return this.m_sharpConstraints;
    }

    public void setSharpConstraints(PgSharpConstraints sharpConstraints) {
        if (sharpConstraints != null && sharpConstraints.getGeometry() != this) {
            PsDebug.warning((String)"geometry of sharpConstraints not this geometry");
        }
        this.m_sharpConstraints = sharpConstraints;
    }

    public PgVectorField getCurvatureVectorField() {
        return this.m_curvatureVectorField;
    }

    public void setCurvatureVectorField(PgVectorField curvatureVectorField) {
        this.m_curvatureVectorField = curvatureVectorField;
    }

    public PdVector[] getCurvatureValues() {
        return this.m_curvatureValues;
    }

    public void setCurvatureValues(PdVector[] curvatureValues) {
        this.m_curvatureValues = curvatureValues;
    }

    public PdVector[] getRefVectors() {
        return this.m_refVectors;
    }

    public void setRefVectors(PdVector[] refVectors) {
        this.m_refVectors = refVectors;
    }

    public PdVector[] getEdgeAngles() {
        return this.m_edgeAngles;
    }

    public void setEdgeAngles(PdVector[] edgeAngles) {
        this.m_edgeAngles = edgeAngles;
    }

    public PdVector getWeights() {
        return this.m_weights;
    }

    public void setWeights(PdVector weights) {
        this.m_weights = weights;
    }

    public Object clone() {
        PgParamGeom clone = (PgParamGeom)((Object)super.clone());
        clone.m_showBranchPoints = new PuBoolean("Branch Points", (PsUpdateIf)clone, true);
        clone.m_showSparseField = new PuBoolean("Sparse Field", (PsUpdateIf)clone, false);
        clone.m_showGradientField = new PuBoolean("Gradient Field", (PsUpdateIf)clone, false);
        clone.m_showCurvatureField = new PuBoolean("Curvature Field", (PsUpdateIf)clone, false);
        clone.m_showFrameField = new PuBoolean("Frame Field", (PsUpdateIf)clone, false);
        clone.copyParamGeom(this);
        return clone;
    }

    public void copy(PsObject object) {
        if (object == null) {
            return;
        }
        super.copy(object);
        if (!(object instanceof PgParamGeom)) {
            return;
        }
        PgParamGeom geom = (PgParamGeom)object;
        this.copyParamGeom(geom);
    }

    protected void copyParamGeom(PgParamGeom geom) {
        int e;
        int numE;
        this.m_parameterKeys = (Vector)geom.m_parameterKeys.clone();
        this.m_parameterValues = (Vector)geom.m_parameterValues.clone();
        if (geom.m_paramTexture == null) {
            this.m_paramTexture = null;
        } else {
            numE = geom.m_paramTexture.length;
            this.m_paramTexture = new PdVector[numE][];
            e = 0;
            while (e < numE) {
                this.m_paramTexture[e] = PdVector.copyNew((PdVector[])geom.m_paramTexture[e]);
                ++e;
            }
        }
        this.m_sparseField = geom.m_sparseField == null ? null : (PgVectorField)geom.m_sparseField.clone();
        this.m_gradientField = geom.m_gradientField == null ? null : (PgVectorField[])geom.m_gradientField.clone();
        this.m_curvatureField = geom.m_curvatureField == null ? null : (PgVectorField[])geom.m_curvatureField.clone();
        this.m_trustWeights = geom.m_trustWeights == null ? null : PdVector.copyNew((PdVector)geom.m_trustWeights);
        this.m_frameField = geom.m_frameField == null ? null : PgFrameField.copyNew((PgFrameField)geom.m_frameField);
        this.m_frameScaleFactor = geom.m_frameScaleFactor;
        PgGraphOnElementSet pgGraphOnElementSet = this.m_elementTree = geom.m_elementTree == null ? null : PgGraphOnElementSet.copyNew((PgGraphOnElementSet)geom.m_elementTree);
        if (geom.m_cutPaths == null) {
            this.m_cutPaths = null;
        } else {
            int numP = geom.m_cutPaths.length;
            this.m_cutPaths = new PgPathOnCovering[numP];
            int i = 0;
            while (i < numP) {
                this.m_cutPaths[i] = geom.m_cutPaths[i] == null ? null : PgPathOnCovering.copyNew((PgPathOnCovering)geom.m_cutPaths[i]);
                ++i;
            }
        }
        this.m_bridges = geom.m_bridges == null ? null : PiVector.copyNew((PiVector)geom.m_bridges);
        PdVector pdVector = this.m_gaps = geom.m_gaps == null ? null : PdVector.copyNew((PdVector)geom.m_gaps);
        if (geom.m_discontinuousTexture == null) {
            this.m_discontinuousTexture = null;
        } else {
            numE = geom.m_discontinuousTexture.length;
            this.m_discontinuousTexture = new PdVector[numE][];
            e = 0;
            while (e < numE) {
                this.m_discontinuousTexture[e] = PdVector.copyNew((PdVector[])geom.m_discontinuousTexture[e]);
                ++e;
            }
        }
        this.m_solverType = geom.m_solverType;
        PdVector[] pdVectorArray = this.m_curvatureValues = geom.m_curvatureValues == null ? null : PdVector.copyNew((PdVector[])geom.m_curvatureValues);
        if (geom.m_curvatureVectorField != null) {
            this.m_curvatureVectorField.copy((PsObject)geom.m_curvatureVectorField);
        }
        this.m_showBranchPoints.copy((PsObject)geom.m_showBranchPoints);
        this.m_showSparseField.copy((PsObject)geom.m_showSparseField);
        this.m_showGradientField.copy((PsObject)geom.m_showGradientField);
        this.m_showCurvatureField.copy((PsObject)geom.m_showCurvatureField);
        this.m_showFrameField.copy((PsObject)geom.m_showFrameField);
        this.m_updateBranchpoints = true;
        this.m_updateTrustWeights = true;
        this.m_updateSparseField = true;
        this.m_updateFrameField = true;
        this.m_updateTexture = true;
        this.m_updateDiscoTexture = true;
        this.m_fixMatching = geom.m_fixMatching;
        this.m_fixSharpConstraints = geom.m_fixSharpConstraints;
        this.updateVisualizations();
    }

    public boolean isConfigurable(int panel) {
        return panel == 10 || super.isConfigurable(panel);
    }

    public boolean update(Object event) {
        if (event == null) {
            return super.update(null);
        }
        if (event == this.m_showBranchPoints || event == this.m_showSparseField || event == this.m_showGradientField || event == this.m_showCurvatureField || event == this.m_showFrameField) {
            if (event == this.m_showBranchPoints) {
                this.m_updateBranchpoints = true;
            } else if (event == this.m_showSparseField) {
                this.m_updateSparseField = true;
            } else if (event == this.m_showFrameField) {
                this.m_updateFrameField = true;
            }
            if (this.updateVisualizations()) {
                this.update((Object)this);
            }
            return true;
        }
        if (event == this) {
            if (this.updateVisualizations()) {
                return super.update((Object)this);
            }
        } else {
            if (event == this.m_fixMatching) {
                this.setFixMatching(this.m_fixMatching.getState());
                return true;
            }
            if (event == this.m_fixSharpConstraints) {
                this.setFixSharpConstraints(this.m_fixSharpConstraints.getState());
                return true;
            }
        }
        return super.update(event);
    }

    public boolean updateVisualizations() {
        boolean geomChanged = false;
        geomChanged |= this.showBranchPoints(this.m_showBranchPoints.getState());
        geomChanged |= this.showSparseField(this.m_showSparseField.getState());
        geomChanged |= this.showGradientField(this.m_showGradientField.getState());
        geomChanged |= this.showCurvatureField(this.m_showCurvatureField.getState());
        geomChanged |= this.showField(this.m_showFrameField.getState());
        return geomChanged |= this.showColors(this.m_showingColors);
    }

    public int getShowingColor() {
        return this.m_showingColors;
    }

    public PdVector[][] getTmpTexture() {
        return this.m_tmpTexture;
    }

    public void setTmpTexture(PdVector[][] tmpTexture) {
        this.m_tmpTexture = tmpTexture;
        this.m_updateTmpTexture = true;
    }

    public boolean showColors(int show) {
        boolean val = false;
        switch (show) {
            case 0: {
                val = this.showNoColors();
                break;
            }
            case 1: {
                val = this.showTrustWeights();
                break;
            }
            case 3: {
                val = this.showDiscoTexture();
                break;
            }
            case 2: {
                val = this.showTexture();
                break;
            }
            case 4: {
                val = this.showCustomColors();
            }
        }
        this.m_showingColors = show;
        return val;
    }

    private boolean showCustomColors() {
        this.m_isShowingTrustWeights = false;
        this.m_isShowingDiscoTexture = false;
        this.m_isShowingTexture = false;
        this.m_isShowingTmpTexture = false;
        this.m_isShowingCustomColors = true;
        this.showElementTexture(false);
        this.showElementColors(true);
        return true;
    }

    private boolean showNoColors() {
        if (!(this.m_isShowingTrustWeights || this.m_isShowingDiscoTexture || this.m_isShowingTexture)) {
            return false;
        }
        this.m_isShowingTrustWeights = true;
        this.m_isShowingDiscoTexture = false;
        this.m_isShowingTexture = false;
        this.m_isShowingTmpTexture = false;
        this.m_isShowingCustomColors = false;
        this.showElementTexture(false);
        this.showElementColors(false);
        return true;
    }

    public boolean showTrustWeights() {
        if (this.m_isShowingTrustWeights && !this.m_updateTrustWeights) {
            return false;
        }
        this.m_isShowingTrustWeights = true;
        this.m_isShowingDiscoTexture = false;
        this.m_isShowingTexture = false;
        this.m_updateTrustWeights = false;
        this.m_isShowingTmpTexture = false;
        this.m_isShowingCustomColors = false;
        this.showElementTexture(false);
        if (this.getTrustWeights() == null) {
            this.showElementColors(false);
            return true;
        }
        this.showElementColors(true);
        int numE = this.getNumElements();
        float[] trustMinHsb = Color.RGBtoHSB(TRUST_MIN_COLOR.getRed(), TRUST_MIN_COLOR.getGreen(), TRUST_MIN_COLOR.getBlue(), null);
        float[] trustMaxHsb = Color.RGBtoHSB(TRUST_MAX_COLOR.getRed(), TRUST_MAX_COLOR.getGreen(), TRUST_MAX_COLOR.getBlue(), null);
        float[] mixHsb = new float[3];
        PdVector weightCopy = PdVector.copyNew((PdVector)this.getTrustWeights());
        weightCopy.sort();
        double max = weightCopy.getEntry(Math.min(numE - 1, numE - numE / 100));
        int e = 0;
        while (e < numE) {
            double w = this.getTrustWeights().m_data[e];
            if (w <= 0.0) {
                this.setElementColor(e, UNTRUST_COLOR);
            } else {
                w /= max;
                int i = 0;
                while (i < 3) {
                    mixHsb[i] = Math.min(1.0f, (float)(w * (double)trustMaxHsb[i] + (1.0 - w) * (double)trustMinHsb[i]));
                    ++i;
                }
                this.setElementColor(e, Color.getHSBColor(mixHsb[0], mixHsb[1], mixHsb[2]));
            }
            ++e;
        }
        return true;
    }

    private boolean showTmpTexture() {
        if (this.m_isShowingTmpTexture && !this.m_updateTmpTexture) {
            return false;
        }
        this.m_isShowingTrustWeights = false;
        this.m_isShowingDiscoTexture = false;
        this.m_isShowingTexture = false;
        this.m_isShowingTmpTexture = true;
        this.m_updateTmpTexture = false;
        this.m_isShowingCustomColors = false;
        if (this.m_tmpTexture == null) {
            this.showElementTexture(false);
            return true;
        }
        this.showElementColors(false);
        this.showElementTexture(true);
        this.setElementTextures(this.m_tmpTexture);
        this.assureTextureImage();
        int numE = this.getNumElements();
        int e = 0;
        while (e < numE) {
            int i = 0;
            while (i < 3) {
                this.getElementTexture(e)[i].multScalar((double)this.getPostScaleFactor());
                ++i;
            }
            ++e;
        }
        return true;
    }

    public boolean showTexture() {
        int e;
        int numE;
        if (this.m_tmpTexture != null) {
            return this.showTmpTexture();
        }
        if (this.m_isShowingTexture && !this.m_updateTexture) {
            return false;
        }
        this.m_isShowingTrustWeights = false;
        this.m_isShowingDiscoTexture = false;
        this.m_isShowingTexture = true;
        this.m_updateTexture = false;
        this.m_isShowingCustomColors = false;
        if (this.m_locSymmOrder != null) {
            this.showElementColors(true);
            numE = this.getNumElements();
            e = 0;
            while (e < numE) {
                if (this.m_locSymmOrder.m_data[e] == 4) {
                    this.setElementColor(e, Color.red);
                } else if (this.m_locSymmOrder.m_data[e] == 6) {
                    this.setElementColor(e, Color.blue);
                } else {
                    this.setElementColor(e, Color.white);
                }
                ++e;
            }
        }
        if (this.getParamTexture() == null) {
            this.showElementTexture(false);
            return true;
        }
        if (this.m_locSymmOrder == null) {
            this.showElementColors(false);
        }
        this.showElementTexture(true);
        this.setElementTextures(this.getParamTexture());
        this.assureTextureImage();
        numE = this.getNumElements();
        e = 0;
        while (e < numE) {
            int i = 0;
            while (i < 3) {
                this.getElementTexture(e)[i].multScalar((double)this.getPostScaleFactor());
                ++i;
            }
            ++e;
        }
        return true;
    }

    public boolean showDiscoTexture() {
        int e;
        int numE;
        if (this.m_tmpTexture != null) {
            return this.showTmpTexture();
        }
        if (this.m_isShowingDiscoTexture && !this.m_updateDiscoTexture) {
            return false;
        }
        this.m_isShowingTrustWeights = false;
        this.m_isShowingDiscoTexture = true;
        this.m_isShowingTexture = false;
        this.m_updateDiscoTexture = false;
        if (this.m_locSymmOrder != null) {
            this.showElementColors(true);
            numE = this.getNumElements();
            e = 0;
            while (e < numE) {
                if (this.m_locSymmOrder.m_data[e] == 4) {
                    this.setElementColor(e, Color.red);
                } else if (this.m_locSymmOrder.m_data[e] == 6) {
                    this.setElementColor(e, Color.blue);
                } else {
                    this.setElementColor(e, Color.white);
                }
                ++e;
            }
        }
        if (this.getDiscontinuousTexture() == null) {
            this.showElementTexture(false);
            return true;
        }
        if (this.m_locSymmOrder == null) {
            this.showElementColors(false);
        }
        this.showElementTexture(true);
        this.setElementTextures(this.getDiscontinuousTexture());
        this.assureTextureImage();
        numE = this.getNumElements();
        e = 0;
        while (e < numE) {
            int i = 0;
            while (i < 3) {
                this.getElementTexture(e)[i].multScalar((double)this.getPostScaleFactor());
                ++i;
            }
            ++e;
        }
        return true;
    }

    public boolean showBranchPoints(boolean show) {
        if (show == this.m_showBranchPoints.getState() && !this.m_updateBranchpoints) {
            return false;
        }
        if (show != this.m_showBranchPoints.getState()) {
            this.m_showBranchPoints.setState(show);
        }
        this.m_updateBranchpoints = false;
        if (!show || this.getCovering() == null) {
            this.showVertexColors(false);
            this.showVertexSizes(false);
            this.showVertices(false);
            return true;
        }
        int numV = this.getNumVertices();
        double globalSize = 0.0;
        Color globalColor = this.getGlobalVertexColor();
        int v = 0;
        while (v < numV) {
            this.setVertexColor(v, globalColor);
            this.setVertexSize(v, globalSize);
            ++v;
        }
        PiVector branchPoints = this.getCovering().getBranchPoints();
        PiVector branchTypes = this.getCovering().getBranchTypes();
        int num = branchPoints.getSize();
        int symmetryOrder = this.getCovering().getSymmetryOrder();
        Color[] matchingColors = PnCovering.makeMatchingColors((int)symmetryOrder);
        int i = 0;
        while (i < num) {
            this.setVertexColor(branchPoints.m_data[i], matchingColors[branchTypes.m_data[i]]);
            this.setVertexSize(branchPoints.m_data[i], 2.0);
            ++i;
        }
        this.showVertexColors(true);
        this.showVertexSizes(true);
        this.showVertices(true);
        return true;
    }

    public boolean showSparseField(boolean show) {
        if (show == this.m_showSparseField.getState() && !this.m_updateSparseField) {
            return false;
        }
        if (show != this.m_showSparseField.getState()) {
            this.m_showSparseField.setState(show);
        }
        this.m_updateSparseField = false;
        if (this.m_sparseField_VF != null) {
            this.removeVectorField((PgGeometryIf)this.m_sparseField_VF);
            this.m_sparseField_VF = null;
        }
        if (show && this.getSparseField() != null) {
            this.addVectorField(this.getSparseField());
            this.m_sparseField_VF = this.getSparseField();
        }
        return true;
    }

    public boolean showGradientField(boolean show) {
        if (show != this.m_showGradientField.getState()) {
            this.m_showGradientField.setState(show);
        }
        if (this.m_gradientField_VF != null) {
            this.removeVectorField((PgGeometryIf)this.m_gradientField_VF[0]);
            this.removeVectorField((PgGeometryIf)this.m_gradientField_VF[1]);
            this.m_gradientField_VF = null;
        }
        if (show && this.getGradientField() != null) {
            this.m_gradientField_VF = new PgVectorField[2];
            this.m_gradientField_VF = this.getGradientField();
            this.addVectorField(this.m_gradientField_VF[0]);
            this.addVectorField(this.m_gradientField_VF[1]);
        }
        return true;
    }

    public boolean showCurvatureField(boolean show) {
        if (show != this.m_showCurvatureField.getState()) {
            this.m_showCurvatureField.setState(show);
        }
        if (this.m_curvatureField_VF != null) {
            this.removeVectorField((PgGeometryIf)this.m_curvatureField_VF[0]);
            this.removeVectorField((PgGeometryIf)this.m_curvatureField_VF[1]);
            this.m_curvatureField_VF = null;
        }
        if (show && this.getCurvatureField() != null) {
            this.m_curvatureField_VF = new PgVectorField[2];
            this.m_curvatureField_VF = this.getCurvatureField();
            this.addVectorField(this.m_curvatureField_VF[0]);
            this.addVectorField(this.m_curvatureField_VF[1]);
        }
        return true;
    }

    public boolean showField(boolean show) {
        if (show == this.m_showFrameField.getState() && !this.m_updateFrameField) {
            return false;
        }
        if (show != this.m_showFrameField.getState()) {
            this.m_showFrameField.setState(show);
        }
        this.m_updateFrameField = false;
        if (this.m_frameField_VF != null) {
            this.removeVectorField((PgGeometryIf)this.m_frameField_VF[0]);
            this.removeVectorField((PgGeometryIf)this.m_frameField_VF[1]);
            this.m_frameField_VF = null;
        }
        if (show && this.getFrameField() != null) {
            this.m_frameField_VF = new PgVectorField[2];
            this.m_frameField_VF[0] = this.getFrameField().getField(0);
            this.m_frameField_VF[1] = this.getFrameField().getField(1);
            this.addVectorField(this.m_frameField_VF[0]);
            this.addVectorField(this.m_frameField_VF[1]);
        }
        return true;
    }

    private void assureTextureImage() {
        String name = this.m_textureImageName;
        if (this.m_textureImageName == null || this.m_textureImageName.equals(DEFAULT_TEXTURE_NAME_4) || this.m_textureImageName.equals(DEFAULT_TEXTURE_NAME_6)) {
            if (this.getCovering().getSymmetryOrder() == 4) {
                name = DEFAULT_TEXTURE_NAME_4;
            } else if (this.getCovering().getSymmetryOrder() == 6) {
                name = DEFAULT_TEXTURE_NAME_6;
            }
        }
        if (this.getTextureImage() != null && this.m_textureImageName != null && name.equals(this.m_textureImageName)) {
            return;
        }
        super.setTextureImageName(name);
        this.getTexture().loadImage();
    }

    public void setTextureImageName(String filename) {
        this.m_textureImageName = filename;
        this.m_paramTexture = null;
        this.assureTextureImage();
    }

    public void scaleTextureForHex(PdVector[][] tex) {
        if (this.m_covering == null) {
            PsDebug.warning((String)"missing covering");
            return;
        }
        double sqrt3 = 1.0 / Math.sqrt(3.0);
        int numE = this.getNumElements();
        switch (this.m_covering.getSymmetryOrder()) {
            case 6: {
                int e = 0;
                while (e < numE) {
                    int i = 0;
                    while (i < 3) {
                        tex[e][i].m_data[0] = tex[e][i].m_data[0] * sqrt3;
                        ++i;
                    }
                    ++e;
                }
                break;
            }
            case 12: {
                int e = 0;
                while (e < numE) {
                    if (this.m_locSymmOrder.m_data[e] == 6) {
                        int i = 0;
                        while (i < 3) {
                            tex[e][i].m_data[0] = tex[e][i].m_data[0] * sqrt3;
                            ++i;
                        }
                    }
                    ++e;
                }
                break;
            }
        }
    }

    public void loadCache() {
        String s;
        PgVectorField field;
        int num = this.getNumVectorFields();
        int symmetryOrder = -1;
        PgVectorField sparseField = null;
        PgVectorField matchingField = null;
        PgVectorField trustField = null;
        PgVectorField locSymmOrderField = null;
        int i = 0;
        while (i < num) {
            field = this.getVectorField(i);
            if (field.getBasedOn() == 1 && field.getName().length() >= 11 && field.getName().substring(0, 11).equalsIgnoreCase("SparseField")) {
                sparseField = field;
                s = this.getVectorField(i).getName().substring(11);
                try {
                    symmetryOrder = Integer.parseInt(s);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            ++i;
        }
        i = 0;
        while (i < num) {
            field = this.getVectorField(i);
            if (field.getBasedOn() == 1 && field.getName().length() >= 8 && field.getName().substring(0, 8).equalsIgnoreCase("matching")) {
                s = this.getVectorField(i).getName().substring(8);
                int so = -1;
                try {
                    so = Integer.parseInt(s);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (so < 0 || so == symmetryOrder) {
                    matchingField = field;
                } else if (symmetryOrder < 0) {
                    matchingField = field;
                    symmetryOrder = so;
                }
            }
            ++i;
        }
        i = 0;
        while (i < num) {
            field = this.getVectorField(i);
            if (field.getBasedOn() == 1 && field.getName().length() >= 13 && field.getName().substring(0, 13).equalsIgnoreCase("trustFunction")) {
                trustField = field;
            }
            ++i;
        }
        i = 0;
        while (i < num) {
            field = this.getVectorField(i);
            if (field.getBasedOn() == 1 && field.getName().length() >= 18 && field.getName().substring(0, 18).equalsIgnoreCase("localSymmetryOrder")) {
                locSymmOrderField = field;
            }
            ++i;
        }
        if (symmetryOrder < 0) {
            return;
        }
        if (sparseField != null) {
            PgVectorField[] customFields = new PgVectorField[2];
            customFields[0] = new PgVectorField(3, 1);
            customFields[0].copy((PsObject)sparseField);
            customFields[0].setGeometry((PgPointSet)this);
            this.setSparseField(customFields[0]);
            sparseField.setVisible(false);
        }
        int numE = this.getNumElements();
        if (matchingField != null) {
            PgCovering cov = new PgCovering((PgElementSet)this, symmetryOrder);
            PiVector[] m = PiVector.realloc(null, (int)numE, (int)3);
            int e = 0;
            while (e < numE) {
                int j = 0;
                while (j < 3) {
                    m[e].m_data[j] = (int)matchingField.getVector((int)e).m_data[j];
                    ++j;
                }
                ++e;
            }
            cov.setMatching(m);
            cov.updateBranchpoints();
            this.setCovering(cov);
            matchingField.setVisible(false);
            this.setFixMatching(true);
        } else {
            this.setCovering(new PgCovering((PgElementSet)this, symmetryOrder));
        }
        PdVector trustWeights = new PdVector(numE);
        if (trustField != null) {
            int e = 0;
            while (e < numE) {
                trustWeights.m_data[e] = trustField.getVector((int)e).m_data[0];
                ++e;
            }
            trustField.setVisible(false);
        } else {
            trustWeights.setConstant(1.0);
        }
        this.setTrustWeights(trustWeights);
        if (locSymmOrderField != null) {
            this.m_locSymmOrder = new PiVector(numE);
            int e = 0;
            while (e < numE) {
                this.m_locSymmOrder.m_data[e] = (int)locSymmOrderField.getVector((int)e).m_data[0];
                ++e;
            }
            locSymmOrderField.setVisible(false);
        }
    }

    public void saveCache() {
        int symmetryOrder = -1;
        int numE = this.getNumElements();
        if (this.getCovering() != null) {
            symmetryOrder = this.getCovering().getSymmetryOrder();
            PgVectorField matchingField = new PgVectorField(3, 1);
            matchingField.setGeometry((PgPointSet)this);
            matchingField.setName("matching" + symmetryOrder);
            matchingField.setVisible(false);
            int e = 0;
            while (e < numE) {
                int i = 0;
                while (i < 3) {
                    matchingField.getVector((int)e).m_data[i] = this.getCovering().getMatching(e, i);
                    ++i;
                }
                ++e;
            }
            this.addVectorField(matchingField);
            if (this.getSparseField() != null) {
                PgVectorField sparseField = new PgVectorField(3, 1);
                sparseField.setGeometry((PgPointSet)this);
                sparseField.setName("SparseField" + symmetryOrder);
                sparseField.setVisible(false);
                int e2 = 0;
                while (e2 < numE) {
                    sparseField.getVector(e2).copy(this.getSparseField().getVector(e2));
                    ++e2;
                }
                this.addVectorField(sparseField);
            }
        }
        if (this.getTrustWeights() != null) {
            PgVectorField trustField = new PgVectorField(1, 1);
            trustField.setGeometry((PgPointSet)this);
            trustField.setName("trustFunction");
            trustField.setVisible(false);
            int e = 0;
            while (e < numE) {
                trustField.getVector((int)e).m_data[0] = this.getTrustWeights().m_data[e];
                ++e;
            }
            this.addVectorField(trustField);
        }
    }
}

