/*
 * Decompiled with CFR 0.152.
 */
package devParameterize.covering;

import devCovering.PgCovering;
import devCovering.PgCoveringSurface;
import devCovering.PnFrameField;
import devCovering.PnStiffMatrix;
import devParameterize.covering.PgTextureMapOnCovering;
import jv.geom.PgElementSet;
import jv.object.PsDebug;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.geom.PgVertexStar;
import jvx.numeric.PnSparseMatrix;

public class PwSmoothTextures {
    protected static PdVector getMeanValueWeights(PgElementSet geom, PgVertexStar star, int vertex) {
        if (!star.isClosed()) {
            return null;
        }
        int starSize = star.getSize();
        PiVector link = star.getLink();
        PdVector weights = new PdVector(starSize);
        PdVector[] vertices = geom.getVertices();
        PdVector center = vertices[vertex];
        int i = 0;
        while (i < star.getSize()) {
            int prevV = link.getEntry((i + starSize - 1) % starSize);
            int thisV = link.getEntry(i);
            int nextV = link.getEntry((i + 1) % starSize);
            double alpha1 = PdVector.angle((PdVector)center, (PdVector)vertices[prevV], (PdVector)vertices[thisV]) / 180.0 * Math.PI;
            double alpha2 = PdVector.angle((PdVector)center, (PdVector)vertices[thisV], (PdVector)vertices[nextV]) / 180.0 * Math.PI;
            weights.m_data[i] = (Math.tan(alpha1 / 2.0) + Math.tan(alpha2 / 2.0)) / center.dist(vertices[thisV]);
            ++i;
        }
        return weights;
    }

    public static void smooth(PgTextureMapOnCovering texMap, boolean useMeanValueCoordinates) {
        PgCoveringSurface geom = texMap.getGeometry();
        PgCovering covering = texMap.getGeometry().getCovering();
        PdVector[] uSummand = texMap.getUSummand();
        PdVector[] vSummand = texMap.getVSummand();
        PdVector uValues = texMap.getUValues();
        PdVector vValues = texMap.getVValues();
        PnSparseMatrix stiffMatrix = null;
        if (!useMeanValueCoordinates) {
            stiffMatrix = PnStiffMatrix.computeMatrixEntries((PgElementSet)geom, (boolean)true, (boolean)true);
        }
        int numVertices = geom.getNumVertices();
        int symmetry = covering.getSymmetryOrder();
        PdVector sum = new PdVector(2);
        PdVector tmp = new PdVector(2);
        PdVector gap = new PdVector(2);
        PdVector prevElemTex = new PdVector(2);
        PdVector thisElemTex = new PdVector(2);
        PdVector niveau = new PdVector(2);
        PdVector newUValues = new PdVector(numVertices);
        PdVector newVValues = new PdVector(numVertices);
        PgVertexStar star = new PgVertexStar();
        int[] elemPerVertex = PgVertexStar.getElementPerVertex((PgElementSet)geom).m_data;
        PdVector area = new PdVector(geom.getNumElements());
        int i = 0;
        while (i < area.getSize()) {
            area.m_data[i] = geom.getAreaOfElement(i);
            ++i;
        }
        int vertex = 0;
        while (vertex < numVertices) {
            star.makeVertexStar((PgElementSet)geom, vertex, elemPerVertex[vertex]);
            PdVector meanValueWeights = null;
            if (useMeanValueCoordinates) {
                meanValueWeights = PwSmoothTextures.getMeanValueWeights((PgElementSet)geom, star, vertex);
            }
            PiVector elem = star.getElement();
            PiVector link = star.getLink();
            PiVector vertexLocInd = star.getVertexLocInd();
            int starSize = star.getSize();
            int elemInd0 = elem.getEntry(0);
            int vertexLocInd0 = vertexLocInd.getEntry(0);
            int m0 = 0;
            if (texMap.getVertexRotation() != null) {
                m0 = texMap.getVertexRotation()[elemInd0].m_data[vertexLocInd0];
            }
            sum.setConstant(0.0);
            thisElemTex.setConstant(0.0);
            niveau.setConstant(0.0);
            double weightSum = 0.0;
            int prevLayer = 0;
            if (star.isClosed() && m0 != Integer.MAX_VALUE) {
                int i2 = 0;
                while (i2 < starSize) {
                    int elemInd = elem.getEntry(i2);
                    int locInd = vertexLocInd.getEntry(i2);
                    int linkVertexLocInd = (locInd + 1) % 3;
                    int linkVertex = link.getEntry(i2);
                    double weight = useMeanValueCoordinates ? meanValueWeights.getEntry(i2) : -stiffMatrix.getEntry(vertex, linkVertex);
                    weightSum += weight;
                    if (i2 > 0) {
                        int prevElementInd = star.getElement().getEntry(i2 - 1);
                        int prevLocInd = vertexLocInd.getEntry(i2 - 1);
                        int matching = covering.getMatching(prevElementInd, (prevLocInd + 1) % 3);
                        int thisLayer = prevLayer + matching;
                        prevElemTex.m_data[0] = uSummand[prevElementInd].m_data[prevLocInd];
                        prevElemTex.m_data[1] = vSummand[prevElementInd].m_data[prevLocInd];
                        thisElemTex.m_data[0] = uSummand[elemInd].m_data[locInd];
                        thisElemTex.m_data[1] = vSummand[elemInd].m_data[locInd];
                        PnFrameField.rot((PdVector)prevElemTex, (int)(-prevLayer), (int)symmetry);
                        PnFrameField.rot((PdVector)thisElemTex, (int)(-thisLayer), (int)symmetry);
                        gap.sub(thisElemTex, prevElemTex);
                        niveau.add(gap);
                        sum.add(-weight, niveau);
                        prevLayer = thisLayer;
                    }
                    texMap.getTextureValue(elemInd, linkVertexLocInd, tmp);
                    int m = texMap.getVertexRotation()[elemInd].m_data[locInd];
                    PnFrameField.rot((PdVector)tmp, (int)(-m), (int)symmetry);
                    sum.add(weight, tmp);
                    ++i2;
                }
                sum.multScalar(1.0 / weightSum);
                if (star.isClosed()) {
                    newUValues.m_data[vertex] = sum.m_data[0] - uSummand[elemInd0].m_data[vertexLocInd0];
                    newVValues.m_data[vertex] = sum.m_data[1] - vSummand[elemInd0].m_data[vertexLocInd0];
                } else {
                    newUValues.m_data[vertex] = uValues.m_data[vertex];
                    newVValues.m_data[vertex] = vValues.m_data[vertex];
                }
            } else {
                newUValues.m_data[vertex] = uValues.m_data[vertex];
                newVValues.m_data[vertex] = vValues.m_data[vertex];
            }
            ++vertex;
        }
        uValues.copyArray(newUValues);
        vValues.copyArray(newVValues);
    }

    public static int markNegativeVertices(PgElementSet geom) {
        PdVector[][] tex = geom.getElementTextures();
        PdVector cross = new PdVector(3);
        PdVector e1 = new PdVector(2);
        PdVector e2 = new PdVector(2);
        int count = 0;
        int e = 0;
        while (e < tex.length) {
            e1.sub(tex[e][1], tex[e][0]);
            e2.sub(tex[e][2], tex[e][0]);
            cross.cross(e1, e2);
            if (cross.m_data[2] < 1.0E-10) {
                PiVector element = geom.getElement(e);
                int j = 0;
                while (j < 3) {
                    int v = element.m_data[j];
                    geom.setTagVertex(v, 1);
                    ++j;
                }
                ++count;
            }
            ++e;
        }
        return count;
    }

    public static void removeOverlap(PgTextureMapOnCovering texMap) {
        PgCoveringSurface geom = texMap.getGeometry();
        PgCovering covering = texMap.getGeometry().getCovering();
        PdVector[] uSummand = texMap.getUSummand();
        PdVector[] vSummand = texMap.getVSummand();
        PdVector uValues = texMap.getUValues();
        PdVector vValues = texMap.getVValues();
        int i = 0;
        while (i < geom.getNumVertices()) {
            geom.clearTagVertex(i, 1);
            ++i;
        }
        PwSmoothTextures.markNegativeVertices((PgElementSet)geom);
        int numVertices = geom.getNumVertices();
        int symmetry = covering.getSymmetryOrder();
        PdVector sum = new PdVector(2);
        PdVector tmp = new PdVector(2);
        PdVector gap = new PdVector(2);
        PdVector prevElemTex = new PdVector(2);
        PdVector thisElemTex = new PdVector(2);
        PdVector niveau = new PdVector(2);
        PdVector newUValues = new PdVector(numVertices);
        PdVector newVValues = new PdVector(numVertices);
        PgVertexStar star = new PgVertexStar();
        int[] elemPerVertex = PgVertexStar.getElementPerVertex((PgElementSet)geom).m_data;
        PdVector area = new PdVector(geom.getNumElements());
        int i2 = 0;
        while (i2 < area.getSize()) {
            area.m_data[i2] = geom.getAreaOfElement(i2);
            ++i2;
        }
        int vertex = 0;
        while (vertex < numVertices) {
            star.makeVertexStar((PgElementSet)geom, vertex, elemPerVertex[vertex]);
            PiVector elem = star.getElement();
            PiVector vertexLocInd = star.getVertexLocInd();
            int starSize = star.getSize();
            int elemInd0 = elem.getEntry(0);
            int vertexLocInd0 = vertexLocInd.getEntry(0);
            int m0 = 0;
            if (texMap.getVertexRotation() != null) {
                m0 = texMap.getVertexRotation()[elemInd0].m_data[vertexLocInd0];
            }
            sum.setConstant(0.0);
            thisElemTex.setConstant(0.0);
            niveau.setConstant(0.0);
            int prevLayer = 0;
            PdVector[] linkCoords = PdVector.realloc(null, (int)starSize, (int)2);
            if (star.isClosed() && m0 != Integer.MAX_VALUE && geom.hasTagVertex(vertex, 1)) {
                int i3 = 0;
                while (i3 < starSize) {
                    int elemInd = elem.getEntry(i3);
                    int locInd = vertexLocInd.getEntry(i3);
                    int linkVertexLocInd = (locInd + 1) % 3;
                    if (i3 > 0) {
                        int prevElementInd = star.getElement().getEntry(i3 - 1);
                        int prevLocInd = vertexLocInd.getEntry(i3 - 1);
                        int matching = covering.getMatching(prevElementInd, (prevLocInd + 1) % 3);
                        int thisLayer = prevLayer + matching;
                        prevElemTex.m_data[0] = uSummand[prevElementInd].m_data[prevLocInd];
                        prevElemTex.m_data[1] = vSummand[prevElementInd].m_data[prevLocInd];
                        thisElemTex.m_data[0] = uSummand[elemInd].m_data[locInd];
                        thisElemTex.m_data[1] = vSummand[elemInd].m_data[locInd];
                        PnFrameField.rot((PdVector)prevElemTex, (int)(-prevLayer), (int)symmetry);
                        PnFrameField.rot((PdVector)thisElemTex, (int)(-thisLayer), (int)symmetry);
                        gap.sub(thisElemTex, prevElemTex);
                        niveau.add(gap);
                        linkCoords[i3].sub(niveau);
                        prevLayer = thisLayer;
                    }
                    texMap.getTextureValue(elemInd, linkVertexLocInd, tmp);
                    int m = texMap.getVertexRotation()[elemInd].m_data[locInd];
                    PnFrameField.rot((PdVector)tmp, (int)(-m), (int)symmetry);
                    linkCoords[i3].add(tmp);
                    ++i3;
                }
            } else {
                geom.clearTagVertex(vertex, 1);
                newUValues.m_data[vertex] = uValues.m_data[vertex];
                newVValues.m_data[vertex] = vValues.m_data[vertex];
            }
            ++vertex;
        }
        uValues.copyArray(newUValues);
        vValues.copyArray(newVValues);
    }

    public static void smoothTexture(PgTextureMapOnCovering texMap, PdVector[][] continuousTextures, boolean useMeanValueWeights, boolean useKernel) {
        if (texMap == null) {
            return;
        }
        PgCoveringSurface geom = texMap.getGeometry();
        int before = PwSmoothTextures.markNegativeTriangles((PgElementSet)geom, continuousTextures);
        int i = 0;
        while (i < 1) {
            if (useKernel) {
                PwSmoothTextures.removeOverlap(texMap);
            } else {
                PwSmoothTextures.smooth(texMap, useMeanValueWeights);
            }
            ++i;
        }
        texMap.getTextureValues(continuousTextures);
        int after = PwSmoothTextures.markNegativeTriangles((PgElementSet)geom, continuousTextures);
        PsDebug.message((String)(before + " --> " + after));
    }

    public static int markNegativeTriangles(PgElementSet geom, PdVector[][] tex) {
        if (tex == null) {
            return -1;
        }
        PdVector cross = new PdVector(3);
        PdVector e1 = new PdVector(2);
        PdVector e2 = new PdVector(2);
        int count = 0;
        int e = 0;
        while (e < tex.length) {
            e1.sub(tex[e][1], tex[e][0]);
            e2.sub(tex[e][2], tex[e][0]);
            cross.cross(e1, e2);
            if (cross.m_data[2] < 1.0E-10) {
                geom.setTagElement(e, 1);
                ++count;
            }
            ++e;
        }
        return count;
    }
}

