/*
 * Decompiled with CFR 0.152.
 */
package devParameterize.covering;

import devCovering.PgCovering;
import devCovering.PgPathOnCovering;
import devCovering.PnCovering;
import devGraph.PgAbstractGraph;
import devGraph.PgGraphOnElementSet;
import devGraph.PnAbstractGraph;
import devGraph.PnGraphOnElementSet;
import java.util.Vector;
import jv.geom.PgElementSet;
import jv.object.PsDebug;
import jv.vecmath.PiVector;
import jvx.geom.PgVertexStar;

public class PnTopologyOnCovering {
    public static PgPathOnCovering[] computePathsOnCovering(PgElementSet geom, PgCovering covering, PgGraphOnElementSet cutGraph, PiVector bridges, int numLayers) {
        PiVector[] paths;
        geom.allocateEdgeStars();
        PiVector branchPoints = new PiVector();
        PiVector branchTypes = new PiVector();
        if (covering != null) {
            PnCovering.filterBranchPoints((PgCovering)covering, (PiVector)branchPoints, (PiVector)branchTypes, (int)numLayers);
        }
        if ((paths = PnTopologyOnCovering.findHomologyGenerators(geom, branchPoints, branchTypes, bridges, cutGraph)) == null) {
            PsDebug.warning((String)"Failed to find homology generators!");
            return null;
        }
        PiVector elementPerVertex = PgVertexStar.getElementPerVertex((PgElementSet)geom);
        PgPathOnCovering[] poc = new PgPathOnCovering[paths.length];
        int i = 0;
        while (i < paths.length) {
            poc[i] = new PgPathOnCovering();
            poc[i].setGeometry(geom, covering);
            if (!poc[i].makePath(paths[i], elementPerVertex)) {
                poc[i] = null;
            }
            ++i;
        }
        return poc;
    }

    public static PiVector[] findHomologyGenerators(PgElementSet geom, PiVector branchPoints, PiVector branchTypes, PiVector bridges, PgGraphOnElementSet cutGraph) {
        if (cutGraph == null) {
            PgGraphOnElementSet tree = new PgGraphOnElementSet(geom, 1);
            PnGraphOnElementSet.makeShortestPathTree((PgGraphOnElementSet)tree);
            cutGraph = PnGraphOnElementSet.makeDualGraph((PgGraphOnElementSet)tree);
        }
        PiVector boundaryNodes = new PiVector(0);
        geom.markBoundary();
        int i = 0;
        while (i < geom.getNumVertices()) {
            if (geom.hasTagVertex(i, 14) && !cutGraph.isIsolated(i)) {
                boundaryNodes.addEntry(i);
            }
            ++i;
        }
        PiVector specialNodes = PiVector.concatNew((PiVector)boundaryNodes, (PiVector)branchPoints);
        PgGraphOnElementSet subtree = new PgGraphOnElementSet(cutGraph.getGeometry(), cutGraph.getBasedOn());
        PnAbstractGraph.makeSubtree((PgAbstractGraph)subtree, (PgAbstractGraph)cutGraph, (PiVector)specialNodes);
        PiVector cycleBridges = new PiVector();
        PiVector pathBridges = new PiVector();
        PiVector[] cycles = PnTopologyOnCovering.findLoops(subtree, cutGraph, branchPoints, boundaryNodes, branchTypes, cycleBridges);
        PiVector[] paths = PnTopologyOnCovering.findPaths(subtree, branchPoints, boundaryNodes, branchTypes, pathBridges);
        if (bridges != null) {
            bridges.setSize(cycleBridges.getSize());
            bridges.copyArray(cycleBridges);
            bridges.concat(pathBridges);
        }
        PiVector[] loopsPaths = new PiVector[cycles.length + paths.length];
        System.arraycopy(cycles, 0, loopsPaths, 0, cycles.length);
        System.arraycopy(paths, 0, loopsPaths, cycles.length, paths.length);
        if (cycles.length + paths.length != 1 - geom.getEulerCharacteristic() + branchPoints.getSize() && branchPoints.getSize() + boundaryNodes.getSize() != 0 && branchPoints.getSize() != 1) {
            PsDebug.warning((String)("Formula 'p = 1 - chi + s' is not valid.\np = " + cycles.length + " + " + paths.length + " (#loops + #paths)\n" + "chi = " + geom.getEulerCharacteristic() + "(Euler characteristic)\n" + "s = " + branchPoints.getSize() + " (branch points)"));
        }
        return loopsPaths;
    }

    public static PiVector[] findLoops(PgGraphOnElementSet subtree, PgGraphOnElementSet dual, PiVector branchPoints, PiVector boundaryNodes, PiVector branchTypes, PiVector bridges) {
        PgElementSet geom = subtree.getGeometry();
        Vector<PiVector> loopVector = new Vector<PiVector>();
        int v = 0;
        while (v < geom.getNumVertices()) {
            PiVector neigh = dual.getNeighbours(v);
            int l = 0;
            while (l < neigh.getSize()) {
                int v2 = neigh.getEntry(l);
                if (v > v2 && !subtree.isAdjacent(v, v2)) {
                    int endType;
                    PiVector vToBranch = branchPoints.getIndexOf(v) != -1 ? new PiVector(new int[]{v}) : PnTopologyOnCovering.pathToRootOrSingularityOrBoundary(subtree, v, branchPoints, boundaryNodes);
                    PiVector v2ToBranch = branchPoints.getIndexOf(v2) != -1 ? new PiVector(new int[]{v2}) : PnTopologyOnCovering.pathToRootOrSingularityOrBoundary(subtree, v2, branchPoints, boundaryNodes);
                    vToBranch.invert();
                    PiVector path = PiVector.concatNew((PiVector)vToBranch, (PiVector)v2ToBranch);
                    int startIndex = branchPoints.getIndexOf(path.getFirstEntry());
                    int endIndex = branchPoints.getIndexOf(path.getLastEntry());
                    boolean bClosed = startIndex >= 0 && endIndex >= 0;
                    int startType = startIndex == -1 ? -1 : branchTypes.getEntry(startIndex);
                    int n = endType = endIndex == -1 ? -1 : branchTypes.getEntry(endIndex);
                    if (bClosed && startType % 2 == 0 && endType % 2 == 1 || startType == 3 && endType % 2 == 1) {
                        path.invert();
                        bridges.addEntry(v2ToBranch.getSize());
                    } else if (bClosed) {
                        bridges.addEntry(vToBranch.getSize() - 1);
                    } else {
                        bridges.addEntry(vToBranch.getSize());
                    }
                    int size = path.getSize();
                    if ((startIndex >= 0 || endIndex >= 0) && path.getFirstEntry() != path.getLastEntry()) {
                        path.setSize(2 * size - 1);
                        int j = size;
                        while (j < 2 * size - 1) {
                            path.m_data[j] = path.m_data[2 * size - j - 2];
                            ++j;
                        }
                    }
                    loopVector.addElement(path);
                }
                ++l;
            }
            ++v;
        }
        PiVector[] loops = new PiVector[loopVector.size()];
        int i = 0;
        while (i < loops.length) {
            loops[i] = (PiVector)loopVector.elementAt(i);
            ++i;
        }
        return loops;
    }

    private static PiVector[] findPaths(PgGraphOnElementSet tree, PiVector branchPoints, PiVector boundaryPoints, PiVector branchTypes, PiVector bridges) {
        int size;
        PiVector path;
        if (branchPoints == null) {
            return null;
        }
        Vector<PiVector> paths = new Vector<PiVector>();
        int i = 0;
        while (i < branchPoints.getSize()) {
            path = PnTopologyOnCovering.pathToRootOrSingularityOrBoundary(tree, branchPoints.getEntry(i), branchPoints, boundaryPoints);
            size = path.getSize();
            if (size > 1) {
                int endType;
                int startIndex = branchPoints.getIndexOf(path.getFirstEntry());
                int endIndex = branchPoints.getIndexOf(path.getLastEntry());
                int startType = branchTypes.getEntry(startIndex);
                int n = endType = endIndex >= 0 ? branchTypes.getEntry(endIndex) : 0;
                if (endIndex < 0 || startType % 2 == 0 && endType % 2 == 1 || startType == 3 && endType % 2 == 1) {
                    path.invert();
                    bridges.addEntry(size - 1);
                } else {
                    bridges.addEntry(0);
                }
                path.setSize(2 * size - 1);
                int j = size;
                while (j < 2 * size - 1) {
                    path.m_data[j] = path.m_data[2 * size - j - 2];
                    ++j;
                }
                paths.addElement(path);
            }
            ++i;
        }
        i = 0;
        while (i < boundaryPoints.getSize()) {
            path = PnTopologyOnCovering.pathToRootOrSingularityOrBoundary(tree, boundaryPoints.getEntry(i), branchPoints, boundaryPoints);
            size = path.getSize();
            if (size > 1) {
                if (branchPoints.getIndexOf(path.getLastEntry()) >= 0) {
                    path.setSize(2 * size - 1);
                    int j = size;
                    while (j < 2 * size - 1) {
                        path.m_data[j] = path.m_data[2 * size - j - 2];
                        ++j;
                    }
                    bridges.addEntry(1);
                } else {
                    bridges.addEntry(0);
                }
                paths.addElement(path);
            }
            ++i;
        }
        PiVector[] array = new PiVector[paths.size()];
        int i2 = 0;
        while (i2 < array.length) {
            array[i2] = (PiVector)paths.elementAt(i2);
            ++i2;
        }
        return array;
    }

    private static PiVector pathToRootOrSingularityOrBoundary(PgGraphOnElementSet tree, int vertex, PiVector branchPoints, PiVector boundaryNodes) {
        if (tree == null || !tree.isTree()) {
            PsDebug.warning((String)"Missing tree");
            return null;
        }
        PiVector path = new PiVector(new int[]{vertex});
        if (tree.isRoot(vertex) || tree.isIsolated(vertex)) {
            return path;
        }
        int currentVertex = vertex;
        do {
            currentVertex = tree.getParent(currentVertex);
            path.addEntry(currentVertex);
        } while (!tree.isRoot(currentVertex) && branchPoints.getIndexOf(currentVertex) == -1 && boundaryNodes.getIndexOf(currentVertex) == -1);
        return path;
    }
}

