/*
 * Decompiled with CFR 0.152.
 */
package devParameterize.covering;

import devCovering.PgCoveringSurface;
import devCovering.PgPathOnCovering;
import devParameterize.covering.PgIntTextureMapOnCovering;
import devParameterize.covering.PgTextureMapOnCovering;
import jv.geom.PgElementSet;
import jv.object.PsDebug;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.geom.PgVertexStar;

public class PnTextureQuantizer {
    private PgCoveringSurface m_geom;
    private int m_quantization;
    private PgTextureMapOnCovering m_texMap;
    private PgPathOnCovering[] m_paths;
    private PiVector m_bridges;
    private PdVector m_gaps;

    public PnTextureQuantizer(int quantization) {
        this.m_quantization = quantization;
    }

    public void setGeometry(PgCoveringSurface geom) {
        this.m_geom = geom;
    }

    public void setTextureMap(PgTextureMapOnCovering tex) {
        this.m_texMap = tex;
    }

    public void setPaths(PgPathOnCovering[] paths, PiVector bridges) {
        this.m_paths = paths;
        this.m_bridges = bridges;
    }

    public void setGaps(PdVector gaps) {
        this.m_gaps = gaps;
    }

    public PgIntTextureMapOnCovering makeQuantizedTextures() {
        if (this.m_geom == null) {
            PsDebug.warning((String)"No geometry set.");
            return null;
        }
        if (this.m_texMap == null) {
            PsDebug.warning((String)"No Texture map set.");
            return null;
        }
        if (this.m_paths == null || this.m_bridges == null) {
            PsDebug.warning((String)"No paths or bridges set.");
            return null;
        }
        if (this.m_gaps == null) {
            PsDebug.warning((String)"No gaps set.");
            return null;
        }
        PgIntTextureMapOnCovering intTex = new PgIntTextureMapOnCovering();
        intTex.setGeometry(this.m_geom);
        intTex.setVertexRotation(this.m_texMap.getVertexRotation());
        this.makeSummandFromGaps(intTex);
        this.addContinuousCoordinates(intTex);
        return intTex;
    }

    private boolean makeSummandFromGaps(PgIntTextureMapOnCovering intTex) {
        int numGaps = this.m_gaps.getSize() / 2;
        PdVector uGaps = new PdVector(numGaps);
        PdVector vGaps = new PdVector(numGaps);
        int i = 0;
        while (i < numGaps) {
            uGaps.m_data[i] = this.m_gaps.m_data[2 * i];
            vGaps.m_data[i] = this.m_gaps.m_data[2 * i + 1];
            ++i;
        }
        int symmetryOrder = this.m_texMap.getGeometry().getCovering().getSymmetryOrder();
        if (symmetryOrder == 6) {
            uGaps.multScalar(1.0 / Math.sqrt(3.0));
        }
        PiVector intUGaps = this.quantizeVector(uGaps);
        PiVector intVGaps = this.quantizeVector(vGaps);
        intTex.makeSummandFromGaps(this.m_paths, this.m_bridges, intUGaps, intVGaps);
        return true;
    }

    private PiVector quantizeVector(PdVector vec) {
        int len = vec.getSize();
        PiVector intVec = new PiVector(len);
        int i = 0;
        while (i < len) {
            intVec.m_data[i] = (int)Math.round(vec.m_data[i] * (double)this.m_quantization);
            ++i;
        }
        return intVec;
    }

    private void addContinuousCoordinates(PgIntTextureMapOnCovering intTex) {
        int numV = this.m_geom.getNumVertices();
        PgVertexStar star = new PgVertexStar();
        PiVector elementPerVertex = PgVertexStar.getElementPerVertex((PgElementSet)this.m_geom);
        PdVector actTex = new PdVector(2);
        PiVector actIntTex = new PiVector(2);
        PiVector[] vRotation = this.m_texMap.getVertexRotation();
        int v = 0;
        while (v < numV) {
            int e = elementPerVertex.m_data[v];
            star.makeVertexStar((PgElementSet)this.m_geom, v, e);
            e = star.getElement().m_data[0];
            int locInd = star.getVertexLocInd().m_data[0];
            if (vRotation[e].m_data[locInd] != Integer.MAX_VALUE) {
                int i = 0;
                while (vRotation[e].m_data[locInd] != 0) {
                    e = star.getElement().m_data[++i];
                    locInd = star.getVertexLocInd().m_data[i];
                }
                this.m_texMap.getTextureValue(e, locInd, actTex);
                PiVector quantizedActTex = this.quantizeVector(actTex);
                intTex.getTextureValue(e, locInd, actIntTex);
                int addUValue = quantizedActTex.m_data[0] - actIntTex.m_data[0];
                int addVValue = quantizedActTex.m_data[1] - actIntTex.m_data[1];
                int n = v;
                intTex.getUValues().m_data[n] = intTex.getUValues().m_data[n] + addUValue;
                int n2 = v;
                intTex.getVValues().m_data[n2] = intTex.getVValues().m_data[n2] + addVValue;
            }
            ++v;
        }
        v = 0;
        while (v < numV) {
            int n = v;
            intTex.getUValues().m_data[n] = intTex.getUValues().m_data[n] & 0xFFFFFFFE;
            int n3 = v++;
            intTex.getVValues().m_data[n3] = intTex.getVValues().m_data[n3] & 0xFFFFFFFE;
        }
    }
}

