/*
 * Decompiled with CFR 0.152.
 */
package devParameterize.covering;

import devCovering.PgCovering;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import jv.geom.PgElementSet;
import jv.geom.PgVectorField;
import jv.object.PsDebug;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuMath;
import jv.vecmath.PuVectorGeom;
import jvx.geom.PgVertexStar;
import jvx.numeric.PnConjugateGradient;
import jvx.numeric.PnFunction;
import jvx.vector.PwVectorField;

public class PnFrameFieldSmoother
extends PnFunction {
    protected PgElementSet m_geom;
    protected PgVectorField m_field;
    protected PgCovering m_covering;
    protected PdVector m_weights;
    protected int m_numVariables;
    private PdVector m_startAngles;
    protected double[] m_elemArea;
    protected double[] m_edgeWeight;
    protected boolean m_bVertexBased;
    protected PiVector[] m_neighbour;
    protected boolean[] m_constraint;
    protected double m_smooth;
    protected boolean m_bStripes;
    protected int m_symmetryOrder;
    private ExecutorService m_threadPool;
    private int m_numThreads;
    private int[][] m_edgeIndex;
    private boolean m_useMultithreading = true;

    public void setVectorField(PgElementSet geom, PgVectorField field, int symmetryOrder) {
        if (field.getGeometry() != geom) {
            PsDebug.warning((String)"Vector field does not live on given geometry.");
            return;
        }
        this.m_geom = geom;
        this.m_field = field;
        this.m_covering = null;
        this.m_symmetryOrder = symmetryOrder;
        this.initializeDatastructures();
    }

    public void setFrameField(PgElementSet geom, PgVectorField field, PgCovering covering, int symmetryOrder) {
        if (field.getGeometry() != geom) {
            PsDebug.warning((String)"Vector field does not live on given geometry.");
            return;
        }
        this.m_geom = geom;
        this.m_field = field;
        this.m_covering = covering;
        this.m_symmetryOrder = symmetryOrder;
        this.initializeDatastructures();
    }

    private void initializeDatastructures() {
        this.m_bVertexBased = this.m_field.getBasedOn() == 0;
        this.m_numVariables = this.m_bVertexBased ? this.m_geom.getNumVertices() : this.m_geom.getNumElements();
        this.m_startAngles = new PdVector(this.m_geom.getNumEdges());
        this.m_elemArea = new double[this.m_numVariables];
        this.m_edgeWeight = new double[this.m_geom.getNumEdges()];
        double totalArea = 0.0;
        if (this.m_bVertexBased) {
            this.m_neighbour = new PiVector[this.m_numVariables];
            PiVector incidentElement = PgVertexStar.getElementPerVertex((PgElementSet)this.m_geom);
            PgVertexStar star = new PgVertexStar();
            int v = 0;
            while (v < this.m_numVariables) {
                if (incidentElement.m_data[v] != -1) {
                    star.makeVertexStar(this.m_geom, v, incidentElement.m_data[v]);
                    this.m_neighbour[v] = PiVector.copyNew((PiVector)star.getLink());
                }
                ++v;
            }
        } else {
            this.m_neighbour = this.m_geom.getNeighbours();
        }
        int i = 0;
        this.m_edgeIndex = new int[this.m_numVariables][];
        int e = 0;
        while (e < this.m_numVariables) {
            int size = this.m_neighbour[e].getSize();
            this.m_edgeIndex[e] = new int[size];
            int j = 0;
            while (j < size) {
                int ne = this.m_neighbour[e].m_data[j];
                if (ne > e) {
                    if (this.m_bVertexBased) {
                        this.m_startAngles.m_data[i] = PwVectorField.calcVertexAngle((PgVectorField)this.m_field, (int)e, (int)ne);
                    } else {
                        this.m_startAngles.m_data[i] = PwVectorField.calcAngle((PgVectorField)this.m_field, (int)e, (int)ne);
                        if (this.m_covering != null) {
                            int m = this.m_covering.getMatching(e, j);
                            int n = i;
                            this.m_startAngles.m_data[n] = this.m_startAngles.m_data[n] + Math.PI * 2 / (double)this.m_symmetryOrder * (double)PuMath.modulo((int)m, (int)this.m_symmetryOrder);
                        }
                    }
                    this.m_edgeIndex[e][j] = i++;
                }
                ++j;
            }
            this.m_elemArea[e] = this.m_geom.getAreaOfElement(e);
            totalArea += this.m_elemArea[e];
            ++e;
        }
        i = 0;
        e = 0;
        while (e < this.m_numVariables) {
            int j = 0;
            while (j < this.m_neighbour[e].getSize()) {
                int ne = this.m_neighbour[e].m_data[j];
                if (ne > e) {
                    double hingeArea = 0.3333333333333333 * (this.m_elemArea[e] + this.m_elemArea[ne]);
                    int locE = this.m_geom.getNeighbour(e).getIndexOf(ne);
                    PdVector v1 = this.m_geom.getVertex(this.m_geom.getElement(e).getEntry((locE + 1) % 3));
                    PdVector v2 = this.m_geom.getVertex(this.m_geom.getElement(e).getEntry((locE + 2) % 3));
                    double length = PdVector.dist((PdVector)v1, (PdVector)v2);
                    double height = Math.sqrt(3.0) * 2.0 * hingeArea / length;
                    double heightRatio = length / height;
                    this.m_edgeWeight[i] = heightRatio * this.m_smooth;
                    ++i;
                }
                ++j;
            }
            ++e;
        }
        e = 0;
        while (e < this.m_numVariables) {
            int n = e++;
            this.m_elemArea[n] = this.m_elemArea[n] * ((double)this.m_numVariables / totalArea);
        }
        ++i;
    }

    public void setSmoothingFactor(double smooth) {
        this.m_smooth = smooth;
    }

    public void setWeights(PdVector weights) {
        this.m_weights = weights;
    }

    public void setEnabledStripes(boolean bEnableStripes) {
        this.m_bStripes = bEnableStripes;
    }

    public int getNumOfVariables() {
        return this.m_numVariables;
    }

    public double eval(PdVector coord) {
        if (this.m_useMultithreading && this.m_threadPool != null) {
            return this.evalMT(coord);
        }
        double energy = 0.0;
        int i = 0;
        int e = 0;
        while (e < this.m_numVariables) {
            int size = this.m_neighbour[e].getSize();
            int j = 0;
            while (j < size) {
                int ne = this.m_neighbour[e].m_data[j];
                if (ne > e) {
                    double angle = this.m_startAngles.m_data[i] + coord.m_data[ne] - coord.m_data[e];
                    double cos = this.m_covering == null ? (1.0 - Math.cos((double)this.m_symmetryOrder * angle)) / (double)this.m_symmetryOrder : (!this.m_bStripes ? 4.0 * (1.0 - Math.cos(angle)) : 1.0 - Math.cos(2.0 * angle));
                    energy += this.m_edgeWeight[i] * cos;
                    ++i;
                }
                ++j;
            }
            energy += this.m_elemArea[e] * (1.0 - this.m_smooth) * this.m_weights.m_data[e] * coord.m_data[e] * coord.m_data[e] / 2.0;
            ++e;
        }
        return energy;
    }

    private double evalMT(final PdVector coord) {
        final int numThreads = this.m_numThreads > 0 ? this.m_numThreads : Runtime.getRuntime().availableProcessors();
        final PdVector startAngles = this.m_startAngles;
        final int[][] edgeIndex = this.m_edgeIndex;
        Future[] result = new Future[numThreads];
        int t = 0;
        while (t < numThreads) {
            final int tt = t;
            result[t] = this.m_threadPool.submit(new Callable<Double>(){

                @Override
                public Double call() {
                    double energy = 0.0;
                    int e = 0;
                    while (e < PnFrameFieldSmoother.this.m_numVariables) {
                        if (e % numThreads == tt) {
                            int size = PnFrameFieldSmoother.this.m_neighbour[e].getSize();
                            int j = 0;
                            while (j < size) {
                                int ne = PnFrameFieldSmoother.this.m_neighbour[e].m_data[j];
                                if (ne > e) {
                                    int i = edgeIndex[e][j];
                                    double angle = startAngles.m_data[i] + coord.m_data[ne] - coord.m_data[e];
                                    double cos = PnFrameFieldSmoother.this.m_covering == null ? (1.0 - Math.cos((double)PnFrameFieldSmoother.this.m_symmetryOrder * angle)) / (double)PnFrameFieldSmoother.this.m_symmetryOrder : (!PnFrameFieldSmoother.this.m_bStripes ? 4.0 * (1.0 - Math.cos(angle)) : 1.0 - Math.cos(2.0 * angle));
                                    energy += PnFrameFieldSmoother.this.m_edgeWeight[i] * cos;
                                }
                                ++j;
                            }
                            energy += PnFrameFieldSmoother.this.m_elemArea[e] * (1.0 - PnFrameFieldSmoother.this.m_smooth) * PnFrameFieldSmoother.this.m_weights.m_data[e] * coord.m_data[e] * coord.m_data[e] / 2.0;
                        }
                        ++e;
                    }
                    return new Double(energy);
                }
            });
            ++t;
        }
        double totalEnergy = 0.0;
        try {
            int j = 0;
            while (j < result.length) {
                totalEnergy += ((Double)result[j].get()).doubleValue();
                ++j;
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        return totalEnergy;
    }

    public PdVector evalGradient(PdVector coord, PdVector gradient) {
        if (this.m_useMultithreading && this.m_threadPool != null) {
            return PdVector.copyNew((PdVector)this.evalGradientMT(coord, gradient));
        }
        int i = 0;
        if (gradient == null) {
            gradient = new PdVector(coord.getSize());
        } else {
            gradient.setConstant(0.0);
        }
        int e = 0;
        while (e < this.m_numVariables) {
            int size = this.m_neighbour[e].getSize();
            int j = 0;
            while (j < size) {
                int ne = this.m_neighbour[e].m_data[j];
                if (ne > e) {
                    double angle = this.m_startAngles.m_data[i] + coord.m_data[ne] - coord.m_data[e];
                    double sin = this.m_covering == null ? Math.sin((double)this.m_symmetryOrder * angle) : (!this.m_bStripes ? 4.0 * Math.sin(angle) : 2.0 * Math.sin(2.0 * angle));
                    double derivative = this.m_edgeWeight[i] * sin;
                    int n = e;
                    gradient.m_data[n] = gradient.m_data[n] - derivative;
                    int n2 = ne;
                    gradient.m_data[n2] = gradient.m_data[n2] + derivative;
                    ++i;
                }
                ++j;
            }
            int n = e;
            gradient.m_data[n] = gradient.m_data[n] + this.m_elemArea[e] * (1.0 - this.m_smooth) * this.m_weights.m_data[e] * coord.m_data[e];
            ++e;
        }
        if (this.m_constraint != null) {
            e = 0;
            while (e < this.m_numVariables) {
                if (this.m_constraint[e]) {
                    gradient.m_data[e] = 0.0;
                }
                ++e;
            }
        }
        return gradient;
    }

    private PdVector evalGradientMT(final PdVector coord, PdVector gradient) {
        final int numThreads = this.m_numThreads > 0 ? this.m_numThreads : Runtime.getRuntime().availableProcessors();
        final PdVector startAngles = this.m_startAngles;
        final int[][] edgeIndex = this.m_edgeIndex;
        Future[] result = new Future[numThreads];
        int t = 0;
        while (t < numThreads) {
            final int tt = t;
            result[t] = this.m_threadPool.submit(new Callable<PdVector>(){

                @Override
                public PdVector call() {
                    PdVector grad = new PdVector(coord.getSize());
                    int e = 0;
                    while (e < PnFrameFieldSmoother.this.m_numVariables) {
                        if (e % numThreads == tt) {
                            int size = PnFrameFieldSmoother.this.m_neighbour[e].getSize();
                            int j = 0;
                            while (j < size) {
                                int ne = PnFrameFieldSmoother.this.m_neighbour[e].m_data[j];
                                if (ne > e) {
                                    int i = edgeIndex[e][j];
                                    double angle = startAngles.m_data[i] + coord.m_data[ne] - coord.m_data[e];
                                    double sin = PnFrameFieldSmoother.this.m_covering == null ? Math.sin((double)PnFrameFieldSmoother.this.m_symmetryOrder * angle) : (!PnFrameFieldSmoother.this.m_bStripes ? 4.0 * Math.sin(angle) : 2.0 * Math.sin(2.0 * angle));
                                    double derivative = PnFrameFieldSmoother.this.m_edgeWeight[i] * sin;
                                    int n = e;
                                    grad.m_data[n] = grad.m_data[n] - derivative;
                                    int n2 = ne;
                                    grad.m_data[n2] = grad.m_data[n2] + derivative;
                                }
                                ++j;
                            }
                            int n = e;
                            grad.m_data[n] = grad.m_data[n] + PnFrameFieldSmoother.this.m_elemArea[e] * (1.0 - PnFrameFieldSmoother.this.m_smooth) * PnFrameFieldSmoother.this.m_weights.m_data[e] * coord.m_data[e];
                        }
                        ++e;
                    }
                    return grad;
                }
            });
            ++t;
        }
        if (gradient == null) {
            gradient = new PdVector(coord.getSize());
        } else {
            gradient.setConstant(0.0);
        }
        try {
            int j = 0;
            while (j < result.length) {
                gradient.add((PdVector)result[j].get());
                ++j;
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        return gradient;
    }

    public PdMatrix evalHessian(PdMatrix aHessian) {
        return null;
    }

    public void setConstraint(boolean[] constraint) {
        this.m_constraint = constraint;
    }

    public static double smoothCurvatureField(PgElementSet geom, PgVectorField[] field, PdVector elemWeights, double smooth, PgCovering covering, int symmetryOrder, boolean bStripes, boolean[] constraint, ExecutorService threadPool, int numThreads) {
        PnFrameFieldSmoother energy = new PnFrameFieldSmoother();
        energy.setThreadPool(threadPool);
        energy.setNumThreads(numThreads);
        energy.setSmoothingFactor(smooth);
        energy.setWeights(elemWeights);
        energy.setFrameField(geom, field[0], covering, symmetryOrder);
        energy.setEnabledStripes(bStripes);
        energy.setConstraint(constraint);
        PdVector angles = new PdVector(energy.getNumOfVariables());
        PnConjugateGradient cgMethod = new PnConjugateGradient();
        cgMethod.setMaxNumIterations(1000);
        double energyVal = cgMethod.dfrprmn(angles, 1.0E-5, (PnFunction)energy);
        int i = 0;
        while (i < geom.getNumElements()) {
            int f = 0;
            while (f < field.length) {
                PdVector v = field[f].getVector(i);
                PuVectorGeom.rotatePointAroundVector((PdVector)v, (PdVector)v, (PdVector)geom.getElementNormal(i), (double)angles.getEntry(i));
                ++f;
            }
            ++i;
        }
        return energyVal;
    }

    public void setNumThreads(int numThreads) {
        this.m_numThreads = numThreads;
    }

    public void setThreadPool(ExecutorService threadPool) {
        this.m_threadPool = threadPool;
    }

    public PdVector getStartAngles() {
        return this.m_startAngles;
    }

    public void setStartAngles(PdVector startAngles) {
        this.m_startAngles = startAngles;
    }
}

