/*
 * Decompiled with CFR 0.152.
 */
package devParameterize.covering;

import devCovering.PgCovering;
import devCovering.PgFrameField;
import devCovering.PnFrameField;
import devCovering.PnStiffMatrixOnCovering;
import jv.geom.PgElementSet;
import jv.object.PsDebug;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.geom.PgUtil;
import jvx.gui.PuProgressBar;
import jvx.numeric.PnFunction;
import jvx.numeric.PnSparseMatrix;

public class PnFrameFieldHodgeEnergy
extends PnFunction {
    protected PgElementSet m_geom;
    protected PgFrameField m_field;
    protected boolean m_conforming;
    protected boolean m_rotateGradient;
    protected int m_numVertices;
    protected PiVector[] m_vertexRotation;
    PuProgressBar m_status = null;
    double m_initialStatus = 0.0;
    private PdVector[][] m_potentialSummand;
    private double m_maxProgress;
    private boolean[] m_bConstraint;
    private PnSparseMatrix m_lagrangeMultiplier;
    private int m_numLagrangeMultiplier;
    private int m_numMethodCalls = 0;
    private PdVector m_vectorX = new PdVector(3);
    private PdVector m_vectorY = new PdVector(3);
    private PdVector m_tmp3 = new PdVector(3);
    private PdVector m_edge = new PdVector(3);
    private static PdVector m_values = new PdVector(3);
    private static PdVector m_tmp = new PdVector(2);

    public PnFrameFieldHodgeEnergy(PgElementSet geom, PgFrameField field, PiVector[] vertexRotation, boolean conforming, boolean rotateGradient) {
        this.m_geom = geom;
        if (this.m_geom.getElementEdges() == null) {
            this.m_geom.setEnabledEdges(true);
            this.m_geom.makeEdgeStars();
        }
        this.m_field = field;
        this.m_conforming = conforming;
        this.m_rotateGradient = rotateGradient;
        this.m_numVertices = this.m_geom.getNumVertices();
        this.m_vertexRotation = vertexRotation;
    }

    public int getNumOfVariables() {
        if (this.m_conforming) {
            return 2 * this.m_numVertices + this.m_numLagrangeMultiplier;
        }
        return 2 * this.m_geom.getNumEdges() + this.m_numLagrangeMultiplier;
    }

    public void setPotentialSummand(PdVector[][] potentialSummand) {
        this.m_potentialSummand = potentialSummand;
    }

    public void setConstraintVertices(boolean[] constraint) {
        this.m_bConstraint = constraint;
    }

    public double eval(PdVector coord) {
        int numElements = this.m_geom.getNumElements();
        if (this.m_tmp3 == null) {
            this.m_tmp3 = new PdVector(3);
        }
        double value = 0.0;
        int e = 0;
        while (e < numElements) {
            double area = this.m_geom.getAreaOfElement(e);
            if (this.m_conforming) {
                value += area * this.calcVectorX(coord, e, this.m_tmp3, this.m_potentialSummand).sqrLength();
                value += area * this.calcVectorY(coord, e, this.m_tmp3, this.m_potentialSummand).sqrLength();
            } else {
                value += area * this.calcVectorXNonConf(coord, e, this.m_tmp3).sqrLength();
                value += area * this.calcVectorYNonConf(coord, e, this.m_tmp3).sqrLength();
            }
            ++e;
        }
        if (this.m_lagrangeMultiplier != null) {
            int numVariables = this.m_conforming ? 2 * this.m_numVertices : 2 * this.m_geom.getNumEdges();
            int i = 0;
            while (i < this.m_numLagrangeMultiplier) {
                double cx = 0.0;
                int numEntries = this.m_lagrangeMultiplier.getNumEntries(i);
                int j = 0;
                while (j < numEntries) {
                    int jInd = this.m_lagrangeMultiplier.getColIndex(i, j);
                    cx += this.m_lagrangeMultiplier.getEntry(i, j) * coord.m_data[jInd];
                    ++j;
                }
                value -= coord.m_data[numVariables + i] * cx;
                ++i;
            }
        }
        return value;
    }

    public PdVector evalGradient(PdVector coord, PdVector gradient) {
        double process;
        if (this.m_geom.getDimOfElements() != 3) {
            PsDebug.warning((String)"Surface is not triangulated.");
            return null;
        }
        PdVector[] vertex = this.m_geom.getVertices();
        PiVector[] neighbour = this.m_geom.getNeighbours();
        int numElements = this.m_geom.getNumElements();
        if (gradient == null) {
            gradient = new PdVector(this.getNumOfVariables());
        } else {
            gradient.setSize(this.getNumOfVariables());
            gradient.setConstant(0.0);
        }
        PiVector[] edgeIndices = this.m_geom.getElementEdges();
        PdVector grad = new PdVector(2);
        int e = 0;
        while (e < numElements) {
            PiVector element = this.m_geom.getElement(e);
            if (this.m_conforming) {
                this.m_vectorX = this.calcVectorX(coord, e, this.m_vectorX, this.m_potentialSummand);
                this.m_vectorY = this.calcVectorY(coord, e, this.m_vectorY, this.m_potentialSummand);
            } else {
                this.m_vectorX = this.calcVectorXNonConf(coord, e, this.m_vectorX);
                this.m_vectorY = this.calcVectorYNonConf(coord, e, this.m_vectorY);
            }
            int i = 0;
            while (i < 3) {
                block18: {
                    int r;
                    int idx;
                    block19: {
                        block17: {
                            if (!this.m_conforming) break block17;
                            idx = element.m_data[i];
                            r = this.m_vertexRotation[e].m_data[i];
                            if (r == Integer.MAX_VALUE) break block18;
                            this.m_edge.sub(vertex[element.m_data[(i + 2) % 3]], vertex[element.m_data[(i + 1) % 3]]);
                            this.m_edge.cross(this.m_geom.getElementNormal(e), this.m_edge);
                            break block19;
                        }
                        idx = edgeIndices[e].m_data[i];
                        int ne = neighbour[e].m_data[i];
                        if (this.m_lagrangeMultiplier == null && ne < 0) break block18;
                        r = PnStiffMatrixOnCovering.getRotation((PgCovering)this.m_field.getCovering(), (int)e, (int)ne, (int)i);
                        this.m_edge.sub(vertex[element.m_data[(i + 2) % 3]], vertex[element.m_data[(i + 1) % 3]]);
                    }
                    grad.set(this.m_vectorX.dot(this.m_edge), this.m_vectorY.dot(this.m_edge));
                    PnFrameField.rot((PdVector)grad, (int)(-r), (int)this.m_field.getCovering().getSymmetryOrder());
                    int n = 2 * idx;
                    gradient.m_data[n] = gradient.m_data[n] + 2.0 * grad.m_data[0];
                    int n2 = 2 * idx + 1;
                    gradient.m_data[n2] = gradient.m_data[n2] + 2.0 * grad.m_data[1];
                }
                ++i;
            }
            ++e;
        }
        if (this.m_lagrangeMultiplier != null) {
            int numVariables = this.m_conforming ? 2 * this.m_numVertices : 2 * this.m_geom.getNumEdges();
            int i = 0;
            while (i < this.m_numLagrangeMultiplier) {
                int numEntries = this.m_lagrangeMultiplier.getNumEntries(i);
                int j = 0;
                while (j < numEntries) {
                    int jInd = this.m_lagrangeMultiplier.getColIndex(i, j);
                    double entry = this.m_lagrangeMultiplier.getEntries((int)i).m_data[j];
                    int n = jInd;
                    gradient.m_data[n] = gradient.m_data[n] - entry * coord.m_data[numVariables + i];
                    int n3 = numVariables + i;
                    gradient.m_data[n3] = gradient.m_data[n3] - entry * coord.m_data[jInd];
                    ++j;
                }
                ++i;
            }
        }
        if (this.m_bConstraint != null) {
            int i = 0;
            while (i < coord.getSize()) {
                if (this.m_bConstraint[i]) {
                    gradient.m_data[i] = 0.0;
                }
                ++i;
            }
        }
        if (++this.m_numMethodCalls % 10 == 0 && this.m_status != null && (process = (PnFrameFieldHodgeEnergy.progressFun(gradient) - this.m_initialStatus) / this.m_maxProgress) > this.m_status.getProgress()) {
            this.m_status.setProgress(process);
        }
        return gradient;
    }

    public void setLagrangeMultiplier(PnSparseMatrix constraint) {
        this.m_lagrangeMultiplier = constraint;
        this.m_numLagrangeMultiplier = constraint == null ? 0 : constraint.getNumRows();
    }

    public void setProgressStatus(PuProgressBar status, PdVector coords, double eps) {
        if (status == null) {
            PsDebug.warning((String)"Argument is null.");
            return;
        }
        this.m_status = status;
        this.m_initialStatus = PnFrameFieldHodgeEnergy.progressFun(this.evalGradient(coords, null));
        double finalStatus = -Math.log(eps) / 3.0;
        this.m_maxProgress = finalStatus - this.m_initialStatus;
        this.m_status.reset();
    }

    private static double progressFun(PdVector grad) {
        double entries = 0.0;
        int size = grad.getSize();
        int i = 0;
        while (i < size) {
            entries += Math.abs(grad.m_data[i]);
            ++i;
        }
        return -Math.log(entries);
    }

    public PdMatrix evalHessian(PdMatrix aHessian) {
        return null;
    }

    private PdVector calcVectorXNonConf(PdVector coord, int elementIdx, PdVector vector) {
        vector = PnFrameFieldHodgeEnergy.calcGradXNonConf(this.m_geom, this.m_field.getCovering(), elementIdx, coord, vector, this.m_rotateGradient);
        vector.sub(this.m_field.getField(0).getVector(elementIdx));
        return vector;
    }

    private PdVector calcVectorYNonConf(PdVector coord, int elementIdx, PdVector vector) {
        vector = PnFrameFieldHodgeEnergy.calcGradYNonConf(this.m_geom, this.m_field.getCovering(), elementIdx, coord, vector, this.m_rotateGradient);
        vector.sub(this.m_field.getField(1).getVector(elementIdx));
        return vector;
    }

    private PdVector calcVectorX(PdVector coord, int elementIdx, PdVector vector, PdVector[][] potentialSummand) {
        int numLayers = this.m_field.getCovering().getSymmetryOrder();
        vector = PnFrameFieldHodgeEnergy.calcGradX(this.m_geom, this.m_vertexRotation, numLayers, elementIdx, coord, vector, potentialSummand, this.m_rotateGradient);
        vector.sub(this.m_field.getField(0).getVector(elementIdx));
        return vector;
    }

    private PdVector calcVectorY(PdVector coord, int elementIdx, PdVector vector, PdVector[][] potentialSummand) {
        int numLayers = this.m_field.getCovering().getSymmetryOrder();
        vector = PnFrameFieldHodgeEnergy.calcGradY(this.m_geom, this.m_vertexRotation, numLayers, elementIdx, coord, vector, potentialSummand, this.m_rotateGradient);
        vector.sub(this.m_field.getField(1).getVector(elementIdx));
        return vector;
    }

    public static PdVector calcGradXNonConf(PgElementSet geom, PgCovering covering, int elementIdx, PdVector coord, PdVector vector, boolean rotateGradient) {
        PiVector edgeIndices = geom.getElementEdges()[elementIdx];
        PiVector neighbour = geom.getNeighbour(elementIdx);
        int numLayers = covering.getSymmetryOrder();
        int i = 0;
        while (i < 3) {
            PnFrameFieldHodgeEnergy.m_tmp.m_data[0] = coord.m_data[2 * edgeIndices.m_data[i]];
            PnFrameFieldHodgeEnergy.m_tmp.m_data[1] = coord.m_data[2 * edgeIndices.m_data[i] + 1];
            int r = PnStiffMatrixOnCovering.getRotation((PgCovering)covering, (int)elementIdx, (int)neighbour.m_data[i], (int)i);
            PnFrameField.rot((PdVector)m_tmp, (int)r, (int)numLayers);
            PnFrameFieldHodgeEnergy.m_values.m_data[i] = PnFrameFieldHodgeEnergy.m_tmp.m_data[0];
            ++i;
        }
        vector = PgUtil.calcLinearGradientNonConforming((PgElementSet)geom, (int)elementIdx, (PdVector)m_values, (PdVector)vector);
        if (rotateGradient) {
            vector.cross(geom.getElementNormal(elementIdx), vector);
        }
        return vector;
    }

    public static PdVector calcGradYNonConf(PgElementSet geom, PgCovering covering, int elementIdx, PdVector coord, PdVector vector, boolean rotateGradient) {
        PiVector edgeIndices = geom.getElementEdges()[elementIdx];
        PiVector neighbour = geom.getNeighbour(elementIdx);
        int numLayers = covering.getSymmetryOrder();
        int i = 0;
        while (i < 3) {
            PnFrameFieldHodgeEnergy.m_tmp.m_data[0] = coord.m_data[2 * edgeIndices.m_data[i]];
            PnFrameFieldHodgeEnergy.m_tmp.m_data[1] = coord.m_data[2 * edgeIndices.m_data[i] + 1];
            int r = PnStiffMatrixOnCovering.getRotation((PgCovering)covering, (int)elementIdx, (int)neighbour.m_data[i], (int)i);
            PnFrameField.rot((PdVector)m_tmp, (int)r, (int)numLayers);
            PnFrameFieldHodgeEnergy.m_values.m_data[i] = PnFrameFieldHodgeEnergy.m_tmp.m_data[1];
            ++i;
        }
        vector = PgUtil.calcLinearGradientNonConforming((PgElementSet)geom, (int)elementIdx, (PdVector)m_values, (PdVector)vector);
        if (rotateGradient) {
            vector.cross(geom.getElementNormal(elementIdx), vector);
        }
        return vector;
    }

    public static PdVector calcGradX(PgElementSet geom, PiVector[] vertexRotation, int numLayers, int elementIdx, PdVector coord, PdVector vector, PdVector[][] potentialSummand, boolean rotateGradient) {
        PiVector element = geom.getElement(elementIdx);
        int i = 0;
        while (i < 3) {
            double summandX;
            double d = summandX = potentialSummand != null ? potentialSummand[elementIdx][i].m_data[0] : 0.0;
            if (coord == null || vertexRotation[elementIdx].m_data[i] == Integer.MAX_VALUE) {
                PnFrameFieldHodgeEnergy.m_values.m_data[i] = summandX;
            } else {
                PnFrameFieldHodgeEnergy.m_tmp.m_data[0] = coord.m_data[2 * element.m_data[i]];
                PnFrameFieldHodgeEnergy.m_tmp.m_data[1] = coord.m_data[2 * element.m_data[i] + 1];
                PnFrameField.rot((PdVector)m_tmp, (int)vertexRotation[elementIdx].m_data[i], (int)numLayers);
                PnFrameFieldHodgeEnergy.m_values.m_data[i] = summandX + PnFrameFieldHodgeEnergy.m_tmp.m_data[0];
            }
            ++i;
        }
        vector = PgUtil.calcLinearGradient((PgElementSet)geom, (int)elementIdx, (PdVector)m_values, (PdVector)vector);
        if (rotateGradient) {
            vector.cross(geom.getElementNormal(elementIdx), vector);
        }
        return vector;
    }

    public static PdVector calcGradY(PgElementSet geom, PiVector[] vertexRotation, int numLayers, int elementIdx, PdVector coord, PdVector vector, PdVector[][] potentialSummand, boolean rotateGradient) {
        PiVector element = geom.getElement(elementIdx);
        int i = 0;
        while (i < 3) {
            double summandY;
            double d = summandY = potentialSummand != null ? potentialSummand[elementIdx][i].m_data[1] : 0.0;
            if (coord == null || vertexRotation[elementIdx].m_data[i] == Integer.MAX_VALUE) {
                PnFrameFieldHodgeEnergy.m_values.m_data[i] = summandY;
            } else {
                PnFrameFieldHodgeEnergy.m_tmp.m_data[0] = coord.m_data[2 * element.m_data[i]];
                PnFrameFieldHodgeEnergy.m_tmp.m_data[1] = coord.m_data[2 * element.m_data[i] + 1];
                PnFrameField.rot((PdVector)m_tmp, (int)vertexRotation[elementIdx].m_data[i], (int)numLayers);
                PnFrameFieldHodgeEnergy.m_values.m_data[i] = summandY + PnFrameFieldHodgeEnergy.m_tmp.m_data[1];
            }
            ++i;
        }
        vector = PgUtil.calcLinearGradient((PgElementSet)geom, (int)elementIdx, (PdVector)m_values, (PdVector)vector);
        if (rotateGradient) {
            vector.cross(geom.getElementNormal(elementIdx), vector);
        }
        return vector;
    }

    public static int getRotation(PgCovering covering, int e, int ne, int locNeighbInd) {
        return PnStiffMatrixOnCovering.getRotation((PgCovering)covering, (int)e, (int)ne, (int)locNeighbInd);
    }
}

