/*
 * Decompiled with CFR 0.152.
 */
package devParameterize.covering;

import dev.numeric.PnTaucsSolver;
import dev6.numeric.PnCSparseCholesky;
import dev6.numeric.PnConjugateGradientMatrixMT;
import devCovering.PgCovering;
import devCovering.PgFrameField;
import devCovering.PnCovering;
import devCovering.PnFrameField;
import devCovering.PnStiffMatrixOnCovering;
import devParameterize.covering.PgTextureMapOnCovering;
import devParameterize.covering.PnFrameFieldHodgeEnergy;
import jv.geom.PgElementSet;
import jv.object.PsDebug;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.numeric.PnConjugateGradient;
import jvx.numeric.PnFunction;
import jvx.numeric.PnSparseMatrix;

public class PnFrameFieldHodge {
    public static final int MAX_ITERATIONS = Integer.MAX_VALUE;
    public static final int SOLVER_CG = 0;
    public static final int SOLVER_TAUCS = 1;
    public static final int SOLVER_CSPARSEJ = 2;
    private int m_solver = 0;
    protected PgElementSet m_geom;
    protected PgFrameField m_field;
    protected double m_eps = 1.0E-12;
    protected PiVector[] m_vertexRotation;
    protected PnConjugateGradient m_cgMethod;
    protected PnSparseMatrix m_constraint;
    private PdVector m_constraintRv;
    private PnSparseMatrix m_matrix;
    private boolean m_conforming;
    private PdVector m_weights;

    public void setGeometry(PgElementSet geom) {
        this.m_geom = geom;
    }

    public void setField(PgFrameField field) {
        this.m_field = field;
        this.m_matrix = null;
    }

    public void setEps(double eps) {
        this.m_eps = eps;
    }

    public void setStopped(boolean bStopped) {
        if (this.m_cgMethod != null) {
            this.m_cgMethod.setStopped(bStopped);
        }
    }

    public void setConstraint(PnSparseMatrix constraint, PdVector constraintRv) {
        this.m_constraint = constraint;
        this.m_constraintRv = constraintRv;
    }

    private PdVector solve(PdVector[][] summand, boolean conforming, boolean rotateGradient) {
        PdVector coord;
        this.m_conforming = conforming;
        if (this.m_solver == 0 || this.m_solver == 1 || this.m_solver == 2) {
            if (this.m_matrix == null || this.m_conforming != conforming) {
                this.computeMatrix();
            }
            PdVector rv = PnStiffMatrixOnCovering.computeRightVector((PgElementSet)this.m_geom, (PgFrameField)this.m_field, (PiVector[])this.m_vertexRotation, (PdVector[][])summand, (boolean)conforming, (boolean)rotateGradient, (PdVector)this.m_weights);
            if (this.m_constraint != null && this.m_constraint.getNumRows() > 0) {
                int numConstraints = this.m_constraint.getNumRows();
                rv.setSize(rv.getSize() + numConstraints);
                System.arraycopy(this.m_constraintRv.m_data, 0, rv.m_data, rv.getSize() - numConstraints, numConstraints);
            }
            coord = new PdVector(this.m_matrix.getNumCols());
            if (this.m_solver == 1 || this.m_solver == 2) {
                this.m_matrix.addDiagonal(1.0E-19);
            }
            boolean ok = false;
            if (this.m_solver == 1) {
                ok = PnTaucsSolver.solve(null, (PnSparseMatrix)this.m_matrix, (PdVector)coord, (PdVector)rv);
            }
            if (this.m_solver == 2) {
                boolean bl = ok = PnCSparseCholesky.solve(this.m_matrix, coord, rv) != null;
            }
            if (this.m_solver == 0 || !ok) {
                PnConjugateGradientMatrixMT solver = new PnConjugateGradientMatrixMT();
                solver.solve(this.m_matrix, coord, rv);
            }
        } else {
            PnFrameFieldHodgeEnergy energy = new PnFrameFieldHodgeEnergy(this.m_geom, this.m_field, this.m_vertexRotation, conforming, !conforming);
            energy.setPotentialSummand(summand);
            energy.setLagrangeMultiplier(this.m_constraint);
            coord = new PdVector(energy.getNumOfVariables());
            this.m_cgMethod = new PnConjugateGradient();
            this.m_cgMethod.setStopped(false);
            this.m_cgMethod.setMaxNumIterations(Integer.MAX_VALUE);
            this.m_cgMethod.dfrprmn(coord, this.m_eps, (PnFunction)energy);
        }
        return coord;
    }

    private void computeMatrix() {
        this.m_matrix = PnStiffMatrixOnCovering.computeStiffnessMatrix((PgElementSet)this.m_geom, (PgCovering)this.m_field.getCovering(), (PiVector[])this.m_vertexRotation, (boolean)this.m_conforming, (PdVector)this.m_weights);
        this.m_matrix.compress();
        if (this.m_constraint != null && this.m_constraint.getNumRows() > 0) {
            int numConstraints = this.m_constraint.getNumRows();
            PnSparseMatrix newSm = new PnSparseMatrix();
            PnSparseMatrix topLeft = this.m_matrix;
            PnSparseMatrix bottomLeft = this.m_constraint;
            PnSparseMatrix topRight = PnSparseMatrix.transposeNew((PnSparseMatrix)this.m_constraint);
            PnSparseMatrix bottomRight = new PnSparseMatrix(numConstraints, numConstraints);
            newSm.concatMatrices(topLeft, topRight, bottomLeft, bottomRight);
            this.m_matrix = newSm;
        }
    }

    public PgFrameField calcDivField() {
        if (this.m_geom.getDimOfElements() != 3) {
            PsDebug.warning((String)"Elements must be triangles.");
            return null;
        }
        if (this.m_vertexRotation == null) {
            this.m_vertexRotation = PnCovering.makeVertexRotation((PgCovering)this.m_field.getCovering());
        }
        PdVector coord = this.solve(null, true, false);
        PgFrameField gradField = this.derivePotential(coord, null);
        gradField.setName("Div field");
        return gradField;
    }

    public PgFrameField calcDivFreeField() {
        PgFrameField field = this.calcDivField();
        field.multScalar(-1.0);
        field.add(this.m_field);
        field.setName("Div free field");
        return field;
    }

    public PgFrameField calcHarmonicField() {
        PgFrameField field = this.calcDivField();
        field.add(this.calcRotFieldNonConforming());
        field.multScalar(-1.0);
        field.add(this.m_field);
        field.setName("Harmonic field");
        return field;
    }

    public PgFrameField calcRotFieldNonConforming() {
        if (this.m_geom.getDimOfElements() != 3) {
            PsDebug.warning((String)"Elements must be triangles.");
            return null;
        }
        PdVector coord = this.solve(null, false, true);
        PgFrameField gradField = new PgFrameField(this.m_field.getCovering());
        gradField.assureFields();
        gradField.setName("Rot* field");
        PdVector gradX = new PdVector(3);
        PdVector gradY = new PdVector(3);
        int e = 0;
        while (e < this.m_geom.getNumElements()) {
            gradX = gradField.getField(0).getVector(e);
            gradY = gradField.getField(1).getVector(e);
            PnStiffMatrixOnCovering.calcGradNonConf((PgElementSet)this.m_geom, (PgCovering)this.m_field.getCovering(), (int)e, (PdVector)coord, (PdVector)gradX, (PdVector)gradY, (boolean)true);
            ++e;
        }
        return gradField;
    }

    public PgFrameField projectToRotStarFree() {
        PgFrameField field = this.calcRotFieldNonConforming();
        field.multScalar(-1.0);
        field.add(this.m_field);
        field.setName("Curl* free field");
        return field;
    }

    public PdVector[][] calcDivAndHarmonicPotential(PdVector[][] summand) {
        if (this.m_geom.getDimOfElements() != 3) {
            PsDebug.warning((String)"Elements must be triangles.");
            return null;
        }
        if (this.m_vertexRotation == null) {
            this.m_vertexRotation = PnCovering.makeVertexRotation((PgCovering)this.m_field.getCovering());
        }
        PdVector coord = this.solve(summand, true, false);
        int numElements = this.m_geom.getNumElements();
        PdVector[][] tex = PdVector.alloc((int)numElements, (int)3, (int)2);
        int numLayers = this.m_field.getCovering().getSymmetryOrder();
        int e = 0;
        while (e < numElements) {
            int i = 0;
            while (i < 3) {
                if (this.m_vertexRotation[e].m_data[i] != Integer.MAX_VALUE) {
                    int vertex = this.m_geom.getElement((int)e).m_data[i];
                    tex[e][i].m_data[0] = coord.m_data[2 * vertex];
                    tex[e][i].m_data[1] = coord.m_data[2 * vertex + 1];
                    PnFrameField.rot((PdVector)tex[e][i], (int)this.m_vertexRotation[e].m_data[i], (int)numLayers);
                }
                if (summand != null) {
                    tex[e][i].add(summand[e][i]);
                }
                ++i;
            }
            ++e;
        }
        return tex;
    }

    public void calcDivAndHarmonicPotential(PgTextureMapOnCovering tex) {
        if (this.m_geom.getDimOfElements() != 3) {
            PsDebug.warning((String)"Elements must be triangles.");
            return;
        }
        if (this.m_vertexRotation == null) {
            this.m_vertexRotation = PnCovering.makeVertexRotation((PgCovering)this.m_field.getCovering());
        }
        PdVector[] uSummand = tex.getUSummand();
        PdVector[] vSummand = tex.getVSummand();
        int numE = this.m_geom.getNumElements();
        PdVector[][] summand = new PdVector[numE][3];
        int e = 0;
        while (e < numE) {
            int i = 0;
            while (i < 3) {
                summand[e][i] = new PdVector(uSummand[e].m_data[i], vSummand[e].m_data[i]);
                ++i;
            }
            ++e;
        }
        PdVector coord = this.solve(summand, true, false);
        int numV = this.m_geom.getNumVertices();
        int v = 0;
        while (v < numV) {
            tex.getUValues().m_data[v] = coord.m_data[2 * v];
            tex.getVValues().m_data[v] = coord.m_data[2 * v + 1];
            ++v;
        }
    }

    public static void harmonify(PgTextureMapOnCovering tex, PnFrameFieldHodge hodge) {
        PgFrameField nullField = new PgFrameField(tex.getGeometry().getCovering());
        nullField.assureFields();
        if (hodge == null) {
            hodge = new PnFrameFieldHodge();
            hodge.setGeometry((PgElementSet)tex.getGeometry());
            hodge.setVertexRotation(tex.getVertexRotation());
        }
        hodge.setField(nullField);
        PdVector[][] summand = tex.flattenSummand(null);
        PdVector coord = hodge.solve(summand, true, false);
        PgTextureMapOnCovering.splitValues(coord, tex.getUValues(), tex.getVValues());
    }

    public PgFrameField derivePotential(PdVector coord, PdVector[][] summand) {
        return PnFrameFieldHodge.derivePotential(this.m_geom, this.m_field.getCovering(), coord, summand, this.m_vertexRotation);
    }

    public static PgFrameField derivePotential(PgElementSet geom, PgCovering cov, PdVector coord, PdVector[][] summand, PiVector[] vertexRotation) {
        int numLayers = 4;
        if (vertexRotation == null) {
            vertexRotation = PnCovering.makeVertexRotation((PgCovering)cov);
        }
        PgFrameField gradField = new PgFrameField(cov);
        gradField.assureFields();
        gradField.setName("Derivative");
        int numElements = geom.getNumElements();
        int e = 0;
        while (e < numElements) {
            PdVector gradX = gradField.getField(0).getVector(e);
            PdVector gradY = gradField.getField(1).getVector(e);
            PnStiffMatrixOnCovering.calcGrad((PgElementSet)geom, (PiVector[])vertexRotation, (int)4, (int)e, (PdVector)coord, (PdVector)gradX, (PdVector)gradY, (PdVector[][])summand, (boolean)false);
            ++e;
        }
        return gradField;
    }

    public void setSolver(int solver) {
        this.m_solver = solver;
    }

    public static PdVector[][] harmonify(PgElementSet geom, PgCovering covering, PdVector[][] tex, int solver, PnSparseMatrix constraint, PdVector constraintRv) {
        PgFrameField nullField = new PgFrameField(covering);
        nullField.assureFields();
        PnFrameFieldHodge hodge = new PnFrameFieldHodge();
        hodge.setGeometry(geom);
        hodge.setField(nullField);
        hodge.setConstraint(constraint, constraintRv);
        hodge.setSolver(solver);
        return hodge.calcDivAndHarmonicPotential(tex);
    }

    public void setVertexRotation(PiVector[] vr) {
        this.m_vertexRotation = vr;
    }

    public void setWeights(PdVector weights) {
        this.m_weights = weights;
    }
}

