/*
 * Decompiled with CFR 0.152.
 */
package devParameterize.covering;

import dev.numeric.PnGaussMethod;
import devCovering.PgCovering;
import devCovering.PgCoveringSurface;
import devCovering.PgFrameField;
import devCovering.PgPathOnCovering;
import devCovering.PnCovering;
import devCovering.PnFrameField;
import devCovering.PnStiffMatrixOnCovering;
import devParameterize.covering.PnFrameFieldHodge;
import devParameterize.geom.PgSharpConstraints;
import java.util.Vector;
import jv.geom.PgElementSet;
import jv.geom.PgVectorField;
import jv.object.PsDebug;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuMath;
import jvx.geom.PgUtil;
import jvx.geom.PgVertexStar;
import jvx.numeric.PnSparseMatrix;

public class PgTextureMapOnCovering {
    protected PgCoveringSurface m_geom;
    private PgPathOnCovering[] m_paths;
    private PiVector m_bridges;
    private PiVector[] m_vertexRotation;
    protected PdVector m_uValues = new PdVector();
    protected PdVector m_vValues = new PdVector();
    protected PdVector[] m_uSummand;
    protected PdVector[] m_vSummand;
    private PgSharpConstraints m_sharpConstraints;
    private PiVector[][] m_symbolicSummandInds;
    private PdVector[][][] m_symbolicSummandVals;
    private PiVector m_constrainedVertices;
    private PdMatrix m_softConstraints;
    private PnGaussMethod m_gauss;

    public PgTextureMapOnCovering() {
        if (this.getClass() == PgTextureMapOnCovering.class) {
            this.init();
        }
    }

    public void init() {
    }

    public PgCoveringSurface getGeometry() {
        return this.m_geom;
    }

    public void setGeometry(PgCoveringSurface geom) {
        if (geom == null) {
            this.m_geom = null;
            return;
        }
        if (this.m_geom == geom) {
            return;
        }
        this.m_geom = geom;
        this.m_vertexRotation = PnCovering.makeVertexRotation((PgCovering)this.m_geom.getCovering());
        this.m_uValues.setSize(this.m_geom.getNumVertices());
        this.m_vValues.setSize(this.m_geom.getNumVertices());
        this.m_uSummand = PdVector.realloc((PdVector[])this.m_uSummand, (int)this.m_geom.getNumElements(), (int)3);
        this.m_vSummand = PdVector.realloc((PdVector[])this.m_vSummand, (int)this.m_geom.getNumElements(), (int)3);
    }

    public void setCutPaths(PgPathOnCovering[] paths, PiVector bridges, PgSharpConstraints sharpConstraints) {
        this.m_paths = paths;
        this.m_bridges = bridges;
        this.m_sharpConstraints = sharpConstraints;
        this.makeSymbolicSummand();
    }

    public PiVector[][] getSymbolicSummandInds() {
        return this.m_symbolicSummandInds;
    }

    public PdVector[][][] getSymbolicSummandVals() {
        return this.m_symbolicSummandVals;
    }

    public PdVector getUValues() {
        return this.m_uValues;
    }

    public PdVector getVValues() {
        return this.m_vValues;
    }

    public void setSummand(PdVector[][] tex) {
        int numE = this.m_geom.getNumElements();
        int e = 0;
        while (e < numE) {
            int i = 0;
            while (i < 3) {
                this.m_uSummand[e].m_data[i] = tex[e][i].m_data[0];
                this.m_vSummand[e].m_data[i] = tex[e][i].m_data[1];
                ++i;
            }
            ++e;
        }
    }

    public PdVector[] getUSummand() {
        return this.m_uSummand;
    }

    public PdVector[] getVSummand() {
        return this.m_vSummand;
    }

    public PiVector[] getVertexRotation() {
        return this.m_vertexRotation;
    }

    public void add(PgTextureMapOnCovering texMap) {
        if (texMap.m_geom != this.m_geom) {
            PsDebug.warning((String)"Texture map has wrong geometry.");
            return;
        }
        int numE = this.m_geom.getNumElements();
        if (texMap.m_geom.getNumElements() != numE) {
            PsDebug.warning((String)"Scalar fields are not compatible.");
            return;
        }
        this.m_uValues.add(texMap.m_uValues);
        this.m_vValues.add(texMap.m_vValues);
        int e = 0;
        while (e < numE) {
            this.m_uSummand[e].add(texMap.m_uSummand[e]);
            this.m_vSummand[e].add(texMap.m_vSummand[e]);
            ++e;
        }
    }

    public void sub(PgTextureMapOnCovering texMap) {
        if (texMap.m_geom != this.m_geom) {
            PsDebug.warning((String)"Texture map has wrong geometry.");
            return;
        }
        int numE = this.m_geom.getNumElements();
        if (texMap.m_geom.getNumElements() != numE) {
            PsDebug.warning((String)"Scalar fields are not compatible.");
            return;
        }
        this.m_uValues.sub(texMap.m_uValues);
        this.m_vValues.sub(texMap.m_vValues);
        int e = 0;
        while (e < numE) {
            this.m_uSummand[e].sub(texMap.m_uSummand[e]);
            this.m_vSummand[e].sub(texMap.m_vSummand[e]);
            ++e;
        }
    }

    public void multScalar(double scalar) {
        this.m_uValues.multScalar(scalar);
        this.m_vValues.multScalar(scalar);
        int numE = this.m_geom.getNumElements();
        int e = 0;
        while (e < numE) {
            this.m_uSummand[e].multScalar(scalar);
            this.m_vSummand[e].multScalar(scalar);
            ++e;
        }
    }

    public void setName(String name) {
        this.m_uValues.setName(String.valueOf(name) + "(u)");
        this.m_vValues.setName(String.valueOf(name) + "(v)");
    }

    public void clearVectors() {
        this.m_uValues.setConstant(0.0);
        this.m_vValues.setConstant(0.0);
        int numE = this.m_geom.getNumElements();
        int e = 0;
        while (e < numE) {
            this.m_uSummand[e].setConstant(0.0);
            this.m_vSummand[e].setConstant(0.0);
            ++e;
        }
    }

    public PdVector[][] getTextureValues(PdVector[][] tex) {
        int numElements = this.m_geom.getNumElements();
        if (tex == null || tex.length != numElements) {
            tex = new PdVector[numElements][3];
        }
        int e = 0;
        while (e < numElements) {
            tex[e] = PdVector.realloc((PdVector[])tex[e], (int)3, (int)2);
            ++e;
        }
        e = 0;
        while (e < numElements) {
            int i = 0;
            while (i < 3) {
                this.getTextureValue(e, i, tex[e][i]);
                ++i;
            }
            ++e;
        }
        return tex;
    }

    public PdVector getTextureValue(int element, int locVertInd, PdVector tex) {
        if (this.m_vertexRotation[element].m_data[locVertInd] != Integer.MAX_VALUE) {
            int vertex = this.m_geom.getElement((int)element).m_data[locVertInd];
            tex.m_data[0] = this.m_uValues.m_data[vertex];
            tex.m_data[1] = this.m_vValues.m_data[vertex];
            PnFrameField.rot((PdVector)tex, (int)this.m_vertexRotation[element].m_data[locVertInd], (int)this.m_geom.getCovering().getSymmetryOrder());
        } else {
            tex.setConstant(0.0);
        }
        tex.m_data[0] = tex.m_data[0] + this.m_uSummand[element].m_data[locVertInd];
        tex.m_data[1] = tex.m_data[1] + this.m_vSummand[element].m_data[locVertInd];
        return tex;
    }

    public void makeSummandFromGaps(PdVector gaps) {
        if (this.m_symbolicSummandInds == null) {
            PsDebug.warning((String)"Cut paths not set");
            return;
        }
        int i = 0;
        while (i < this.m_uSummand.length) {
            this.m_uSummand[i].setConstant(0.0);
            this.m_vSummand[i].setConstant(0.0);
            ++i;
        }
        int numE = this.m_geom.getNumElements();
        PdVector tex = new PdVector(2);
        int e = 0;
        while (e < numE) {
            int i2 = 0;
            while (i2 < 3) {
                if (this.m_symbolicSummandInds[e][i2] != null) {
                    int num = this.m_symbolicSummandInds[e][i2].getSize();
                    tex.setConstant(0.0);
                    int j = 0;
                    while (j < num) {
                        double gap = gaps.m_data[this.m_symbolicSummandInds[e][i2].m_data[j]];
                        tex.add(gap, this.m_symbolicSummandVals[e][i2][j]);
                        ++j;
                    }
                    int n = i2;
                    this.m_uSummand[e].m_data[n] = this.m_uSummand[e].m_data[n] + tex.m_data[0];
                    int n2 = i2;
                    this.m_vSummand[e].m_data[n2] = this.m_vSummand[e].m_data[n2] + tex.m_data[1];
                }
                ++i2;
            }
            ++e;
        }
    }

    private void makeSymbolicSummand() {
        PiVector bp;
        int numConstraints;
        if (this.m_paths == null || this.m_bridges == null) {
            this.m_symbolicSummandInds = null;
            return;
        }
        int numE = this.m_geom.getNumElements();
        int numV = this.m_geom.getNumVertices();
        this.m_symbolicSummandInds = new PiVector[numE][3];
        this.m_symbolicSummandVals = new PdVector[numE][3][];
        this.m_constrainedVertices = new PiVector(numV);
        this.m_constrainedVertices.setConstant(-2);
        int numPaths = this.m_paths.length;
        int n = numConstraints = this.m_sharpConstraints == null ? 0 : this.m_sharpConstraints.getNumConstraintsCut();
        if (numPaths >= 1) {
            int i = 0;
            while (i < numPaths) {
                if (this.m_paths[i] != null) {
                    PiVector summandInds = new PiVector();
                    PdVector[] summandVals = PgTextureMapOnCovering.symbGapToSummand(i, this.m_paths[i], this.m_bridges.m_data[i], summandInds);
                    if (summandInds.getSize() > 0) {
                        this.addGapAlongPathSymb(i, summandInds, summandVals);
                    }
                }
                ++i;
            }
        }
        int numBp = (bp = this.m_geom.getCovering().getBranchPoints()) == null ? 0 : bp.getSize();
        int i = 0;
        while (i < numBp) {
            this.m_constrainedVertices.m_data[bp.m_data[i]] = -1;
            ++i;
        }
        if (numConstraints >= 1) {
            this.constrainSymbolicSummand();
        }
    }

    private void constrainSymbolicSummand() {
        PiVector[] elementsRight = this.m_sharpConstraints.getElementsRight();
        PiVector[] locVertIndsRight = this.m_sharpConstraints.getLocVertexIndRight();
        PiVector[] layersRight = this.m_sharpConstraints.getLayerRight();
        int numSc = this.m_sharpConstraints.getNumConstraintsCut();
        int numP = this.m_paths == null ? 0 : this.m_paths.length;
        Vector softConstraintsInds = new Vector();
        Vector softConstraintsVals = new Vector();
        PiVector constrainedVerticesSoft = PiVector.copyNew((PiVector)this.m_constrainedVertices);
        int symmOrder = this.m_geom.getCovering().getSymmetryOrder();
        PdVector softConstraintRHS = new PdVector(0);
        int i = 0;
        while (i < numSc) {
            if (this.m_sharpConstraints.isEnabled(i)) {
                boolean isHard = this.m_sharpConstraints.isHardCut(i);
                PiVector constrInd = new PiVector(2);
                constrInd.m_data[0] = 2 * (numP + i);
                constrInd.m_data[1] = 2 * (numP + i) + 1;
                PdVector[] constrVal = new PdVector[]{new PdVector(1.0, 0.0), new PdVector(0.0, 1.0)};
                int len = elementsRight[i].getSize();
                int prevV = -1;
                constrainedVerticesSoft.copy(this.m_constrainedVertices);
                int j = 0;
                while (j < len) {
                    int element = elementsRight[i].m_data[j];
                    int layer = layersRight[i].m_data[j];
                    int locVertInd = locVertIndsRight[i].m_data[j];
                    int v = this.m_geom.getElement((int)element).m_data[locVertInd];
                    if (v != prevV) {
                        PiVector actSummandInds = this.m_symbolicSummandInds[element][locVertInd];
                        PdVector[] actSummandVals = this.m_symbolicSummandVals[element][locVertInd];
                        int vertRot = this.m_vertexRotation[element].m_data[locVertInd];
                        int vertexLayer = PuMath.modulo((int)(layer - vertRot), (int)symmOrder);
                        if (constrainedVerticesSoft.m_data[v] == -2) {
                            constrainedVerticesSoft.m_data[v] = vertexLayer;
                            if (isHard) {
                                this.m_constrainedVertices.m_data[v] = vertexLayer;
                            }
                            this.constrainSymbolicSummand_(element, locVertInd, layer, constrInd, constrVal, -1);
                        } else if (constrainedVerticesSoft.m_data[v] == -1) {
                            this.addSoftConstraint(softConstraintsInds, softConstraintsVals, constrInd, constrVal, actSummandInds, actSummandVals, PuMath.modulo((int)layer, (int)(symmOrder / 2)));
                            softConstraintRHS.addEntry(0.0);
                        } else if (PuMath.modulo((int)(constrainedVerticesSoft.m_data[v] - vertexLayer), (int)(symmOrder / 2)) != 0) {
                            this.constrainSymbolicSummand_(element, locVertInd, layer, constrInd, constrVal, PuMath.modulo((int)(constrainedVerticesSoft.m_data[v] + vertRot), (int)symmOrder));
                            constrainedVerticesSoft.m_data[v] = -1;
                            if (isHard) {
                                this.m_constrainedVertices.m_data[v] = -1;
                            }
                        } else if (isHard) {
                            this.addSoftConstraint(softConstraintsInds, softConstraintsVals, constrInd, constrVal, actSummandInds, actSummandVals, PuMath.modulo((int)layer, (int)(symmOrder / 2)));
                            softConstraintRHS.addEntry(0.0);
                        }
                        prevV = v;
                    } else {
                        constrInd = this.m_symbolicSummandInds[element][locVertInd];
                        constrVal = this.m_symbolicSummandVals[element][locVertInd];
                    }
                    ++j;
                }
                if (!isHard) {
                    softConstraintRHS.m_data[softConstraintRHS.getSize() - 1] = this.m_sharpConstraints.getConstraintValue(i);
                }
            }
            ++i;
        }
        int numC = softConstraintsInds.size();
        if (numC == 0) {
            this.m_softConstraints = null;
        } else {
            this.m_softConstraints = new PdMatrix(numC, 2 * (numP + numSc));
            int c = 0;
            while (c < numC) {
                PiVector inds = (PiVector)softConstraintsInds.elementAt(c);
                PdVector vals = (PdVector)softConstraintsVals.elementAt(c);
                int num = inds.getSize();
                int i2 = 0;
                while (i2 < num) {
                    double[] dArray = this.m_softConstraints.m_data[c];
                    int n = inds.m_data[i2];
                    dArray[n] = dArray[n] + vals.m_data[i2];
                    ++i2;
                }
                ++c;
            }
            this.m_gauss = new PnGaussMethod();
            this.m_gauss.makeTriangular(this.m_softConstraints, softConstraintRHS);
        }
    }

    private void addSoftConstraint(Vector softConstraintsInds, Vector softConstraintsVals, PiVector constr1Ind, PdVector[] constr1Val, PiVector constr2Ind, PdVector[] constr2Val, int layer) {
        int k;
        int dim1 = constr1Ind == null ? 0 : constr1Ind.getSize();
        int dim2 = constr2Ind == null ? 0 : constr2Ind.getSize();
        PiVector inds = new PiVector(dim1 + dim2);
        PdVector[] vals = new PdVector[dim1 + dim2];
        int k2 = 0;
        while (k2 < dim1) {
            inds.m_data[k2] = constr1Ind.m_data[k2];
            vals[k2] = PdVector.copyNew((PdVector)constr1Val[k2]);
            ++k2;
        }
        k2 = 0;
        while (k2 < dim2) {
            inds.m_data[dim1 + k2] = constr2Ind.m_data[k2];
            vals[dim1 + k2] = PdVector.copyNew((PdVector)constr2Val[k2]);
            vals[dim1 + k2].multScalar(-1.0);
            ++k2;
        }
        if (layer > 0) {
            int symmOrder = this.m_geom.getCovering().getSymmetryOrder();
            k = 0;
            while (k < dim1 + dim2) {
                PnFrameField.rot((PdVector)vals[k], (int)layer, (int)symmOrder);
                ++k;
            }
        }
        PdVector scVals = new PdVector(dim1 + dim2);
        k = 0;
        while (k < dim1 + dim2) {
            scVals.m_data[k] = vals[k].m_data[0];
            ++k;
        }
        softConstraintsInds.addElement(PiVector.copyNew((PiVector)inds));
        softConstraintsVals.addElement(scVals);
        if (layer < 0) {
            scVals = new PdVector(dim1 + dim2);
            k = 0;
            while (k < dim1 + dim2) {
                scVals.m_data[k] = vals[k].m_data[1];
                ++k;
            }
            softConstraintsInds.addElement(PiVector.copyNew((PiVector)inds));
            softConstraintsVals.addElement(scVals);
        }
    }

    private void constrainSymbolicSummand_(int element, int locVertInd, int constrLayer, PiVector constrInd, PdVector[] constrVal, int prevConstrLayer) {
        PdVector trace = null;
        if (prevConstrLayer >= 0) {
            trace = PgTextureMapOnCovering.getConstrainedDir(prevConstrLayer, this.m_geom.getCovering().getSymmetryOrder());
            PnFrameField.rot((PdVector)trace, (int)1, (int)4);
        }
        PiVector actSummandInds = this.m_symbolicSummandInds[element][locVertInd];
        PdVector[] actSummandVals = this.m_symbolicSummandVals[element][locVertInd];
        int asLen = actSummandInds == null ? 0 : actSummandInds.getSize();
        int cLen = constrInd == null ? 0 : constrInd.getSize();
        PiVector diffInds = new PiVector(asLen + cLen);
        PdVector[] diffVals = new PdVector[asLen + cLen];
        int i = 0;
        while (i < asLen) {
            diffInds.m_data[i] = actSummandInds.m_data[i];
            diffVals[i] = PdVector.copyNew((PdVector)actSummandVals[i]);
            diffVals[i].multScalar(-1.0);
            ++i;
        }
        i = 0;
        while (i < cLen) {
            diffInds.m_data[asLen + i] = constrInd.m_data[i];
            diffVals[asLen + i] = PdVector.copyNew((PdVector)constrVal[i]);
            ++i;
        }
        if (trace == null) {
            this.addHatFunctionSymb(element, locVertInd, diffInds, diffVals);
        } else {
            PdVector constrDir = PgTextureMapOnCovering.getConstrainedDir(constrLayer, this.m_geom.getCovering().getSymmetryOrder());
            int len = diffInds.getSize();
            int i2 = 0;
            while (i2 < len) {
                double lambda = constrDir.dot(diffVals[i2]) / constrDir.dot(trace);
                diffVals[i2] = PdVector.copyNew((PdVector)trace);
                diffVals[i2].multScalar(lambda);
                ++i2;
            }
            this.addHatFunctionSymb(element, locVertInd, diffInds, diffVals);
        }
    }

    private void addHatFunctionSymb(int e, int locVertInd, PiVector inds, PdVector[] vals) {
        PgVertexStar star = new PgVertexStar();
        int v = this.m_geom.getElement((int)e).m_data[locVertInd];
        star.makeVertexStar((PgElementSet)this.m_geom, v, e);
        PiVector elements = star.getElement();
        int vrot = this.m_vertexRotation[e].m_data[locVertInd];
        int dim = inds == null ? 0 : inds.getSize();
        int size = star.getSize();
        int symmOrder = this.m_geom.getCovering().getSymmetryOrder();
        int i = 0;
        while (i < size) {
            int dimSummand;
            int actE = elements.m_data[i];
            int actLocInd = star.getVertexLocInd().m_data[i];
            int actVr = this.m_vertexRotation[actE].m_data[actLocInd];
            int n = dimSummand = this.m_symbolicSummandInds[actE][actLocInd] == null ? 0 : this.m_symbolicSummandInds[actE][actLocInd].getSize();
            if (this.m_symbolicSummandInds[actE][actLocInd] == null) {
                this.m_symbolicSummandInds[actE][actLocInd] = new PiVector(dim);
            } else {
                this.m_symbolicSummandInds[actE][actLocInd].setSize(dimSummand + dim);
            }
            this.m_symbolicSummandVals[actE][actLocInd] = PdVector.realloc((PdVector[])this.m_symbolicSummandVals[actE][actLocInd], (int)(dim + dimSummand), (int)2);
            int j = 0;
            while (j < dim) {
                this.m_symbolicSummandInds[actE][actLocInd].m_data[dimSummand + j] = inds.m_data[j];
                PnFrameField.rot((PdVector)vals[j], (int)(actVr - vrot), (int)symmOrder, (PdVector)this.m_symbolicSummandVals[actE][actLocInd][dimSummand + j]);
                ++j;
            }
            ++i;
        }
    }

    private static PdVector getConstrainedDir(int layer, int symmOrder) {
        if (symmOrder == 4) {
            if ((layer & 1) > 0) {
                return new PdVector(0.0, 1.0);
            }
            return new PdVector(1.0, 0.0);
        }
        if (symmOrder == 6) {
            int l = PuMath.modulo((int)layer, (int)symmOrder);
            double[] cos = new double[]{1.0, 0.5, -0.5, -1.0, -0.5, 0.5};
            double d = Math.sqrt(3.0) / 2.0;
            double[] sin = new double[]{0.0, d, d, 0.0, -d, -d};
            return new PdVector(cos[l], sin[l]);
        }
        int l = PuMath.modulo((int)layer, (int)symmOrder);
        return new PdVector(Math.cos(Math.PI * 2 * (double)l / (double)symmOrder), Math.sin(Math.PI * 2 * (double)l / (double)symmOrder));
    }

    public PiVector getConstrainedVertices() {
        return this.m_constrainedVertices;
    }

    private static PdVector[] symbGapToSummand(int pathInd, PgPathOnCovering path, int bridge, PiVector summandInds) {
        double sqrt3 = Math.sqrt(3.0);
        double[][][] MATRICES_LAYER_6 = new double[][][]{new double[][]{{0.5, -sqrt3 / 2.0}, {sqrt3 / 2.0, 0.5}}, new double[][]{{0.5, -0.5 / sqrt3}, {0.5 / sqrt3, 0.5}}, new double[][]{{0.5, 0.0}, {0.0, 0.5}}, new double[][]{{0.5, 0.5 / sqrt3}, {-0.5 / sqrt3, 0.5}}, new double[][]{{0.5, sqrt3 / 2.0}, {-sqrt3 / 2.0, 0.5}}};
        double[][][] MATRICES_LAYER_12 = new double[][][]{new double[][]{{0.5, -1.0 - sqrt3 / 2.0}, {1.0 + sqrt3 / 2.0, 0.5}}, new double[][]{{0.5, -sqrt3 / 2.0}, {sqrt3 / 2.0, 0.5}}, new double[][]{{0.5, -0.5}, {0.5, 0.5}}, new double[][]{{0.5, -0.5 / sqrt3}, {0.5 / sqrt3, 0.5}}, new double[][]{{0.5, -1.0 + sqrt3 / 2.0}, {1.0 - sqrt3 / 2.0, 0.5}}, new double[][]{{0.5, 0.0}, {0.0, 0.5}}, new double[][]{{0.5, 1.0 - sqrt3 / 2.0}, {-1.0 + sqrt3 / 2.0, 0.5}}, new double[][]{{0.5, 0.5 / sqrt3}, {-0.5 / sqrt3, 0.5}}, new double[][]{{0.5, 0.5}, {-0.5, 0.5}}, new double[][]{{0.5, sqrt3 / 2.0}, {-sqrt3 / 2.0, 0.5}}, new double[][]{{0.5, 1.0 + sqrt3 / 2.0}, {-1.0 - sqrt3 / 2.0, 0.5}}};
        if (path == null) {
            return null;
        }
        PgCovering covering = path.getCovering();
        PgElementSet geom = covering.getGeometry();
        int numLayers = covering.getSymmetryOrder();
        PdVector tmp = new PdVector(2);
        int bridgeIndex = PgTextureMapOnCovering.calcBridgeIndex(geom, numLayers, path, bridge);
        summandInds.setSize(2);
        summandInds.m_data[0] = 2 * pathInd;
        summandInds.m_data[1] = 2 * pathInd + 1;
        PdVector[] summandVals = new PdVector[2];
        summandVals[0] = new PdVector(2);
        summandVals[0].m_data[0] = 1.0;
        summandVals[1] = new PdVector(2);
        summandVals[1].m_data[1] = 1.0;
        if (bridgeIndex >= 0) {
            int i = 0;
            while (i < 2) {
                int negBi;
                if (numLayers == 4) {
                    if (bridgeIndex > 0 && bridgeIndex != 2) {
                        summandVals[i].sub(PnFrameField.rot((PdVector)summandVals[i], (int)bridgeIndex, (int)4, (PdVector)tmp));
                    }
                    if (bridgeIndex > 0) {
                        summandVals[i].multScalar(0.5);
                    }
                } else if (numLayers == 6) {
                    negBi = PuMath.modulo((int)(-bridgeIndex), (int)6);
                    if (negBi == 0) {
                        PsDebug.warning((String)"Bridge index is 0");
                        return null;
                    }
                    tmp.m_data[0] = summandVals[i].m_data[0] * MATRICES_LAYER_6[negBi - 1][0][0] + summandVals[i].m_data[1] * MATRICES_LAYER_6[negBi - 1][0][1];
                    tmp.m_data[1] = summandVals[i].m_data[0] * MATRICES_LAYER_6[negBi - 1][1][0] + summandVals[i].m_data[1] * MATRICES_LAYER_6[negBi - 1][1][1];
                    summandVals[i].copy(tmp);
                } else if (numLayers == 12) {
                    negBi = PuMath.modulo((int)(-bridgeIndex), (int)12);
                    if (negBi == 0) {
                        PsDebug.warning((String)"Bridge index is 0");
                        return null;
                    }
                    tmp.m_data[0] = summandVals[i].m_data[0] * MATRICES_LAYER_12[negBi - 1][0][0] + summandVals[i].m_data[1] * MATRICES_LAYER_12[negBi - 1][0][1];
                    tmp.m_data[1] = summandVals[i].m_data[0] * MATRICES_LAYER_12[negBi - 1][1][0] + summandVals[i].m_data[1] * MATRICES_LAYER_12[negBi - 1][1][1];
                    summandVals[i].copy(tmp);
                } else {
                    PsDebug.warning((String)"Symmtetry order not supported");
                    return null;
                }
                ++i;
            }
        }
        return summandVals;
    }

    public static int calcBridgeIndex(PgElementSet geom, int symmetryOrder, PgPathOnCovering path, int bridge) {
        if (path.getCovering() == null) {
            PsDebug.warning((String)"path has no covering");
            return -1;
        }
        PiVector[] pathElements = path.getElementNeighbours();
        PiVector[] pathLayers = path.getElementLayers();
        if (bridge + 1 >= pathElements.length) {
            PsDebug.warning((String)"Bridge index out of range.");
            return -1;
        }
        int bridgeEl = pathElements[bridge + 1].m_data[0];
        int bridgeLayer = pathLayers[bridge + 1].m_data[0];
        int edgeLocInd = (path.getVertexLocInd()[bridge + 1].m_data[0] + 2) % 3;
        int neigh = geom.getNeighbour((int)bridgeEl).m_data[edgeLocInd];
        int m = path.getCovering().getMatching(bridgeEl, edgeLocInd);
        int matching = PuMath.modulo((int)m, (int)symmetryOrder);
        int bridgeIndex = -1;
        int neighElemInd = -1;
        int k = 1;
        while (k < pathElements.length) {
            int locInd;
            if (pathElements[k].getEntry(0) == neigh && geom.getNeighbour((int)neigh).m_data[locInd = (path.getVertexLocInd()[k].m_data[0] + 2) % 3] == bridgeEl) {
                neighElemInd = k;
            }
            ++k;
        }
        if (neighElemInd != -1) {
            int neighRot = pathLayers[neighElemInd].m_data[0];
            bridgeIndex = PuMath.modulo((int)(bridgeLayer - neighRot + matching), (int)symmetryOrder);
        }
        return bridgeIndex;
    }

    private void addGapAlongPathSymb(int pathInd, PiVector summandInds, PdVector[] summandVals) {
        PgPathOnCovering path = this.m_paths[pathInd];
        int bridge = this.m_bridges.m_data[pathInd];
        PiVector[] layers = path.getElementLayers();
        int bridgeRotation = layers[bridge + 1].m_data[0];
        int numLayers = this.m_geom.getCovering().getSymmetryOrder();
        PdVector tmp = new PdVector(2);
        PiVector[] pathElements = path.getElementNeighbours();
        PiVector[] elementLayers = path.getElementLayers();
        PiVector[] pathLocInd = path.getVertexLocInd();
        int i = 0;
        while (i < pathElements.length) {
            int size = pathElements[i].getSize();
            int j = 0;
            while (j < size) {
                int summandSize = summandInds.getSize();
                int k = 0;
                while (k < summandSize) {
                    tmp = PnFrameField.rot((PdVector)summandVals[k], (int)(elementLayers[i].m_data[j] - bridgeRotation), (int)numLayers, (PdVector)tmp);
                    int e = pathElements[i].m_data[j];
                    int locInd = pathLocInd[i].m_data[j];
                    this.addSymbolicSummand(e, locInd, summandInds.m_data[k], tmp);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    private void addSymbolicSummand(int e, int locInd, int ind, PdVector val) {
        if (this.m_symbolicSummandInds[e][locInd] == null) {
            this.m_symbolicSummandInds[e][locInd] = new PiVector(1);
            this.m_symbolicSummandInds[e][locInd].m_data[0] = ind;
            this.m_symbolicSummandVals[e][locInd] = new PdVector[1];
            this.m_symbolicSummandVals[e][locInd][0] = new PdVector(2);
            this.m_symbolicSummandVals[e][locInd][0].copy(val);
            return;
        }
        this.m_symbolicSummandInds[e][locInd].addEntry(ind);
        int num = this.m_symbolicSummandVals[e][locInd].length;
        PdVector[] newVals = new PdVector[num + 1];
        int i = 0;
        while (i < num) {
            newVals[i] = this.m_symbolicSummandVals[e][locInd][i];
            ++i;
        }
        newVals[num] = new PdVector(2);
        newVals[num].copy(val);
        this.m_symbolicSummandVals[e][locInd] = newVals;
    }

    public boolean computeGaps(PgPathOnCovering[] paths, PiVector bridges, PdVector uGaps, PdVector vGaps) {
        if (paths == null) {
            return false;
        }
        PdVector gap = new PdVector(2);
        uGaps.setSize(paths.length);
        vGaps.setSize(paths.length);
        int p = 0;
        while (p < paths.length) {
            PgPathOnCovering path = paths[p];
            if (path != null) {
                boolean bOk = this.calcGap(path, bridges.getEntry(p), gap);
                if (!bOk) {
                    return false;
                }
                uGaps.m_data[p] = gap.m_data[0];
                vGaps.m_data[p] = gap.m_data[1];
            }
            ++p;
        }
        return true;
    }

    private boolean calcGap(PgPathOnCovering path, int bridge, PdVector gap) {
        PiVector[] pathElements = path.getElementNeighbours();
        int numLayers = path.getCovering().getSymmetryOrder();
        if (bridge + 1 >= pathElements.length || pathElements[bridge + 1].getSize() == 0) {
            PsDebug.warning((String)"bridge index out of range");
            return false;
        }
        int bridgeEl = pathElements[bridge + 1].m_data[0];
        int edgeLocInd = (path.getVertexLocInd()[bridge + 1].m_data[0] + 2) % 3;
        PiVector[] neighbours = this.m_geom.getNeighbours();
        int neigh = neighbours[bridgeEl].m_data[edgeLocInd];
        int nLocInd = neighbours[neigh].getIndexOf(bridgeEl);
        int matching = PuMath.modulo((int)(-this.m_geom.getCovering().getMatching(bridgeEl, edgeLocInd)), (int)this.m_geom.getCovering().getSymmetryOrder());
        gap.m_data[0] = this.m_uSummand[bridgeEl].m_data[(edgeLocInd + 1) % 3];
        gap.m_data[1] = this.m_vSummand[bridgeEl].m_data[(edgeLocInd + 1) % 3];
        PdVector tmp = new PdVector(2);
        tmp.m_data[0] = this.m_uSummand[neigh].m_data[(nLocInd + 2) % 3];
        tmp.m_data[1] = this.m_vSummand[neigh].m_data[(nLocInd + 2) % 3];
        gap.sub(PnFrameField.rot((PdVector)tmp, (int)matching, (int)numLayers));
        return true;
    }

    public void harmonify(int solver, PnSparseMatrix constraint, PdVector constraintRv) {
        PnFrameFieldHodge hodge = new PnFrameFieldHodge();
        hodge.setGeometry((PgElementSet)this.m_geom);
        hodge.setConstraint(constraint, constraintRv);
        hodge.setSolver(solver);
        hodge.setVertexRotation(this.getVertexRotation());
        PnFrameFieldHodge.harmonify(this, hodge);
    }

    public static PdVector flattenValues(PdVector uValues, PdVector vValues, PdVector coord) {
        int size = uValues.getSize();
        if (coord == null) {
            coord = new PdVector(2 * size);
        } else if (coord.getSize() < 2 * size) {
            coord.setSize(2 * size);
        }
        int e = 0;
        while (e < size) {
            coord.m_data[2 * e] = uValues.m_data[e];
            coord.m_data[2 * e + 1] = vValues.m_data[e];
            ++e;
        }
        return coord;
    }

    public static void splitValues(PdVector coord, PdVector uValues, PdVector vValues) {
        if (coord == null || uValues == null || vValues == null) {
            PsDebug.warning((String)"Argument is null.");
            return;
        }
        int size = coord.getSize() / 2;
        uValues.setSize(size);
        vValues.setSize(size);
        int i = 0;
        while (i < size) {
            uValues.m_data[i] = coord.m_data[2 * i];
            vValues.m_data[i] = coord.m_data[2 * i + 1];
            ++i;
        }
    }

    public PdVector[][] flattenSummand(PdVector[][] summand) {
        return PgTextureMapOnCovering.flattenSummand(this.m_uSummand, this.m_vSummand, summand);
    }

    public static PdVector[][] flattenSummand(PdVector[] uSummand, PdVector[] vSummand, PdVector[][] summand) {
        int numE = uSummand.length;
        if (summand == null) {
            summand = new PdVector[numE][];
        }
        if (summand.length != numE) {
            PsDebug.warning((String)"summand has wrong size");
            return null;
        }
        int e = 0;
        while (e < numE) {
            summand[e] = PdVector.realloc((PdVector[])summand[e], (int)3, (int)2);
            int i = 0;
            while (i < 3) {
                summand[e][i].m_data[0] = uSummand[e].m_data[i];
                summand[e][i].m_data[1] = vSummand[e].m_data[i];
                ++i;
            }
            ++e;
        }
        return summand;
    }

    public double distL2(PgFrameField field) {
        PdVector coord = PgTextureMapOnCovering.flattenValues(this.m_uValues, this.m_vValues, null);
        PdVector[][] summand = PgTextureMapOnCovering.flattenSummand(this.m_uSummand, this.m_vSummand, null);
        int numElements = this.m_geom.getNumElements();
        PdVector gradX = new PdVector(3);
        PdVector gradY = new PdVector(3);
        int numLayers = this.m_geom.getCovering().getSymmetryOrder();
        PgVectorField[] f = field.getFields();
        double value = 0.0;
        int e = 0;
        while (e < numElements) {
            double area = this.m_geom.getAreaOfElement(e);
            PnStiffMatrixOnCovering.calcGrad((PgElementSet)this.m_geom, (PiVector[])this.m_vertexRotation, (int)numLayers, (int)e, (PdVector)coord, (PdVector)gradX, (PdVector)gradY, (PdVector[][])summand, (boolean)false);
            value += (gradX.sqrDist(f[0].getVector(e)) + gradY.sqrDist(f[1].getVector(e))) * area;
            ++e;
        }
        return Math.sqrt(value);
    }

    public PgFrameField derivePotential(PgFrameField gradientField) {
        if (gradientField == null) {
            gradientField = new PgFrameField(this.m_geom.getCovering());
            gradientField.assureFields();
            gradientField.setName("Derivative");
        } else if (gradientField.getCovering() != this.m_geom.getCovering() || gradientField.getGeometry() != this.m_geom) {
            PsDebug.warning((String)"Wrong covering or geometry.");
            return null;
        }
        int numLayers = 4;
        PdVector xValues = new PdVector(3);
        PdVector yValues = new PdVector(3);
        PdVector tmp = new PdVector(2);
        PgVectorField[] field = gradientField.getFields();
        int e = 0;
        while (e < this.m_geom.getNumElements()) {
            PiVector elem = this.m_geom.getElement(e);
            int i = 0;
            while (i < 3) {
                int rot = this.m_vertexRotation[e].m_data[i];
                xValues.m_data[i] = this.m_uSummand[e].m_data[i];
                yValues.m_data[i] = this.m_vSummand[e].m_data[i];
                if (rot != Integer.MAX_VALUE) {
                    tmp.set(this.m_uValues.m_data[elem.m_data[i]], this.m_vValues.m_data[elem.m_data[i]]);
                    PnFrameField.rot((PdVector)tmp, (int)rot, (int)4);
                    int n = i;
                    xValues.m_data[n] = xValues.m_data[n] + tmp.m_data[0];
                    int n2 = i;
                    yValues.m_data[n2] = yValues.m_data[n2] + tmp.m_data[1];
                }
                ++i;
            }
            PgUtil.calcLinearGradient((PgElementSet)this.m_geom, (int)e, (PdVector)xValues, (PdVector)field[0].getVector(e));
            PgUtil.calcLinearGradient((PgElementSet)this.m_geom, (int)e, (PdVector)yValues, (PdVector)field[1].getVector(e));
            ++e;
        }
        return gradientField;
    }

    public void makeValidGapsAndConstraintValues(PdVector gaps) {
        if (this.m_softConstraints == null) {
            return;
        }
        int jSize = gaps.getSize();
        if (jSize != this.m_softConstraints.getNumCols()) {
            PsDebug.warning((String)"Soft constraints invalid");
            return;
        }
        this.m_gauss.solveForVector(gaps);
    }
}

