/*
 * Decompiled with CFR 0.152.
 */
package devParameterize.covering;

import devCovering.PgCovering;
import devCovering.PgCoveringSurface;
import devCovering.PgPathOnCovering;
import devParameterize.covering.PgTextureMapOnCovering;
import jv.geom.PgElementSet;
import jv.object.PsDebug;
import jv.vecmath.PiVector;
import jv.vecmath.PuMath;
import jvx.geom.PgVertexStar;
import jvx.util.PuPriorityQueue;

public class PgIntTextureMapOnCovering {
    protected PgCoveringSurface m_geom;
    protected PiVector[] m_vertexRotation;
    protected PiVector m_uValues = new PiVector();
    protected PiVector m_vValues = new PiVector();
    protected PiVector[] m_uSummand;
    protected PiVector[] m_vSummand;
    private static final double[][][] MATRICES_LAYER_6 = new double[][][]{new double[][]{{0.5, -0.5}, {1.5, 0.5}}, new double[][]{{0.5, -0.16666666666666666}, {0.5, 0.5}}, new double[][]{{0.5, 0.0}, {0.0, 0.5}}, new double[][]{{0.5, 0.16666666666666666}, {-0.5, 0.5}}, new double[][]{{0.5, 0.5}, {-1.5, 0.5}}};

    public PgIntTextureMapOnCovering() {
        if (this.getClass() == PgIntTextureMapOnCovering.class) {
            this.init();
        }
    }

    public void init() {
    }

    public PgCoveringSurface getGeometry() {
        return this.m_geom;
    }

    public void setGeometry(PgCoveringSurface geom) {
        if (geom == null) {
            this.m_geom = null;
            return;
        }
        if (this.m_geom == geom) {
            return;
        }
        this.m_geom = geom;
        if (this.m_geom.getCovering().getSymmetryOrder() != 4 && this.m_geom.getCovering().getSymmetryOrder() != 6) {
            PsDebug.warning((String)"Symmetry order must be 4 or 6.");
            return;
        }
        this.m_uValues.setSize(this.m_geom.getNumVertices());
        this.m_vValues.setSize(this.m_geom.getNumVertices());
        this.m_uSummand = PiVector.realloc((PiVector[])this.m_uSummand, (int)this.m_geom.getNumElements(), (int)3);
        this.m_vSummand = PiVector.realloc((PiVector[])this.m_vSummand, (int)this.m_geom.getNumElements(), (int)3);
    }

    public PiVector[] getVertexRotation() {
        return this.m_vertexRotation;
    }

    public void setVertexRotation(PiVector[] vertexRotation) {
        this.m_vertexRotation = vertexRotation;
    }

    public PiVector getUValues() {
        return this.m_uValues;
    }

    public PiVector getVValues() {
        return this.m_vValues;
    }

    public void setSummand(PiVector[][] tex) {
        int numE = this.m_geom.getNumElements();
        int e = 0;
        while (e < numE) {
            int i = 0;
            while (i < 3) {
                this.m_uSummand[e].m_data[i] = tex[e][i].m_data[0];
                this.m_vSummand[e].m_data[i] = tex[e][i].m_data[1];
                ++i;
            }
            ++e;
        }
    }

    public PiVector[] getUSummand() {
        return this.m_uSummand;
    }

    public PiVector[] getVSummand() {
        return this.m_vSummand;
    }

    public void add(PgIntTextureMapOnCovering texMap) {
        if (texMap.m_geom != this.m_geom) {
            PsDebug.warning((String)"Texture map has wrong geometry.");
            return;
        }
        int numE = this.m_geom.getNumElements();
        if (texMap.m_geom.getNumElements() != numE) {
            PsDebug.warning((String)"Scalar fields are not compatible.");
            return;
        }
        this.m_uValues.add(texMap.m_uValues);
        this.m_vValues.add(texMap.m_vValues);
        int e = 0;
        while (e < numE) {
            this.m_uSummand[e].add(texMap.m_uSummand[e]);
            this.m_vSummand[e].add(texMap.m_vSummand[e]);
            ++e;
        }
    }

    public void sub(PgIntTextureMapOnCovering field) {
        if (field.m_geom != this.m_geom) {
            PsDebug.warning((String)"Texture map has wrong geometry.");
            return;
        }
        int numE = this.m_geom.getNumElements();
        if (field.m_geom.getNumElements() != numE) {
            PsDebug.warning((String)"Scalar fields are not compatible.");
            return;
        }
        this.m_uValues.sub(field.m_uValues);
        this.m_vValues.sub(field.m_vValues);
        int e = 0;
        while (e < numE) {
            this.m_uSummand[e].sub(field.m_uSummand[e]);
            this.m_vSummand[e].sub(field.m_vSummand[e]);
            ++e;
        }
    }

    public void multScalar(int scalar) {
        this.m_uValues.multScalar(scalar);
        this.m_vValues.multScalar(scalar);
        int numE = this.m_geom.getNumElements();
        int e = 0;
        while (e < numE) {
            this.m_uSummand[e].multScalar(scalar);
            this.m_vSummand[e].multScalar(scalar);
            ++e;
        }
    }

    public void clearVectors() {
        this.m_uValues.setConstant(0);
        this.m_vValues.setConstant(0);
        int numE = this.m_geom.getNumElements();
        int e = 0;
        while (e < numE) {
            this.m_uSummand[e].setConstant(0);
            this.m_vSummand[e].setConstant(0);
            ++e;
        }
    }

    public PiVector[][] getTextureValues(PiVector[][] tex) {
        int numElements = this.m_geom.getNumElements();
        if (tex == null || tex.length != numElements) {
            tex = new PiVector[numElements][3];
        }
        int e = 0;
        while (e < numElements) {
            tex[e] = PiVector.realloc((PiVector[])tex[e], (int)3, (int)2);
            ++e;
        }
        e = 0;
        while (e < numElements) {
            int i = 0;
            while (i < 3) {
                this.getTextureValue(e, i, tex[e][i]);
                ++i;
            }
            ++e;
        }
        return tex;
    }

    public PiVector getTextureValue(int element, int locVertInd, PiVector tex) {
        if (this.m_vertexRotation[element].m_data[locVertInd] != Integer.MAX_VALUE) {
            int vertex = this.m_geom.getElement((int)element).m_data[locVertInd];
            tex.m_data[0] = this.m_uValues.m_data[vertex];
            tex.m_data[1] = this.m_vValues.m_data[vertex];
            PgIntTextureMapOnCovering.rot(tex, this.m_vertexRotation[element].m_data[locVertInd], this.m_geom.getCovering().getSymmetryOrder());
        } else {
            tex.setConstant(0);
        }
        tex.m_data[0] = tex.m_data[0] + this.m_uSummand[element].m_data[locVertInd];
        tex.m_data[1] = tex.m_data[1] + this.m_vSummand[element].m_data[locVertInd];
        return tex;
    }

    public void makeSummandFromGaps(PgPathOnCovering[] paths, PiVector bridges, PiVector uGaps, PiVector vGaps) {
        if (paths == null) {
            return;
        }
        int i = 0;
        while (i < this.m_uSummand.length) {
            this.m_uSummand[i].setConstant(0);
            this.m_vSummand[i].setConstant(0);
            ++i;
        }
        if (paths.length < 1) {
            return;
        }
        PiVector uPathSummand = new PiVector();
        PiVector vPathSummand = new PiVector();
        PgIntTextureMapOnCovering.gapToSummand(paths, bridges, uGaps, vGaps, uPathSummand, vPathSummand);
        PiVector gap = new PiVector(2);
        int numLayers = paths[0].getCovering().getSymmetryOrder();
        int p = 0;
        while (p < paths.length) {
            gap.set(uPathSummand.m_data[p], vPathSummand.m_data[p]);
            PgIntTextureMapOnCovering.addGapAlongPath(this.m_uSummand, this.m_vSummand, paths[p], bridges.getEntry(p), gap, numLayers);
            ++p;
        }
    }

    private static void addGapAlongPath(PiVector[] uSummand, PiVector[] vSummand, PgPathOnCovering path, int bridge, PiVector gap, int numLayers) {
        PgIntTextureMapOnCovering.addGapAlongPath(uSummand, vSummand, path, gap, path.getElementLayers()[bridge + 1].m_data[0], numLayers);
    }

    private static void addGapAlongPath(PiVector[] uSummand, PiVector[] vSummand, PgPathOnCovering path, PiVector gap, int bridgeRotation, int numLayers) {
        PiVector tmp = new PiVector(2);
        PiVector[] pathElements = path.getElementNeighbours();
        PiVector[] elementLayers = path.getElementLayers();
        PiVector[] pathLocInd = path.getVertexLocInd();
        int i = 0;
        while (i < pathElements.length) {
            int size = pathElements[i].getSize();
            int j = 0;
            while (j < size) {
                tmp = PgIntTextureMapOnCovering.rot(gap, elementLayers[i].m_data[j] - bridgeRotation, numLayers, tmp);
                int n = pathLocInd[i].m_data[j];
                uSummand[pathElements[i].m_data[j]].m_data[n] = uSummand[pathElements[i].m_data[j]].m_data[n] + tmp.m_data[0];
                int n2 = pathLocInd[i].m_data[j];
                vSummand[pathElements[i].m_data[j]].m_data[n2] = vSummand[pathElements[i].m_data[j]].m_data[n2] + tmp.m_data[1];
                ++j;
            }
            ++i;
        }
    }

    public static void gapToSummand(PgPathOnCovering[] paths, PiVector bridges, PiVector uGaps, PiVector vGaps, PiVector uPathSummand, PiVector vPathSummand) {
        if (paths == null) {
            return;
        }
        uPathSummand.setSize(paths.length);
        vPathSummand.setSize(paths.length);
        if (paths.length < 1) {
            return;
        }
        PgCovering covering = paths[0].getCovering();
        PgElementSet geom = covering.getGeometry();
        int numLayers = covering.getSymmetryOrder();
        PiVector gap = new PiVector(2);
        PiVector tmp = new PiVector(2);
        int p = 0;
        while (p < paths.length) {
            int bridgeIndex = PgTextureMapOnCovering.calcBridgeIndex(geom, numLayers, paths[p], bridges.getEntry(p));
            gap.m_data[0] = uGaps.m_data[p];
            gap.m_data[1] = vGaps.m_data[p];
            if (numLayers == 4) {
                if (bridgeIndex > 0 && bridgeIndex != 2) {
                    gap.sub(PgIntTextureMapOnCovering.rot(gap, bridgeIndex, 4, tmp));
                }
                if (bridgeIndex > 0) {
                    gap.m_data[0] = gap.m_data[0] / 2;
                    gap.m_data[1] = gap.m_data[1] / 2;
                }
            } else if (numLayers == 6) {
                int negBi = PuMath.modulo((int)(-bridgeIndex), (int)6);
                tmp.m_data[0] = (int)((double)gap.m_data[0] * MATRICES_LAYER_6[negBi - 1][0][0] + (double)gap.m_data[1] * MATRICES_LAYER_6[negBi - 1][0][1]);
                tmp.m_data[1] = (int)((double)gap.m_data[0] * MATRICES_LAYER_6[negBi - 1][1][0] + (double)gap.m_data[1] * MATRICES_LAYER_6[negBi - 1][1][1]);
                gap.copy(tmp);
            }
            uPathSummand.m_data[p] = gap.m_data[0];
            vPathSummand.m_data[p] = gap.m_data[1];
            ++p;
        }
    }

    public static PiVector rot(PiVector inOut, int r, int numLayers) {
        if (inOut.getSize() != 2) {
            PsDebug.warning((String)"Input vector has wrong dimension.");
            return null;
        }
        if (numLayers == 4) {
            switch (r & 3) {
                case 0: {
                    break;
                }
                case 1: {
                    int temp = inOut.m_data[0];
                    inOut.m_data[0] = -inOut.m_data[1];
                    inOut.m_data[1] = temp;
                    break;
                }
                case 2: {
                    inOut.m_data[0] = -inOut.m_data[0];
                    inOut.m_data[1] = -inOut.m_data[1];
                    break;
                }
                case 3: {
                    int temp = inOut.m_data[0];
                    inOut.m_data[0] = inOut.m_data[1];
                    inOut.m_data[1] = -temp;
                }
            }
            return inOut;
        }
        if (numLayers == 6) {
            switch (PuMath.modulo((int)r, (int)3)) {
                case 0: 
                case 3: {
                    break;
                }
                case 1: 
                case 4: {
                    int temp = inOut.m_data[0];
                    inOut.m_data[0] = (temp - inOut.m_data[1]) / 2;
                    inOut.m_data[1] = (3 * temp + inOut.m_data[1]) / 2;
                    break;
                }
                case 2: 
                case 5: {
                    int temp = inOut.m_data[0];
                    inOut.m_data[0] = (-temp - inOut.m_data[1]) / 2;
                    inOut.m_data[1] = (3 * temp - inOut.m_data[1]) / 2;
                }
            }
            if (PuMath.modulo((int)r, (int)6) >= 3) {
                inOut.multScalar(-1);
            }
        }
        return inOut;
    }

    public static PiVector rot(PiVector in, int r, int numLayers, PiVector out) {
        if (numLayers == 4) {
            switch (r & 3) {
                case 0: {
                    out.m_data[0] = in.m_data[0];
                    out.m_data[1] = in.m_data[1];
                    break;
                }
                case 1: {
                    out.m_data[0] = -in.m_data[1];
                    out.m_data[1] = in.m_data[0];
                    break;
                }
                case 2: {
                    out.m_data[0] = -in.m_data[0];
                    out.m_data[1] = -in.m_data[1];
                    break;
                }
                case 3: {
                    out.m_data[0] = in.m_data[1];
                    out.m_data[1] = -in.m_data[0];
                }
            }
            return out;
        }
        if (numLayers == 6) {
            switch (PuMath.modulo((int)r, (int)3)) {
                case 0: 
                case 3: {
                    out.copy(in);
                    break;
                }
                case 1: 
                case 4: {
                    out.m_data[0] = (in.m_data[0] - in.m_data[1]) / 2;
                    out.m_data[1] = (3 * in.m_data[0] + in.m_data[1]) / 2;
                    break;
                }
                case 2: 
                case 5: {
                    out.m_data[0] = (-in.m_data[0] - in.m_data[1]) / 2;
                    out.m_data[1] = (3 * in.m_data[0] - in.m_data[1]) / 2;
                }
            }
            if (PuMath.modulo((int)r, (int)6) >= 3) {
                out.multScalar(-1);
            }
        }
        return out;
    }

    public void addTexValues(int e, int i, PiVector tex) {
        int v;
        int vRot = this.m_vertexRotation[e].m_data[i];
        PgIntTextureMapOnCovering.rot(tex, -vRot, this.m_geom.getCovering().getSymmetryOrder());
        int n = v = this.m_geom.getElement((int)e).m_data[i];
        this.m_uValues.m_data[n] = this.m_uValues.m_data[n] + tex.m_data[0];
        int n2 = v;
        this.m_vValues.m_data[n2] = this.m_vValues.m_data[n2] + tex.m_data[1];
    }

    public static void removeNegativeTriangles(PgElementSet geom, PgIntTextureMapOnCovering tex) {
        int numE = geom.getNumElements();
        PuPriorityQueue queue = new PuPriorityQueue(numE);
        PiVector[] texValues = PiVector.realloc(null, (int)3, (int)2);
        int e = 0;
        while (e < numE) {
            int i = 0;
            while (i < 3) {
                tex.getTextureValue(e, i, texValues[i]);
                ++i;
            }
            int area = (texValues[1].m_data[0] - texValues[0].m_data[0]) * (texValues[2].m_data[1] - texValues[0].m_data[1]) - (texValues[1].m_data[1] - texValues[0].m_data[1]) * (texValues[2].m_data[0] - texValues[0].m_data[0]);
            queue.enqueue(e, (double)area);
            ++e;
        }
        int numV = geom.getNumVertices();
        PiVector[] lockVertices = PiVector.realloc(null, (int)numV, (int)1);
        PiVector[] lockMatching = PiVector.realloc(null, (int)numV, (int)1);
        PiVector vertexInLockList = new PiVector(numV);
        int v = 0;
        while (v < numV) {
            vertexInLockList.m_data[v] = v;
            lockVertices[v].m_data[0] = v;
            lockMatching[v].m_data[0] = 0;
            ++v;
        }
        boolean[] lockListContainsBranchPoint = new boolean[numE];
        PgCovering cov = tex.getGeometry().getCovering();
        PiVector bp = cov.getBranchPoints();
        int numBp = bp.getSize();
        int i = 0;
        while (i < numBp) {
            lockListContainsBranchPoint[bp.m_data[i]] = true;
            ++i;
        }
        PiVector texDest = new PiVector(2);
        PiVector texMove = new PiVector(2);
        int symmOrder = cov.getSymmetryOrder();
        PiVector[] vertexRotation = tex.getVertexRotation();
        PiVector diffTex = new PiVector(2);
        PiVector elementPerVertex = PgVertexStar.getElementPerVertex((PgElementSet)geom);
        while (!queue.isEmpty()) {
            double area = queue.getKeyOfMin();
            if (area >= 0.0) break;
            int e2 = queue.extractMin();
            PiVector element = geom.getElement(e2);
            int moveVInd = 0;
            if (lockListContainsBranchPoint[vertexInLockList.m_data[element.m_data[moveVInd]]] && lockListContainsBranchPoint[vertexInLockList.m_data[element.m_data[moveVInd = 1]]] && lockListContainsBranchPoint[vertexInLockList.m_data[element.m_data[moveVInd = 2]]]) {
                PsDebug.warning((String)("Element " + e2 + " cannot be collapsed."));
                continue;
            }
            int destVInd = (moveVInd + 1) % 3;
            if (!lockListContainsBranchPoint[vertexInLockList.m_data[element.m_data[destVInd]]]) {
                destVInd = (destVInd + 1) % 3;
            }
            tex.getTextureValue(e2, destVInd, texDest);
            tex.getTextureValue(e2, moveVInd, texMove);
            PiVector addToVMove = texDest;
            addToVMove.sub(texMove);
            int baseM = -vertexRotation[e2].m_data[moveVInd];
            int vDest = element.m_data[destVInd];
            int vMove = element.m_data[moveVInd];
            int lockListDest = vertexInLockList.m_data[vDest];
            int lockListMove = vertexInLockList.m_data[vMove];
            if (lockListMove == lockListDest) {
                PsDebug.warning((String)"Should never happen. Internal error.");
                return;
            }
            int indInLockListDest = lockVertices[lockListDest].getIndexOf(vDest);
            int indInLockListMove = lockVertices[lockListMove].getIndexOf(vMove);
            baseM += lockMatching[lockListMove].m_data[indInLockListMove];
            int num = lockVertices[lockListMove].getSize();
            int i2 = 0;
            while (i2 < num) {
                int v2 = lockVertices[lockListMove].m_data[i2];
                int m = lockMatching[lockListMove].m_data[i2];
                PgIntTextureMapOnCovering.rot(addToVMove, baseM - m, symmOrder, diffTex);
                int n = v2;
                tex.getUValues().m_data[n] = tex.getUValues().m_data[n] + diffTex.m_data[0];
                int n2 = v2;
                tex.getVValues().m_data[n2] = tex.getVValues().m_data[n2] + diffTex.m_data[1];
                PgVertexStar star = new PgVertexStar();
                star.makeVertexStar(geom, v2, elementPerVertex.m_data[v2]);
                int size = star.getSize();
                int j = 0;
                while (j < size) {
                    int e_ = star.getElement().m_data[j];
                    int k = 0;
                    while (k < 3) {
                        tex.getTextureValue(e_, k, texValues[k]);
                        ++k;
                    }
                    area = (texValues[1].m_data[0] - texValues[0].m_data[0]) * (texValues[2].m_data[1] - texValues[0].m_data[1]) - (texValues[1].m_data[1] - texValues[0].m_data[1]) * (texValues[2].m_data[0] - texValues[0].m_data[0]);
                    if (queue.isElement(e_)) {
                        queue.changeKey(e_, area);
                    } else {
                        queue.enqueue(e_, area);
                    }
                    ++j;
                }
                ++i2;
            }
            int size = lockVertices[lockListMove].getSize();
            int shiftM = vertexRotation[e2].m_data[moveVInd] - vertexRotation[e2].m_data[destVInd] + lockMatching[lockListDest].m_data[indInLockListDest] - lockMatching[lockListMove].m_data[indInLockListMove];
            int i3 = 0;
            while (i3 < size) {
                int v3 = lockVertices[lockListMove].m_data[i3];
                int m = lockMatching[lockListMove].m_data[i3];
                vertexInLockList.m_data[v3] = lockListDest;
                lockVertices[lockListDest].addEntry(v3);
                lockMatching[lockListDest].addEntry(shiftM + m);
                ++i3;
            }
            int n = lockListDest;
            lockListContainsBranchPoint[n] = lockListContainsBranchPoint[n] | lockListContainsBranchPoint[lockListMove];
            lockVertices[lockListMove] = null;
            lockMatching[lockListMove] = null;
        }
    }
}

