/*
 * Decompiled with CFR 0.152.
 */
package devParameterize.apps;

import devParameterize.apps.PwParameterizerBase_IP;
import devParameterize.apps.PwParameterizerDemo;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import jv.object.PsDebug;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;
import jv.objectGui.PsMultiLineLabel;

public class PwParameterizerDemo_IP
extends PwParameterizerBase_IP
implements ItemListener {
    protected static final boolean DEBUG_MODE = false;
    protected PwParameterizerDemo m_pwParameterizer;
    private static final String[] TAB_NAMES = new String[]{"Field Generator", "Field Optimizer", "Parameterizer", "Covering Editor"};
    private static final int[][] TAB_MODULES;
    private Checkbox m_trianglesBox;
    private Checkbox m_quadsBox;
    private Checkbox m_alignToBoundary;
    private Button m_remeshButton;
    private Button m_relaxButton;
    private Choice m_timingsChoice;
    private Button m_restartButton;
    private boolean m_threadRestart;
    private boolean m_threadRemesh;
    private Button m_discardRemeshButton;

    static {
        int[][] nArrayArray = new int[4][];
        int[] nArray = new int[2];
        nArray[1] = 2;
        nArrayArray[0] = nArray;
        nArrayArray[1] = new int[]{6, 7, 8, 3};
        nArrayArray[2] = new int[]{10, 11, 12, 13, 14, 15, 16};
        nArrayArray[3] = new int[]{17};
        TAB_MODULES = nArrayArray;
    }

    public PwParameterizerDemo_IP() {
        if (this.getClass() == PwParameterizerDemo_IP.class) {
            this.init();
        }
    }

    @Override
    public void init() {
        super.init();
    }

    @Override
    public void setParent(PsUpdateIf parent) {
        if (parent == null) {
            return;
        }
        if (!(parent instanceof PwParameterizerDemo)) {
            PsDebug.warning((String)"Parent must be of type PwParameterizerDemo");
            return;
        }
        this.m_pwParameterizer = (PwParameterizerDemo)parent;
        super.setParent(parent);
    }

    @Override
    protected int[][] getTabModules() {
        return TAB_MODULES;
    }

    @Override
    protected String[] getTabNames() {
        return TAB_NAMES;
    }

    @Override
    public void makeLayout() {
        this.removeAll();
        this.setInsetSize(0);
        this.addSubTitle("1. Generate Parameterization:");
        PsPanel pNotice = new PsPanel();
        pNotice.setInsetSize(5);
        pNotice.setBorderType(3);
        pNotice.add((Component)new PsMultiLineLabel("Adjust the desired edge length (if you enter a number into the text field, hit 'SHIFT+ENTER'). You can also choose how much the parameterization should  align to the priciple curvature directions. Then choose an optimization method and press 'Start'."));
        this.add((Component)pNotice);
        this.add((Component)this.m_pwParameterizer.m_edgeSize.getInfoPanel());
        this.add((Component)this.m_pwParameterizer.m_alignment.getInfoPanel());
        Panel p = new Panel();
        p.add(new Label("Optimization:"));
        this.m_timingsChoice = new Choice();
        p.add(this.m_timingsChoice);
        int num = this.m_pwParameterizer.TIMING_STRINGS.length;
        int i = 0;
        while (i < num) {
            this.m_timingsChoice.add(this.m_pwParameterizer.TIMING_STRINGS[i]);
            ++i;
        }
        this.add(p);
        p = new Panel();
        if (this.m_startButton == null) {
            this.m_startButton = new Button("Start");
            this.m_startButton.addActionListener((ActionListener)((Object)this));
        }
        p = new Panel();
        p.add(this.m_startButton);
        this.add(p);
        this.addLine(1);
        this.addSubTitle("2. Move irregular points (optional):");
        pNotice = new PsPanel();
        pNotice.setInsetSize(5);
        pNotice.setBorderType(3);
        pNotice.add((Component)new PsMultiLineLabel("Hold 'i' and click on an irregular (colored) point. Then, hold 'i' and click on any other point on the surface to move the irregular point there. After editing, click 'Update Paneling'"));
        this.add((Component)pNotice);
        p = new Panel();
        this.m_restartButton = new Button("Update Paneling");
        p.add(this.m_restartButton);
        this.m_restartButton.addActionListener((ActionListener)((Object)this));
        this.m_restartButton.setEnabled(false);
        this.add(p);
        this.addLine(1);
        this.addSubTitle("3. Remesh:");
        pNotice = new PsPanel();
        pNotice.setInsetSize(5);
        pNotice.setBorderType(3);
        pNotice.add((Component)new PsMultiLineLabel("After parameterization, press 'Remesh' to start generating the final mesh."));
        this.add((Component)pNotice);
        this.add((Component)this.m_pwParameterizer.m_postScale.getInfoPanel());
        this.m_pwParameterizer.m_postScale.setEnabled(false);
        p = new Panel();
        this.m_remeshButton = new Button("Remesh");
        p.add(this.m_remeshButton);
        this.m_remeshButton.setEnabled(false);
        this.m_remeshButton.addActionListener((ActionListener)((Object)this));
        this.add(p);
        p = new Panel();
        this.m_discardRemeshButton = new Button("Discard remesh");
        p.add(this.m_discardRemeshButton);
        this.m_discardRemeshButton.addActionListener((ActionListener)((Object)this));
        this.m_discardRemeshButton.setEnabled(false);
        this.add(p);
    }

    @Override
    public boolean update(Object event) {
        if (event == null) {
            return super.update(null);
        }
        if (event == this.m_pwParameterizer && this.m_pwParameterizer.m_newGeometry) {
            this.m_pwParameterizer.m_newGeometry = false;
            this.m_startButton.setEnabled(true);
            this.m_pwParameterizer.m_edgeSize.setEnabled(true);
            this.m_pwParameterizer.m_alignment.setEnabled(true);
            this.m_timingsChoice.setEnabled(true);
            this.m_restartButton.setEnabled(false);
            this.m_pwParameterizer.m_postScale.setEnabled(false);
            this.m_remeshButton.setEnabled(false);
            this.m_discardRemeshButton.setEnabled(false);
        }
        return super.update(event);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        if (source == this.m_trianglesBox || source == this.m_quadsBox) {
            this.m_pwParameterizer.getGeometry().setTextureImageName(this.m_trianglesBox.getState() ? "images/hexagons.png" : "images/quads.png");
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.m_startButton) {
            this.m_pwParameterizer.setTimings(this.m_timingsChoice.getSelectedIndex());
            new Thread(this).start();
            return;
        }
        if (source == this.m_remeshButton) {
            this.m_threadRemesh = true;
            new Thread(this).start();
            return;
        }
        if (source == this.m_relaxButton) {
            this.m_pwParameterizer.relax();
            return;
        }
        if (source == this.m_restartButton) {
            this.m_threadRestart = true;
            new Thread(this).start();
            return;
        }
        if (source == this.m_discardRemeshButton) {
            this.m_pwParameterizer.discardRemeshedGeom();
            this.m_restartButton.setEnabled(true);
            this.m_remeshButton.setEnabled(true);
            this.m_discardRemeshButton.setEnabled(false);
            this.m_pwParameterizer.m_postScale.setEnabled(true);
            return;
        }
        super.actionPerformed(event);
    }

    @Override
    public void run() {
        if (this.m_threadRestart) {
            this.m_threadRestart = false;
            Color c = this.m_restartButton.getBackground();
            this.m_restartButton.setBackground(Color.red);
            this.m_restartButton.setEnabled(false);
            this.m_remeshButton.setEnabled(false);
            this.m_pwParameterizer.m_postScale.setEnabled(false);
            this.m_pwParameterizer.m_running = true;
            this.m_pwParameterizer.restart();
            this.m_pwParameterizer.m_running = false;
            this.m_restartButton.setEnabled(true);
            this.m_remeshButton.setEnabled(true);
            this.m_pwParameterizer.m_postScale.setEnabled(true);
            this.m_restartButton.setBackground(c);
        } else if (this.m_threadRemesh) {
            this.m_threadRemesh = false;
            this.m_restartButton.setEnabled(false);
            this.m_remeshButton.setEnabled(false);
            this.m_pwParameterizer.m_postScale.setEnabled(false);
            Color c = this.m_remeshButton.getBackground();
            this.m_remeshButton.setBackground(Color.red);
            this.m_pwParameterizer.m_running = true;
            this.m_pwParameterizer.remesh();
            this.m_pwParameterizer.m_running = false;
            this.m_remeshButton.setBackground(c);
            this.m_discardRemeshButton.setEnabled(true);
        } else {
            if (this.m_pwParameterizer.getGeometry() == null) {
                this.m_pwParameterizer.printError("No geometry loaded");
                return;
            }
            this.m_pwParameterizer.m_edgeSize.setEnabled(false);
            this.m_pwParameterizer.m_alignment.setEnabled(false);
            this.m_pwParameterizer.getGeometry().removeTexture();
            this.m_pwParameterizer.m_running = true;
            this.m_pwParameterizer.getGeometry().showColors(2);
            super.run();
            this.m_pwParameterizer.m_running = false;
            if (this.m_pwParameterizer.getGeometry().getParamTexture() != null) {
                this.m_startButton.setEnabled(false);
                this.m_timingsChoice.setEnabled(false);
                this.m_pwParameterizer.m_postScale.setEnabled(true);
                this.m_restartButton.setEnabled(true);
                this.m_remeshButton.setEnabled(true);
            }
        }
    }
}

