/*
 * Decompiled with CFR 0.152.
 */
package devParameterize.apps;

import devParameterize.apps.PjParameterizerDemo;
import devParameterize.apps.PwParameterizerBase;
import devParameterize.geom.PgParamGeom;
import devParameterize.geom.PwRemesher;
import devParameterize.modules.fieldGenerator.PmConstraintsGenerator;
import devParameterize.modules.fieldGenerator.PmPrerelaxer;
import devParameterize.modules.fieldGenerator.PmRelaxAlongGradient;
import devParameterize.modules.fieldGenerator.PmRelaxEnergyCurl;
import devParameterize.modules.fieldGenerator.PmSparseFieldGenerator;
import devParameterize.modules.parameterizer.PmGapEstimator;
import devSmoothing.PwCentroidRegularization;
import javax.swing.JOptionPane;
import jv.geom.PgElementSet;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsDebug;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.vecmath.PiVector;

public class PwParameterizerDemo
extends PwParameterizerBase {
    public static final String TEXTURE_IMAGE_4 = "images/quads.png";
    public static final String TEXTURE_IMAGE_6 = "images/hexagons.png";
    protected final String[] TIMING_STRINGS = new String[]{"Fastest (< approx. 1min)", "Normal (< approx. 5min)", "Slow / Optimized"};
    private static final int[] USED_MODULES;
    protected PgElementSet m_remeshedGeom;
    private boolean m_threadRelax;
    protected PuDouble m_edgeSize;
    protected PuDouble m_alignment;
    protected PuInteger m_postScale;
    private static final double DEFAULT_SCALE = 40.0;
    protected boolean m_newGeometry;
    private PjParameterizerDemo m_project;
    protected boolean m_running;

    static {
        int[] nArray = new int[14];
        nArray[1] = 2;
        nArray[2] = 6;
        nArray[3] = 7;
        nArray[4] = 8;
        nArray[5] = 3;
        nArray[6] = 10;
        nArray[7] = 11;
        nArray[8] = 12;
        nArray[9] = 13;
        nArray[10] = 14;
        nArray[11] = 15;
        nArray[12] = 16;
        nArray[13] = 17;
        USED_MODULES = nArray;
    }

    public PwParameterizerDemo(PjParameterizerDemo project) {
        this.setName("QuadCover Demonstration Workshop");
        this.m_project = project;
        this.setUsedModuleIDs(USED_MODULES);
        this.m_edgeSize = new PuDouble("Edge length", (PsUpdateIf)this);
        this.m_edgeSize.setDefBounds(0.0, 12.0, 1.0, 1.0);
        this.m_edgeSize.setDefValue(1.0);
        this.m_alignment = new PuDouble("Curvature Alignment", (PsUpdateIf)this);
        this.m_alignment.setDefBounds(0.0, 1.0, 0.1, 0.1);
        this.m_alignment.setDefValue(0.1);
        this.m_postScale = new PuInteger("Refinement", (PsUpdateIf)this);
        this.m_postScale.setDefBounds(0, 2, 1, 1);
        this.m_postScale.setDefValue(0);
        if (this.getClass() == PwParameterizerDemo.class) {
            this.init();
        }
    }

    @Override
    public void init() {
        super.init();
        this.m_edgeSize.init();
        this.m_alignment.init();
        this.m_postScale.init();
    }

    @Override
    public void setGeometry(PgGeometry geom) {
        super.setGeometry(geom);
        PmSparseFieldGenerator cg = (PmSparseFieldGenerator)this.createModule(0);
        cg.setAlignToBoundary(false);
        cg.setAlignToSharpEdges(false);
        cg.showSharpEdges(false);
        cg.setCurvRadius(1.5 * cg.getCurvRadiusTic());
        cg.setTrustThreshold(0.1, false);
        this.m_geom.setTextureImageName(TEXTURE_IMAGE_4);
        this.m_geom.showEdges(false);
        PmConstraintsGenerator cog = (PmConstraintsGenerator)this.createModule(9);
        cog.setMakeSharpEdgeConstraints(false);
        cog.setMakeBoundaryConstraints(false);
        PmGapEstimator ge = (PmGapEstimator)this.createModule(12);
        double sc = 20.0 / geom.getDiameter();
        ge.setScaleFactor(sc);
        this.m_edgeSize.setBounds(0.1 / sc, 10.0 / sc, 0.1 / sc, 0.1 / sc);
        this.m_edgeSize.setValue(1.0 / sc);
        this.m_postScale.setValue(0);
        this.m_geom.setPostScaleFactor(1 << this.m_postScale.getValue() + 1);
        this.m_alignment.init();
        PmPrerelaxer rel0 = (PmPrerelaxer)this.createModule(6);
        PmRelaxAlongGradient rel1 = (PmRelaxAlongGradient)this.createModule(7);
        PmPrerelaxer rel2 = (PmPrerelaxer)this.createModule(8);
        rel0.setEnabled(true);
        rel1.setEnabled(true);
        rel2.setEnabled(true);
        rel2.setMinDist(0.0);
        this.createModule(16).setEnabled(true);
        this.m_newGeometry = true;
        ((PmSparseFieldGenerator)this.createModule(0)).start();
        this.m_geom.showColors(1);
        this.update(this);
        this.m_newGeometry = false;
    }

    public void setTimings(int timing) {
        PmPrerelaxer rel0 = (PmPrerelaxer)this.createModule(6);
        PmRelaxAlongGradient rel1 = (PmRelaxAlongGradient)this.createModule(7);
        PmPrerelaxer rel2 = (PmPrerelaxer)this.createModule(8);
        switch (timing) {
            case 0: {
                rel0.setTimeLimit(8000L);
                rel1.setTimeLimit(10000L);
                rel2.setTimeLimit(20000L);
                break;
            }
            case 1: {
                rel0.setTimeLimit(30000L);
                rel1.setTimeLimit(60000L);
                rel2.setTimeLimit(180000L);
                break;
            }
            case 2: {
                rel0.setTimeLimit(0L);
                rel1.setTimeLimit(0L);
                rel2.setTimeLimit(300000L);
            }
        }
    }

    @Override
    public boolean update(Object event) {
        PgParamGeom geom = this.getGeometry();
        if (event == this.m_edgeSize) {
            if (geom != null) {
                PmGapEstimator ge = (PmGapEstimator)this.createModule(12);
                ge.setScaleFactor(0.5 / this.m_edgeSize.getValue());
                geom.setFrameScaleFactor(0.5 / this.m_edgeSize.getValue());
            }
            return true;
        }
        if (event == this.m_alignment) {
            if (geom != null) {
                double value = this.m_alignment.getValue();
                PmSparseFieldGenerator curvGen = (PmSparseFieldGenerator)this.createModule(0);
                curvGen.setTrustThreshold(value, false);
                PmRelaxEnergyCurl relaxer2Energy = ((PmRelaxAlongGradient)this.createModule(7)).getEnergy();
                relaxer2Energy.setAlignmentWeight(10.0 * value);
                PmPrerelaxer relaxer3 = (PmPrerelaxer)this.createModule(8);
                PmRelaxEnergyCurl relaxer3Energy = (PmRelaxEnergyCurl)relaxer3.getEnergy();
                relaxer3Energy.setAlignmentWeight(10.0 * value);
                double c1 = this.m_alignment.getDefValue();
                double c2 = 0.7;
                double d = c2 / c1 * (1.0 - c1) / (1.0 - c2);
                this.getSmoother().setSmoothingFactor(1.0 - d * value / (1.0 + (d - 1.0) * value));
                curvGen.start();
                geom.update((Object)geom);
            }
            return true;
        }
        if (event == this.m_postScale) {
            if (geom != null) {
                geom.setPostScaleFactor(1 << this.m_postScale.getValue() + 1);
                geom.update((Object)geom);
            }
            return true;
        }
        return super.update(event);
    }

    public void restart() {
        if (this.m_geom == null) {
            this.printError("No geometry loaded");
        } else if (this.m_geom.getParamTexture() == null) {
            this.printError("No Parameterization. Click 'Start' first");
        } else {
            this.startFFExtension();
        }
    }

    public void remesh() {
        if (this.m_geom.getParamTexture() == null) {
            this.printError("No Parameterization. Click 'Start' first");
            return;
        }
        try {
            PwRemesher remesher = new PwRemesher();
            remesher.setGeometry((PgGeometry)this.m_geom);
            remesher.setDisplay(this.getDisplay());
            this.m_remeshedGeom = remesher.remeshFromTexture(true, false);
            if (this.m_remeshedGeom != null) {
                int numE = this.m_remeshedGeom.getNumElements();
                int e = 0;
                while (e < numE) {
                    this.m_remeshedGeom.clearTagElement(e, 1);
                    ++e;
                }
            }
            this.m_remeshedGeom.showVertices(false);
            PmConstraintsGenerator cg = (PmConstraintsGenerator)this.createModule(9);
            if (cg.getMakeBoundaryConstraints()) {
                int numE = this.m_remeshedGeom.getNumElements();
                int e = 0;
                while (e < numE) {
                    double area = this.m_remeshedGeom.getAreaOfElement(e);
                    if (area < 0.01) {
                        this.m_remeshedGeom.setTagElement(e, 2);
                    }
                    ++e;
                }
                this.m_remeshedGeom.removeMarkedElements();
            }
            int[] val = PgElementSet.getVertexValence((PgElementSet)this.m_remeshedGeom).m_data;
            int j = 0;
            while (j < this.m_remeshedGeom.getNumVertices()) {
                if (val[j] < 3) {
                    this.m_remeshedGeom.setTagVertex(j, 1);
                } else {
                    this.m_remeshedGeom.clearTagVertex(j, 1);
                }
                ++j;
            }
            int numE = this.m_remeshedGeom.getNumElements();
            int j2 = 0;
            while (j2 < numE) {
                PiVector elem = this.m_remeshedGeom.getElement(j2);
                int index = -1;
                int k = 0;
                while (k < elem.getSize()) {
                    if (this.m_remeshedGeom.hasTagVertex(elem.getEntry(k), 1)) {
                        index = k;
                    }
                    ++k;
                }
                if (index != -1) {
                    elem.removeEntry(index);
                    --j2;
                    this.m_remeshedGeom.makeNeighbour();
                    this.m_remeshedGeom.makeElementNormals();
                }
                ++j2;
            }
            this.m_remeshedGeom.removeUnusedVertices();
            this.m_threadRelax = true;
            this.run();
            if (this.m_display != null) {
                this.m_display.addGeometry((PgGeometryIf)this.m_remeshedGeom);
                this.m_display.selectGeometry((PgGeometryIf)this.m_remeshedGeom);
                this.m_geom.setVisible(false);
                this.m_geom.update((Object)this.m_geom);
                this.m_display.update((Object)this.m_display);
            }
        }
        catch (Exception e) {
            this.printError("Cannot remesh surface");
        }
        this.m_project.setRemesh(this.m_remeshedGeom);
    }

    protected void printError(String msg) {
        JOptionPane.showMessageDialog(null, msg, "Error", 0);
    }

    public void relax() {
        if (this.m_remeshedGeom != null) {
            this.m_threadRelax = true;
            new Thread(this).start();
        } else {
            PsDebug.warning((String)"No remeshed geometry generated.");
        }
    }

    @Override
    public void run() {
        if (this.m_threadRelax) {
            this.m_threadRelax = false;
            PmConstraintsGenerator cg = (PmConstraintsGenerator)this.createModule(9);
            if (!cg.getMakeBoundaryConstraints()) {
                int numE = this.m_remeshedGeom.getNumElements();
                int e = 0;
                while (e < numE) {
                    int i = 0;
                    while (i < 3) {
                        if (this.m_remeshedGeom.getNeighbour((int)e).m_data[i] < 0) {
                            PiVector element = this.m_remeshedGeom.getElement(e);
                            int j = 0;
                            while (j < 3) {
                                this.m_remeshedGeom.setTagVertex(element.m_data[j], 1);
                                ++j;
                            }
                        }
                        ++i;
                    }
                    ++e;
                }
            }
            try {
                PwCentroidRegularization mr = new PwCentroidRegularization();
                mr.setGeometry((PgGeometry)this.m_remeshedGeom);
                mr.setProjectionIterations(8);
                mr.setSmoothingIterations(24);
                mr.setTarget((PgElementSet)this.m_geom);
                mr.smoothCentroid(false);
            }
            catch (Exception f) {
                PsDebug.warning((String)"Relaxation failed.");
            }
            int numV = this.m_remeshedGeom.getNumVertices();
            int v = 0;
            while (v < numV) {
                this.m_remeshedGeom.clearTagVertex(v, 1);
                ++v;
            }
            this.m_remeshedGeom.update((Object)this.m_remeshedGeom);
        } else {
            super.run();
        }
    }

    public void discardRemeshedGeom() {
        if (this.m_remeshedGeom != null) {
            this.getDisplay().removeGeometry((PgGeometryIf)this.m_remeshedGeom);
            this.getDisplay().selectGeometry((PgGeometryIf)this.m_geom);
            this.m_geom.setVisible(true);
            this.m_geom.update((Object)this.m_geom);
        }
    }
}

