/*
 * Decompiled with CFR 0.152.
 */
package devParameterize.apps;

import devParameterize.apps.PwParameterizerBase;
import devParameterize.modules.PnModule;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import jv.object.PsDebug;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;
import jv.objectGui.PsTabPanel;
import jvx.project.PjWorkshop_IP;

public abstract class PwParameterizerBase_IP
extends PjWorkshop_IP
implements Runnable {
    protected PwParameterizerBase m_pwParameterizerBase;
    protected Button m_startButton;
    private Color m_buttonColor;
    private boolean m_bRunning;
    private PnModule m_runningModule;

    public PwParameterizerBase_IP() {
        if (this.getClass() == PwParameterizerBase_IP.class) {
            this.init();
        }
    }

    public void init() {
        super.init();
    }

    public void setParent(PsUpdateIf parent) {
        if (parent == null) {
            return;
        }
        if (!(parent instanceof PwParameterizerBase)) {
            PsDebug.warning((String)"Parent has to be of type PwParameterizerBase");
            return;
        }
        this.m_pwParameterizerBase = (PwParameterizerBase)parent;
        super.setParent(parent);
        this.makeLayout();
    }

    public void makeLayout() {
        this.setInsetSize(1);
        Panel gridPanel = new Panel(new GridLayout(1, 3));
        gridPanel.add(new Label());
        this.m_startButton = new Button("Parameterize");
        this.m_startButton.addActionListener((ActionListener)((Object)this));
        gridPanel.add(this.m_startButton);
        gridPanel.add((Component)this.m_pwParameterizerBase.m_bConsoleLog.getInfoPanel());
        this.add(gridPanel);
        int[][] tabModules = this.getTabModules();
        String[] tabNames = this.getTabNames();
        int numTabs = tabModules == null ? 0 : tabModules.length;
        PsTabPanel tabPanel = new PsTabPanel();
        tabPanel.setBackground(Color.LIGHT_GRAY);
        int t = 0;
        while (t < numTabs) {
            int numModules = tabModules[t] == null ? 0 : tabModules[t].length;
            PsPanel pTab = new PsPanel();
            int j = 0;
            while (j < numModules) {
                PnModule module = this.m_pwParameterizerBase.createModule(tabModules[t][j]);
                pTab.add((Component)module.getHeadBar());
                pTab.add((Component)module.getInfoPanel());
                ++j;
            }
            tabPanel.addPanel(tabNames[t], pTab);
            ++t;
        }
        this.add((Component)tabPanel);
    }

    protected abstract String[] getTabNames();

    protected abstract int[][] getTabModules();

    public boolean update(Object event) {
        if (this.m_pwParameterizerBase == null) {
            PsDebug.notify((String)"missing parent");
            return true;
        }
        if (event == this.m_pwParameterizerBase) {
            PnModule runningModule = this.m_pwParameterizerBase.getRunningModule();
            if (runningModule != this.m_runningModule) {
                if (this.m_runningModule != null) {
                    this.m_runningModule.getHeadBar().setRunning(false);
                }
                this.m_runningModule = runningModule;
                if (runningModule != null) {
                    runningModule.getHeadBar().setRunning(true);
                }
            }
            return true;
        }
        return super.update(event);
    }

    public void actionPerformed(ActionEvent event) {
        if (this.m_pwParameterizerBase == null) {
            return;
        }
        Object source = event.getSource();
        if (source == this.m_startButton) {
            new Thread(this).start();
        }
    }

    @Override
    public void run() {
        if (this.m_bRunning) {
            this.m_pwParameterizerBase.abort(null);
        } else {
            this.m_bRunning = true;
            this.m_buttonColor = this.m_startButton.getBackground();
            this.m_startButton.setBackground(Color.red);
            this.m_startButton.setLabel("Abort");
            this.m_pwParameterizerBase.startAllUsed();
        }
        this.m_pwParameterizerBase.m_geom.update((Object)this.m_pwParameterizerBase.m_geom);
        this.m_startButton.setLabel("Parameterize");
        this.m_startButton.setBackground(this.m_buttonColor);
        this.m_bRunning = false;
    }
}

