/*
 * Decompiled with CFR 0.152.
 */
package devParameterize.apps;

import devCovering.PgCovering;
import devCovering.PgPathOnCovering;
import devCovering.PnCovering;
import devParameterize.geom.PgParamGeom;
import devParameterize.modules.PnModule;
import devParameterize.modules.editor.PmCoveringEditor;
import devParameterize.modules.fieldGenerator.PmAlignmentOptimizer;
import devParameterize.modules.fieldGenerator.PmConstraintsGenerator;
import devParameterize.modules.fieldGenerator.PmFieldExtender;
import devParameterize.modules.fieldGenerator.PmFrameAngleEditor;
import devParameterize.modules.fieldGenerator.PmFrameFieldScaler;
import devParameterize.modules.fieldGenerator.PmPrerelaxer;
import devParameterize.modules.fieldGenerator.PmRelaxAlongGradient;
import devParameterize.modules.fieldGenerator.PmRelaxEnergyIf;
import devParameterize.modules.fieldGenerator.PmRelaxEnergySmooth;
import devParameterize.modules.fieldGenerator.PmSingularityMover;
import devParameterize.modules.fieldGenerator.PmSparseFieldEditor;
import devParameterize.modules.fieldGenerator.PmSparseFieldGenerator;
import devParameterize.modules.fieldGenerator.PmVectorAngleSmoother;
import devParameterize.modules.meshGenerator.PmMeshGenerator;
import devParameterize.modules.parameterizer.PmAntiSpiraler;
import devParameterize.modules.parameterizer.PmContinuousMaker;
import devParameterize.modules.parameterizer.PmDegenerationDetector;
import devParameterize.modules.parameterizer.PmGapEditor;
import devParameterize.modules.parameterizer.PmGapEstimator;
import devParameterize.modules.parameterizer.PmGapRounder;
import devParameterize.modules.parameterizer.PmGraphBuilder;
import devParameterize.modules.parameterizer.PmPositiveOrienter;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import jv.geom.PgElementSet;
import jv.geom.PgPolygonSet;
import jv.number.PuBoolean;
import jv.number.PuString;
import jv.object.PsDebug;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.project.PvDisplayIf;
import jv.vecmath.PiVector;
import jvx.geom.PgUtil;
import jvx.geom.PwBoundary;
import jvx.geom.PwCleanMesh;
import jvx.project.PjWorkshop;

public abstract class PwParameterizerBase
extends PjWorkshop
implements ActionListener,
Runnable {
    public static boolean CONSOLE_OUTPUT = false;
    public static final int MODULE_SPARSE_FIELD_GENERATOR = 0;
    public static final int MODULE_SPARSE_FIELD_EDITOR = 1;
    public static final int MODULE_FIELD_EXTENDER = 2;
    public static final int MODULE_FRAME_FIELD_SCALER = 3;
    public static final int MODULE_FRAME_ANGLE_EDITOR = 4;
    public static final int MODULE_ALIGNMENT_OPTIMIZER = 5;
    public static final int MODULE_BRANCH_POINT_OPTIMIZER = 6;
    public static final int MODULE_RELAX_ALONG_GRADIENT = 7;
    public static final int MODULE_BRANCH_POINT_RELAXER = 8;
    public static final int MODULE_CONSTAINTS_GENERATOR = 9;
    public static final int MODULE_GRAPH_BUILDER = 10;
    public static final int MODULE_BOUNDARY_CONSTRAINTS_GENERATOR = 11;
    public static final int MODULE_GAP_ESTIMATOR = 12;
    public static final int MODULE_GAP_ROUNDER = 13;
    public static final int MODULE_CONTINUOUS_MAKER = 14;
    public static final int MODULE_DEGENERATION_DETECTOR = 15;
    public static final int MODULE_POSITIVE_ORIENTER = 16;
    public static final int MODULE_COVERING_EDITOR = 17;
    public static final int MODULE_MESH_GENERATOR = 18;
    public static final int MODULE_ANTI_SPIRALER = 19;
    public static final int MODULE_SINGULARITY_MOVER = 20;
    public static final int MODULE_GAP_EDITOR = 21;
    private PnModule[] MODULES = new PnModule[]{new PmSparseFieldGenerator(), new PmSparseFieldEditor(), new PmFieldExtender(), new PmFrameFieldScaler(), new PmFrameAngleEditor(), new PmAlignmentOptimizer(), new PmPrerelaxer(new PmRelaxEnergyIf[]{new PmRelaxEnergySmooth()}), new PmRelaxAlongGradient(), new PmPrerelaxer(), new PmConstraintsGenerator(), new PmGraphBuilder(), new PmConstraintsGenerator(), new PmGapEstimator(), new PmGapRounder(), new PmContinuousMaker(), new PmDegenerationDetector(), new PmPositiveOrienter(), new PmCoveringEditor(), new PmMeshGenerator(), new PmAntiSpiraler(), new PmSingularityMover(), new PmGapEditor()};
    private int[] m_usedModuleID;
    private PnModule[] m_usedModule;
    private PnModule m_moduleRunning;
    protected PmVectorAngleSmoother m_smoother;
    private boolean m_bAbort;
    protected PuBoolean m_bConsoleLog;
    protected PgParamGeom m_geom;
    private PgGeometry[] m_matchingGeom;
    private PgGeometry m_elementTreeGeom;
    private PgPolygonSet m_cutPathsGeom;
    private PgPolygonSet m_sharpConstraintsGeom;
    protected PuBoolean m_showMatching;
    protected PuBoolean m_showElementTree;
    protected PuBoolean m_showCutPaths;
    protected PuBoolean m_showSharpConstraints;
    protected boolean m_updateMatching;
    protected boolean m_updateElementTree;
    private boolean m_updateCutPaths;
    public boolean m_updateSharpConstraints;
    public static int MAX_NUM_THREADS = 0;
    private int m_numThreads;
    private ExecutorService m_threadPool;
    protected ActionEvent m_threadAction;

    public PwParameterizerBase() {
        super("Parameterizer workshop");
        this.setUsedModuleIDs(null);
        this.m_bConsoleLog = new PuBoolean("Log to console");
        this.m_bConsoleLog.setDefState(CONSOLE_OUTPUT);
        this.m_showMatching = new PuBoolean("Matching", (PsUpdateIf)this, false);
        this.m_showElementTree = new PuBoolean("Element Tree", (PsUpdateIf)this, false);
        this.m_showCutPaths = new PuBoolean("Cut Paths", (PsUpdateIf)this, false);
        this.m_showSharpConstraints = new PuBoolean("Sharp Constraints", (PsUpdateIf)this, true);
        this.m_cutPathsGeom = new PgPolygonSet(3);
        this.m_cutPathsGeom.setName("Cut paths");
        this.m_numThreads = Runtime.getRuntime().availableProcessors();
        if (MAX_NUM_THREADS > 0) {
            this.m_numThreads = Math.min(this.m_numThreads, MAX_NUM_THREADS);
        }
        this.m_threadPool = Executors.newFixedThreadPool(this.m_numThreads);
        if (this.getClass() == PwParameterizerBase.class) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_bConsoleLog.init();
        this.m_showMatching.init();
        this.m_showElementTree.init();
        this.m_showCutPaths.init();
        this.m_showSharpConstraints.init();
        this.m_cutPathsGeom.showVertices(false);
        this.m_cutPathsGeom.setGlobalPolygonSize(4.0);
    }

    public boolean update(Object event) {
        if (event == null) {
            return super.update(null);
        }
        if (event == this.m_showMatching || event == this.m_showSharpConstraints || event == this.m_showElementTree || event == this.m_showCutPaths) {
            if (event == this.m_showMatching) {
                this.m_updateMatching = true;
            } else if (event == this.m_showElementTree) {
                this.m_updateElementTree = true;
            } else if (event == this.m_showCutPaths) {
                this.m_updateCutPaths = true;
            } else if (event == this.m_showSharpConstraints) {
                this.m_updateSharpConstraints = true;
            }
            if (this.updateVisualizations()) {
                this.update(this);
            }
            return true;
        }
        if (event == this && this.updateVisualizations()) {
            return super.update((Object)this);
        }
        return super.update(event);
    }

    public boolean updateVisualizations() {
        PvDisplayIf currDisp;
        boolean geomChanged = false;
        boolean dispChanged = false;
        dispChanged |= this.showMatching(this.m_showMatching.getState());
        dispChanged |= this.showElementTree(this.m_showElementTree.getState());
        dispChanged |= this.showCutPaths(this.m_showCutPaths.getState());
        if ((dispChanged |= this.showSharpConstraints(this.m_showSharpConstraints.getState())) && (currDisp = this.getDisplay()) != null) {
            currDisp.update((Object)currDisp);
        }
        return dispChanged || geomChanged;
    }

    public PmVectorAngleSmoother getSmoother() {
        return this.m_smoother;
    }

    private void setSmoother(PmVectorAngleSmoother smoother) {
        this.m_smoother = smoother;
        this.m_smoother.setGeometry(this.m_geom);
    }

    public void assureSmoother() {
        if (this.m_smoother == null) {
            this.setSmoother(new PmVectorAngleSmoother());
        }
    }

    public PgParamGeom getGeometry() {
        return this.m_geom;
    }

    public void setGeometry(PgGeometry geom) {
        if (geom == null || !(geom instanceof PgParamGeom)) {
            PsDebug.warning((String)"geom is not a PgParamGeom.");
            return;
        }
        PgParamGeom pGeom = (PgParamGeom)geom;
        if (!PwParameterizerBase.preprocessGeometry((PgElementSet)pGeom)) {
            return;
        }
        super.setGeometry((PgGeometry)pGeom);
        this.m_geom = pGeom;
        this.m_geom.m_showMatching = this.m_showMatching;
        this.m_geom.m_showElementTree = this.m_showElementTree;
        this.m_geom.m_showCutPaths = this.m_showCutPaths;
        this.m_geom.m_showSharpConstraints = this.m_showSharpConstraints;
        this.m_cutPathsGeom.setDimOfVertices(this.m_geom.getDimOfVertices());
        int num = this.getNumUsedModules();
        int i = 0;
        while (i < num) {
            if (this.m_usedModule[i] != null) {
                this.m_usedModule[i].setGeometry(this.m_geom);
            }
            ++i;
        }
        if (this.m_smoother != null) {
            this.m_smoother.setGeometry(this.m_geom);
        }
    }

    protected static boolean preprocessGeometry(PgElementSet geom) {
        if (geom == null) {
            PsDebug.warning((String)"missing geometry.");
            return false;
        }
        if (!PwCleanMesh.checkManifold((PgElementSet)geom, (boolean)false)) {
            PsDebug.warning((String)"geometry not manifold.");
            return false;
        }
        if (geom.getDimOfElements() != 3) {
            PgElementSet.triangulate((PgElementSet)geom);
        }
        if (!PwCleanMesh.makeOrientation((PgElementSet)geom)) {
            PsDebug.warning((String)"geometry is not orientable.");
            return false;
        }
        if (!geom.checkNeighbour(false)) {
            PsDebug.warning((String)"error in neighbourhood.");
            return false;
        }
        geom.removeUnusedVertices();
        geom.allocateEdgeStars();
        geom.assureEdgeColors();
        geom.showEdgeColors(true);
        geom.assureElementTextures();
        geom.makeElementNormals();
        PwBoundary.makeBoundary((PgElementSet)geom);
        geom.setGlobalVectorLength(PgUtil.getEdgeLengths((PgElementSet)geom, null, (boolean)true).average() / 4.0);
        geom.setGlobalVectorColor(Color.black);
        geom.showVectorFields(true);
        geom.showElementBackColors(false);
        geom.showElementBackColor(true);
        int numVertices = geom.getNumVertices();
        int i = 0;
        while (i < numVertices) {
            geom.getVertex(i).clearTag(1);
            ++i;
        }
        return true;
    }

    public boolean showMatching(boolean show) {
        int i;
        if (show == this.m_showMatching.getState() && !this.m_updateMatching) {
            return false;
        }
        if (show != this.m_showMatching.getState()) {
            this.m_showMatching.setState(show);
        }
        this.m_updateMatching = false;
        if (this.m_matchingGeom != null) {
            i = 0;
            while (i < this.m_matchingGeom.length) {
                this.dispRemoveGeometry(this.m_matchingGeom[i]);
                ++i;
            }
        }
        this.m_matchingGeom = null;
        if (show && this.m_geom != null && this.m_geom.getCovering() != null) {
            this.m_matchingGeom = PnCovering.makeMatchingGeometry((PgCovering)this.m_geom.getCovering());
            if (this.m_matchingGeom != null) {
                i = 0;
                while (i < this.m_matchingGeom.length) {
                    this.dispAddGeometry(this.m_matchingGeom[i]);
                    ++i;
                }
            }
        }
        return true;
    }

    public boolean showElementTree(boolean show) {
        if (show == this.m_showElementTree.getState() && !this.m_updateElementTree) {
            return false;
        }
        if (show != this.m_showElementTree.getState()) {
            this.m_showElementTree.setState(show);
        }
        this.m_updateElementTree = false;
        if (this.m_elementTreeGeom != null) {
            this.dispRemoveGeometry(this.m_elementTreeGeom);
            this.m_elementTreeGeom = null;
        }
        if (show && this.m_geom != null && this.m_geom.getElementTree() != null) {
            this.m_elementTreeGeom = this.m_geom.getElementTree().getVisualizingGeometry();
            this.dispAddGeometry(this.m_elementTreeGeom);
        }
        return true;
    }

    public boolean showCutPaths(boolean show) {
        if (show == this.m_showCutPaths.getState() && !this.m_updateCutPaths) {
            return false;
        }
        if (show != this.m_showCutPaths.getState()) {
            this.m_showCutPaths.setState(show);
        }
        this.m_updateCutPaths = false;
        if (this.m_cutPathsGeom != null) {
            this.dispRemoveGeometry((PgGeometry)this.m_cutPathsGeom);
        }
        if (show && this.m_geom != null && this.m_geom.getCutPaths() != null) {
            PgPathOnCovering[] path = this.m_geom.getCutPaths();
            this.m_cutPathsGeom.setEnabledInstanceSharing(true);
            this.m_cutPathsGeom.setNumVertices(this.m_geom.getNumVertices());
            this.m_cutPathsGeom.setVertices(this.m_geom.getVertices());
            this.m_cutPathsGeom.setEnabledInstanceSharing(false);
            int numPolys = path.length;
            this.m_cutPathsGeom.setNumPolygons(numPolys);
            int i = 0;
            while (i < numPolys) {
                if (path[i] == null) {
                    PsDebug.warning((String)("cutPath[" + i + "] is null."));
                } else {
                    this.m_cutPathsGeom.setPolygon(i, path[i].getVertexIndices());
                }
                ++i;
            }
            this.dispAddGeometry((PgGeometry)this.m_cutPathsGeom);
        }
        return true;
    }

    public boolean showSharpConstraints(boolean show) {
        if (show == this.m_showSharpConstraints.getState() && !this.m_updateSharpConstraints) {
            return false;
        }
        if (show != this.m_showSharpConstraints.getState()) {
            this.m_showSharpConstraints.setState(show);
        }
        this.m_showSharpConstraints.setState(show);
        this.m_updateSharpConstraints = false;
        if (this.m_sharpConstraintsGeom != null) {
            this.dispRemoveGeometry((PgGeometry)this.m_sharpConstraintsGeom);
        }
        this.m_sharpConstraintsGeom = null;
        if (show && this.m_geom != null && this.m_geom.getSharpConstraints() != null) {
            this.m_sharpConstraintsGeom = this.m_geom.getSharpConstraints().getConstraintsAsPolygonSet();
            if (this.m_sharpConstraintsGeom != null) {
                this.dispAddGeometry((PgGeometry)this.m_sharpConstraintsGeom);
            }
        }
        return true;
    }

    public boolean isShowingSharpConstraints() {
        return this.m_showSharpConstraints.getState();
    }

    public void setUpdateMatching(boolean b) {
        this.m_updateMatching = b;
    }

    public void setUpdateElementTree(boolean b) {
        this.m_updateElementTree = b;
    }

    public void setUpdateSharpConstraints(boolean b) {
        this.m_updateSharpConstraints = b;
    }

    private void dispAddGeometry(PgGeometry geom) {
        if (geom == null) {
            return;
        }
        PvDisplayIf currDisp = this.getDisplay();
        if (currDisp != null) {
            currDisp.addGeometry((PgGeometryIf)geom);
        }
    }

    private void dispRemoveGeometry(PgGeometry geom) {
        if (geom == null) {
            return;
        }
        PvDisplayIf currDisp = this.getDisplay();
        if (currDisp != null) {
            currDisp.removeGeometry((PgGeometryIf)geom);
        }
    }

    public void setDisplay(PvDisplayIf display) {
        super.setDisplay(display);
        int num = this.getNumUsedModules();
        int i = 0;
        while (i < num) {
            if (this.m_usedModule[i] != null) {
                this.m_usedModule[i].setDisplay(display);
            }
            ++i;
        }
    }

    public boolean isEnabledConsoleLog() {
        return this.m_bConsoleLog.getState();
    }

    public void setEnabledConsoleLog(boolean consoleLog) {
        this.m_bConsoleLog.setState(consoleLog);
    }

    public int getNumUsedModules() {
        int num = this.m_usedModuleID == null ? 0 : this.m_usedModuleID.length;
        return num;
    }

    public void setUsedModuleIDs(int[] moduleID) {
        this.m_usedModuleID = moduleID;
        this.createUsedModules();
    }

    protected void createUsedModules() {
        if (this.m_usedModuleID == null) {
            this.m_usedModule = null;
            return;
        }
        int num = this.getNumUsedModules();
        this.m_usedModule = new PnModule[num];
        int i = 0;
        while (i < num) {
            this.m_usedModule[i] = this.createModule(this.m_usedModuleID[i]);
            this.m_usedModule[i].setParameterizer(this);
            ++i;
        }
    }

    public PnModule createModule(int moduleID) {
        if (moduleID < 0 || moduleID >= this.MODULES.length) {
            PsDebug.warning((String)("Module ID out of range, id = " + moduleID));
            return null;
        }
        return this.MODULES[moduleID];
    }

    public int[] getUsedModulesID() {
        return this.m_usedModuleID;
    }

    public PnModule[] getUsedModules() {
        return this.m_usedModule;
    }

    public PnModule getUsedModule(int usedModuleID) {
        if (usedModuleID < 0 || usedModuleID >= this.getNumUsedModules()) {
            PsDebug.warning((String)("Module ID out of range, id = " + usedModuleID));
            return null;
        }
        return this.m_usedModule[usedModuleID];
    }

    public PnModule getUsedModuleGlobalID(int usedModuleGlobalID) {
        int usedModuleID = -1;
        int i = 0;
        while (i < this.m_usedModuleID.length) {
            if (this.m_usedModuleID[i] == usedModuleGlobalID) {
                usedModuleID = i;
                break;
            }
            ++i;
        }
        if (usedModuleID < 0 || usedModuleID >= this.getNumUsedModules()) {
            PsDebug.warning((String)("Module ID out of range, id = " + usedModuleID));
            return null;
        }
        return this.m_usedModule[usedModuleID];
    }

    public PnModule getModule(int moduleID) {
        if (moduleID < 0 || moduleID >= this.MODULES.length) {
            PsDebug.warning((String)("Module ID out of range, id = " + moduleID));
            return null;
        }
        return this.createModule(moduleID);
    }

    public void startAllUsed() {
        try {
            this.m_geom.reset();
            if (this.m_smoother != null) {
                this.m_smoother.reset();
            }
            this.startUsedModulesFromCurrent(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void startUsedModulesFromCurrent(PnModule startModule) {
        long startTime = System.currentTimeMillis();
        try {
            int numUsedModules = this.getNumUsedModules();
            int moduleInd = 0;
            if (startModule != null) {
                while (moduleInd < numUsedModules && this.getUsedModule(moduleInd) != startModule) {
                    ++moduleInd;
                }
                if (moduleInd >= numUsedModules) {
                    return;
                }
            }
            this.m_bAbort = false;
            int i = moduleInd;
            while (i < numUsedModules) {
                PnModule module = this.getUsedModule(i);
                if (!this.m_bAbort && module.getEnabled()) {
                    this.startModule(module);
                    int nextModule = module.jumpToModule();
                    if (nextModule != -1) {
                        i = new PiVector(this.getUsedModulesID()).getIndexOf(nextModule);
                        if (i == -1) break;
                        --i;
                    }
                }
                ++i;
            }
            long endTime = System.currentTimeMillis();
            if (this.m_bConsoleLog.getState()) {
                String aString = "                                        Total Time: ";
                PsDebug.message((String)(String.valueOf(aString) + PuString.timeToString((long)(endTime - startTime)) + "\n"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void startFFExtension() {
        boolean fixMatching = this.m_geom.getFixMatching();
        boolean fixConstraints = this.m_geom.getFixSharpConstraints();
        this.m_geom.setFixMatching(true);
        this.m_geom.setFixSharpConstraints(true);
        boolean FFScalerState = this.getUsedModuleGlobalID(3).getEnabled();
        boolean antiSpiralerState = this.getUsedModuleGlobalID(19).getEnabled();
        boolean singMoverState = false;
        if (this.getUsedModuleGlobalID(20) != null) {
            singMoverState = this.getUsedModuleGlobalID(20).getEnabled();
        }
        this.getUsedModuleGlobalID(3).setEnabled(false);
        this.getUsedModuleGlobalID(19).setEnabled(false);
        if (this.getUsedModuleGlobalID(20) != null) {
            this.getUsedModuleGlobalID(20).setEnabled(false);
        }
        this.startUsedModulesFromCurrent(this.getUsedModuleGlobalID(2));
        this.getUsedModuleGlobalID(3).setEnabled(FFScalerState);
        this.getUsedModuleGlobalID(19).setEnabled(antiSpiralerState);
        if (this.getUsedModuleGlobalID(20) != null) {
            this.getUsedModuleGlobalID(20).setEnabled(singMoverState);
        }
        this.m_geom.setFixSharpConstraints(fixConstraints);
        this.m_geom.setFixMatching(fixMatching);
    }

    protected PnModule getRunningModule() {
        return this.m_moduleRunning;
    }

    public boolean isRunning() {
        return this.m_moduleRunning != null;
    }

    public void startModule(PnModule module) {
        try {
            if (this.isRunning()) {
                return;
            }
            this.m_moduleRunning = module;
            this.update(this);
            boolean log = this.m_bConsoleLog.getState();
            if (log) {
                String status = "   " + module.getStatusMessage() + "                                                       ";
                status = (String)status.subSequence(0, 40);
                PsDebug.messageWithoutNewline((String)(String.valueOf(status) + "... "));
            }
            PsDebug.showStatus((String)(String.valueOf(module.getStatusMessage()) + "..."));
            long startTime = System.currentTimeMillis();
            try {
                module.start();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            long endTime = System.currentTimeMillis();
            PsDebug.showStatus((String)"");
            if (log) {
                PsDebug.message((String)(" Time: " + PuString.timeToString((long)(endTime - startTime))));
            }
            this.m_moduleRunning = null;
            this.update(this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void skipModule(PnModule module) {
        if (this.isRunning() && this.m_moduleRunning == module) {
            this.m_moduleRunning.abort();
            this.m_moduleRunning = null;
        }
    }

    public void abort(PnModule module) {
        if (module == null || this.m_moduleRunning == module) {
            this.m_bAbort = true;
            this.skipModule(this.m_moduleRunning);
        }
    }

    public void abort() {
        if (this.isRunning()) {
            this.m_bAbort = true;
            this.skipModule(this.m_moduleRunning);
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        this.m_threadAction = event;
        Thread thread = new Thread(this);
        thread.setName("Parameterizer");
        thread.start();
    }

    @Override
    public void run() {
        Object source = this.m_threadAction.getSource();
        try {
            int num = this.getNumUsedModules();
            int i = 0;
            while (i < num) {
                PnModule module = this.getUsedModuleGlobalID(this.getUsedModulesID()[i]);
                if (source == module.getHeadBar()) {
                    int id = this.m_threadAction.getID();
                    if (id == 0) {
                        this.startModule(module);
                    } else if (id == 1) {
                        this.startUsedModulesFromCurrent(module);
                    } else if (id == 2) {
                        this.skipModule(module);
                    } else if (id == 3) {
                        this.abort(module);
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getNumThreads() {
        return this.m_numThreads;
    }

    public ExecutorService getThreadPool() {
        return this.m_threadPool;
    }

    public boolean isShowingMatching() {
        return this.m_showMatching.getState();
    }
}

