/*
 * Decompiled with CFR 0.152.
 */
package devParameterize.apps;

import devParameterize.apps.PwParameterizerDemo;
import devParameterize.geom.PgParamGeom;
import devParameterize.loader.PjImportParamModel;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import jv.geom.PgElementSet;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.project.PjProject;
import jv.project.PvDisplayIf;
import jv.rsrc.PsJavaView;
import jvx.geom.PwCleanMesh;

public class PjParameterizerDemo
extends PjProject
implements ActionListener {
    private static final int MAX_TRIANGLES = 30000;
    public static final String DEFAULT_FILENAME = "models/byu/Brezel_480.byu";
    protected PjImportParamModel m_import = new PjImportParamModel();
    protected PwParameterizerDemo m_pwQuadCover;
    protected PgGeometryIf m_geom;

    public PjParameterizerDemo() {
        super("QuadCover Project");
        this.m_import.setTypeOfInfoPanel(0);
        this.m_import.setSaveAsGp(false);
        Dimension d = this.m_import.getInfoPanel().getSize();
        d.width += 100;
        this.m_import.getInfoPanel().setSize(d);
        this.m_import.setFileName(DEFAULT_FILENAME);
        this.m_import.load(DEFAULT_FILENAME);
        this.m_import.addActionListener(this);
        this.m_pwQuadCover = new PwParameterizerDemo(this);
        if (this.getClass() == PjParameterizerDemo.class) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.setGeometry(this.m_import.getGeometry());
        this.m_import.setGeometry(null);
    }

    public void setDisplay(PvDisplayIf disp) {
        super.setDisplay(disp);
        if (disp != null) {
            disp.setEnabled3DLook(true);
        }
        this.m_pwQuadCover.setDisplay(disp);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.m_import) {
            if (this.m_pwQuadCover.isRunning()) {
                this.m_pwQuadCover.printError("Cannot load file: QuadCover is already running.");
                return;
            }
            this.setGeometry(this.m_import.getGeometry());
            this.m_import.setGeometry(null);
        }
    }

    public boolean setGeometry(PgGeometryIf geom) {
        PgParamGeom pGeom;
        super.setGeometry(geom);
        if (!(geom instanceof PgElementSet)) {
            PsDebug.warning((String)"Geometry must be an instance of PgElementSet.");
            return false;
        }
        if (!this.checkValidGeometry((PgElementSet)geom)) {
            return false;
        }
        if (geom instanceof PgParamGeom) {
            pGeom = (PgParamGeom)geom;
        } else {
            pGeom = new PgParamGeom();
            pGeom.copy((PsObject)((PgElementSet)geom));
            pGeom.setName(geom.getName());
        }
        pGeom.removeTexture();
        pGeom.loadCache();
        if (this.m_geom != null) {
            this.removeGeometry(this.m_geom);
        }
        this.m_geom = pGeom;
        if (this.getDisplay() != null) {
            this.getDisplay().removeGeometries();
        }
        this.addGeometry(this.m_geom);
        this.selectGeometry(this.m_geom);
        if (this.getDisplay() != null) {
            this.getDisplay().fit();
        }
        PsJavaView.setEnabledWorkshopBackup((boolean)false);
        this.m_pwQuadCover.setGeometry((PgGeometry)this.m_geom);
        return true;
    }

    private boolean checkValidGeometry(PgElementSet geom) {
        if (geom == null) {
            return false;
        }
        if (geom.getNumElements() < 1) {
            PsDebug.warning((String)"Geometry contains no triangles.");
            return false;
        }
        if (geom.getNumElements() > 30000) {
            PsDebug.warning((String)("Geometry has too many triangles (" + geom.getNumElements() + "), only " + 30000 + " allowed."));
            return false;
        }
        int e = 0;
        while (e < geom.getNumElements()) {
            if (geom.getDimOfElement(e) != 3) {
                PsDebug.warning((String)("Element " + e + " is not a triangle."));
                return false;
            }
            ++e;
        }
        if (!PwCleanMesh.checkManifold((PgElementSet)geom, (boolean)false)) {
            PsDebug.warning((String)"Geometry is not a manifold surface.");
            return false;
        }
        return true;
    }

    public void setRemesh(PgElementSet remeshedGeom) {
        this.m_import.setGeometry((PgGeometryIf)remeshedGeom);
    }
}

