/*
 * Decompiled with CFR 0.152.
 */
package devParameterize._tmp;

import dev.vecmath.PiDynVector;
import devCovering.PgCoveringSurface;
import devCovering.PgFrameField;
import jv.geom.PgElementSet;
import jv.object.PsDebug;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuMath;
import jvx.geom.PgVertexStar;

public class PnBoundaryConditions {
    private PgCoveringSurface m_geom;
    private PiVector[][] m_vertexPolygon;
    private PiVector[][] m_elements;
    private PiVector[][] m_locVertexInd;
    private PiVector[][] m_layer;

    public PgElementSet getGeometry() {
        return this.m_geom;
    }

    public PiVector[][] getVertexPolygon() {
        return this.m_vertexPolygon;
    }

    public PiVector[][] getElements() {
        return this.m_elements;
    }

    public PiVector[][] getLocVertexInd() {
        return this.m_locVertexInd;
    }

    public PiVector[][] getLayer() {
        return this.m_layer;
    }

    public void makeBoundaries(PgCoveringSurface geom, PgFrameField field) {
        if (geom == null) {
            PsDebug.warning((String)"missing geometry.");
            return;
        }
        if (geom.getCovering() == null) {
            PsDebug.warning((String)"missing covering in geometry.");
            return;
        }
        this.m_geom = geom;
        this.m_vertexPolygon = new PiVector[0][0];
        this.m_elements = new PiVector[0][0];
        this.m_locVertexInd = new PiVector[0][0];
        this.m_layer = new PiVector[0][0];
        int numV = this.m_geom.getNumVertices();
        boolean[] vertexVisited = new boolean[numV];
        PgVertexStar star = new PgVertexStar();
        PiVector elementPerVertex = PgVertexStar.getElementPerVertex((PgElementSet)this.m_geom);
        int v = 0;
        while (v < numV) {
            if (!vertexVisited[v]) {
                vertexVisited[v] = true;
                star.makeVertexStar((PgElementSet)this.m_geom, v, elementPerVertex.m_data[v]);
                if (!star.isClosed()) {
                    int index = this.appendBoundaryComponent();
                    this.traceBoundary(index, v, vertexVisited, field);
                }
            }
            ++v;
        }
    }

    private void traceBoundary(int component, int startV, boolean[] vertexVisited, PgFrameField field) {
        PgVertexStar star = new PgVertexStar();
        PiVector elementPerVertex = PgVertexStar.getElementPerVertex((PgElementSet)this.m_geom);
        int v = startV;
        int r = 0;
        PiDynVector dynVertexPolygon = new PiDynVector();
        PiDynVector dynElements = new PiDynVector();
        PiDynVector dynLocVertexInd = new PiDynVector();
        PiDynVector dynLayer = new PiDynVector();
        int e = -1;
        boolean firstTime = true;
        int finish = -1;
        while (true) {
            star.makeVertexStar((PgElementSet)this.m_geom, v, elementPerVertex.m_data[v]);
            PiVector elements = star.getElement();
            PiVector link = star.getLink();
            PiVector vLocInd = star.getVertexLocInd();
            int dim = elements.getSize();
            if (firstTime) {
                PdVector bndEdge = PdVector.subNew((PdVector)this.m_geom.getVertex(v), (PdVector)this.m_geom.getVertex(link.getFirstEntry()));
                e = elements.getFirstEntry();
                boolean diriOddLayer = Math.abs(field.getField(1).getVector(e).dot(bndEdge)) < Math.abs(field.getField(0).getVector(e).dot(bndEdge));
                r = diriOddLayer ? 1 : 0;
            }
            int startR = r;
            int i = 0;
            while (i < dim) {
                e = elements.m_data[i];
                int locEdgeInd = (vLocInd.m_data[i] + 1) % 3;
                dynElements.appendEntry(e);
                dynLocVertexInd.appendEntry(vLocInd.m_data[i]);
                dynLayer.appendEntry(r);
                if (i < dim - 1) {
                    r = PuMath.modulo((int)(r + this.m_geom.getCovering().getMatching(e, locEdgeInd)), (int)4);
                }
                ++i;
            }
            if (finish >= 0) {
                int num = this.m_layer[component][0].getSize();
                if (finish >= num || r == this.m_layer[component][0].m_data[finish]) break;
                int i2 = finish;
                while (i2 < num) {
                    this.m_layer[component][0].m_data[i2] = PuMath.modulo((int)(this.m_layer[component][0].m_data[i2] + 2), (int)4);
                    ++i2;
                }
                break;
            }
            int nv = link.getLastEntry();
            vertexVisited[nv] = true;
            PdVector bndEdge = PdVector.subNew((PdVector)this.m_geom.getVertex(nv), (PdVector)this.m_geom.getVertex(v));
            boolean diriOddLayer = Math.abs(field.getField(1).getVector(e).dot(bndEdge)) < Math.abs(field.getField(0).getVector(e).dot(bndEdge));
            boolean setCorner = PuMath.modulo((int)r, (int)2) == 1 ^ diriOddLayer;
            dynVertexPolygon.appendEntry(v);
            if (setCorner) {
                this.appendBoundaryPolygon(component, dynVertexPolygon.toPiVector(), dynElements.toPiVector(), dynLocVertexInd.toPiVector(), dynLayer.toPiVector());
                dynVertexPolygon.setSize(0);
                dynElements.setSize(0);
                dynLocVertexInd.setSize(0);
                dynLayer.setSize(0);
                r = PuMath.modulo((int)(1 - startR), (int)4);
            } else if (v == startV && !firstTime) {
                this.prependFirstBoundaryPolygon(component, dynVertexPolygon.toPiVector(), dynElements.toPiVector(), dynLocVertexInd.toPiVector(), dynLayer.toPiVector());
                finish = dynLayer.getSize();
            } else {
                v = nv;
            }
            firstTime = false;
        }
    }

    private void prependFirstBoundaryPolygon(int component, PiVector vertexPolygon, PiVector elements, PiVector locVInd, PiVector layer) {
        if (this.m_vertexPolygon[component] == null) {
            this.m_vertexPolygon[component] = new PiVector[1];
            this.m_vertexPolygon[component][0] = vertexPolygon;
            this.m_elements[component] = new PiVector[1];
            this.m_elements[component][0] = elements;
            this.m_locVertexInd[component] = new PiVector[1];
            this.m_locVertexInd[component][0] = locVInd;
            this.m_layer[component] = new PiVector[1];
            this.m_layer[component][0] = layer;
        } else {
            this.m_vertexPolygon[component][0] = PiVector.concatNew((PiVector)vertexPolygon, (PiVector)this.m_vertexPolygon[component][0]);
            this.m_elements[component][0] = PiVector.concatNew((PiVector)elements, (PiVector)this.m_elements[component][0]);
            this.m_locVertexInd[component][0] = PiVector.concatNew((PiVector)locVInd, (PiVector)this.m_locVertexInd[component][0]);
            this.m_layer[component][0] = PiVector.concatNew((PiVector)layer, (PiVector)this.m_layer[component][0]);
        }
    }

    private void appendBoundaryPolygon(int component, PiVector vertexPolygon, PiVector elements, PiVector locVInd, PiVector layer) {
        int num = this.m_vertexPolygon[component] == null ? 0 : this.m_vertexPolygon[component].length;
        PiVector[] newVertexPolygon = new PiVector[num + 1];
        PiVector[] newElements = new PiVector[num + 1];
        PiVector[] newLocVInd = new PiVector[num + 1];
        PiVector[] newLayer = new PiVector[num + 1];
        if (num > 0) {
            System.arraycopy(this.m_vertexPolygon[component], 0, newVertexPolygon, 0, num);
            System.arraycopy(this.m_elements[component], 0, newElements, 0, num);
            System.arraycopy(this.m_locVertexInd[component], 0, newLocVInd, 0, num);
            System.arraycopy(this.m_layer[component], 0, newLayer, 0, num);
        }
        newVertexPolygon[num] = vertexPolygon;
        newElements[num] = elements;
        newLocVInd[num] = locVInd;
        newLayer[num] = layer;
        this.m_vertexPolygon[component] = newVertexPolygon;
        this.m_elements[component] = newElements;
        this.m_locVertexInd[component] = newLocVInd;
        this.m_layer[component] = newLayer;
    }

    public int getNumBoundaryComponents() {
        return this.m_vertexPolygon == null ? 0 : this.m_vertexPolygon.length;
    }

    private int appendBoundaryComponent() {
        int index = this.getNumBoundaryComponents();
        PiVector[][] newVertexPolygon = new PiVector[index + 1][];
        PiVector[][] newElements = new PiVector[index + 1][];
        PiVector[][] newLocVertexInd = new PiVector[index + 1][];
        PiVector[][] newLayer = new PiVector[index + 1][];
        if (index > 0) {
            System.arraycopy(this.m_vertexPolygon, 0, newVertexPolygon, 0, index);
            System.arraycopy(this.m_elements, 0, newElements, 0, index);
            System.arraycopy(this.m_locVertexInd, 0, newLocVertexInd, 0, index);
            System.arraycopy(this.m_layer, 0, newLayer, 0, index);
        }
        this.m_vertexPolygon = newVertexPolygon;
        this.m_elements = newElements;
        this.m_locVertexInd = newLocVertexInd;
        this.m_layer = newLayer;
        return index;
    }

    public PdVector[][] makeGradientConstraints() {
        int numE = this.m_geom.getNumElements();
        PdVector[][] gradientConstraints = new PdVector[numE][];
        int numC = this.m_vertexPolygon == null ? 0 : this.m_vertexPolygon.length;
        int c = 0;
        while (c < numC) {
            int numD = this.m_vertexPolygon[c].length;
            int d = 0;
            while (d < numD) {
                int dim = this.m_elements[c][d].getSize() - 1;
                int i = 0;
                while (i < dim) {
                    if (this.m_elements[c][d].m_data[i] == this.m_elements[c][d].m_data[i + 1]) {
                        int e0 = this.m_elements[c][d].m_data[i];
                        int e1 = this.m_elements[c][d].m_data[i + 1];
                        int locV0 = this.m_locVertexInd[c][d].m_data[i];
                        int locV1 = this.m_locVertexInd[c][d].m_data[i + 1];
                        int v0 = this.m_geom.getElement((int)e0).m_data[locV0];
                        int v1 = this.m_geom.getElement((int)e1).m_data[locV1];
                        int layer0 = this.m_layer[c][d].m_data[i];
                        PdVector constr = PdVector.subNew((PdVector)this.m_geom.getVertex(v1), (PdVector)this.m_geom.getVertex(v0));
                        int len = gradientConstraints[e0] == null ? 0 : gradientConstraints[e0].length;
                        PdVector[] gc = new PdVector[len + 1];
                        int j = 0;
                        while (j < len) {
                            gc[j] = gradientConstraints[e0][j];
                            ++j;
                        }
                        gc[len] = new PdVector(6);
                        if (layer0 % 2 == 0) {
                            j = 0;
                            while (j < 3) {
                                gc[len].m_data[j] = constr.m_data[j];
                                ++j;
                            }
                        } else {
                            j = 0;
                            while (j < 3) {
                                gc[len].m_data[3 + j] = constr.m_data[j];
                                ++j;
                            }
                        }
                        gradientConstraints[e0] = gc;
                    }
                    ++i;
                }
                ++d;
            }
            ++c;
        }
        return gradientConstraints;
    }
}

