/*
 * Decompiled with CFR 0.152.
 */
package devFundamentalsatz;

import java.util.Random;
import jv.geom.PgPolygon;
import jv.number.PuComplex;
import jv.object.PsDebug;
import jv.vecmath.PdVector;

public class PuPolygonUtil {
    public static final double PRECISION = 1.0E-19;

    @Deprecated
    public static int computeWindingNumber(PgPolygon poly, PdVector c) {
        int firstVertexQuadrant;
        poly.isClosed();
        int windingNumber = 0;
        PdVector[] vertices = poly.getVertices();
        PdVector v = vertices[0];
        double x = v.m_data[0] - c.m_data[0];
        double y = v.m_data[1] - c.m_data[1];
        int prevQuadrant = firstVertexQuadrant = PuPolygonUtil.computeQuadrant(x, y);
        int curQuadrant = 0;
        int i = 1;
        while (i < vertices.length) {
            v = vertices[i];
            x = v.m_data[0] - c.m_data[0];
            y = v.m_data[1] - c.m_data[1];
            curQuadrant = PuPolygonUtil.computeQuadrant(x, y);
            if (curQuadrant > prevQuadrant || curQuadrant == 1 && prevQuadrant == 4) {
                ++windingNumber;
            } else if (curQuadrant < prevQuadrant || curQuadrant == 4 && prevQuadrant == 1) {
                --windingNumber;
            }
            prevQuadrant = curQuadrant;
            ++i;
        }
        if (firstVertexQuadrant > prevQuadrant || firstVertexQuadrant == 1 && prevQuadrant == 4) {
            ++windingNumber;
        } else if (firstVertexQuadrant < prevQuadrant || firstVertexQuadrant == 4 && prevQuadrant == 1) {
            --windingNumber;
        }
        return windingNumber / 4;
    }

    public static int computeWindingNumberAlciatore(PgPolygon poly, PdVector c) {
        poly.isClosed();
        double wn = 0.0;
        PdVector[] vertices = poly.getVertices();
        int nov = poly.getNumVertices();
        double x_c = c.m_data[0];
        double y_c = c.m_data[1];
        int i = 0;
        while (i < nov) {
            PdVector v_cur = vertices[i];
            double x_vcur = v_cur.m_data[0] - x_c;
            double y_vcur = v_cur.m_data[1] - y_c;
            PdVector v_next = i == nov - 1 ? vertices[0] : vertices[i + 1];
            double x_vnext = v_next.m_data[0] - x_c;
            double y_vnext = v_next.m_data[1] - y_c;
            if (y_vcur * y_vnext < 0.0) {
                double r = x_vcur + y_vcur * (x_vnext - x_vcur) / (y_vcur - y_vnext);
                if (r > 0.0) {
                    wn = y_vcur < 0.0 ? wn + 1.0 : wn - 1.0;
                }
            } else if (Math.abs(y_vcur) < 1.0E-19 && x_vcur > 0.0) {
                wn = y_vnext > 0.0 ? wn + 0.5 : wn - 0.5;
            } else if (Math.abs(y_vnext) < 1.0E-19 && x_vnext > 0.0) {
                wn = y_vcur < 0.0 ? wn + 0.5 : wn - 0.5;
            }
            ++i;
        }
        return (int)Math.round(wn);
    }

    public static int computeQuadrant(PdVector p) {
        double x = p.m_data[0];
        double y = p.m_data[1];
        return PuPolygonUtil.computeQuadrant(x, y);
    }

    public static int computeQuadrant(double x, double y) {
        if (x > 0.0 && y >= 0.0) {
            return 1;
        }
        if (x <= 0.0 && y > 0.0) {
            return 2;
        }
        if (x < 0.0 && y <= 0.0) {
            return 3;
        }
        if (x >= 0.0 && y < 0.0) {
            return 4;
        }
        return 0;
    }

    public static String generateRandomPolynomialString(int num_poles, int max_degree) {
        String expr = "";
        Random rand_gen = new Random();
        if (num_poles <= max_degree) {
            int d = max_degree;
            int counter = 1;
            while (d > 0) {
                PuComplex roots_of_unity = new PuComplex(0.0, Math.PI * 2 / (double)num_poles);
                PuComplex nullstelle = PuComplex.exp((PuComplex)PuComplex.mult((PuComplex)roots_of_unity, (double)counter));
                if (d < max_degree) {
                    expr = String.valueOf(expr) + "*";
                }
                int power = d > 1 ? rand_gen.nextInt(d - 1) + 1 : 1;
                String term = "(z-(" + nullstelle.toString() + ") )^" + Integer.toString(power);
                expr = String.valueOf(expr) + term;
                d -= power;
                ++counter;
            }
        }
        System.out.println("The randomly generated derivative: \n" + expr);
        return expr;
    }

    public static void computeSquare(PgPolygon geom, int numPointsX, int numPointsY, double radius) {
        boolean normalsExist;
        if (geom == null) {
            PsDebug.warning((String)"Geometry is null");
            return;
        }
        if (numPointsX < 2 || numPointsY < 2) {
            PsDebug.warning((String)"Square needs to have at least 2 vertices per side");
            return;
        }
        int nov = 2 * numPointsX + 2 * (numPointsY - 2);
        geom.setNumVertices(nov);
        geom.assureVertexNormals();
        PdVector[] vs = geom.getVertices();
        PdVector[] vsn = geom.getVertexNormals();
        boolean bl = normalsExist = vsn != null;
        if (geom.getDimOfVertices() > 2) {
            PdVector.setConstant((PdVector[])vs, (double)0.0);
            if (normalsExist) {
                PdVector.setConstant((PdVector[])vsn, (double)0.0);
            }
        }
        double incX = 2.0 * radius / (double)(numPointsX - 1);
        double incY = 2.0 * radius / (double)(numPointsY - 1);
        int head = 0;
        int i = 0;
        while (i < numPointsX) {
            vs[i].m_data[0] = -radius + (double)i * incX;
            vs[i].m_data[1] = -radius;
            if (normalsExist) {
                vsn[i].m_data[0] = 0.0;
                vsn[i].m_data[1] = -1.0;
            }
            ++i;
        }
        head = numPointsX;
        i = 0;
        while (i < numPointsY - 1) {
            vs[head + i].m_data[0] = radius;
            vs[head + i].m_data[1] = -radius + (double)i * incY;
            if (normalsExist) {
                vsn[head + i].m_data[0] = 1.0;
                vsn[head + i].m_data[1] = 0.0;
            }
            ++i;
        }
        head = numPointsX + (numPointsY - 1);
        i = 0;
        while (i < numPointsX - 1) {
            vs[head + i].m_data[0] = radius - (double)i * incX;
            vs[head + i].m_data[1] = radius;
            if (normalsExist) {
                vsn[head + i].m_data[0] = 0.0;
                vsn[head + i].m_data[1] = 1.0;
            }
            ++i;
        }
        head = numPointsX + (numPointsY - 1) + (numPointsX - 1);
        i = 0;
        while (i < numPointsY - 2) {
            vs[head + i].m_data[0] = -radius;
            vs[head + i].m_data[1] = radius - (double)i * incY;
            if (normalsExist) {
                vsn[head + i].m_data[0] = -1.0;
                vsn[head + i].m_data[1] = 0.0;
            }
            ++i;
        }
        geom.setClosed(true);
    }

    public static void computeRegularNgon(PgPolygon geom, int n, int numOfVerticesPerSide, double radius) {
        int nov = n * (numOfVerticesPerSide - 1);
        geom.setNumVertices(nov);
        geom.assureVertexNormals();
        PdVector[] vs = geom.getVertices();
        PdVector[] vsn = geom.getVertexNormals();
        boolean normalsExist = vsn != null;
        double sidelength = 2.0 * radius * Math.cos(Math.PI / (double)n);
        double inc = Math.PI * 2 / (double)n;
        PuComplex expInc = new PuComplex(0.0, 0.0);
        int k = 0;
        while (k < n) {
            PuComplex curRoot = PuComplex.exp((PuComplex)expInc.set(0.0, inc * (double)k)).mult(radius);
            PuComplex nextRoot = PuComplex.exp((PuComplex)expInc.set(0.0, inc * (double)(k + 1))).mult(radius);
            double diffReInc = (nextRoot.re - curRoot.re) / (double)(numOfVerticesPerSide - 1);
            double diffImInc = (nextRoot.im - curRoot.im) / (double)(numOfVerticesPerSide - 1);
            int j = 0;
            while (j < numOfVerticesPerSide - 1) {
                vs[k * (numOfVerticesPerSide - 1) + j].m_data[0] = curRoot.re + (double)j * diffReInc;
                vs[k * (numOfVerticesPerSide - 1) + j].m_data[1] = curRoot.im + (double)j * diffImInc;
                if (normalsExist) {
                    vsn[k * j + j].m_data[0] = -vs[k * j + j].m_data[1] / sidelength;
                    vsn[k * j + j].m_data[1] = vs[k * j + j].m_data[0] / sidelength;
                }
                ++j;
            }
            ++k;
        }
        geom.setClosed(true);
    }
}

