/*
 * Decompiled with CFR 0.152.
 */
package devFundamentalsatz;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import jv.function.PuComplexFunction;
import jv.number.PuComplex;

public class PuComplexPoly
implements Cloneable,
Serializable {
    private static final double CP_BASE = 2.0;
    private static final double CP_kT = 53.0;
    private static final double CP_kN = -1022.0;
    private static final double CP_ETA = Math.pow(2.0, -52.0);
    private static final double CP_INFIN = Double.MAX_VALUE;
    private static final double CP_SMALNO = Math.pow(2.0, -1019.0) / Math.pow(2.0, 3.0);
    private static final double CP_ARE = CP_ETA;
    private static final double CP_MRE = 2.0 * Math.sqrt(2.0) * CP_ETA;
    private static final double CP_COSR = -0.060756474;
    private static final double CP_SINR = 0.99756405;
    private static final double CP_HIGH_TOLERANCE = 1.0E-6;
    private static final double CP_LOW_TOLERANCE = 1.0E-12;
    private static DecimalFormat CP_df;
    private PuComplex[] m_coef;
    private transient double m_PVr;
    private transient double m_PVi;
    private transient double m_Tr;
    private transient double m_Ti;
    private transient double m_Sr;
    private transient double m_Si;
    private transient double m_Zr;
    private transient double m_Zi;

    static {
        DecimalFormatSymbols otherSymbols = new DecimalFormatSymbols();
        otherSymbols.setDecimalSeparator('.');
        otherSymbols.setGroupingSeparator('.');
        CP_df = new DecimalFormat("#.#############", otherSymbols);
    }

    public PuComplexPoly() {
    }

    public PuComplexPoly(PuComplex[] coefficients) {
        this.m_coef = (PuComplex[])coefficients.clone();
    }

    public PuComplexPoly(double[] coefficients) {
        int length = coefficients.length;
        this.m_coef = new PuComplex[length];
        int i = 0;
        while (i < length) {
            this.m_coef[i] = new PuComplex(coefficients[i]);
            ++i;
        }
    }

    public void setCoefficients(PuComplex[] coefficients) {
        this.m_coef = (PuComplex[])coefficients.clone();
    }

    public void setCoefficients(double[] coefficients) {
        int length = coefficients.length;
        this.m_coef = new PuComplex[length];
        int i = 0;
        while (i < length) {
            this.m_coef[i] = new PuComplex(coefficients[i]);
            ++i;
        }
    }

    public PuComplex[] getCoefficients() {
        return this.m_coef;
    }

    public PuComplex evaluate(PuComplex z) {
        return this.evaluate(z.re(), z.im());
    }

    public PuComplex evaluate(double x) {
        return this.evaluate(x, 0.0);
    }

    public PuComplex evaluate(double zr, double zi) {
        if (this.m_coef == null) {
            return new PuComplex(0.0, 0.0);
        }
        int NN = this.m_coef.length;
        double pvr = this.m_coef[NN - 1].re();
        double pvi = this.m_coef[NN - 1].im();
        int i = NN - 2;
        while (i >= 0) {
            double temp = pvr;
            pvr = pvr * zr - pvi * zi + this.m_coef[i].re();
            pvi = temp * zi + pvi * zr + this.m_coef[i].im();
            --i;
        }
        return new PuComplex(pvr, pvi);
    }

    public PuComplex slope(PuComplex z) {
        return this.slope(z.re(), z.im());
    }

    public PuComplex slope(double x) {
        return this.slope(x, 0.0);
    }

    public PuComplex slope(double zr, double zi) {
        if (this.m_coef == null) {
            return new PuComplex(0.0, 0.0);
        }
        int NN = this.m_coef.length;
        double dpr = this.m_coef[NN - 1].re() * (double)(NN - 1);
        double dpi = this.m_coef[NN - 1].im() * (double)(NN - 1);
        int i = NN - 2;
        while (i >= 1) {
            double temp = dpr;
            dpr = dpr * zr - dpi * zi + (double)i * this.m_coef[i].re();
            dpi = temp * zi + dpi * zr + (double)i * this.m_coef[i].im();
            --i;
        }
        return new PuComplex(dpr, dpi);
    }

    public PuComplex[] zeros() throws Exception {
        PuComplex[] zeros = null;
        if (this.m_coef != null && this.m_coef.length > 0) {
            int NN = this.m_coef.length;
            double[] Pr = new double[NN];
            double[] Pi = new double[NN];
            int i = 0;
            while (i < NN) {
                Pr[i] = this.m_coef[NN - 1 - i].re();
                Pi[i] = this.m_coef[NN - 1 - i].im();
                ++i;
            }
            zeros = this.cpoly(Pr, Pi);
        }
        return zeros;
    }

    public int hashcode() {
        if (this.m_coef == null) {
            return 0;
        }
        int length = this.m_coef.length;
        if (length > 3) {
            length = 3;
        }
        int hash = 0;
        int i = 0;
        while (i < length) {
            hash ^= this.m_coef[i].hashCode();
            ++i;
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PuComplexPoly newObj = (PuComplexPoly)obj;
        if (this.m_coef == newObj.m_coef) {
            return true;
        }
        if (this.m_coef == null) {
            return newObj.m_coef.length == 1 && newObj.m_coef[0].re() == 0.0 && newObj.m_coef[0].im() == 0.0;
        }
        if (newObj.m_coef == null) {
            return this.m_coef.length == 1 && newObj.m_coef[0].re() == 0.0 && newObj.m_coef[0].im() == 0.0;
        }
        int length = this.m_coef.length;
        if (length != newObj.m_coef.length) {
            return false;
        }
        boolean retVal = true;
        int i = 0;
        while (i < length) {
            if (!this.m_coef[i].equals(newObj.m_coef[i])) {
                retVal = false;
                break;
            }
            ++i;
        }
        return retVal;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.m_coef != null) {
            int NN = this.m_coef.length;
            if (this.m_coef[0].abs() > 1.0E-6) {
                if (Math.abs(this.m_coef[0].im()) > 1.0E-6) {
                    buffer.append(PuComplexPoly.roundedString(this.m_coef[0]));
                } else {
                    buffer.append(CP_df.format(this.m_coef[0].re()));
                }
            }
            if (NN > 1) {
                if (this.m_coef[1].abs() > 1.0E-6 && this.m_coef[0].abs() > 1.0E-6) {
                    buffer.append(" + (");
                    if (Math.abs(this.m_coef[1].im()) > 1.0E-6) {
                        buffer.append(PuComplexPoly.roundedString(this.m_coef[1]));
                    } else {
                        buffer.append(CP_df.format(this.m_coef[1].re()));
                    }
                    buffer.append(")*z");
                } else if (this.m_coef[1].abs() > 1.0E-6 && this.m_coef[0].abs() < 1.0E-6) {
                    buffer.append("(");
                    if (Math.abs(this.m_coef[1].im()) > 1.0E-6) {
                        buffer.append(PuComplexPoly.roundedString(this.m_coef[1]));
                    } else {
                        buffer.append(CP_df.format(this.m_coef[1].re()));
                    }
                    buffer.append(")*z");
                }
                int i = 2;
                while (i < NN) {
                    if (this.m_coef[i].abs() > 1.0E-6) {
                        buffer.append(" + (");
                        if (Math.abs(this.m_coef[i].im()) > 1.0E-6) {
                            buffer.append(PuComplexPoly.roundedString(this.m_coef[i]));
                        } else {
                            buffer.append(CP_df.format(this.m_coef[i].re()));
                        }
                        buffer.append(")*z^");
                        buffer.append(i);
                    }
                    ++i;
                }
            }
        } else {
            buffer.append("0.");
        }
        return buffer.toString();
    }

    private static String roundedString(PuComplex z) {
        String imStr = String.valueOf(CP_df.format(z.im)) + "*i";
        if (Math.abs(z.im - 1.0) < 1.0E-6) {
            imStr = "i";
        } else if (Math.abs(z.im + 1.0) < 1.0E-6) {
            imStr = "-i";
        } else if (Math.abs(z.im) < 1.0E-6) {
            return CP_df.format(z.re);
        }
        if (Math.abs(z.re) < 1.0E-6) {
            return imStr;
        }
        if (imStr.charAt(0) == '-') {
            return String.valueOf(CP_df.format(z.re)) + imStr;
        }
        return String.valueOf(CP_df.format(z.re)) + "+" + imStr;
    }

    public static PuComplexPoly computeComplexPoly(String poly) {
        PuComplex[] coeff = new PuComplex[100];
        Double ACCEPTABLE_TOLERANCE = 1.0E-12;
        int length = coeff.length;
        int index = 0;
        int i = 0;
        while (i < coeff.length) {
            coeff[i] = PuComplexPoly.DerivativeApprox(poly, i, 20, 1.0);
            ++i;
        }
        i = length - 1;
        while (i >= 0) {
            if (coeff[i].abs() > ACCEPTABLE_TOLERANCE) {
                index = i;
                break;
            }
            --i;
        }
        PuComplex[] coefficients = new PuComplex[index + 1];
        int i2 = 0;
        while (i2 < index + 1) {
            coefficients[i2] = coeff[i2];
            ++i2;
        }
        PuComplexPoly cpoly = new PuComplexPoly(coefficients);
        return cpoly;
    }

    public static PuComplex DerivativeApprox(String poly, int k, int n, double radius) {
        double twopi = Math.PI * 2;
        PuComplex z = new PuComplex();
        PuComplex w1 = new PuComplex();
        PuComplex w2 = new PuComplex();
        PuComplex sum = new PuComplex();
        PuComplex poly_k = new PuComplex();
        PuComplexFunction m_exp = new PuComplexFunction(1, 1);
        m_exp.setExpression("exp(i*z)");
        PuComplexFunction m_f = new PuComplexFunction(1, 1);
        m_f.setExpression(poly);
        int N = k < n ? n : n + k;
        double h = twopi / (double)N;
        int j = 1;
        while (j < N) {
            z.re = (double)j * h;
            z.im = 0.0;
            PuComplex exp = m_exp.eval(z);
            w1 = PuComplex.pow((PuComplex)exp, (int)k);
            w2 = PuComplex.mult((PuComplex)exp, (double)radius);
            PuComplex f = m_f.eval(w2);
            sum = PuComplex.add((PuComplex)sum, (PuComplex)PuComplex.div((PuComplex)f, (PuComplex)w1));
            ++j;
        }
        z.re = radius;
        z.im = 0.0;
        poly_k = PuComplex.mult((PuComplex)PuComplex.add((PuComplex)m_f.eval(z), (PuComplex)sum), (double)(h / twopi));
        return poly_k;
    }

    public static PuComplexPoly makePoly(PuComplex[] zeros, PuComplex factor) {
        String str = "";
        int i = 0;
        while (i < zeros.length - 1) {
            str = String.valueOf(str) + "(z - (" + zeros[i] + "))*";
            ++i;
        }
        str = String.valueOf(str) + "(z - (" + zeros[zeros.length - 1] + "))*" + factor;
        PuComplexPoly poly = PuComplexPoly.computeComplexPoly(str);
        return poly;
    }

    public static PuComplexPoly makeDerivative(PuComplexPoly poly) {
        int L = poly.getCoefficients().length;
        PuComplex[] derivCoeffs = new PuComplex[L - 1];
        int i = 1;
        while (i < L) {
            derivCoeffs[i - 1] = PuComplex.mult((PuComplex)poly.getCoefficients()[i], (double)i);
            ++i;
        }
        PuComplexPoly derivative = new PuComplexPoly(derivCoeffs);
        return derivative;
    }

    public Object clone() {
        PuComplexPoly newObject = null;
        try {
            newObject = (PuComplexPoly)super.clone();
            int length = this.m_coef.length;
            newObject.m_coef = new PuComplex[length];
            int i = 0;
            while (i < length) {
                newObject.m_coef[i] = new PuComplex(this.m_coef[i].re(), this.m_coef[i].im());
                ++i;
            }
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return newObject;
    }

    protected PuComplex[] cpoly(double[] Pr, double[] Pi) throws Exception {
        int i;
        int NN = Pr.length;
        int degree = NN - 1;
        if (Pr[0] == 0.0 && Pi[0] == 0.0) {
            throw new Exception("Leading coefficient is zero.");
        }
        double[] Hr = new double[NN];
        double[] Hi = new double[NN];
        double[] QPr = new double[NN];
        double[] QPi = new double[NN];
        double[] QHr = new double[NN];
        double[] QHi = new double[NN];
        double[] SHr = new double[NN];
        double[] SHi = new double[NN];
        PuComplex[] zeros = new PuComplex[degree];
        double XX = Math.sqrt(2.0) / 2.0;
        double YY = -XX;
        int idNN2 = 0;
        while (Pr[NN - 1] == 0.0 && Pi[NN - 1] == 0.0) {
            idNN2 = degree - NN + 1;
            zeros[idNN2] = new PuComplex(0.0, 0.0);
            --NN;
        }
        int i2 = 0;
        while (i2 < NN) {
            SHr[i2] = PuComplexPoly.cmod(Pr[i2], Pi[i2]);
            ++i2;
        }
        double bound = PuComplexPoly.scale(NN, SHr);
        if (bound != 1.0) {
            i = 0;
            while (i < NN) {
                int n = i;
                Pr[n] = Pr[n] * bound;
                int n2 = i++;
                Pi[n2] = Pi[n2] * bound;
            }
        }
        block3: while (true) {
            if (NN <= 2) {
                this.cdiv(-Pr[1], -Pi[1], Pr[0], Pi[0]);
                zeros[degree - 1] = new PuComplex(this.m_Tr, this.m_Ti);
                return zeros;
            }
            i = 0;
            while (i < NN) {
                SHr[i] = PuComplexPoly.cmod(Pr[i], Pi[i]);
                ++i;
            }
            bound = PuComplexPoly.cauchy(NN, SHr, SHi);
            int cnt1 = 0;
            while (cnt1 < 2) {
                this.noShift(NN, 5, Pr, Pi, Hr, Hi);
                int cnt2 = 0;
                while (cnt2 < 9) {
                    double XXX = -0.060756474 * XX - 0.99756405 * YY;
                    YY = 0.99756405 * XX - -0.060756474 * YY;
                    XX = XXX;
                    this.m_Sr = bound * XX;
                    this.m_Si = bound * YY;
                    boolean conv = this.fxShift(NN, 10 * cnt2, Pr, Pi, QPr, QPi, Hr, Hi, QHr, QHi, SHr, SHi);
                    if (conv) {
                        idNN2 = degree - NN + 1;
                        zeros[idNN2] = new PuComplex(this.m_Zr, this.m_Zi);
                        --NN;
                        int i3 = 0;
                        while (true) {
                            if (i3 >= NN) continue block3;
                            Pr[i3] = QPr[i3];
                            Pi[i3] = QPi[i3];
                            ++i3;
                        }
                    }
                    ++cnt2;
                }
                ++cnt1;
            }
            break;
        }
        throw new Exception("Found fewer than " + degree + " zeros.");
    }

    private void polyEv(int NN, double Sr, double Si, double[] Pr, double[] Pi, double[] Qr, double[] Qi) {
        double pvr = Qr[0] = Pr[0];
        double pvi = Qi[0] = Pi[0];
        int i = 1;
        while (i < NN) {
            double temp = pvr;
            pvr = pvr * Sr - pvi * Si + Pr[i];
            pvi = temp * Si + pvi * Sr + Pi[i];
            Qr[i] = pvr;
            Qi[i] = pvi;
            ++i;
        }
        this.m_PVr = pvr;
        this.m_PVi = pvi;
    }

    private static double errEv(int NN, double[] Qr, double[] Qi, double MS, double MP, double ARE, double MRE) {
        double E = PuComplexPoly.cmod(Qr[0], Qi[0]) * MRE / (ARE + MRE);
        int i = 0;
        while (i < NN) {
            E = E * MS + PuComplexPoly.cmod(Qr[i], Qi[i]);
            ++i;
        }
        return E * (ARE + MRE) - MP * MRE;
    }

    private static double cauchy(int NN, double[] PT, double[] Q) {
        double F;
        double XM;
        int NNm1 = NN - 1;
        PT[NNm1] = -PT[NNm1];
        int N = NN - 1;
        int Nm1 = N - 1;
        double X = Math.exp((Math.log(-PT[NNm1]) - Math.log(PT[0])) / (double)N);
        if (PT[Nm1] != 0.0 && (XM = -PT[NNm1] / PT[Nm1]) < X) {
            X = XM;
        }
        while (true) {
            XM = X * 0.1;
            F = PT[0];
            int i = 1;
            while (i < NN) {
                F = F * XM + PT[i];
                ++i;
            }
            if (F <= 0.0) break;
            X = XM;
        }
        double DX = X;
        while (Math.abs(DX / X) > 0.005) {
            Q[0] = PT[0];
            int i = 1;
            while (i < NN) {
                Q[i] = Q[i - 1] * X + PT[i];
                ++i;
            }
            F = Q[NNm1];
            double DF = Q[0];
            int i2 = 1;
            while (i2 < N) {
                DF = DF * X + Q[i2];
                ++i2;
            }
            DX = F / DF;
            X -= DX;
        }
        return X;
    }

    private static double scale(int NN, double[] PT) {
        double sc;
        double X;
        double hi = Math.sqrt(Double.MAX_VALUE);
        double lo = CP_SMALNO / CP_ETA;
        double max = 0.0;
        double min = Double.MAX_VALUE;
        int i = 0;
        while (i < NN) {
            X = PT[i];
            if (X > max) {
                max = X;
            }
            if (X != 0.0 && X < min) {
                min = X;
            }
            ++i;
        }
        double scale = 1.0;
        if (min >= lo && max <= hi) {
            return scale;
        }
        X = lo / min;
        if (X > 1.0) {
            sc = X;
            if (Double.MAX_VALUE / sc > max) {
                sc = 1.0;
            }
        } else {
            sc = 1.0 / Math.sqrt(max * min);
        }
        double L = Math.log(sc) / Math.log(2.0) + 0.5;
        scale = Math.pow(2.0, L);
        return scale;
    }

    private void cdiv(double Ar, double Ai, double Br, double Bi) {
        if (Br == 0.0 && Bi == 0.0) {
            this.m_Tr = Double.MAX_VALUE;
            this.m_Ti = Double.MAX_VALUE;
            return;
        }
        if (Math.abs(Br) >= Math.abs(Bi)) {
            double R = Bi / Br;
            double D = Br + R * Bi;
            this.m_Tr = (Ar + Ai * R) / D;
            this.m_Ti = (Ai - Ar * R) / D;
        } else {
            double R = Br / Bi;
            double D = Bi + R * Br;
            this.m_Tr = (Ar * R + Ai) / D;
            this.m_Ti = (Ai * R - Ar) / D;
        }
    }

    private static double cmod(double re, double im) {
        double ans = 0.0;
        re = Math.abs(re);
        im = Math.abs(im);
        if (re == 0.0) {
            ans = im;
        } else if (im == 0.0) {
            ans = re;
        } else if (re > im) {
            double temp = im / re;
            ans = re * Math.sqrt(1.0 + temp * temp);
        } else {
            double temp = re / im;
            ans = im * Math.sqrt(1.0 + temp * temp);
        }
        return ans;
    }

    private void noShift(int NN, int L1, double[] Pr, double[] Pi, double[] Hr, double[] Hi) {
        int N = NN - 1;
        int Nm1 = N - 1;
        int NNm1 = NN - 1;
        int i = 0;
        while (i < N) {
            double XNi = NNm1 - i;
            Hr[i] = XNi * Pr[i] / (double)N;
            Hi[i] = XNi * Pi[i] / (double)N;
            ++i;
        }
        int jj = 0;
        while (jj < L1) {
            int j;
            int i2;
            if (PuComplexPoly.cmod(Hr[Nm1], Hi[Nm1]) - CP_ETA * 10.0 * PuComplexPoly.cmod(Pr[Nm1], Pi[Nm1]) > 1.0E-12) {
                this.cdiv(-Pr[NNm1], -Pi[NNm1], Hr[Nm1], Hi[Nm1]);
                i2 = 1;
                while (i2 <= Nm1) {
                    j = NNm1 - i2;
                    double T1 = Hr[j - 1];
                    double T2 = Hi[j - 1];
                    Hr[j] = this.m_Tr * T1 - this.m_Ti * T2 + Pr[j];
                    Hi[j] = this.m_Tr * T2 + this.m_Ti * T1 + Pi[j];
                    ++i2;
                }
                Hr[0] = Pr[0];
                Hi[0] = Pi[0];
            } else {
                i2 = 1;
                while (i2 <= Nm1) {
                    j = NNm1 - i2;
                    Hr[j] = Hr[j - 1];
                    Hi[j] = Hi[j - 1];
                    ++i2;
                }
                Hr[0] = 0.0;
                Hi[0] = 0.0;
            }
            ++jj;
        }
    }

    private boolean calcT(int NN, double Sr, double Si, double[] Hr, double[] Hi, double[] QHr, double[] QHi) {
        boolean bool;
        int N = NN - 1;
        int Nm1 = N - 1;
        double tempR = this.m_PVr;
        double tempI = this.m_PVi;
        this.polyEv(N, Sr, Si, Hr, Hi, QHr, QHi);
        double HVr = this.m_PVr;
        double HVi = this.m_PVi;
        this.m_PVr = tempR;
        this.m_PVi = tempI;
        boolean bl = bool = PuComplexPoly.cmod(HVr, HVi) - CP_ARE * 10.0 * PuComplexPoly.cmod(Hr[Nm1], Hi[Nm1]) <= 1.0E-12;
        if (bool) {
            this.m_Tr = 0.0;
            this.m_Ti = 0.0;
        } else {
            this.cdiv(-this.m_PVr, -this.m_PVi, HVr, HVi);
        }
        return bool;
    }

    private void nextH(int NN, boolean bool, double[] Hr, double[] Hi, double[] QPr, double[] QPi, double[] QHr, double[] QHi) {
        int N = NN - 1;
        if (!bool) {
            int j = 1;
            while (j < N) {
                double T1 = QHr[j - 1];
                double T2 = QHi[j - 1];
                Hr[j] = this.m_Tr * T1 - this.m_Ti * T2 + QPr[j];
                Hi[j] = this.m_Tr * T2 + this.m_Ti * T1 + QPi[j];
                ++j;
            }
            Hr[0] = QPr[0];
            Hi[0] = QPi[0];
        } else {
            int j = 1;
            while (j < N) {
                Hr[j] = QHr[j - 1];
                Hi[j] = QHi[j - 1];
                ++j;
            }
            Hr[0] = 0.0;
            Hi[0] = 0.0;
        }
    }

    private boolean vrShift(int NN, int L3, double[] Pr, double[] Pi, double[] QPr, double[] QPi, double[] Hr, double[] Hi, double[] QHr, double[] QHi) {
        boolean conv = false;
        boolean B = false;
        boolean bool = false;
        double OMP = 0.0;
        double RelSTP = 0.0;
        this.m_Sr = this.m_Zr;
        this.m_Si = this.m_Zi;
        int i = 0;
        while (i < L3) {
            this.polyEv(NN, this.m_Sr, this.m_Si, Pr, Pi, QPr, QPi);
            double MP = PuComplexPoly.cmod(this.m_PVr, this.m_PVi);
            double MS = PuComplexPoly.cmod(this.m_Sr, this.m_Si);
            if (MP <= 20.0 * PuComplexPoly.errEv(NN, QPr, QPi, MS, MP, CP_ARE, CP_MRE)) {
                this.m_Zr = this.m_Sr;
                this.m_Zi = this.m_Si;
                return true;
            }
            if (i == 0) {
                OMP = MP;
            } else if (!B && MP >= OMP && RelSTP < 0.05) {
                double TP = RelSTP;
                B = true;
                if (RelSTP < CP_ETA) {
                    TP = CP_ETA;
                }
                double R1 = Math.sqrt(TP);
                double R2 = this.m_Sr * (1.0 + R1) - this.m_Si * R1;
                this.m_Si = this.m_Sr * R1 + this.m_Si * (1.0 + R1);
                this.m_Sr = R2;
                this.polyEv(NN, this.m_Sr, this.m_Si, Pr, Pi, QPr, QPi);
                int j = 0;
                while (j < 5) {
                    bool = this.calcT(NN, this.m_Sr, this.m_Si, Hr, Hi, QHr, QHi);
                    this.nextH(NN, bool, Hr, Hi, QPr, QPi, QHr, QHi);
                    ++j;
                }
                OMP = Double.MAX_VALUE;
            } else {
                if (MP * 0.1 > OMP) {
                    return conv;
                }
                OMP = MP;
            }
            bool = this.calcT(NN, this.m_Sr, this.m_Si, Hr, Hi, QHr, QHi);
            this.nextH(NN, bool, Hr, Hi, QPr, QPi, QHr, QHi);
            bool = this.calcT(NN, this.m_Sr, this.m_Si, Hr, Hi, QHr, QHi);
            if (!bool) {
                RelSTP = PuComplexPoly.cmod(this.m_Tr, this.m_Ti) / PuComplexPoly.cmod(this.m_Sr, this.m_Si);
                this.m_Sr += this.m_Tr;
                this.m_Si += this.m_Ti;
            }
            ++i;
        }
        return conv;
    }

    private boolean fxShift(int NN, int L2, double[] Pr, double[] Pi, double[] QPr, double[] QPi, double[] Hr, double[] Hi, double[] QHr, double[] QHi, double[] SHr, double[] SHi) {
        boolean conv = false;
        int N = NN - 1;
        this.polyEv(NN, this.m_Sr, this.m_Si, Pr, Pi, QPr, QPi);
        boolean test = true;
        boolean pasd = false;
        boolean bool = this.calcT(NN, this.m_Sr, this.m_Si, Hr, Hi, QHr, QHi);
        int j = 0;
        while (j < L2) {
            double OTr = this.m_Tr;
            double OTi = this.m_Ti;
            this.nextH(NN, bool, Hr, Hi, QPr, QPi, QHr, QHi);
            bool = this.calcT(NN, this.m_Sr, this.m_Si, Hr, Hi, QHr, QHi);
            this.m_Zr = this.m_Sr + this.m_Tr;
            this.m_Zi = this.m_Si + this.m_Ti;
            if (!bool && test && j != L2 - 1) {
                if (PuComplexPoly.cmod(this.m_Tr - OTr, this.m_Ti - OTi) < 0.5 * PuComplexPoly.cmod(this.m_Zr, this.m_Zi)) {
                    if (pasd) {
                        int i = 0;
                        while (i < N) {
                            SHr[i] = Hr[i];
                            SHi[i] = Hi[i];
                            ++i;
                        }
                        double SVSr = this.m_Sr;
                        double SVSi = this.m_Si;
                        conv = this.vrShift(NN, 10, Pr, Pi, QPr, QPi, Hr, Hi, QHr, QHi);
                        if (conv) {
                            return conv;
                        }
                        test = false;
                        int i2 = 0;
                        while (i2 < N) {
                            Hr[i2] = SHr[i2];
                            Hi[i2] = SHi[i2];
                            ++i2;
                        }
                        this.m_Sr = SVSr;
                        this.m_Si = SVSi;
                        this.polyEv(NN, this.m_Sr, this.m_Si, Pr, Pi, QPr, QPi);
                        bool = this.calcT(NN, this.m_Sr, this.m_Si, Hr, Hi, QHr, QHi);
                    } else {
                        pasd = true;
                    }
                } else {
                    pasd = false;
                }
            }
            ++j;
        }
        conv = this.vrShift(NN, 10, Pr, Pi, QPr, QPi, Hr, Hi, QHr, QHi);
        return conv;
    }
}

