/*
 * Decompiled with CFR 0.152.
 */
package devFundamentalsatz;

import devFundamentalsatz.PjFundamentalsatz;
import devFundamentalsatz.PuPolygonUtil;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsDialog;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;
import jv.objectGui.PsMultiLineLabel;
import jv.objectGui.PsTabPanel;
import jv.project.PjProject_IP;

public class PjFundamentalsatz_IP
extends PjProject_IP
implements ItemListener,
ActionListener {
    protected PjFundamentalsatz m_pjFundamentalsatz;
    private static final Color LIGHT_BLUE = new Color(220, 235, 255);
    protected PsMultiLineLabel m_pExplainTxt;
    protected TextField m_tfFunctionDefinition;
    protected List m_lExamples;
    protected Label m_labWindingNumber;
    protected Button m_bConfigSegmentColor;
    protected Button m_bConfigCircleColor;
    private Checkbox m_cModeFlat;
    private Checkbox m_cModePerspective;
    private Checkbox m_cCircle;
    private Checkbox m_cSquare;
    private Checkbox m_cNgon;
    private static final String[] EXAMPLE_FUNCTIONS = new String[]{"z", "z^2", "z^3+2*z^2-4", "z^5+z", "5*z^10+3*z^9+2*z^7+3*z^6+2*z^3+3*z^2", "2*z^10+6*z^2+6*z^1", "9*z^10+8*z^1", "2*z^10+5*z^6+2*z^3+9*z^2", "5*z^10+4*z^7+3*z^4+8*z^1", "Random"};

    public PjFundamentalsatz_IP() {
        if (this.getClass() == PjFundamentalsatz_IP.class) {
            this.init();
        }
        this.m_pExplainTxt = new PsMultiLineLabel(PsConfig.getMessage((boolean)true, (int)88000, (String)"Applet visualizing transformations induced by complex polynomials. When computation of zeros is enabled, you can interactively add, remove and move the zeros determining a polynomial.\n Press and click in left hand window: \n\t'a' to add new polynomial zeros,\n\t'p' to pick a zero and move it,\n\t'm' to mark one or more zeros and Method -> Delete -> Remove Marked Vertices, to delete them.\n"));
        this.add((Component)this.m_pExplainTxt, "North");
        this.m_tfFunctionDefinition = new TextField("z");
        this.m_tfFunctionDefinition.setBackground(LIGHT_BLUE);
        this.m_tfFunctionDefinition.addActionListener(this);
        this.m_bConfigSegmentColor = new Button("Segment Color");
        this.m_bConfigSegmentColor.addActionListener(this);
        this.m_bConfigSegmentColor.setEnabled(false);
        this.m_bConfigCircleColor = new Button("Polygon Color");
        this.m_bConfigCircleColor.addActionListener(this);
        this.m_labWindingNumber = new Label("");
        this.m_lExamples = new List();
        int i = 0;
        while (i < EXAMPLE_FUNCTIONS.length) {
            this.m_lExamples.add(EXAMPLE_FUNCTIONS[i]);
            ++i;
        }
        this.m_lExamples.select(0);
        this.m_lExamples.addItemListener(this);
        PsPanel pFunction = new PsPanel();
        pFunction.addTitle("Polynomial");
        pFunction.add((Component)this.m_tfFunctionDefinition);
        this.add((Component)pFunction);
        PsPanel pExamples = new PsPanel();
        pExamples.addTitle("Examples");
        pExamples.add((Component)this.m_lExamples);
        this.add((Component)pExamples);
        PsPanel pWindingInfoZero = new PsPanel((LayoutManager)new GridLayout(1, 2));
        pWindingInfoZero.add((Component)new Label("Winding number at zero:"));
        pWindingInfoZero.add((Component)this.m_labWindingNumber);
        this.add((Component)pWindingInfoZero);
    }

    public void init() {
        super.init();
    }

    public void setParent(PsUpdateIf parent) {
        super.setParent(parent);
        this.m_pjFundamentalsatz = (PjFundamentalsatz)parent;
        this.m_pjFundamentalsatz.m_showFilledSegements.addUpdateListener((PsUpdateIf)this);
        PsTabPanel tabPanel = new PsTabPanel();
        PsPanel pShape = new PsPanel();
        CheckboxGroup cbgShapes = new CheckboxGroup();
        this.m_cCircle = new Checkbox("Circle", true, cbgShapes);
        this.m_cCircle.addItemListener(this);
        this.m_cSquare = new Checkbox("Square", false, cbgShapes);
        this.m_cSquare.addItemListener(this);
        this.m_cNgon = new Checkbox("N-gon", false, cbgShapes);
        this.m_cNgon.addItemListener(this);
        pShape.add((Component)this.m_cCircle);
        pShape.add((Component)this.m_cSquare);
        Panel pNgon = new Panel(new GridLayout(2, 1));
        pNgon.add(this.m_cNgon);
        PsPanel pNgonIP = this.m_pjFundamentalsatz.m_numOfNgonCorners.getInfoPanel();
        pNgonIP.setEnabled(false);
        pNgon.add((Component)pNgonIP);
        pShape.add((Component)pNgon);
        pShape.addLine(1);
        pShape.add((Component)this.m_pjFundamentalsatz.m_radius.getInfoPanel());
        pShape.addLine(1);
        tabPanel.addPanel("Shape", pShape);
        PsPanel pDisplay = new PsPanel();
        PsPanel pFeatures = new PsPanel();
        pFeatures.addTitle("Features");
        pFeatures.add((Component)this.m_pjFundamentalsatz.m_enableZeros.getInfoPanel());
        pFeatures.add((Component)this.m_pjFundamentalsatz.m_showCovering.getInfoPanel());
        pDisplay.add((Component)pFeatures);
        PsPanel pMode = new PsPanel((LayoutManager)new GridLayout(3, 1));
        pMode.addTitle("Set Display Mode");
        CheckboxGroup cbgModes = new CheckboxGroup();
        this.m_cModeFlat = new Checkbox("Flat", true, cbgModes);
        this.m_cModeFlat.addItemListener(this);
        this.m_cModePerspective = new Checkbox("Perspective", false, cbgModes);
        this.m_cModePerspective.addItemListener(this);
        pMode.add((Component)this.m_cModeFlat);
        pMode.add((Component)this.m_cModePerspective);
        pDisplay.add((Component)pMode);
        PsPanel pBackground = new PsPanel();
        pBackground.addTitle("Fill Segments");
        Panel p = new Panel(new GridLayout(1, 2));
        p.add((Component)this.m_pjFundamentalsatz.m_showFilledSegements.newInspector("_IP"));
        p.add(this.m_bConfigSegmentColor);
        pBackground.add((Component)p);
        pDisplay.add((Component)pBackground);
        PsPanel pColors = new PsPanel();
        pColors.addTitle("Color Settings");
        PsPanel pCB = new PsPanel((LayoutManager)new GridLayout(1, 2));
        pCB.add((Component)this.m_bConfigCircleColor);
        pColors.add((Component)pCB);
        pDisplay.add((Component)pColors);
        tabPanel.addPanel("Display", pDisplay);
        this.add((Component)tabPanel);
        this.m_pjFundamentalsatz.m_WindingNumber.addUpdateListener((PsUpdateIf)this);
        this.m_pjFundamentalsatz.m_polyZerosPS.addUpdateListener((PsUpdateIf)this);
        this.validate();
    }

    public boolean update(Object event) {
        if (this.m_pjFundamentalsatz.m_WindingNumber == event) {
            int wnZero = this.m_pjFundamentalsatz.m_WindingNumber.getValue();
            this.m_labWindingNumber.setText(Integer.toString(wnZero));
            return true;
        }
        if (this.m_pjFundamentalsatz == event) {
            return true;
        }
        if (this.m_pjFundamentalsatz.m_polyZerosPS == event) {
            String str = this.m_pjFundamentalsatz.m_function.getExpression();
            this.m_tfFunctionDefinition.setText(str);
            return true;
        }
        if (this.m_pjFundamentalsatz.m_showFilledSegements == event) {
            this.m_bConfigSegmentColor.setEnabled(this.m_pjFundamentalsatz.m_showFilledSegements.getState());
            return true;
        }
        return super.update(event);
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        Object s = event.getSource();
        if (s == this.m_lExamples) {
            String expr;
            if (this.m_lExamples.getSelectedIndex() == this.m_lExamples.getItemCount() - 1) {
                expr = PuPolygonUtil.generateRandomPolynomialString(5, 9);
                this.m_pjFundamentalsatz.m_function.setExpression(expr);
                expr = this.m_pjFundamentalsatz.integrate();
                this.m_pjFundamentalsatz.m_function.setExpression(expr);
            } else {
                expr = this.m_lExamples.getSelectedItem();
                this.m_pjFundamentalsatz.m_function.setExpression(expr);
            }
            this.m_tfFunctionDefinition.setText(expr);
            this.m_pjFundamentalsatz.update(this.m_pjFundamentalsatz.m_function);
        } else if (s == this.m_cModeFlat) {
            this.m_pjFundamentalsatz.setMode(0);
        } else if (s == this.m_cModePerspective) {
            this.m_pjFundamentalsatz.setMode(1);
        } else if (s == this.m_cCircle) {
            this.m_pjFundamentalsatz.setShape(0);
            this.m_pjFundamentalsatz.m_numOfNgonCorners.getInfoPanel().setEnabled(false);
        } else if (s == this.m_cSquare) {
            this.m_pjFundamentalsatz.setShape(1);
            this.m_pjFundamentalsatz.m_numOfNgonCorners.getInfoPanel().setEnabled(false);
        } else if (s == this.m_cNgon) {
            this.m_pjFundamentalsatz.setShape(2);
            this.m_pjFundamentalsatz.m_numOfNgonCorners.getInfoPanel().setEnabled(true);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.m_tfFunctionDefinition) {
            String expr = this.m_tfFunctionDefinition.getText();
            this.m_pjFundamentalsatz.m_function.setExpression(expr);
            this.m_pjFundamentalsatz.update(this.m_pjFundamentalsatz.m_function);
            this.m_lExamples.deselect(this.m_lExamples.getSelectedIndex());
        } else if (o == this.m_bConfigSegmentColor) {
            PsPanel infoPanel = this.m_pjFundamentalsatz.m_segmentColor.getInfoPanel();
            if (infoPanel == null) {
                PsDebug.warning((String)"Could not open config panel for color scheme");
                return;
            }
            this.createDlgPopup(infoPanel);
        } else if (o == this.m_bConfigCircleColor) {
            PsPanel infoPanel = this.m_pjFundamentalsatz.m_polygonColor.getInfoPanel();
            if (infoPanel == null) {
                PsDebug.warning((String)"Could not open config panel for color scheme");
                return;
            }
            this.createDlgPopup(infoPanel);
        }
    }

    private void createDlgPopup(PsPanel infoPanel) {
        PsDialog dlgConfig = new PsDialog(PsConfig.getFrame(), false);
        dlgConfig.add((Component)infoPanel);
        Panel pButtons = dlgConfig.getBottomButtons(5);
        dlgConfig.add((Component)pButtons, (Object)"South");
        dlgConfig.setParent((PsUpdateIf)this);
        dlgConfig.pack();
        dlgConfig.setVisible(true);
    }
}

