/*
 * Decompiled with CFR 0.152.
 */
package devFundamentalsatz;

import devDomainColoring.colors.PuColorUtil;
import devDomainColoring.colors.schemes.PuCSCustomColorWheel2d;
import devFundamentalsatz.PuComplexPoly;
import devFundamentalsatz.PuPolygonUtil;
import java.awt.Color;
import java.util.Random;
import jv.function.PuComplexFunction;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgPolygon;
import jv.number.PuBoolean;
import jv.number.PuComplex;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsDebug;
import jv.object.PsUpdateIf;
import jv.project.PgGeometryIf;
import jv.project.PjProject;
import jv.project.PvDisplayIf;
import jv.project.PvViewerIf;
import jv.vecmath.PdVector;
import jv.viewer.PvDisplay;

public class PjFundamentalsatz
extends PjProject {
    protected static final int MODE_FLAT = 0;
    protected static final int MODE_PERSPECTIVE = 1;
    public static final int SHAPE_CIRCLE = 0;
    public static final int SHAPE_SQUARE = 1;
    public static final int SHAPE_NGON = 2;
    protected static final double EPS = 0.15;
    protected static final double PHI = 0.618033988749895;
    protected static final int CIRCLE_RESOLUTION = 400;
    protected static final int DISC_RESOLUTION = 200;
    protected static final int LOOPS_RESOLUTION = 75;
    private static final int NGON_RES = 100;
    private static final int SQUARE_RES_X = 250;
    private static final int SQUARE_RES_Y = 250;
    protected static final int BACKGROUND_RES_X = 250;
    protected static final int BACKGROUND_RES_Y = 250;
    protected static final double POLYGON_EDGE_SIZE = 12.0;
    protected static final double POLY_ZERO_SIZE = 18.0;
    private static final Color BRANCHPOINT_COLOR = new Color(214, 0, 136);
    private static final Color RAMIFICATIONPOINT_COLOR = new Color(214, 0, 136);
    private static final Color ZERO_COLOR = new Color(85, 85, 85);
    protected Color[] SEGMENT_COLORS;
    protected PgPolygon m_polygon;
    protected PgPolygon m_transformedPolygon;
    protected PgElementSet m_disc;
    protected PgElementSet m_transformedDisc;
    protected PgPointSet m_polyZerosPS;
    protected PgPointSet m_constTermPS;
    protected PgPointSet m_ramificationPtsPS;
    protected PgPointSet m_branchPtsPS;
    protected PgElementSet m_background;
    protected PuComplexFunction m_function = new PuComplexFunction(1, 1);
    protected PuComplexPoly m_polynomial;
    protected PuComplex[] m_polyZeros;
    protected PuComplex m_constTerm;
    protected PuComplex[] m_ramificationPts;
    protected PuComplex[] m_branchPts;
    protected PuInteger m_WindingNumber;
    protected PuDouble m_radius;
    protected PuInteger m_numOfNgonCorners;
    protected PuBoolean m_showFilledSegements;
    protected PuBoolean m_showCovering;
    protected PuBoolean m_enableZeros;
    private int m_shapeMode;
    private int m_mode;
    public PuCSCustomColorWheel2d m_segmentColor;
    public PuCSCustomColorWheel2d m_polygonColor;
    private PvDisplay m_dispDomain;
    private PvDisplay m_dispRange;

    public PjFundamentalsatz() {
        super("Fundamentalsatz");
        this.m_function.setParent((PsUpdateIf)this);
        this.m_segmentColor = new PuCSCustomColorWheel2d();
        this.m_polygonColor = new PuCSCustomColorWheel2d();
        this.m_polygonColor.addUpdateListener((PsUpdateIf)this);
        this.m_radius = new PuDouble("Radius");
        this.m_radius.setDefBounds(0.1, 50.0, 0.05, 1.0);
        this.m_radius.setDefValue(1.0);
        this.m_radius.init();
        this.m_radius.addUpdateListener((PsUpdateIf)this);
        this.m_numOfNgonCorners = new PuInteger("N");
        this.m_numOfNgonCorners.addUpdateListener((PsUpdateIf)this);
        this.m_numOfNgonCorners.setDefBounds(3, 32, 1, 4);
        this.m_numOfNgonCorners.setDefValue(4);
        this.m_numOfNgonCorners.init();
        this.m_polygon = new PgPolygon(3);
        this.m_polygon.setName("Polygon");
        this.computePolygon(this.m_polygon, this.m_radius.getValue(), false);
        this.m_polygon.setGlobalEdgeSize(12.0);
        this.m_polygon.showVertices(false);
        this.m_polygon.showVertexColors(true);
        this.m_polygon.showEdgeColors(true);
        this.m_polygon.makeVertexColorsFromXYZ();
        this.m_polygon.makeEdgeFromVertexColors();
        this.m_transformedPolygon = new PgPolygon(3);
        this.m_transformedPolygon.setName("Transformed Polygon");
        this.computePolygon(this.m_transformedPolygon, this.m_radius.getValue(), true);
        this.m_transformedPolygon.setGlobalEdgeSize(12.0);
        this.m_transformedPolygon.showVertices(false);
        this.m_transformedPolygon.showVertexColors(true);
        this.m_transformedPolygon.showEdgeColors(true);
        this.m_transformedPolygon.makeVertexColorsFromXYZ();
        this.m_transformedPolygon.makeEdgeFromVertexColors();
        this.m_disc = new PgElementSet(3);
        this.m_disc.setName("Domain Disc");
        this.m_disc.computeDisk(200, 200, this.m_radius.getValue());
        this.m_disc.makeVertexColorsFromXYZ();
        this.m_disc.showVertices(false);
        this.m_disc.showEdges(false);
        this.m_disc.showElementColors(true);
        this.m_disc.makeElementFromVertexColors();
        this.m_transformedDisc = new PgElementSet(3);
        this.m_transformedDisc.setName("Transformed Domain Disc");
        this.m_transformedDisc.computeDisk(200, 200, this.m_radius.getValue());
        this.m_transformedDisc.setVertexColors(this.m_disc.getVertexColors());
        this.m_transformedDisc.showVertices(false);
        this.m_transformedDisc.showEdges(false);
        this.m_transformedDisc.showElementColors(true);
        this.m_transformedDisc.makeElementFromVertexColors();
        this.m_transformedDisc.showTransparency(true);
        this.m_background = new PgElementSet(2);
        this.m_background.setName("Background");
        this.m_background.showVertices(false);
        this.m_background.showEdges(false);
        this.m_background.showVertexColors(true);
        this.m_background.showElementColors(true);
        this.m_background.setVisible(false);
        this.m_WindingNumber = new PuInteger("Winding Number at Zero");
        this.m_WindingNumber.setValue(0);
        this.m_polyZeros = new PuComplex[100];
        this.m_polyZerosPS = new PgPointSet(3);
        this.m_polyZerosPS.setName("Polynomial Zeros");
        this.m_polyZerosPS.setGlobalVertexColor(ZERO_COLOR);
        this.m_polyZerosPS.setGlobalVertexSize(18.0);
        this.m_polyZerosPS.addUpdateListener((PsUpdateIf)this);
        this.m_ramificationPts = new PuComplex[100];
        this.m_ramificationPtsPS = new PgPointSet(3);
        this.m_ramificationPtsPS.setName("Ramification Points");
        this.m_ramificationPtsPS.setGlobalVertexColor(RAMIFICATIONPOINT_COLOR);
        this.m_ramificationPtsPS.setGlobalVertexSize(4.0);
        this.m_branchPts = new PuComplex[100];
        this.m_branchPtsPS = new PgPointSet(3);
        this.m_branchPtsPS.setName("Branch Points");
        this.m_branchPtsPS.setGlobalVertexColor(BRANCHPOINT_COLOR);
        this.m_branchPtsPS.setGlobalVertexSize(0.7);
        this.m_constTerm = new PuComplex(0.0, 0.0);
        this.m_constTermPS = new PgPointSet(3);
        this.m_constTermPS.setName("Constant Term");
        this.m_constTermPS.setNumVertices(1);
        this.m_constTermPS.setGlobalVertexSize(1.0);
        this.m_constTermPS.setGlobalVertexColor(Color.BLUE);
        this.m_showFilledSegements = new PuBoolean("Fill Segments", (PsUpdateIf)this);
        this.m_showCovering = new PuBoolean("Show Covering (experimental)", (PsUpdateIf)this);
        this.m_enableZeros = new PuBoolean("Enable Zeros", (PsUpdateIf)this);
        Color start = new Color(0.52f, 0.02f, 0.66f);
        Color end = new Color(0.02f, 0.51f, 0.62f);
        this.SEGMENT_COLORS = PuColorUtil.createLinearPalette(new Color[]{Color.white, start, end}, 15);
        if (((Object)((Object)this)).getClass() == PjFundamentalsatz.class) {
            this.init();
        }
    }

    public void init() {
        this.m_showCovering.setState(false);
        this.m_enableZeros.setState(false);
        this.m_polygon.setVisible(true);
        this.m_transformedPolygon.setVisible(true);
        this.m_disc.setVisible(this.m_showCovering.getState());
        this.m_transformedDisc.setVisible(this.m_showCovering.getState());
        this.m_constTermPS.setVisible(this.m_enableZeros.getState());
        this.m_branchPtsPS.setVisible(this.m_enableZeros.getState());
        this.computePolygonColors();
        this.m_mode = 0;
        super.init();
    }

    public void start() {
        this.m_dispDomain = (PvDisplay)this.getDispDomain();
        if (this.m_dispDomain != null) {
            this.m_dispDomain.setMajorMode(6);
            this.m_dispDomain.setBackgroundColor(Color.white);
            this.m_dispDomain.selectCamera(1);
            this.m_dispDomain.showAxes(true);
            this.m_dispDomain.getAxes().setAxesColor(Color.black);
            this.m_dispDomain.getAxes().setAxesSize(2.0);
            this.m_dispDomain.getAxes().showNames(false);
            this.m_dispDomain.getAxes().showLabels(false);
            this.m_dispDomain.getAxes().showMinorHashings(false);
            this.m_dispDomain.setLightingModel(0);
            this.m_dispDomain.setEnabled3DLook(true);
            this.m_dispDomain.showScenegraph(false);
        }
        if (this.m_dispRange != null) {
            this.m_dispRange.selectCamera(1);
            this.m_dispRange.setMajorMode(6);
            this.m_dispRange.setBackgroundColor(Color.white);
            this.m_dispRange.showAxes(true);
            this.m_dispRange.getAxes().setAxesColor(Color.black);
            this.m_dispRange.getAxes().setAxesSize(2.0);
            this.m_dispRange.getAxes().showNames(false);
            this.m_dispRange.getAxes().showLabels(false);
            this.m_dispRange.getAxes().showMinorHashings(false);
            this.m_dispRange.setLightingModel(0);
            this.m_dispRange.setEnabled3DLook(true);
            this.m_dispRange.showScenegraph(false);
        }
        this.m_dispDomain.addGeometry((PgGeometryIf)this.m_polygon);
        this.m_dispDomain.addGeometry((PgGeometryIf)this.m_disc);
        this.m_dispDomain.addGeometry((PgGeometryIf)this.m_polyZerosPS);
        this.m_dispDomain.addGeometry((PgGeometryIf)this.m_ramificationPtsPS);
        this.m_dispDomain.selectGeometry((PgGeometryIf)this.m_polyZerosPS);
        this.m_dispRange.addGeometry((PgGeometryIf)this.m_transformedPolygon);
        this.m_dispRange.addGeometry((PgGeometryIf)this.m_transformedDisc);
        this.m_dispRange.addGeometry((PgGeometryIf)this.m_constTermPS);
        this.m_dispRange.addGeometry((PgGeometryIf)this.m_branchPtsPS);
        this.m_dispRange.addGeometry((PgGeometryIf)this.m_background);
        this.setMode(this.m_mode);
        if (this.m_enableZeros.getState()) {
            this.computePolyZeros();
            this.computePolyBranchPts();
        }
        this.transform();
        super.start();
    }

    public boolean update(Object event) {
        if (event == this.m_radius) {
            this.computePolygon(this.m_polygon, this.m_radius.getValue(), false);
            this.transform();
            return this.update(this.m_showFilledSegements);
        }
        if (event == this.m_polyZerosPS) {
            if (this.m_enableZeros.getState()) {
                if (this.m_polyZeros == null || this.m_polyZerosPS.getNumVertices() != this.m_polyZeros.length) {
                    this.m_polyZeros = new PuComplex[this.m_polyZerosPS.getNumVertices()];
                }
                int i = 0;
                while (i < this.m_polyZerosPS.getNumVertices()) {
                    this.m_polyZeros[i] = new PuComplex();
                    this.m_polyZeros[i].set(this.m_polyZerosPS.getVertex(i));
                    this.m_polyZerosPS.getVertex((int)i).m_data[2] = 1.0;
                    ++i;
                }
                PuComplex c = this.m_polynomial.getCoefficients()[this.m_polynomial.getCoefficients().length - 1];
                this.m_polynomial = PuComplexPoly.makePoly(this.m_polyZeros, c);
                String expr = this.m_polynomial.toString();
                this.m_function.setExpression(expr);
                this.computePolyBranchPts();
                this.transform();
            }
            this.m_polyZerosPS.setVisible(this.m_enableZeros.getState());
        } else {
            if (event == this.m_function) {
                if (this.m_enableZeros.getState()) {
                    this.computePolyZeros();
                    this.computePolyBranchPts();
                }
                this.transform();
                return this.update(this.m_showFilledSegements);
            }
            if (event == this.m_showFilledSegements) {
                if (this.m_showFilledSegements.getState()) {
                    this.fillSegments();
                    this.m_background.setVisible(true);
                } else {
                    this.m_background.setVisible(false);
                }
                this.m_background.update(null);
            } else if (event == this.m_showCovering) {
                this.transform();
                this.m_disc.setVisible(this.m_showCovering.getState());
                this.m_transformedDisc.setVisible(this.m_showCovering.getState());
                this.m_disc.update(null);
                this.m_transformedDisc.update(null);
            } else if (event == this.m_polygonColor) {
                this.computePolygonColors();
                this.m_polygon.update(null);
                this.m_transformedPolygon.update(null);
            } else {
                if (event == this.m_numOfNgonCorners) {
                    this.computePolygon(this.m_polygon, this.m_radius.getValue(), false);
                    this.computePolygon(this.m_transformedPolygon, this.m_radius.getValue(), true);
                    this.transform();
                    return this.update(this.m_showFilledSegements);
                }
                if (event == this.m_enableZeros) {
                    if (this.m_enableZeros.getState()) {
                        this.computePolyZeros();
                        this.computePolyBranchPts();
                    }
                    this.m_polyZerosPS.setVisible(this.m_enableZeros.getState());
                    this.m_ramificationPtsPS.setVisible(this.m_enableZeros.getState());
                    this.m_branchPtsPS.setVisible(this.m_enableZeros.getState());
                    this.m_polyZerosPS.update(null);
                    this.m_ramificationPtsPS.update(null);
                    this.m_branchPtsPS.update(null);
                } else {
                    return super.update(event);
                }
            }
        }
        this.m_dispDomain.update((Object)this);
        this.m_dispRange.update((Object)this);
        this.m_dispDomain.fit();
        this.m_dispRange.fit();
        return true;
    }

    private void transform() {
        this.transformGeometry((PgPointSet)this.m_polygon, (PgPointSet)this.m_transformedPolygon);
        this.computePolygonColors();
        this.m_polygon.update(null);
        this.m_transformedPolygon.update(null);
        int wnzero = PuPolygonUtil.computeWindingNumberAlciatore(this.m_transformedPolygon, new PdVector(0.0, 0.0));
        this.m_WindingNumber.setValue(wnzero);
        this.m_WindingNumber.update((Object)this.m_WindingNumber);
        if (this.m_showCovering.getState()) {
            this.m_disc.computeDisk(200, 200, this.m_radius.getValue());
            this.transformGeometry((PgPointSet)this.m_disc, (PgPointSet)this.m_transformedDisc);
            this.m_disc.update(null);
            this.m_transformedDisc.update(null);
        }
    }

    private void transformGeometry(PgPointSet srcGeom, PgPointSet destGeom) {
        if (srcGeom.getNumVertices() != destGeom.getNumVertices()) {
            PsDebug.warning((String)"Transform: Geometry sizes don't match");
            return;
        }
        PdVector[] srcVertices = srcGeom.getVertices();
        PdVector[] destVertices = destGeom.getVertices();
        PuComplex z = new PuComplex();
        int nov = srcGeom.getNumVertices();
        int k = 0;
        while (k < nov) {
            PdVector v = srcVertices[k];
            z.re = v.m_data[0];
            z.im = v.m_data[1];
            PuComplex fz = this.m_function.eval(z);
            double ratio = (double)k / (double)nov;
            destVertices[k].set(fz.re, fz.im, this.computeRenderHeight(ratio));
            if (this.m_mode == 1) {
                destVertices[k].m_data[2] = this.computeHeight(z) + srcVertices[k].m_data[2];
            }
            ++k;
        }
    }

    private void computePolygon(PgPolygon p, double radius, boolean addHeightIncrement) {
        switch (this.m_shapeMode) {
            case 1: {
                PuPolygonUtil.computeSquare(p, 250, 250, radius);
                break;
            }
            case 2: {
                PuPolygonUtil.computeRegularNgon(p, this.m_numOfNgonCorners.getValue(), 100, radius);
                break;
            }
            default: {
                p.computeCircle(400, radius);
            }
        }
    }

    private void fillSegments() {
        PdVector[] bounds = this.m_transformedPolygon.getAmbientBounds();
        this.m_background.computePlane(250, 250, bounds[0].m_data[0], bounds[0].m_data[1], bounds[1].m_data[0], bounds[1].m_data[1]);
        PdVector[] vertices = this.m_background.getVertices();
        int nov = this.m_background.getNumVertices();
        int i = 0;
        while (i < nov) {
            PdVector v = vertices[i];
            int wn = PuPolygonUtil.computeWindingNumberAlciatore(this.m_transformedPolygon, v);
            if (wn < 25 && wn > 0) {
                this.m_background.setVertexColor(i, this.m_segmentColor.getRelativeColor(wn, 25));
            } else if (wn == 0) {
                this.m_background.setVertexColor(i, Color.white);
            } else {
                this.m_background.setVertexColor(i, this.m_segmentColor.getRelativeColor(0, 25));
            }
            ++i;
        }
        this.m_background.makeElementFromVertexColors();
    }

    private double computeRenderHeight(double ratio) {
        double height = 1.5;
        double topRatio = 0.75;
        if (ratio <= 0.75) {
            return ratio / 0.75 * 1.5;
        }
        return 1.5 * (1.0 - (ratio - 0.75) / 0.25);
    }

    private double computeHeight(PuComplex z) {
        double r = this.m_radius.getValue();
        double h = 0.0;
        PdVector[] bnds = this.m_transformedPolygon.getAmbientBounds();
        double weight = bnds[1].getFirstEntry() - bnds[0].getFirstEntry();
        double alpha = 0.6666666666666666;
        double beta = 2.0;
        double gamma = 0.0;
        double max_arg = 0.0;
        boolean empty = true;
        int i = 0;
        while (i < this.m_branchPts.length) {
            if (this.m_branchPts[i] != null) {
                empty = false;
                break;
            }
            ++i;
        }
        if (!empty) {
            max_arg = PjFundamentalsatz.maximalArgument(this.m_branchPts);
            alpha = Math.PI / max_arg;
            beta = Math.PI / (Math.PI * 2 - max_arg);
            gamma = 2.0 * max_arg - Math.PI * 2;
        }
        h = z.arg() < max_arg ? z.abs() / r * Math.sin(alpha * z.arg() / 2.0) * Math.sin(alpha * z.arg() / 2.0) - z.abs() * 0.5 / r + 0.5 : z.abs() / r * Math.sin(beta * (z.arg() - gamma) / 2.0) * Math.sin(beta * (z.arg() - gamma) / 2.0) - z.abs() * 0.5 / r + 0.5;
        double height = h * weight * 0.4;
        return height;
    }

    protected void computePolyZeros() {
        String poly = this.m_function.getExpression();
        try {
            this.m_polynomial = PuComplexPoly.computeComplexPoly(poly);
            this.m_polyZeros = this.m_polynomial.zeros();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int L = this.m_polyZeros.length;
        this.m_polyZerosPS.setNumVertices(L);
        int i = 0;
        while (i < L) {
            this.m_polyZerosPS.setVertex(i, this.m_polyZeros[i].re(), this.m_polyZeros[i].im(), 1.0);
            ++i;
        }
        this.m_polyZerosPS.update(null);
    }

    private void computePolyBranchPts() {
        PuComplexPoly derivative = PuComplexPoly.makeDerivative(this.m_polynomial);
        PuComplex[] derivCoeffs = derivative.getCoefficients();
        if (derivCoeffs.length > 1) {
            try {
                this.m_ramificationPts = derivative.zeros();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            int L = this.m_ramificationPts.length;
            this.m_ramificationPtsPS.setNumVertices(L);
            this.m_branchPtsPS.setNumVertices(L);
            int i = 0;
            while (i < L) {
                Random rn = new Random();
                float h = rn.nextFloat();
                h = (float)((double)h + 0.618033988749895);
                this.m_ramificationPtsPS.setVertex(i, this.m_ramificationPts[i].re(), this.m_ramificationPts[i].im(), 0.0);
                this.m_ramificationPtsPS.setVertexColor(i, Color.getHSBColor(h %= 1.0f, 0.8f, 0.99f));
                this.m_branchPts[i] = this.m_polynomial.evaluate(this.m_ramificationPts[i]);
                this.m_branchPtsPS.setVertex(i, this.m_branchPts[i].re(), this.m_branchPts[i].im(), 0.0);
                ++i;
            }
        }
        this.m_ramificationPtsPS.update(null);
        this.m_branchPtsPS.update(null);
    }

    private void computePolygonColors() {
        int nov = this.m_polygon.getNumVertices();
        PdVector[] vs = this.m_polygon.getVertices();
        int i = 0;
        while (i < nov) {
            PdVector v = vs[i];
            Color c = new Color(this.m_polygonColor.getColor(v));
            this.m_polygon.setVertexColor(i, c);
            this.m_transformedPolygon.setVertexColor(i, c);
            ++i;
        }
        this.m_polygon.makeEdgeFromVertexColors();
        this.m_transformedPolygon.makeEdgeFromVertexColors();
    }

    protected void setMode(int mode) {
        if (this.m_mode == mode) {
            return;
        }
        this.m_mode = mode;
        switch (this.m_mode) {
            default: {
                this.m_mode = 0;
            }
            case 0: {
                this.m_dispRange.showBndBox(false);
                this.m_dispRange.selectCamera(1);
                this.m_dispRange.setMajorMode(3);
                break;
            }
            case 1: {
                this.m_dispRange.showBndBox(true);
                this.m_dispRange.selectCamera(0);
                this.m_dispRange.setMajorMode(17);
                this.m_constTermPS.setVisible(false);
            }
        }
        this.transform();
        this.m_dispDomain.update((Object)this);
        this.m_dispRange.update((Object)this);
        this.m_dispDomain.fit();
        this.m_dispRange.fit();
    }

    protected void setShape(int shapeMode) {
        switch (shapeMode) {
            case 0: {
                this.m_shapeMode = 0;
                break;
            }
            case 1: {
                this.m_shapeMode = 1;
                break;
            }
            case 2: {
                this.m_shapeMode = 2;
            }
        }
        this.computePolygon(this.m_polygon, this.m_radius.getValue(), false);
        this.computePolygon(this.m_transformedPolygon, this.m_radius.getValue(), true);
        this.computePolygonColors();
        this.transform();
        this.update(this.m_showFilledSegements);
        this.m_polygon.update(null);
        this.m_transformedPolygon.update(null);
    }

    private static double maximalArgument(PuComplex[] zeros) {
        double maxarg = 0.0;
        int i = 0;
        while (i < zeros.length) {
            double cur_arg;
            if (zeros[i] != null && maxarg < (cur_arg = zeros[i].arg())) {
                maxarg = cur_arg;
            }
            ++i;
        }
        if (maxarg > 5.969026041820607) {
            maxarg = 5.969026041820607;
        }
        return maxarg;
    }

    protected String integrate() {
        this.computePolyZeros();
        PuComplex[] temp_poly = this.m_polynomial.getCoefficients();
        System.out.println(temp_poly.toString());
        PuComplex[] temp_cp = new PuComplex[temp_poly.length + 1];
        int i = 0;
        while (i < temp_cp.length) {
            temp_cp[i] = i == 0 ? PuComplex.ZERO : PuComplex.div((PuComplex)temp_poly[i - 1], (double)i);
            ++i;
        }
        this.m_polynomial.setCoefficients(temp_cp);
        String expr = this.m_polynomial.toString();
        System.out.println("The polynomial: \n" + expr);
        return expr;
    }

    protected PvDisplayIf getDispDomain() {
        if (this.m_dispDomain != null) {
            return this.m_dispDomain;
        }
        if (this.getDisplay() != null) {
            this.m_dispDomain = (PvDisplay)this.getDisplay();
        } else {
            PvViewerIf viewer = this.getViewer();
            this.m_dispDomain = (PvDisplay)viewer.newDisplay("Domain", false);
        }
        return this.m_dispDomain;
    }

    protected PvDisplayIf getDispImage() {
        if (this.m_dispRange != null) {
            return this.m_dispRange;
        }
        PvViewerIf viewer = this.getViewer();
        this.m_dispRange = (PvDisplay)viewer.newDisplay("Image", false);
        return this.m_dispRange;
    }
}

